/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.c4ws.util;

import com.infor.erpln.c4ws.util.C4WSProperties;
import com.infor.erpln.c4ws.util.ConnectionHelper;
import com.infor.erpln.c4ws.util.oauth.Authenticator;
import com.infor.erpln.c4ws.util.oauth.AuthorizationStatus;
import com.infor.erpln.c4ws.util.oauth.BaseUriUtil;
import com.infor.erpln.jca.ConnectionFactoryImpl;
import com.infor.erpln.jca.ConnectionSpecImpl;
import com.infor.erpln.soap.servlet.ServletUtils;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionSpec;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.codec.binary.Base64;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConnectionHelper {
    private static final String BAANLOGIN_SSL = "baanlogin_ssl";
    private static final String CLOUD_SERVICE_USER = "svc_ln";
    private static final String IMS_TENANT_USER = "ion_integration";
    private static final String IMS_FARM_USER = "inforln";
    private static final String TENANT_INFOR = "infor";
    private static final String HTTP_HEADER_AUTHORIZATION = "Authorization";
    private static final String HTTP_HEADER_TENANT = "X-Infor-TenantId";
    private static final String URL_QUERY_TENANT = "tenant=";
    private static final int URL_QUERY_TENANT_LENGTH = "tenant=".length();
    private static final String HTTP_HEADER_IDENTITY2 = "X-Infor-Identity2";
    private static final String HTTP_HEADER_DOMAIN_USERNAME = "domainUsername";
    private static final String HTTP_HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    private static final String HTTP_HEADER_CLIENT_LANGUAGE = "inforCurrentLanguage";
    private static final String HTTP_HEADER_CLIENT_LOCALE = "inforCurrentLocale";
    private static final String HTTP_HEADER_COMPANY = "X-Infor-LNcompany";
    private static final String BASIC_AUTHENTICATION = "Basic";
    private static final String OAUTH1_AUTHETICATION = "OAuth";
    private static final String SOAP_HEADER_ACTIVATION = "Activation";
    private static final String PARAMETER_USERNAME = "username";
    private static final String PARAMETER_PASSWORD = "password";
    private static final String PARAMETER_COMPANY = "company";
    private static final String UTF8 = "UTF-8";
    private static final Logger LOG = ESAPI.getLogger(ConnectionHelper.class);
    private Context context;
    private C4WSProperties c4wsProperties;
    private String connectionPoint;
    private HttpServletRequest httpRequest;
    private Message soapMessage;
    private String imsTenant;
    private int imsCompany;
    private ConnectionSpecImpl connectionSpec;
    private String errorMessage;
    private boolean cloudMode;
    private boolean useBaanloginSsl;
    private HashMap<String, String> activationParameters;
    private AuthorizationStatus oauthStatus;
    private boolean basicAuthenticationError = false;

    public static Connection getSOAPConnection(String connectionPoint, HttpServletRequest request, Message message) throws ResourceException {
        ConnectionHelper helper = new ConnectionHelper(Context.SOAP, connectionPoint, null, request, message, null);
        return ConnectionHelper.getConnectionFactory().getConnection((ConnectionSpec)helper.getConnectionSpec());
    }

    public static Connection getRESTConnection(String connectionPoint, HttpServletRequest request) throws ResourceException {
        ConnectionHelper helper = new ConnectionHelper(Context.REST, connectionPoint, null, request, null, null);
        return ConnectionHelper.getConnectionFactory().getConnection((ConnectionSpec)helper.getConnectionSpec());
    }

    public static Connection getIMSFarmConnection(HttpServletRequest request) throws ResourceException {
        ConnectionHelper helper = new ConnectionHelper(Context.IMS_FARM, null, null, request, null, null);
        return ConnectionHelper.getConnectionFactory().getConnection((ConnectionSpec)helper.getConnectionSpec());
    }

    public static Connection getIMSTenantConnection(HttpServletRequest request, String tenant, int company) throws ResourceException {
        ConnectionHelper helper = new ConnectionHelper(Context.IMS_TENANT, null, null, request, null, tenant, company);
        return ConnectionHelper.getConnectionFactory().getConnection((ConnectionSpec)helper.getConnectionSpec());
    }

    public static Connection getLNRestConnection(String connectionPoint, HttpServletRequest request) throws ResourceException {
        ConnectionHelper helper = new ConnectionHelper(Context.LNREST, connectionPoint, null, request, null, null);
        return ConnectionHelper.getConnectionFactory().getConnection((ConnectionSpec)helper.getConnectionSpec());
    }

    private static ConnectionFactoryImpl getConnectionFactory() throws ResourceException {
        ConnectionFactoryImpl factory = (ConnectionFactoryImpl)ServletUtils.getServletContext().getAttribute("com.infor.erpln.soap.connectionFactory");
        if (factory == null) {
            throw new ResourceException("No ConnectionFactory object in servlet context");
        }
        return factory;
    }

    private static Authenticator getOAuth1Authenticator() throws ResourceException {
        Authenticator authenticator = (Authenticator)ServletUtils.getServletContext().getAttribute("com.infor.erpln.util.oauth.Authenticator");
        if (authenticator == null) {
            throw new ResourceException("No Authenticator object in servlet context");
        }
        return authenticator;
    }

    public ConnectionHelper(Context context, String connectionPoint, C4WSProperties c4wsProperties, HttpServletRequest request, Message soapMessage, String imsTenant) {
        this(context, connectionPoint, c4wsProperties, request, soapMessage, imsTenant, 0);
    }

    private ConnectionHelper(Context context, String connectionPoint, C4WSProperties c4wsProperties, HttpServletRequest request, Message soapMessage, String imsTenant, int imsCompany) {
        this.context = context;
        this.connectionPoint = connectionPoint;
        this.c4wsProperties = c4wsProperties;
        this.httpRequest = request;
        this.soapMessage = soapMessage;
        this.imsTenant = imsTenant;
        this.imsCompany = imsCompany;
        try {
            this.buildConnectionSpec();
        }
        catch (Exception ex) {
            LOG.fatal(Logger.EVENT_FAILURE, "Unexpected error", (Throwable)ex);
        }
    }

    public ConnectionSpecImpl getConnectionSpec() throws ResourceException {
        if (this.oauthStatus != null && !this.oauthStatus.isOk()) {
            throw new OAuthValidationException(this.oauthStatus);
        }
        if (this.basicAuthenticationError) {
            throw new BasicAuthenticationException(this.errorMessage);
        }
        if (this.errorMessage != null) {
            throw new ResourceException(this.errorMessage);
        }
        return this.connectionSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildConnectionSpec() {
        HeaderList soapHeaders;
        if (this.c4wsProperties == null) {
            this.c4wsProperties = ServletUtils.getC4WSProperties();
            if (this.c4wsProperties == null) {
                this.errorMessage = "Unable to open c4wsProperties.xml";
                return;
            }
        }
        this.cloudMode = this.c4wsProperties.isCloudEnabled();
        try {
            if (this.context == Context.IMS_FARM || this.context == Context.IMS_TENANT) {
                this.connectionSpec = this.c4wsProperties.getIMSConnectionSpec();
            } else if (this.cloudMode) {
                this.connectionSpec = this.c4wsProperties.getCloudConnectionSpec();
            } else if (this.connectionPoint == null && this.context == Context.LNREST) {
                String authorization = this.httpRequest.getHeader("Authorization");
                boolean requireSSL = authorization != null && authorization.startsWith("OAuth");
                this.connectionSpec = this.c4wsProperties.getLNRestConnectionSpec(requireSSL);
            } else {
                this.connectionSpec = this.c4wsProperties.getConnectionSpec(this.connectionPoint);
            }
        }
        catch (Exception ex) {
            this.errorMessage = ex.getMessage();
            return;
        }
        this.useBaanloginSsl = "baanlogin_ssl".equals(this.connectionSpec.getActivationType());
        if (this.useBaanloginSsl) {
            try {
                Authenticator authenticator = ConnectionHelper.getOAuth1Authenticator();
                this.validateOAuth(authenticator);
                if (!this.oauthStatus.isOk()) {
                    this.errorMessage = this.oauthStatus.getErrorMessage();
                    return;
                }
            }
            catch (ResourceException ex) {
                this.errorMessage = "OAuth 1.0a validation failed: " + ex.getMessage();
                return;
            }
        }
        if (this.soapMessage != null && (soapHeaders = this.soapMessage.getHeaders()) != null) {
            for (Header header : soapHeaders) {
                if (!"Activation".equals(header.getLocalPart())) continue;
                this.activationParameters = new HashMap();
                XMLStreamReader reader = null;
                try {
                    reader = header.readHeader();
                    reader.nextTag();
                    while (reader.nextTag() == 1) {
                        String name = reader.getLocalName();
                        String value = reader.getElementText();
                        this.activationParameters.put(name, value);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Found parameter '%s' in SOAP 'Activation' header", name));
                    }
                }
                catch (Exception ex) {
                    LOG.warning(Logger.EVENT_FAILURE, "(Ignoring) Error when reading SOAP header", (Throwable)ex);
                }
                finally {
                    if (reader == null) continue;
                    try {
                        reader.close();
                    }
                    catch (Exception ex) {
                        LOG.debug(Logger.EVENT_FAILURE, "(Ignoring) Error when closing XMLStreamReader", (Throwable)ex);
                    }
                }
            }
        }
        if (this.useBaanloginSsl || !this.c4wsProperties.isAnonymousAllowed(this.connectionPoint)) {
            this.resetCredentials();
        }
        this.applyCredentials();
        if (this.connectionSpec.getUser().isEmpty()) {
            this.basicAuthenticationError = true;
            this.errorMessage = "Anonymous requests are not allowed";
            return;
        }
        this.applyCompany();
        this.applyTenant();
        this.applyClientSettings();
    }

    private void applyCredentials() {
        switch (1.$SwitchMap$com$infor$erpln$c4ws$util$ConnectionHelper$Context[this.context.ordinal()]) {
            case 1: {
                if (this.useBaanloginSsl && this.cloudMode) {
                    this.connectionSpec.setUser("ion_integration");
                    try {
                        String debugUser = System.getProperty("debug.ims.tenantuser");
                        if (debugUser == null) break;
                        this.connectionSpec.setUser(debugUser);
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Overriding IMS Tenant user as '%s'", debugUser));
                    }
                    catch (Exception ex) {
                        LOG.warning(Logger.EVENT_FAILURE, "(Ignoring) Error when reading system property", (Throwable)ex);
                    }
                    break;
                }
                if (this.useBaanloginSsl) break;
                this.connectionSpec.setUser("");
                LOG.error(Logger.EVENT_FAILURE, "IMS environment fails to use baanlogin_ssl protocol");
                break;
            }
            case 2: {
                if (this.useBaanloginSsl && this.cloudMode) {
                    this.connectionSpec.setUser("inforln");
                    try {
                        String debugUser = System.getProperty("debug.ims.farmuser");
                        if (debugUser == null) break;
                        this.connectionSpec.setUser(debugUser);
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Overriding IMS Farm user as '%s'", debugUser));
                    }
                    catch (Exception ex) {
                        LOG.warning(Logger.EVENT_FAILURE, "(Ignoring) Error when reading system property", (Throwable)ex);
                    }
                    break;
                }
                if (this.useBaanloginSsl) break;
                this.connectionSpec.setUser("");
                LOG.error(Logger.EVENT_FAILURE, "IMS environment fails to use baanlogin_ssl protocol");
                break;
            }
            case 3: {
                if (this.useBaanloginSsl) {
                    String username = this.getSslUser();
                    this.connectionSpec.setUser(username);
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("User for BaanLogin-SSL is '%s'", username));
                    break;
                }
                this.useBasicAuthCredentials();
                this.useSoapHeaderCredentials();
                break;
            }
            case 4: 
            case 5: {
                boolean oauth1;
                if (this.useBaanloginSsl) {
                    String username = this.getSslUser();
                    this.connectionSpec.setUser(username);
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("User for BaanLogin-SSL is '%s'", username));
                    break;
                }
                String authorization = this.httpRequest.getHeader("Authorization");
                boolean bl = oauth1 = authorization != null && authorization.startsWith("OAuth");
                if (oauth1) {
                    this.oauthStatus = new AuthorizationStatus().badRequest(String.format("No OAuth1 supported for this connection point: %s", this.connectionSpec.getConnectionPoint()));
                    break;
                }
                this.useBasicAuthCredentials();
                break;
            }
        }
    }

    private String getSslUser() {
        String identity2 = this.getHttpHeader("X-Infor-Identity2", true);
        if (identity2 == null) {
            identity2 = "svc_ln";
        }
        if (this.cloudMode) {
            return identity2;
        }
        if (this.c4wsProperties.isUseUpn(this.connectionPoint)) {
            return identity2;
        }
        String domainUser = this.getHttpHeader("domainUsername", true);
        if (domainUser == null) {
            domainUser = identity2;
        } else {
            int separatorIndex = domainUser.indexOf(92);
            if (separatorIndex > 0) {
                domainUser = domainUser.substring(separatorIndex + 1);
            }
        }
        return domainUser;
    }

    private void useBasicAuthCredentials() {
        String credentials;
        String[] credParts;
        String[] authParts;
        String authHeader = this.getHttpHeader("Authorization", false);
        if (authHeader != null && (authParts = authHeader.split(" ")).length == 2 && authParts[0].equalsIgnoreCase("Basic") && (credParts = (credentials = new String(Base64.decodeBase64((String)authParts[1]))).split(":", 2)).length == 2) {
            String user = credParts[0];
            String password = credParts[1];
            if (!user.isEmpty() && !password.isEmpty()) {
                this.connectionSpec.setUser(user);
                this.connectionSpec.setPassword(password);
                if (LOG.isInfoEnabled()) {
                    LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Found Basic Authentication (user = '%s')", user));
                }
            }
        }
    }

    private void useSoapHeaderCredentials() {
        if (this.activationParameters != null && this.activationParameters.containsKey("username") && this.activationParameters.containsKey("password")) {
            String userName = (String)this.activationParameters.get("username");
            String password = (String)this.activationParameters.get("password");
            this.connectionSpec.setUser(userName);
            this.connectionSpec.setPassword(password);
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Using credentials from SOAP header (user = '%s')", userName));
            }
        }
    }

    private String getHttpHeader(String headerName, boolean tryAlias) {
        String result = this.httpRequest.getHeader(headerName);
        if (LOG.isDebugEnabled()) {
            if (result == null) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("HTTP header '%s' was not found", headerName));
            } else {
                LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Found HTTP header '%s'", headerName));
            }
        }
        if (tryAlias && result == null) {
            for (String alias : this.c4wsProperties.getHeaderAliases(headerName)) {
                result = this.httpRequest.getHeader(alias);
                if (result == null) continue;
                if (!LOG.isDebugEnabled()) break;
                LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Found HTTP header '%s'", alias));
                break;
            }
        }
        return result;
    }

    private void applyCompany() {
        switch (1.$SwitchMap$com$infor$erpln$c4ws$util$ConnectionHelper$Context[this.context.ordinal()]) {
            case 3: {
                if (this.activationParameters == null || !this.activationParameters.containsKey("company")) break;
                String company = (String)this.activationParameters.get("company");
                try {
                    this.connectionSpec.setCompany(Integer.parseInt(company));
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Using company '%s' from SOAP header", company));
                }
                catch (Exception ex) {
                    LOG.error(Logger.EVENT_FAILURE, String.format("Invalid company '%s' found in SOAP header", company));
                }
                break;
            }
            case 4: 
            case 5: {
                String company = this.getHttpHeader("X-Infor-LNcompany", true);
                if (company == null) break;
                try {
                    this.connectionSpec.setCompany(Integer.parseInt(company));
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Using company '%s' from HTTP header", company));
                }
                catch (Exception ex) {
                    LOG.error(Logger.EVENT_FAILURE, String.format("Invalid company '%s' found in HTTP header", company));
                }
                break;
            }
            case 1: 
            case 2: {
                this.connectionSpec.setCompany(this.imsCompany);
                break;
            }
        }
    }

    private void applyTenant() {
        String tenant = null;
        block2 : switch (1.$SwitchMap$com$infor$erpln$c4ws$util$ConnectionHelper$Context[this.context.ordinal()]) {
            case 1: {
                if (this.imsTenant != null) {
                    this.connectionSpec.setTenant(this.imsTenant);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Using IMS tenant '%s'", this.imsTenant));
                    }
                }
                try {
                    String debugTenant = System.getProperty("debug.ims.tenant");
                    if (debugTenant == null) break;
                    this.connectionSpec.setTenant(debugTenant);
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Overriding IMS tenant as '%s'", debugTenant));
                }
                catch (Exception ex) {
                    LOG.warning(Logger.EVENT_FAILURE, "(Ignoring) Error when reading system property", (Throwable)ex);
                }
                break;
            }
            case 3: 
            case 4: {
                tenant = this.getHttpHeader("X-Infor-TenantId", true);
                if (tenant != null) {
                    this.connectionSpec.setTenant(tenant);
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Using tenant '%s' from HTTP header", tenant));
                    break;
                }
                if (this.c4wsProperties.isCloudEnabled()) break;
                for (String parameter : this.getQueryParameters()) {
                    if (!parameter.startsWith("tenant=")) continue;
                    tenant = parameter.substring(URL_QUERY_TENANT_LENGTH);
                    if (tenant.contains("%")) {
                        try {
                            tenant = URLDecoder.decode(tenant, "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                    this.connectionSpec.setTenant(tenant);
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Using tenant '%s' from URL query", tenant));
                    break block2;
                }
                break;
            }
            case 5: {
                tenant = this.getHttpHeader("X-Infor-TenantId", true);
                if (tenant == null) break;
                this.connectionSpec.setTenant(tenant);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Using tenant '%s' from HTTP header", tenant));
            }
        }
        if ("infor".equalsIgnoreCase(this.connectionSpec.getTenant())) {
            this.connectionSpec.setTenant("");
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Ignoring pseudo-tenant 'infor'");
            }
        }
    }

    private void applyClientSettings() {
        if (this.context == Context.LNREST) {
            String language = this.getHttpHeader("Accept-Language", false);
            if (language != null) {
                this.connectionSpec.setClientLanguage(language);
                this.connectionSpec.setClientLocale(language);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Using client language and locale '%s'", language));
                }
            }
        } else {
            String language = this.getHttpHeader("inforCurrentLanguage", true);
            String locale = this.getHttpHeader("inforCurrentLocale", true);
            if (language != null) {
                this.connectionSpec.setClientLanguage(language);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Using client language '%s'", language));
                }
            }
            if (locale != null) {
                this.connectionSpec.setClientLocale(locale);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Using client locale '%s'", locale));
                }
            }
        }
    }

    private void resetCredentials() {
        if (this.context != Context.IMS_FARM && this.context != Context.IMS_TENANT) {
            this.connectionSpec.setUser("");
        }
        this.connectionSpec.setPassword("");
    }

    private void validateOAuth(Authenticator authenticator) {
        String oauthHeader = this.getHttpHeader("Authorization", false);
        if (oauthHeader == null) {
            this.oauthStatus = new AuthorizationStatus().unauthorized("Missing Authorization header for OAuth 1.0a");
        } else {
            String baseUri = BaseUriUtil.getBaseUri((HttpServletRequest)this.httpRequest);
            String query = this.httpRequest.getQueryString();
            this.oauthStatus = authenticator.verify(this.httpRequest.getMethod(), baseUri, query, oauthHeader);
        }
    }

    private List<String> getQueryParameters() {
        String queryString = this.httpRequest.getQueryString();
        if (queryString != null) {
            String[] parameters = queryString.split("&");
            return Arrays.asList(parameters);
        }
        return Collections.emptyList();
    }
}

