/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.c4ws.util;

import com.infor.erpln.c4ws.util.C4WSProperties;
import java.io.File;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class C4WSPropertiesManager {
    protected static final long CHECK_INTERVAL = 60000L;
    private static final String C4WS_PROPERTIES_XML = "c4wsProperties.xml";
    private static final String CONFIG_LOCATION = "configLocation";
    private static final String CONFIG_PATH = "ConfigPath";
    private static final String JNDI_ENV_CONFIG_LOCATION = "java:comp/env/configLocation";
    private static final String CONFIG_PROPERTY = "com.infor.c4ws.configLocation";
    private static final Logger LOG = ESAPI.getLogger(C4WSPropertiesManager.class);
    private final ServletContext servletContext;
    private C4WSProperties properties;
    private File propertiesFile;
    private Thread fileChangeWatchdog;

    public C4WSPropertiesManager(ServletContext context) {
        this.servletContext = context;
        this.propertiesFile = this.findPropertiesFile();
        this.fileChangeWatchdog = new /* Unavailable Anonymous Inner Class!! */;
        this.fileChangeWatchdog.setDaemon(true);
        this.fileChangeWatchdog.start();
    }

    public C4WSProperties getProperties() {
        if (this.properties == null) {
            this.properties = new C4WSProperties(this.propertiesFile);
        }
        return this.properties;
    }

    public C4WSProperties getEditableProperties() {
        C4WSProperties editableProperties = new C4WSProperties(this.propertiesFile);
        editableProperties.setEditable(true);
        return editableProperties;
    }

    public void updateProperties() {
        try {
            C4WSProperties props = this.getEditableProperties();
            props.updateIfNeeded();
            props.setEditable(false);
            this.properties = props;
        }
        catch (C4WSProperties.UpdateException e) {
            LOG.debug(Logger.EVENT_FAILURE, "Unable to perform an update of the properties file", (Throwable)e);
        }
    }

    public void saveProperties(C4WSProperties changedProperties) throws C4WSProperties.UpdateException {
        changedProperties.save();
        changedProperties.setEditable(false);
        this.properties = changedProperties;
    }

    private File findPropertiesFile() {
        String configDir = this.servletContext.getInitParameter(CONFIG_PATH);
        if (StringUtils.isEmpty((String)configDir)) {
            configDir = this.servletContext.getInitParameter(CONFIG_LOCATION);
        }
        if (StringUtils.isEmpty((String)configDir)) {
            try {
                InitialContext context = new InitialContext();
                String value = (String)context.lookup(JNDI_ENV_CONFIG_LOCATION);
                if (StringUtils.isNotEmpty((String)value)) {
                    configDir = value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtils.isEmpty((String)configDir)) {
            try {
                configDir = System.getProperty(CONFIG_PROPERTY);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtils.isEmpty((String)configDir)) {
            configDir = this.servletContext.getRealPath("/WEB-INF");
        }
        return new File(configDir, C4WS_PROPERTIES_XML);
    }

    public void stopFileChangeWatchdog() {
        this.fileChangeWatchdog.interrupt();
    }

    static /* synthetic */ File access$000(C4WSPropertiesManager x0) {
        return x0.propertiesFile;
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    static /* synthetic */ C4WSProperties access$202(C4WSPropertiesManager x0, C4WSProperties x1) {
        x0.properties = x1;
        return x0.properties;
    }
}

