/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.c4ws.util;

import com.infor.erpln.c4ws.util.C4WSProperties;
import com.infor.erpln.c4ws.util.KmsUtil;
import com.infor.erpln.c4ws.util.LNEnvironment;
import com.infor.erpln.jca.ConnectionSpecImpl;
import com.infor.erpln.util.encryption.PasswordEncryption;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.resource.ResourceException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class C4WSProperties {
    private static final String KEY_CLOUD_ENABLED = "general/cloudEnabled";
    private static final String KEY_USE_KMS = "general/usekms";
    private static final String KEY_CONSUMER_KEY = "cloud/consumerkey";
    private static final String KEY_CONSUMER_SECRET = "cloud/consumersecret";
    private static final String KEY_CLOUD_LN_ENVIRONMENT = "cloud/environmentID";
    private static final String KEY_ENVIRONMENTS = "environments";
    private static final String KEY_ENVIRONMENT = "environments/environment";
    private static final String KEY_ENV_NAME = "environments/environment[@name='%s']";
    private static final String KEY_ENV_NAME_NAME = "environments/environment[@name='%s']/@name";
    private static final String KEY_ENV_ANONYMOUS = "environments/environment[@name='%s']/anonymous";
    private static final String KEY_ENV_USE_UPN = "environments/environment[@name='%s']/useupn";
    private static final String KEY_JSON_SUPPORT = "general/jsonSupport";
    private static final String KEY_KEYSTORE_PASSWORD = "cloud/keystorepassword";
    private static final String KEY_KEYSTORE_PATH = "cloud/keystore";
    private static final String KEY_S3_BUCKET = "cloud/s3bucket";
    private static final String KEY_S3_PREFIX = "cloud/s3prefix";
    private static final String KEY_S3_URL_EXPIRATION = "cloud/s3urlExpiration";
    private static final String KEY_S3_RETRY_COUNT = "cloud/s3retryCount";
    private static final String KEY_LNUI_CONFIG_FILE = "general/lnuiConfigFile";
    private static final String ATTR_KMS = "[@kms='true']";
    private static final String ATTR_CLEARTEXT = "[@cleartext='true']";
    private static final String DEFAULT_KEYSTORE_NAME = "ln-ui.jks";
    private static final String GOVCLOUD_KEYSTORE_NAME = "ln-ui.bcfks";
    private static final String KEYSTORE_PASSWORD_FILE = "ln-ui-pwd.txt";
    private static final String DEFAULT_KEYSTORE_PASSWORD = "ABAACCEC22AE2B85C488DE0FE004BEE4";
    private static final String DEFAULT_KEYSTORES_SUBFOLDER = "keystores";
    private static final String ROOTNODE_C4WS = "c4ws";
    private static final String ROOTNODE_WEBUI = "webui";
    private static final String WEBUI_PROPERTIES_XML = "webuiProperties.xml";
    private static final String BACKUP_EXTENSION = ".bak";
    private static final String ACTIVATION_BAANLOGIN_SSL = "baanlogin_ssl";
    private static final String KEY_BACKENDS = "backends";
    private static final String KEY_BACKEND = "backends/backend";
    private static final String KEY_HEADER_ALIAS = "aliases/header[@nameLowerCase='%s']";
    private static final int DEFAULT_S3_URL_EXPIRATION = 3600000;
    private static final String KEY_IMS_URI_MAPPING = "ims/uriMappings/mapping[@src='%s' and not(@version)]";
    private static final String KEY_IMS_URI_MAPPING_VER = "ims/uriMappings/mapping[@src='%s' and @version='%s']";
    private static final String KEY_IMS_URI_MAPPING_DEFAULT = "ims/uriMappings/mapping[@src='*' and not(@version)]";
    private static final String KEY_IMS_URI_MAPPING_DEFAULT_VER = "ims/uriMappings/mapping[@src='*' and @version='%s']";
    private static final String KEY_IMS_SERVICE_MAPPING = "ims/serviceMappings/mapping[@src='%s' and not(@version)]";
    private static final String KEY_IMS_SERVICE_MAPPING_VER = "ims/serviceMappings/mapping[@src='%s' and @version='%s']";
    private static final String KEY_IMS_SERVICE_MAPPING_DEFAULT = "ims/serviceMappings/mapping[@src='*' and not(@version)]";
    private static final String KEY_IMS_SERVICE_MAPPING_DEFAULT_VER = "ims/serviceMappings/mapping[@src='*' and @version='%s']";
    private static final String KEY_IMS_ENVIRONMENT = "ims/environmentID";
    private static final Map<String, String> IMS_DEFAULT_URI_MAP = new HashMap();
    private static final Map<String, String> IMS_DEFAULT_SERVICE_MAP = new HashMap();
    private static final String IMS_KEY_ANYNAME_ANYVERSION = "*\r*";
    private static final String IMS_KEY_ANYNAME_VERSION2 = "*\rv2";
    private static final String IMS_KEY_PROTOCOL_ANYVERSION = "/protocol\r*";
    private static final Logger LOG;
    private File c4wsConfigFile;
    private XMLConfiguration c4wsConfiguration;
    private XMLConfiguration lnuiConfiguration;
    private boolean isEditable;
    private Map<String, String> imsBaseUriCache = new HashMap();
    private Map<String, String> imsServiceCache = new HashMap();

    public C4WSProperties(File c4wsConfigFile) {
        this.c4wsConfigFile = c4wsConfigFile;
        this.c4wsConfiguration = C4WSProperties.createXMLConfiguration((File)c4wsConfigFile, (String)"c4ws");
        File lnuiFile = this.getLNUIConfigFileOrDefault(this.c4wsConfiguration.getString("general/lnuiConfigFile"));
        this.lnuiConfiguration = C4WSProperties.createXMLConfiguration((File)lnuiFile, (String)"webui");
        this.isEditable = false;
    }

    public String getConfigFolder() {
        return this.c4wsConfigFile.getParent();
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    void setEditable(boolean editable) {
        this.isEditable = editable;
    }

    public boolean isCloudEnabled() {
        String cloudEnabled = this.getValue("general/cloudEnabled", Boolean.toString(false));
        return Boolean.parseBoolean(cloudEnabled);
    }

    public void setCloudEnabled(boolean cloudEnabled) {
        this.setCombinedValue("general/cloudEnabled", String.valueOf(cloudEnabled));
    }

    public boolean isUseKms() {
        String useKms = this.getValue("general/usekms", Boolean.toString(false));
        return Boolean.parseBoolean(useKms);
    }

    public ConnectionSpecImpl getCloudConnectionSpec() throws ResourceException {
        String environmentID = this.getCloudEnvironmentID();
        if (environmentID == null) {
            throw new ResourceException("Configuration error: no \"cloud environmentID\" has been specified");
        }
        LNEnvironment environment = this.getEnvironmentForID(environmentID);
        if (environment == null) {
            String message = String.format("Configuration error: \"cloud environmentID\" specifies an undefined environment ('%s')", environmentID);
            throw new ResourceException(message);
        }
        return environment.createConnectionSpec();
    }

    public ConnectionSpecImpl getConnectionSpec(String connectionpoint) throws ResourceException {
        String environmentID = this.getEnvironmentIdForConnectionpoint(connectionpoint);
        if (environmentID.isEmpty()) {
            String message = String.format("Connectionpoint '%s' not defined", connectionpoint);
            throw new ResourceException(message);
        }
        LNEnvironment environment = this.getEnvironmentForID(environmentID);
        if (environment == null) {
            String message = String.format("Environment '%s' (referenced by connectionpoint '%s') not defined", environmentID, connectionpoint);
            throw new ResourceException(message);
        }
        return environment.createConnectionSpec(connectionpoint);
    }

    public boolean isAnonymousAllowed(String connectionpoint) {
        String environmentID = this.getEnvironmentIdForConnectionpoint(connectionpoint);
        String ananymousAllowed = this.getValue(this.getEnvironmentXPath("environments/environment[@name='%s']/anonymous", environmentID), Boolean.toString(false));
        return Boolean.parseBoolean(ananymousAllowed);
    }

    public boolean isUseUpn(String connectionpoint) {
        String environmentID = this.getEnvironmentIdForConnectionpoint(connectionpoint);
        String useUPN = this.getValue(this.getEnvironmentXPath("environments/environment[@name='%s']/useupn", environmentID), Boolean.toString(false));
        return Boolean.parseBoolean(useUPN);
    }

    public boolean isUseUpnInCloud() {
        String environmentID = this.getCloudEnvironmentID();
        String useUPN = this.getValue(this.getEnvironmentXPath("environments/environment[@name='%s']/useupn", environmentID), Boolean.toString(false));
        return Boolean.parseBoolean(useUPN);
    }

    public String getKeyStorePath() {
        String path = this.getValue("cloud/keystore", null);
        if (path == null) {
            try {
                File keystoresFolder = this.getLNUIKeystoresFolder();
                File keystoreFile = new File(keystoresFolder, "ln-ui.bcfks");
                if (!keystoreFile.exists()) {
                    keystoreFile = new File(keystoresFolder, "ln-ui.jks");
                }
                path = keystoreFile.getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return path;
    }

    private File getLNUIKeystoresFolder() {
        File lnuiConfigFolder = this.lnuiConfiguration.getFile().getParentFile();
        File keystoresFolder = new File(lnuiConfigFolder, "keystores");
        return keystoresFolder;
    }

    public void setKeyStorePath(String path) {
        this.setCombinedValue("cloud/keystore", path);
    }

    public String getKeyStorePassword() {
        if (this.isUseKms()) {
            return this.getKmsKeyStorePassword();
        }
        return this.getDecryptedValue("cloud/keystorepassword", "ABAACCEC22AE2B85C488DE0FE004BEE4");
    }

    private String getKmsKeyStorePassword() {
        File keystoresFolder = this.getLNUIKeystoresFolder();
        File pwdFile = new File(keystoresFolder, "ln-ui-pwd.txt");
        if (pwdFile.exists()) {
            try {
                String encPassword = FileUtils.readFileToString((File)pwdFile, (String)"UTF-8");
                String password = KmsUtil.getInstance().kmsDecrypt(encPassword);
                return password;
            }
            catch (IOException e) {
                LOG.error(Logger.EVENT_FAILURE, "Failure to read file: ln-ui-pwd.txt", (Throwable)e);
            }
        }
        return "";
    }

    public void setKeyStorePassword(String password) {
        this.c4wsConfiguration.clearProperty("cloud/keystorepassword[@cleartext='true']");
        String encryptedPassword = "";
        if (password != null && !password.isEmpty()) {
            encryptedPassword = PasswordEncryption.getEncryptionPassword((String)password);
        }
        this.setCombinedValue("cloud/keystorepassword", encryptedPassword);
    }

    public String getConsumerKey() {
        return this.getValue("cloud/consumerkey", null);
    }

    public void setConsumerKey(String consumerKey) {
        this.setC4WSOnlyValue("cloud/consumerkey", consumerKey);
    }

    public String getConsumerSecret() {
        return this.getDecryptedValue("cloud/consumersecret", null);
    }

    public void setConsumerSecret(String secret) {
        String encryptedSecret = "";
        if (secret != null && !secret.isEmpty()) {
            encryptedSecret = PasswordEncryption.getEncryptionPassword((String)secret);
        }
        this.setC4WSOnlyValue("cloud/consumersecret", encryptedSecret);
    }

    public String getCloudEnvironmentID() {
        return this.getValue("cloud/environmentID", null);
    }

    public void setCloudEnvironmentID(String id) {
        this.setC4WSOnlyValue("cloud/environmentID", id);
    }

    public List<String> getAllEnvironments() {
        String envName;
        ArrayList<String> result = new ArrayList<String>();
        List environments = this.lnuiConfiguration.configurationsAt("environments/environment");
        for (HierarchicalConfiguration env : environments) {
            envName = env.getString("@name");
            if (envName == null) continue;
            result.add(envName);
        }
        environments = this.c4wsConfiguration.configurationsAt("environments/environment");
        for (HierarchicalConfiguration env : environments) {
            envName = env.getString("@name");
            if (envName == null || result.contains(envName)) continue;
            result.add(envName);
        }
        return result;
    }

    public SortedMap<String, String> getEnvironmentMapping() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        List backends = this.c4wsConfiguration.configurationsAt("backends/backend");
        for (HierarchicalConfiguration backendConfig : backends) {
            String connectionpoint = backendConfig.getString("@name");
            String environment = backendConfig.getString("@ref");
            result.put(connectionpoint, environment);
        }
        return result;
    }

    public void addEnvironmentMapping(String connectionpoint, String environmentID) {
        String key;
        Iterator backendsIterator = this.c4wsConfiguration.getKeys("backends");
        if (!backendsIterator.hasNext()) {
            this.c4wsConfiguration.addProperty("/ backends", (Object)"");
        }
        if (!this.c4wsConfiguration.containsKey(key = "backends/backend[@name='" + connectionpoint + "']")) {
            this.c4wsConfiguration.addProperty("backends backend", (Object)"");
            this.c4wsConfiguration.setProperty("backends/backend[last()]/@name", (Object)connectionpoint);
        }
        this.setC4WSOnlyValue(key + "/@ref", environmentID);
    }

    public void removeConnectionpoint(String connectionpoint) {
        String key = "backends/backend[@name='" + connectionpoint + "']";
        this.c4wsConfiguration.clearTree(key);
        this.c4wsConfiguration.setProperty("backends", (Object)"");
    }

    public void removeEnvironment(String environmentID) {
        this.c4wsConfiguration.clearTree(this.getEnvironmentXPath("environments/environment[@name='%s']", environmentID));
        this.c4wsConfiguration.setProperty("environments", (Object)"");
    }

    public LNEnvironment getEnvironmentForID(String environmentID) {
        if (!this.environmentExists(environmentID)) {
            return null;
        }
        LNEnvironment result = new LNEnvironment(environmentID);
        EnvironmentConfig envConfig = new EnvironmentConfig(this, environmentID);
        String activation = envConfig.getActivation("baanlogin_ssl");
        result.setActivation(activation);
        if (activation.equals("rexec")) {
            result.setPort(envConfig.getPort(512));
        } else {
            result.setPort(envConfig.getPort(7150));
        }
        result.setHost(envConfig.getHost(null));
        result.setBSE(envConfig.getBSE(""));
        result.setBshell(envConfig.getBshell("bshell"));
        result.setCommand(envConfig.getCommand(""));
        result.setCompany(envConfig.getCompany(-1));
        result.setMaxConnections(envConfig.getMaxConnections(0));
        result.setMaxReferences(envConfig.getMaxReferences(1));
        result.setMaxThreads(envConfig.getMaxThreads(0));
        result.setKeepAlive(envConfig.getKeepAlive(300));
        result.setUser(envConfig.getUser(""));
        result.setEncryptedPassword(envConfig.getEncryptedPassword(""));
        result.setTraceBackend(envConfig.isTraceBackend());
        result.setAnonymousAllowed(envConfig.isAnonymousAllowed());
        result.setUseUpn(envConfig.isUseUpn());
        return result;
    }

    public boolean environmentExists(String environmentID) {
        String key = this.getEnvironmentXPath("environments/environment[@name='%s']/@name", environmentID);
        return environmentID != null && (this.c4wsConfiguration.containsKey(key) || this.lnuiConfiguration.containsKey(key));
    }

    public void setEnvironmentForID(String environmentID, LNEnvironment environment) {
        if (this.environmentExists(environmentID)) {
            this.removeEnvironment(environmentID);
        }
        EnvironmentConfig envConfig = new EnvironmentConfig(this, environmentID);
        envConfig.setTraceBackend(environment.isTraceBackend());
        envConfig.setAnonymousAllowed(environment.isAnonymousAllowed());
        envConfig.setActivation(environment.getActivation());
        envConfig.setBSE(environment.getBSE());
        envConfig.setBshell(environment.getBshell());
        envConfig.setCommand(environment.getCommand());
        if (environment.getCompany() > -1) {
            envConfig.setCompany(environment.getCompany());
        }
        envConfig.setHost(environment.getHost());
        envConfig.setKeepAlive(environment.getKeepAlive());
        envConfig.setMaxThreads(environment.getMaxThreads());
        envConfig.setMaxConnections(environment.getMaxConnections());
        envConfig.setMaxReferences(environment.getMaxReferences());
        envConfig.setEncryptedPassword(environment.getEncryptedPassword());
        envConfig.setPort(environment.getPort());
        envConfig.setUser(environment.getUser());
        envConfig.setUseUpn(environment.isUseUpn());
    }

    public List<String> getHeaderAliases(String headerName) {
        String[] aliases = this.c4wsConfiguration.getStringArray(String.format("aliases/header[@nameLowerCase='%s']", headerName.toLowerCase()));
        return Arrays.asList(aliases);
    }

    public String getS3BucketName() {
        return this.getValue("cloud/s3bucket", null);
    }

    public void setS3BucketName(String s3bucket) {
        this.setC4WSOnlyValue("cloud/s3bucket", s3bucket);
    }

    public String getS3Prefix() {
        return this.getValue("cloud/s3prefix", null);
    }

    public void setS3Prefix(String s3prefix) {
        this.setC4WSOnlyValue("cloud/s3prefix", s3prefix);
    }

    public long getS3UrlExpirationTime() {
        return this.getLongValue("cloud/s3urlExpiration", 3600000L);
    }

    public void setS3UrlExpirationTime(long expiration) {
        if (expiration > 0L) {
            this.c4wsConfiguration.setProperty("cloud/s3urlExpiration", (Object)expiration);
        } else {
            this.c4wsConfiguration.clearProperty("cloud/s3urlExpiration");
        }
    }

    public int getS3MaxRetryCount() {
        return this.getIntValue("cloud/s3retryCount", 4);
    }

    public void setS3MaxRetryCount(int maxRetries) {
        if (maxRetries >= 0) {
            this.c4wsConfiguration.setProperty("cloud/s3retryCount", (Object)maxRetries);
        } else {
            this.c4wsConfiguration.clearProperty("cloud/s3retryCount");
        }
    }

    @Deprecated
    public String getIMSBaseUri(String imsApiPath, String version) {
        String key = this.createImsKey(imsApiPath, version);
        String value = (String)this.imsBaseUriCache.get(key);
        if (value == null) {
            value = this.internalGetIMSBaseUri(imsApiPath, version);
            this.imsBaseUriCache.put(key, value);
        }
        return value;
    }

    private String internalGetIMSBaseUri(String imsApiPath, String version) {
        String baseUri = null;
        String key = null;
        if (StringUtils.isNotEmpty((String)version)) {
            baseUri = this.c4wsConfiguration.getString(String.format("ims/uriMappings/mapping[@src='%s' and @version='%s']", imsApiPath, version));
            if (baseUri != null) {
                return baseUri;
            }
            key = this.createImsKey(imsApiPath, version);
            if (IMS_DEFAULT_URI_MAP.containsKey(key)) {
                return (String)IMS_DEFAULT_URI_MAP.get(key);
            }
        }
        if ((baseUri = this.c4wsConfiguration.getString(String.format("ims/uriMappings/mapping[@src='%s' and not(@version)]", imsApiPath))) != null) {
            return baseUri;
        }
        key = this.createImsKey(imsApiPath, null);
        if (IMS_DEFAULT_URI_MAP.containsKey(key)) {
            return (String)IMS_DEFAULT_URI_MAP.get(key);
        }
        if (StringUtils.isNotEmpty((String)version)) {
            baseUri = this.c4wsConfiguration.getString(String.format("ims/uriMappings/mapping[@src='*' and @version='%s']", version));
            if (baseUri != null) {
                return baseUri;
            }
            key = this.createImsKey(null, version);
            if (IMS_DEFAULT_URI_MAP.containsKey(key)) {
                return (String)IMS_DEFAULT_URI_MAP.get(key);
            }
        }
        if ((baseUri = this.c4wsConfiguration.getString("ims/uriMappings/mapping[@src='*' and not(@version)]")) != null) {
            return baseUri;
        }
        baseUri = (String)IMS_DEFAULT_URI_MAP.get("*\r*");
        return baseUri;
    }

    private String createImsKey(String imsApiPath, String version) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((String)imsApiPath)) {
            sb.append(imsApiPath);
        } else {
            sb.append("*");
        }
        sb.append('\r');
        if (StringUtils.isNotEmpty((String)version)) {
            sb.append(version);
        } else {
            sb.append("*");
        }
        return sb.toString();
    }

    @Deprecated
    public String getIMSService(String imsApiPath, String version) {
        String key = this.createImsKey(imsApiPath, version);
        String value = (String)this.imsServiceCache.get(key);
        if (value == null) {
            value = this.internalGetIMSService(imsApiPath, version);
            this.imsServiceCache.put(key, value);
        }
        return value;
    }

    private String internalGetIMSService(String imsApiPath, String version) {
        String service = null;
        String key = null;
        if (StringUtils.isNotEmpty((String)version)) {
            service = this.c4wsConfiguration.getString(String.format("ims/serviceMappings/mapping[@src='%s' and @version='%s']", imsApiPath, version));
            if (service != null) {
                return service;
            }
            key = this.createImsKey(imsApiPath, version);
            if (IMS_DEFAULT_SERVICE_MAP.containsKey(key)) {
                return (String)IMS_DEFAULT_SERVICE_MAP.get(key);
            }
        }
        if ((service = this.c4wsConfiguration.getString(String.format("ims/serviceMappings/mapping[@src='%s' and not(@version)]", imsApiPath))) != null) {
            return service;
        }
        key = this.createImsKey(imsApiPath, null);
        if (IMS_DEFAULT_SERVICE_MAP.containsKey(key)) {
            return (String)IMS_DEFAULT_SERVICE_MAP.get(key);
        }
        if (StringUtils.isNotEmpty((String)version)) {
            service = this.c4wsConfiguration.getString(String.format("ims/serviceMappings/mapping[@src='*' and @version='%s']", version));
            if (service != null) {
                return service;
            }
            key = this.createImsKey(null, version);
            if (IMS_DEFAULT_SERVICE_MAP.containsKey(key)) {
                return (String)IMS_DEFAULT_SERVICE_MAP.get(key);
            }
        }
        if ((service = this.c4wsConfiguration.getString("ims/serviceMappings/mapping[@src='*' and not(@version)]")) != null) {
            return service;
        }
        service = (String)IMS_DEFAULT_SERVICE_MAP.get("*\r*");
        return service;
    }

    public String getIMSEnvironmentID() {
        return this.getValue("ims/environmentID", null);
    }

    public void setIMSEnvironmentID(String id) {
        this.setC4WSOnlyValue("ims/environmentID", id);
    }

    public ConnectionSpecImpl getIMSConnectionSpec() throws ResourceException {
        String environmentID = this.getIMSEnvironmentID();
        if (environmentID == null) {
            throw new ResourceException("Configuration error: no \"ims environmentID\" has been specified");
        }
        LNEnvironment environment = this.getEnvironmentForID(environmentID);
        if (environment == null) {
            String message = String.format("Configuration error: \"ims environmentID\" specifies an undefined environment ('%s')", environmentID);
            throw new ResourceException(message);
        }
        return environment.createConnectionSpec(environmentID);
    }

    public ConnectionSpecImpl getLNRestConnectionSpec(boolean requireSSL) throws ResourceException {
        LNEnvironment foundEnvironment = null;
        String foundEnvID = null;
        for (String envID : this.getEnvironmentMapping().values()) {
            boolean isSSL;
            LNEnvironment environment = this.getEnvironmentForID(envID);
            if (environment == null || (isSSL = "baanlogin_ssl".equals(environment.getActivation())) != requireSSL) continue;
            foundEnvironment = environment;
            foundEnvID = envID;
            break;
        }
        if (foundEnvironment == null || foundEnvID == null) {
            throw new ResourceException("Configuration error: No suitable REST environment found");
        }
        return foundEnvironment.createConnectionSpec(foundEnvID);
    }

    void updateIfNeeded() throws UpdateException {
        String[] cleartextAttributes = this.c4wsConfiguration.getStringArray("//@cleartext");
        if (cleartextAttributes.length == 0) {
            return;
        }
        for (String passwordKey : new String[]{"cloud/consumersecret", "cloud/keystorepassword"}) {
            if (!this.c4wsConfiguration.containsKey(passwordKey)) continue;
            String value = this.getDecryptedValue(passwordKey, null);
            this.c4wsConfiguration.clearTree(passwordKey);
            this.c4wsConfiguration.addProperty(passwordKey, (Object)PasswordEncryption.getEncryptionPassword((String)value));
        }
        this.save();
    }

    synchronized void save() throws UpdateException {
        if (!this.isEditable) {
            throw new UpdateException(this, "Not allowed to save read-only properties");
        }
        if (!this.c4wsConfigFile.exists()) {
            try {
                this.c4wsConfiguration.save(this.c4wsConfigFile);
                return;
            }
            catch (ConfigurationException ex) {
                throw new UpdateException(this, "Unable to save configuration file", (Throwable)ex);
            }
        }
        File backupFile = null;
        try {
            backupFile = new File(this.c4wsConfigFile.getCanonicalPath() + ".bak");
            Files.copy(this.c4wsConfigFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            throw new UpdateException(this, "Unable to create backup file", (Throwable)ex);
        }
        try {
            this.c4wsConfiguration.save(this.c4wsConfigFile);
            backupFile.delete();
        }
        catch (ConfigurationException ex) {
            if (this.c4wsConfigFile.length() != backupFile.length()) {
                this.c4wsConfigFile.delete();
                backupFile.renameTo(this.c4wsConfigFile);
            }
            throw new UpdateException(this, "Unable to save configuration file", (Throwable)ex);
        }
    }

    public synchronized void saveAs(String fileName) throws UpdateException {
        try {
            this.c4wsConfiguration.save(fileName);
        }
        catch (ConfigurationException ex) {
            String message = String.format("Unable to save configuration file '%s'", fileName);
            throw new UpdateException(this, message, (Throwable)ex);
        }
    }

    public void changeLNUIConfigFile(String lnuiConfigFile) {
        this.c4wsConfiguration.setProperty("general/lnuiConfigFile", (Object)lnuiConfigFile);
        File configFile = this.getLNUIConfigFileOrDefault(lnuiConfigFile);
        this.lnuiConfiguration = C4WSProperties.createXMLConfiguration((File)configFile, (String)"webui");
    }

    public String getLNUIConfigFile() {
        return this.c4wsConfiguration.getString("general/lnuiConfigFile", null);
    }

    private File getLNUIConfigFileOrDefault(String fileName) {
        File result = null;
        if (fileName != null) {
            result = new File(fileName);
            if (!result.isAbsolute()) {
                result = new File(this.c4wsConfigFile.getParentFile(), fileName);
                try {
                    result = result.getCanonicalFile();
                }
                catch (Exception exception) {}
            }
        } else {
            result = new File(this.c4wsConfigFile.getParentFile(), "webuiProperties.xml");
        }
        return result;
    }

    private String getValue(String key, String defaultValue) {
        String result = this.c4wsConfiguration.getString(key);
        if (result == null) {
            result = this.lnuiConfiguration.getString(key);
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    private void setC4WSOnlyValue(String key, String value) {
        if (value == null) {
            this.c4wsConfiguration.clearProperty(key);
        } else {
            this.c4wsConfiguration.setProperty(key, (Object)value);
        }
    }

    private void setCombinedValue(String key, String value) {
        String oldValue = this.lnuiConfiguration.getString(key, null);
        if (oldValue != null && oldValue.equals(value)) {
            this.c4wsConfiguration.clearProperty(key);
        } else {
            this.c4wsConfiguration.setProperty(key, (Object)value);
        }
    }

    private void setCombinedIntValue(String key, int value) {
        int oldValue = this.lnuiConfiguration.getInt(key, Integer.MIN_VALUE);
        if (oldValue == value) {
            this.c4wsConfiguration.clearProperty(key);
        } else {
            this.c4wsConfiguration.setProperty(key, (Object)value);
        }
    }

    private String getDecryptedValue(String key, String defaultValue) {
        String result = this.getValue(key + "[@cleartext='true']", null);
        if (result == null && (result = this.getKmsValue(key)) == null) {
            result = this.getValue(key, null);
            if (result == null) {
                result = defaultValue;
            }
            if (result != null && result.length() > 0) {
                try {
                    result = PasswordEncryption.getDecryptedPasswords((String)result);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private String getKmsValue(String key) {
        String result = this.getValue(key + "[@kms='true']", null);
        if (result != null) {
            result = KmsUtil.getInstance().kmsDecrypt(result);
        }
        return result;
    }

    private String getEncryptedValue(String key, String defaultValue) {
        String cleartextPassword = this.getValue(key + "[@cleartext='true']", null);
        if (cleartextPassword != null) {
            if (cleartextPassword.isEmpty()) {
                return "";
            }
            return PasswordEncryption.getEncryptionPassword((String)cleartextPassword);
        }
        return this.getValue(key, defaultValue);
    }

    private long getLongValue(String key, long defaultValue) {
        long result = defaultValue;
        try {
            result = this.c4wsConfiguration.getLong(key);
        }
        catch (Exception ex) {
            result = this.lnuiConfiguration.getLong(key, defaultValue);
        }
        return result;
    }

    private int getIntValue(String key, int defaultValue) {
        return (int)this.getLongValue(key, (long)defaultValue);
    }

    private String getEnvironmentXPath(String keyWithPlaceholder, String environmentID) {
        return String.format(keyWithPlaceholder, environmentID);
    }

    private String getEnvironmentIdForConnectionpoint(String connectionpoint) {
        String xpath = String.format("%s[@name=\"%s\"]/@ref", "backends/backend", connectionpoint);
        return this.getValue(xpath, "");
    }

    private static XMLConfiguration createXMLConfiguration(File file, String defaultRoot) {
        XMLConfiguration config = new XMLConfiguration();
        config.setEncoding("UTF-8");
        config.setDelimiterParsingDisabled(true);
        config.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        if (file != null && file.exists() && file.length() > 0L) {
            try {
                config.load(file);
            }
            catch (ConfigurationException e) {
                config.clear();
                config.setRootElementName(defaultRoot);
            }
        } else {
            config.setRootElementName(defaultRoot);
        }
        return config;
    }

    public String getFirstEnvironmentID(boolean preferSSL) {
        String firstEnvID = null;
        for (String envID : this.getEnvironmentMapping().values()) {
            if (firstEnvID == null) {
                firstEnvID = envID;
            }
            if (!preferSSL) break;
            LNEnvironment environment = this.getEnvironmentForID(envID);
            if (environment == null || !"baanlogin_ssl".equals(environment.getActivation())) continue;
            firstEnvID = envID;
            break;
        }
        return firstEnvID;
    }

    public boolean isJsonSupported() {
        String jsonAllowed = this.getValue("general/jsonSupport", Boolean.toString(false));
        return Boolean.parseBoolean(jsonAllowed);
    }

    static /* synthetic */ String access$000(C4WSProperties x0, String x1, String x2) {
        return x0.getEnvironmentXPath(x1, x2);
    }

    static /* synthetic */ XMLConfiguration access$100(C4WSProperties x0) {
        return x0.lnuiConfiguration;
    }

    static /* synthetic */ XMLConfiguration access$200(C4WSProperties x0) {
        return x0.c4wsConfiguration;
    }

    static {
        IMS_DEFAULT_URI_MAP.put("*\r*", "/es_server/management/v1/ionims/service");
        IMS_DEFAULT_SERVICE_MAP.put("*\r*", "ION_IMS");
        IMS_DEFAULT_URI_MAP.put("*\rv2", "/es_server/management/v2/ionims/service");
        IMS_DEFAULT_URI_MAP.put("/protocol\r*", "/es_server/management/v2/ionims/service");
        LOG = ESAPI.getLogger(C4WSProperties.class);
    }
}

