/*
 * Decompiled with CFR 0.152.
 */
package com.baan.baanvm;

import com.baan.baanvm.Queue;
import java.util.Dictionary;
import java.util.Hashtable;

class ClassHolder
implements Runnable {
    private static final String COPYRIGHT = "Copyright (c) 1999 Baan Development B.V.";
    private static ClassHolder s_holderInstance = null;
    private final Dictionary m_classes = new Hashtable();
    private Thread m_runner = new Thread((Runnable)this, "ClassHolder-Thread");

    private synchronized void waitForEver() {
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            Queue.LogMessage("ClassLoader.waitForEver(): wait() interrupted with: " + interruptedException, 0);
            Queue.LogMessage("ClassLoader.waitForEver(): stopped waiting", 0);
            return;
        }
    }

    public Class getClass(String string) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(string);
        this.m_classes.put(string, clazz);
        return clazz;
    }

    private ClassHolder() {
        this.m_runner.setDaemon(true);
        this.m_runner.start();
    }

    public static synchronized ClassHolder instance() {
        if (s_holderInstance == null) {
            s_holderInstance = new ClassHolder();
        }
        return s_holderInstance;
    }

    public void run() {
        this.waitForEver();
    }
}

