/*
 * Decompiled with CFR 0.152.
 */
package com.baan.baanvm;

import com.baan.baanvm.Bucket;
import com.baan.baanvm.IQueueListener;
import com.baan.baanvm.Queue;
import java.util.Hashtable;

class QueueListenerDaemon
extends Thread {
    private static Hashtable listeners;
    private IQueueListener listener;
    private int bucketSyncCount;
    private int queueId;

    public static synchronized void installListener(int n, IQueueListener iQueueListener) throws Exception {
        Integer n2;
        QueueListenerDaemon queueListenerDaemon = null;
        int n3 = Queue.bvmInstallListener(n);
        if (n3 != 0) {
            throw new Exception("bvmInstallListener(" + n + ") ret=" + n3);
        }
        if (listeners == null) {
            listeners = new Hashtable();
        }
        if ((queueListenerDaemon = (QueueListenerDaemon)listeners.get(n2 = new Integer(n))) == null) {
            queueListenerDaemon = new QueueListenerDaemon(n, iQueueListener);
            listeners.put(n2, queueListenerDaemon);
            queueListenerDaemon.start();
            Queue.LogMessage("QueueListener on Queue: " + n + " installed", 0);
            return;
        }
        Queue.LogMessage("QueueListener on Queue: " + n + " already installed", 0);
        throw new Exception("QueueListener on Queue: " + n + " already installed");
    }

    private static synchronized void removeListenerDaemon(int n) {
        if (listeners != null) {
            Integer n2 = new Integer(n);
            listeners.remove(n2);
        }
    }

    public static void dispatchQueueEvent(int n, int n2, int n3) throws Exception {
        QueueListenerDaemon queueListenerDaemon = QueueListenerDaemon.getListenerDaemon(n);
        if (queueListenerDaemon != null) {
            queueListenerDaemon.setBucketSync();
            return;
        }
        Queue.LogMessage("QueueListenerDaemon: No QueueListener Installed on QueueId: " + n, 0);
        throw new Exception("dispatchQueueEvent: No QueueListener Installed on QueueId: " + n);
    }

    public QueueListenerDaemon(int n, IQueueListener iQueueListener) {
        this.queueId = n;
        this.listener = iQueueListener;
    }

    public void start() {
        super.start();
        this.setPriority(9);
    }

    public static void stopAll() {
        Queue.LogMessage("QueueListenerDaemon: stop all Java Threads", 0);
        Thread.currentThread().getThreadGroup().stop();
    }

    public synchronized void setBucketSync() {
        this.notify();
    }

    public synchronized boolean getBucketSync() {
        try {
            this.wait(30000L);
            return true;
        }
        catch (InterruptedException interruptedException) {
            Queue.LogMessage("QueueListenerDaemon: wait() interrupted for QueueId: " + this.queueId, 0);
            return false;
        }
    }

    public void run() {
        int n = 0;
        try {
            try {
                while (true) {
                    Bucket bucket;
                    if ((n = Queue.bvmGetBucket(this.queueId, bucket = new Bucket())) > 0 && bucket.getBucket() == null) {
                        Queue.LogMessage("Received NULL Bucket, while expecting bucket of size: " + n, 0);
                        bucket.setBucket("null");
                    }
                    if (n >= 0) {
                        Bucket bucket2 = bucket;
                        Queue.LogMessage("QueueListenerDaemon.run: invoking listener for queue " + this.queueId, 0);
                        this.listener.onReceive(bucket2);
                        continue;
                    }
                    if (n != -4 || !this.getBucketSync()) break;
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Queue.LogMessage(throwable.getMessage(), 1);
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            QueueListenerDaemon.removeListenerDaemon(this.queueId);
            Queue.LogMessage("QueueListenerDaemon: Queue: " + this.queueId + " Listener Stopped (ret=" + n + ")", 0);
            throw throwable;
        }
        QueueListenerDaemon.removeListenerDaemon(this.queueId);
        Queue.LogMessage("QueueListenerDaemon: Queue: " + this.queueId + " Listener Stopped (ret=" + n + ")", 0);
    }

    private static synchronized QueueListenerDaemon getListenerDaemon(int n) {
        QueueListenerDaemon queueListenerDaemon = null;
        if (listeners != null) {
            Integer n2 = new Integer(n);
            queueListenerDaemon = (QueueListenerDaemon)listeners.get(n2);
        }
        return queueListenerDaemon;
    }
}

