/*
 * Decompiled with CFR 0.152.
 */
package com.baan.baanvm.test.queue;

import com.baan.baanvm.BaanVMImpl;
import com.baan.baanvm.IBaanVM;
import com.baan.baanvm.IBucket;
import com.baan.baanvm.IQueueListener;

public class QueuePinger
implements IQueueListener {
    private int m_queueFrom4GL;
    private int m_queueTo4GL;
    private int m_howmanyReceived = 0;
    private static IBaanVM s_iBaanVm = new BaanVMImpl();

    public static void startQueuePinger(int n, int n2) {
        try {
            s_iBaanVm.installListener(n, new QueuePinger(n, n2));
            return;
        }
        catch (Exception exception) {
            s_iBaanVm.logMessage(exception.toString(), 0);
            return;
        }
    }

    public QueuePinger(int n, int n2) {
        this.m_queueFrom4GL = n;
        this.m_queueTo4GL = n2;
    }

    public void onReceive(IBucket iBucket) {
        if (iBucket != null) {
            ++this.m_howmanyReceived;
            if (new Integer(iBucket.getHeader()) != this.m_howmanyReceived) {
                s_iBaanVm.logMessage("Illegal bucket b: " + new String(iBucket.getBucket()) + " h: " + iBucket.getHeader() + "  Expected: " + this.m_howmanyReceived, 0);
            }
            iBucket.setBucket("" + this.m_howmanyReceived + " " + this.m_queueTo4GL);
            int n = s_iBaanVm.putBucket(this.m_queueTo4GL, iBucket);
            if (n < 0) {
                s_iBaanVm.logMessage("Failed to bounce bucket ret = " + n, 0);
                return;
            }
        } else {
            s_iBaanVm.logMessage("QueuePinger(" + this.m_queueFrom4GL + ") received: NULL bucket!!!", 0);
        }
    }

    public static void testQueuePinger(int[] nArray) {
        s_iBaanVm.logMessage("Results are " + nArray[1] + "," + nArray[2] + nArray[3] + "," + nArray[4] + "," + nArray[5] + "," + nArray[6] + "," + nArray[7] + "," + nArray[8] + "," + nArray[9] + ",", 0);
    }
}

