/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;

public class UnionPattern
extends Expression {
    private StepPattern[] m_patterns;

    public void fixupVariables(Vector vector, int n) {
        int n2 = 0;
        while (n2 < this.m_patterns.length) {
            this.m_patterns[n2].fixupVariables(vector, n);
            ++n2;
        }
    }

    public boolean canTraverseOutsideSubtree() {
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.m_patterns[n2].canTraverseOutsideSubtree()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void setPatterns(StepPattern[] stepPatternArray) {
        this.m_patterns = stepPatternArray;
        if (null != stepPatternArray) {
            int n = 0;
            while (n < stepPatternArray.length) {
                stepPatternArray[n].exprSetParent(this);
                ++n;
            }
        }
    }

    public StepPattern[] getPatterns() {
        return this.m_patterns;
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        XObject xObject = null;
        int n = this.m_patterns.length;
        int n2 = 0;
        while (n2 < n) {
            XObject xObject2 = this.m_patterns[n2].execute(xPathContext);
            if (xObject2 != NodeTest.SCORE_NONE) {
                if (null == xObject) {
                    xObject = xObject2;
                } else if (xObject2.num() > xObject.num()) {
                    xObject = xObject2;
                }
            }
            ++n2;
        }
        if (null == xObject) {
            xObject = NodeTest.SCORE_NONE;
        }
        return xObject;
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        xPathVisitor.visitUnionPattern(expressionOwner, this);
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            int n2 = 0;
            while (n2 < n) {
                this.m_patterns[n2].callVisitors(new UnionPathPartOwner(n2), xPathVisitor);
                ++n2;
            }
        }
    }

    public boolean deepEquals(Expression expression) {
        if (!this.isSameClass(expression)) {
            return false;
        }
        UnionPattern unionPattern = (UnionPattern)expression;
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            if (null == unionPattern.m_patterns || unionPattern.m_patterns.length != n) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (!this.m_patterns[n2].deepEquals(unionPattern.m_patterns[n2])) {
                    return false;
                }
                ++n2;
            }
        } else if (unionPattern.m_patterns != null) {
            return false;
        }
        return true;
    }

    class UnionPathPartOwner
    implements ExpressionOwner {
        int m_index;

        UnionPathPartOwner(int n) {
            this.m_index = n;
        }

        public Expression getExpression() {
            return UnionPattern.this.m_patterns[this.m_index];
        }

        public void setExpression(Expression expression) {
            expression.exprSetParent(UnionPattern.this);
            ((UnionPattern)UnionPattern.this).m_patterns[this.m_index] = (StepPattern)expression;
        }
    }
}

