/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;

public class StepPattern
extends NodeTest
implements SubContextList,
ExpressionOwner {
    protected int m_axis;
    String m_targetString;
    StepPattern m_relativePathPattern;
    Expression[] m_predicates;
    private static final boolean DEBUG_MATCHES = false;

    public StepPattern(int n, String string, String string2, int n2, int n3) {
        super(n, string, string2);
        this.m_axis = n2;
    }

    public StepPattern(int n, int n2, int n3) {
        super(n);
        this.m_axis = n2;
    }

    public void calcTargetString() {
        int n = this.getWhatToShow();
        switch (n) {
            case 128: {
                this.m_targetString = "#comment";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                this.m_targetString = "#text";
                break;
            }
            case -1: {
                this.m_targetString = "*";
                break;
            }
            case 256: 
            case 1280: {
                this.m_targetString = "/";
                break;
            }
            case 1: {
                if ("*" == this.m_name) {
                    this.m_targetString = "*";
                    break;
                }
                this.m_targetString = this.m_name;
                break;
            }
            default: {
                this.m_targetString = "*";
            }
        }
    }

    public String getTargetString() {
        return this.m_targetString;
    }

    public void fixupVariables(Vector vector, int n) {
        super.fixupVariables(vector, n);
        if (null != this.m_predicates) {
            int n2 = 0;
            while (n2 < this.m_predicates.length) {
                this.m_predicates[n2].fixupVariables(vector, n);
                ++n2;
            }
        }
        if (null != this.m_relativePathPattern) {
            this.m_relativePathPattern.fixupVariables(vector, n);
        }
    }

    public void setRelativePathPattern(StepPattern stepPattern) {
        this.m_relativePathPattern = stepPattern;
        stepPattern.exprSetParent(this);
        this.calcScore();
    }

    public StepPattern getRelativePathPattern() {
        return this.m_relativePathPattern;
    }

    public Expression[] getPredicates() {
        return this.m_predicates;
    }

    public boolean canTraverseOutsideSubtree() {
        int n = this.getPredicateCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getPredicate(n2).canTraverseOutsideSubtree()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Expression getPredicate(int n) {
        return this.m_predicates[n];
    }

    public final int getPredicateCount() {
        return null == this.m_predicates ? 0 : this.m_predicates.length;
    }

    public void setPredicates(Expression[] expressionArray) {
        this.m_predicates = expressionArray;
        if (null != expressionArray) {
            int n = 0;
            while (n < expressionArray.length) {
                expressionArray[n].exprSetParent(this);
                ++n;
            }
        }
        this.calcScore();
    }

    public void calcScore() {
        if (this.getPredicateCount() > 0 || null != this.m_relativePathPattern) {
            this.m_score = NodeTest.SCORE_OTHER;
        } else {
            super.calcScore();
        }
        if (null == this.m_targetString) {
            this.calcTargetString();
        }
    }

    public XObject execute(XPathContext xPathContext, int n) throws TransformerException {
        DTM dTM = xPathContext.getDTM(n);
        if (dTM != null) {
            int n2 = dTM.getExpandedTypeID(n);
            return this.execute(xPathContext, n, dTM, n2);
        }
        return NodeTest.SCORE_NONE;
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext, xPathContext.getCurrentNode());
    }

    public XObject execute(XPathContext xPathContext, int n, DTM dTM, int n2) throws TransformerException {
        if (this.m_whatToShow == 65536) {
            if (null != this.m_relativePathPattern) {
                return this.m_relativePathPattern.execute(xPathContext);
            }
            return NodeTest.SCORE_NONE;
        }
        XObject xObject = super.execute(xPathContext, n, dTM, n2);
        if (xObject == NodeTest.SCORE_NONE) {
            return NodeTest.SCORE_NONE;
        }
        if (this.getPredicateCount() != 0 && !this.executePredicates(xPathContext, dTM, n)) {
            return NodeTest.SCORE_NONE;
        }
        if (null != this.m_relativePathPattern) {
            return this.m_relativePathPattern.executeRelativePathPattern(xPathContext, dTM, n);
        }
        return xObject;
    }

    private final boolean checkProximityPosition(XPathContext xPathContext, int n, DTM dTM, int n2, int n3) {
        try {
            DTMAxisTraverser dTMAxisTraverser = dTM.getAxisTraverser(12);
            int n4 = dTMAxisTraverser.first(n2);
            while (-1 != n4) {
                Object var18_15;
                try {
                    xPathContext.pushCurrentNode(n4);
                    if (NodeTest.SCORE_NONE != super.execute(xPathContext, n4)) {
                        Object var16_14;
                        int n5;
                        boolean bl = true;
                        try {
                            xPathContext.pushSubContextList(this);
                            n5 = 0;
                            while (n5 < n) {
                                Object var14_13;
                                xPathContext.pushPredicatePos(n5);
                                try {
                                    Object var12_12;
                                    XObject xObject;
                                    block16: {
                                        xObject = this.m_predicates[n5].execute(xPathContext);
                                        try {
                                            if (2 == xObject.getType()) {
                                                throw new Error("Why: Should never have been called");
                                            }
                                            if (xObject.boolWithSideEffects()) break block16;
                                            bl = false;
                                            var12_12 = null;
                                            xObject.detach();
                                        }
                                        catch (Throwable throwable) {
                                            var12_12 = null;
                                            xObject.detach();
                                            throw throwable;
                                        }
                                        var14_13 = null;
                                        xPathContext.popPredicatePos();
                                        {
                                            break;
                                        }
                                    }
                                    var12_12 = null;
                                    xObject.detach();
                                    {
                                    }
                                }
                                catch (Throwable throwable) {
                                    var14_13 = null;
                                    xPathContext.popPredicatePos();
                                    throw throwable;
                                }
                                var14_13 = null;
                                xPathContext.popPredicatePos();
                                ++n5;
                            }
                            var16_14 = null;
                            xPathContext.popSubContextList();
                        }
                        catch (Throwable throwable) {
                            var16_14 = null;
                            xPathContext.popSubContextList();
                            throw throwable;
                        }
                        if (bl) {
                            --n3;
                        }
                        if (n3 < 1) {
                            n5 = 0;
                            var18_15 = null;
                            xPathContext.popCurrentNode();
                            return n5 != 0;
                        }
                    }
                    var18_15 = null;
                    xPathContext.popCurrentNode();
                }
                catch (Throwable throwable) {
                    var18_15 = null;
                    xPathContext.popCurrentNode();
                    throw throwable;
                }
                n4 = dTMAxisTraverser.next(n2, n4);
            }
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException.getMessage());
        }
        return n3 == 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getProximityPosition(XPathContext xPathContext, int n, boolean bl) {
        int n2 = 0;
        int n3 = xPathContext.getCurrentNode();
        DTM dTM = xPathContext.getDTM(n3);
        int n4 = dTM.getParent(n3);
        try {
            DTMAxisTraverser dTMAxisTraverser = dTM.getAxisTraverser(3);
            int n5 = dTMAxisTraverser.first(n4);
            while (true) {
                Object var20_17;
                if (-1 == n5) {
                    return n2;
                }
                try {
                    xPathContext.pushCurrentNode(n5);
                    if (NodeTest.SCORE_NONE != super.execute(xPathContext, n5)) {
                        Object var18_16;
                        int n6;
                        boolean bl2 = true;
                        try {
                            xPathContext.pushSubContextList(this);
                            n6 = 0;
                            while (true) {
                                Object var16_15;
                                block22: {
                                    block21: {
                                        if (n6 >= n) {
                                            break;
                                        }
                                        xPathContext.pushPredicatePos(n6);
                                        try {
                                            Object var14_14;
                                            XObject xObject;
                                            block18: {
                                                block20: {
                                                    block19: {
                                                        xObject = this.m_predicates[n6].execute(xPathContext);
                                                        try {
                                                            if (2 == xObject.getType()) {
                                                                if (n2 + 1 == (int)xObject.numWithSideEffects()) break block18;
                                                                bl2 = false;
                                                                var14_14 = null;
                                                                xObject.detach();
                                                                break block19;
                                                            }
                                                            if (xObject.boolWithSideEffects()) break block18;
                                                            bl2 = false;
                                                            break block20;
                                                        }
                                                        catch (Throwable throwable) {
                                                            var14_14 = null;
                                                            xObject.detach();
                                                            throw throwable;
                                                        }
                                                    }
                                                    var16_15 = null;
                                                    xPathContext.popPredicatePos();
                                                    break;
                                                }
                                                var14_14 = null;
                                                xObject.detach();
                                                break block21;
                                            }
                                            var14_14 = null;
                                            xObject.detach();
                                            break block22;
                                        }
                                        catch (Throwable throwable) {
                                            var16_15 = null;
                                            xPathContext.popPredicatePos();
                                            throw throwable;
                                        }
                                    }
                                    var16_15 = null;
                                    xPathContext.popPredicatePos();
                                    break;
                                }
                                var16_15 = null;
                                xPathContext.popPredicatePos();
                                ++n6;
                            }
                            var18_16 = null;
                            xPathContext.popSubContextList();
                        }
                        catch (Throwable throwable) {
                            var18_16 = null;
                            xPathContext.popSubContextList();
                            throw throwable;
                        }
                        if (bl2) {
                            ++n2;
                        }
                        if (!bl && n5 == n3) {
                            n6 = n2;
                            var20_17 = null;
                            xPathContext.popCurrentNode();
                            return n6;
                        }
                    }
                    var20_17 = null;
                    xPathContext.popCurrentNode();
                }
                catch (Throwable throwable) {
                    var20_17 = null;
                    xPathContext.popCurrentNode();
                    throw throwable;
                }
                n5 = dTMAxisTraverser.next(n4, n5);
            }
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException.getMessage());
        }
    }

    public int getProximityPosition(XPathContext xPathContext) {
        return this.getProximityPosition(xPathContext, xPathContext.getPredicatePos(), false);
    }

    public int getLastPos(XPathContext xPathContext) {
        return this.getProximityPosition(xPathContext, xPathContext.getPredicatePos(), true);
    }

    protected final XObject executeRelativePathPattern(XPathContext xPathContext, DTM dTM, int n) throws TransformerException {
        XObject xObject = NodeTest.SCORE_NONE;
        int n2 = n;
        DTMAxisTraverser dTMAxisTraverser = dTM.getAxisTraverser(this.m_axis);
        int n3 = dTMAxisTraverser.first(n2);
        while (-1 != n3) {
            Object var9_8;
            try {
                xPathContext.pushCurrentNode(n3);
                xObject = this.execute(xPathContext);
                if (xObject != NodeTest.SCORE_NONE) {
                    var9_8 = null;
                    xPathContext.popCurrentNode();
                    break;
                }
                var9_8 = null;
                xPathContext.popCurrentNode();
            }
            catch (Throwable throwable) {
                var9_8 = null;
                xPathContext.popCurrentNode();
                throw throwable;
            }
            n3 = dTMAxisTraverser.next(n2, n3);
        }
        return xObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean executePredicates(XPathContext xPathContext, DTM dTM, int n) throws TransformerException {
        boolean bl = true;
        boolean bl2 = false;
        int n2 = this.getPredicateCount();
        try {
            xPathContext.pushSubContextList(this);
            int n3 = 0;
            while (true) {
                Object var13_11;
                block16: {
                    block15: {
                        block14: {
                            if (n3 >= n2) {
                                break;
                            }
                            xPathContext.pushPredicatePos(n3);
                            try {
                                Object var11_10;
                                XObject xObject;
                                block11: {
                                    block13: {
                                        block12: {
                                            block10: {
                                                xObject = this.m_predicates[n3].execute(xPathContext);
                                                try {
                                                    if (2 == xObject.getType()) {
                                                        int n4 = (int)xObject.num();
                                                        if (bl2) {
                                                            bl = n4 == 1;
                                                            var11_10 = null;
                                                            xObject.detach();
                                                            break block10;
                                                        }
                                                        bl2 = true;
                                                        if (this.checkProximityPosition(xPathContext, n3, dTM, n, n4)) break block11;
                                                        bl = false;
                                                        break block12;
                                                    }
                                                    if (xObject.boolWithSideEffects()) break block11;
                                                    bl = false;
                                                    break block13;
                                                }
                                                catch (Throwable throwable) {
                                                    var11_10 = null;
                                                    xObject.detach();
                                                    throw throwable;
                                                }
                                            }
                                            var13_11 = null;
                                            xPathContext.popPredicatePos();
                                            break;
                                        }
                                        var11_10 = null;
                                        xObject.detach();
                                        break block14;
                                    }
                                    var11_10 = null;
                                    xObject.detach();
                                    break block15;
                                }
                                var11_10 = null;
                                xObject.detach();
                                break block16;
                            }
                            catch (Throwable throwable) {
                                var13_11 = null;
                                xPathContext.popPredicatePos();
                                throw throwable;
                            }
                        }
                        var13_11 = null;
                        xPathContext.popPredicatePos();
                        break;
                    }
                    var13_11 = null;
                    xPathContext.popPredicatePos();
                    break;
                }
                var13_11 = null;
                xPathContext.popPredicatePos();
                ++n3;
            }
            Object var15_14 = null;
            xPathContext.popSubContextList();
            return bl;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            xPathContext.popSubContextList();
            throw throwable;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StepPattern stepPattern = this;
        while (stepPattern != null) {
            if (stepPattern != this) {
                stringBuffer.append("/");
            }
            stringBuffer.append(Axis.names[stepPattern.m_axis]);
            stringBuffer.append("::");
            if (20480 == stepPattern.m_whatToShow) {
                stringBuffer.append("doc()");
            } else if (65536 == stepPattern.m_whatToShow) {
                stringBuffer.append("function()");
            } else if (-1 == stepPattern.m_whatToShow) {
                stringBuffer.append("node()");
            } else if (4 == stepPattern.m_whatToShow) {
                stringBuffer.append("text()");
            } else if (64 == stepPattern.m_whatToShow) {
                stringBuffer.append("processing-instruction(");
                if (null != stepPattern.m_name) {
                    stringBuffer.append(stepPattern.m_name);
                }
                stringBuffer.append(")");
            } else if (128 == stepPattern.m_whatToShow) {
                stringBuffer.append("comment()");
            } else if (null != stepPattern.m_name) {
                if (2 == stepPattern.m_whatToShow) {
                    stringBuffer.append("@");
                }
                if (null != stepPattern.m_namespace) {
                    stringBuffer.append("{");
                    stringBuffer.append(stepPattern.m_namespace);
                    stringBuffer.append("}");
                }
                stringBuffer.append(stepPattern.m_name);
            } else if (2 == stepPattern.m_whatToShow) {
                stringBuffer.append("@");
            } else if (1280 == stepPattern.m_whatToShow) {
                stringBuffer.append("doc-root()");
            } else {
                stringBuffer.append("?" + Integer.toHexString(stepPattern.m_whatToShow));
            }
            if (null != stepPattern.m_predicates) {
                int n = 0;
                while (n < stepPattern.m_predicates.length) {
                    stringBuffer.append("[");
                    stringBuffer.append(stepPattern.m_predicates[n]);
                    stringBuffer.append("]");
                    ++n;
                }
            }
            stepPattern = stepPattern.m_relativePathPattern;
        }
        return stringBuffer.toString();
    }

    public double getMatchScore(XPathContext xPathContext, int n) throws TransformerException {
        xPathContext.pushCurrentNode(n);
        xPathContext.pushCurrentExpressionNode(n);
        try {
            XObject xObject = this.execute(xPathContext);
            double d = xObject.num();
            Object var7_5 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            return d;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public void setAxis(int n) {
        this.m_axis = n;
    }

    public int getAxis() {
        return this.m_axis;
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        if (xPathVisitor.visitMatchPattern(expressionOwner, this)) {
            this.callSubtreeVisitors(xPathVisitor);
        }
    }

    protected void callSubtreeVisitors(XPathVisitor xPathVisitor) {
        if (null != this.m_predicates) {
            int n = this.m_predicates.length;
            int n2 = 0;
            while (n2 < n) {
                PredOwner predOwner = new PredOwner(n2);
                if (xPathVisitor.visitPredicate(predOwner, this.m_predicates[n2])) {
                    this.m_predicates[n2].callVisitors(predOwner, xPathVisitor);
                }
                ++n2;
            }
        }
        if (null != this.m_relativePathPattern) {
            this.m_relativePathPattern.callVisitors(this, xPathVisitor);
        }
    }

    public Expression getExpression() {
        return this.m_relativePathPattern;
    }

    public void setExpression(Expression expression) {
        expression.exprSetParent(this);
        this.m_relativePathPattern = (StepPattern)expression;
    }

    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        StepPattern stepPattern = (StepPattern)expression;
        if (null != this.m_predicates) {
            int n = this.m_predicates.length;
            if (null == stepPattern.m_predicates || stepPattern.m_predicates.length != n) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (!this.m_predicates[n2].deepEquals(stepPattern.m_predicates[n2])) {
                    return false;
                }
                ++n2;
            }
        } else if (null != stepPattern.m_predicates) {
            return false;
        }
        return !(null != this.m_relativePathPattern ? !this.m_relativePathPattern.deepEquals(stepPattern.m_relativePathPattern) : stepPattern.m_relativePathPattern != null);
    }

    class PredOwner
    implements ExpressionOwner {
        int m_index;

        PredOwner(int n) {
            this.m_index = n;
        }

        public Expression getExpression() {
            return StepPattern.this.m_predicates[this.m_index];
        }

        public void setExpression(Expression expression) {
            expression.exprSetParent(StepPattern.this);
            StepPattern.this.m_predicates[this.m_index] = expression;
        }
    }
}

