/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;

public class FunctionPattern
extends StepPattern {
    Expression m_functionExpr;

    public FunctionPattern(Expression expression, int n, int n2) {
        super(0, null, null, n, n2);
        this.m_functionExpr = expression;
    }

    public final void calcScore() {
        this.m_score = NodeTest.SCORE_OTHER;
        if (null == this.m_targetString) {
            this.calcTargetString();
        }
    }

    public void fixupVariables(Vector vector, int n) {
        super.fixupVariables(vector, n);
        this.m_functionExpr.fixupVariables(vector, n);
    }

    public XObject execute(XPathContext xPathContext, int n) throws TransformerException {
        DTMIterator dTMIterator = this.m_functionExpr.asIterator(xPathContext, n);
        XNumber xNumber = NodeTest.SCORE_NONE;
        if (null != dTMIterator) {
            int n2;
            while (-1 != (n2 = dTMIterator.nextNode())) {
                XNumber xNumber2 = xNumber = n2 == n ? NodeTest.SCORE_OTHER : NodeTest.SCORE_NONE;
                if (xNumber != NodeTest.SCORE_OTHER) continue;
                n = n2;
                break;
            }
        }
        dTMIterator.detach();
        return xNumber;
    }

    public XObject execute(XPathContext xPathContext, int n, DTM dTM, int n2) throws TransformerException {
        DTMIterator dTMIterator = this.m_functionExpr.asIterator(xPathContext, n);
        XNumber xNumber = NodeTest.SCORE_NONE;
        if (null != dTMIterator) {
            int n3;
            while (-1 != (n3 = dTMIterator.nextNode())) {
                XNumber xNumber2 = xNumber = n3 == n ? NodeTest.SCORE_OTHER : NodeTest.SCORE_NONE;
                if (xNumber != NodeTest.SCORE_OTHER) continue;
                n = n3;
                break;
            }
            dTMIterator.detach();
        }
        return xNumber;
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        int n = xPathContext.getCurrentNode();
        DTMIterator dTMIterator = this.m_functionExpr.asIterator(xPathContext, n);
        XNumber xNumber = NodeTest.SCORE_NONE;
        if (null != dTMIterator) {
            int n2;
            while (-1 != (n2 = dTMIterator.nextNode())) {
                XNumber xNumber2 = xNumber = n2 == n ? NodeTest.SCORE_OTHER : NodeTest.SCORE_NONE;
                if (xNumber != NodeTest.SCORE_OTHER) continue;
                n = n2;
                break;
            }
            dTMIterator.detach();
        }
        return xNumber;
    }

    protected void callSubtreeVisitors(XPathVisitor xPathVisitor) {
        this.m_functionExpr.callVisitors(new FunctionOwner(), xPathVisitor);
        super.callSubtreeVisitors(xPathVisitor);
    }

    class FunctionOwner
    implements ExpressionOwner {
        FunctionOwner() {
        }

        public Expression getExpression() {
            return FunctionPattern.this.m_functionExpr;
        }

        public void setExpression(Expression expression) {
            expression.exprSetParent(FunctionPattern.this);
            FunctionPattern.this.m_functionExpr = expression;
        }
    }
}

