/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import java.util.Vector;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.functions.Function3Args;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.res.XPATHMessages;

public class FunctionMultiArgs
extends Function3Args {
    Expression[] m_args;

    public Expression[] getArgs() {
        return this.m_args;
    }

    public void setArg(Expression expression, int n) throws WrongNumberArgsException {
        if (n < 3) {
            super.setArg(expression, n);
        } else {
            if (null == this.m_args) {
                this.m_args = new Expression[1];
                this.m_args[0] = expression;
            } else {
                Expression[] expressionArray = new Expression[this.m_args.length + 1];
                System.arraycopy(this.m_args, 0, expressionArray, 0, this.m_args.length);
                expressionArray[this.m_args.length] = expression;
                this.m_args = expressionArray;
            }
            expression.exprSetParent(this);
        }
    }

    public void fixupVariables(Vector vector, int n) {
        super.fixupVariables(vector, n);
        if (null != this.m_args) {
            int n2 = 0;
            while (n2 < this.m_args.length) {
                this.m_args[n2].fixupVariables(vector, n);
                ++n2;
            }
        }
    }

    public void checkNumberArgs(int n) throws WrongNumberArgsException {
    }

    protected void reportWrongNumberArgs() throws WrongNumberArgsException {
        String string = XPATHMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{"Programmer's assertion:  the method FunctionMultiArgs.reportWrongNumberArgs() should never be called."});
        throw new RuntimeException(string);
    }

    public boolean canTraverseOutsideSubtree() {
        if (super.canTraverseOutsideSubtree()) {
            return true;
        }
        int n = this.m_args.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.m_args[n2].canTraverseOutsideSubtree()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void callArgVisitors(XPathVisitor xPathVisitor) {
        super.callArgVisitors(xPathVisitor);
        if (null != this.m_args) {
            int n = this.m_args.length;
            int n2 = 0;
            while (n2 < n) {
                this.m_args[n2].callVisitors(new ArgMultiOwner(n2), xPathVisitor);
                ++n2;
            }
        }
    }

    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        FunctionMultiArgs functionMultiArgs = (FunctionMultiArgs)expression;
        if (null != this.m_args) {
            int n = this.m_args.length;
            if (null == functionMultiArgs || functionMultiArgs.m_args.length != n) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (!this.m_args[n2].deepEquals(functionMultiArgs.m_args[n2])) {
                    return false;
                }
                ++n2;
            }
        } else if (null != functionMultiArgs.m_args) {
            return false;
        }
        return true;
    }

    class ArgMultiOwner
    implements ExpressionOwner {
        int m_argIndex;

        ArgMultiOwner(int n) {
            this.m_argIndex = n;
        }

        public Expression getExpression() {
            return FunctionMultiArgs.this.m_args[this.m_argIndex];
        }

        public void setExpression(Expression expression) {
            expression.exprSetParent(FunctionMultiArgs.this);
            FunctionMultiArgs.this.m_args[this.m_argIndex] = expression;
        }
    }
}

