/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.ExtensionsProvider;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.functions.Function;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.objects.XNull;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.res.XPATHMessages;

public class FuncExtFunction
extends Function {
    String m_namespace;
    String m_extensionName;
    Object m_methodKey;
    Vector m_argVec = new Vector();

    public void fixupVariables(Vector vector, int n) {
        if (null != this.m_argVec) {
            int n2 = this.m_argVec.size();
            int n3 = 0;
            while (n3 < n2) {
                Expression expression = (Expression)this.m_argVec.elementAt(n3);
                expression.fixupVariables(vector, n);
                ++n3;
            }
        }
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getFunctionName() {
        return this.m_extensionName;
    }

    public Object getMethodKey() {
        return this.m_methodKey;
    }

    public Expression getArg(int n) {
        if (n >= 0 && n < this.m_argVec.size()) {
            return (Expression)this.m_argVec.elementAt(n);
        }
        return null;
    }

    public int getArgCount() {
        return this.m_argVec.size();
    }

    public FuncExtFunction(String string, String string2, Object object) {
        this.m_namespace = string;
        this.m_extensionName = string2;
        this.m_methodKey = object;
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        int n = this.m_argVec.size();
        int n2 = 0;
        while (n2 < n) {
            object2 = (Expression)this.m_argVec.elementAt(n2);
            object = ((Expression)object2).execute(xPathContext);
            vector.addElement(object);
            ++n2;
        }
        object2 = (ExtensionsProvider)xPathContext.getOwnerObject();
        object = object2.extFunction(this, vector);
        XObject xObject = null != object ? XObject.create(object, xPathContext) : new XNull();
        return xObject;
    }

    public void setArg(Expression expression, int n) throws WrongNumberArgsException {
        this.m_argVec.addElement(expression);
    }

    public void checkNumberArgs(int n) throws WrongNumberArgsException {
    }

    public void callArgVisitors(XPathVisitor xPathVisitor) {
        int n = 0;
        while (n < this.m_argVec.size()) {
            Expression expression = (Expression)this.m_argVec.elementAt(n);
            expression.callVisitors(new ArgExtOwner(expression), xPathVisitor);
            ++n;
        }
    }

    public void exprSetParent(ExpressionNode expressionNode) {
        super.exprSetParent(expressionNode);
        int n = this.m_argVec.size();
        int n2 = 0;
        while (n2 < n) {
            Expression expression = (Expression)this.m_argVec.elementAt(n2);
            expression.exprSetParent(expressionNode);
            ++n2;
        }
    }

    protected void reportWrongNumberArgs() throws WrongNumberArgsException {
        String string = XPATHMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{"Programmer's assertion:  the method FunctionMultiArgs.reportWrongNumberArgs() should never be called."});
        throw new RuntimeException(string);
    }

    class ArgExtOwner
    implements ExpressionOwner {
        Expression m_exp;

        ArgExtOwner(Expression expression) {
            this.m_exp = expression;
        }

        public Expression getExpression() {
            return this.m_exp;
        }

        public void setExpression(Expression expression) {
            expression.exprSetParent(FuncExtFunction.this);
            this.m_exp = expression;
        }
    }
}

