/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.compiler;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.ObjectVector;
import org.apache.xpath.compiler.OpMapVector;
import org.apache.xpath.res.XPATHMessages;

public class OpMap {
    protected String m_currentPattern;
    static final int MAXTOKENQUEUESIZE = 500;
    static final int BLOCKTOKENQUEUESIZE = 500;
    ObjectVector m_tokenQueue = new ObjectVector(500, 500);
    OpMapVector m_opMap = null;
    public static final int MAPINDEX_LENGTH = 1;

    public String toString() {
        return this.m_currentPattern;
    }

    public String getPatternString() {
        return this.m_currentPattern;
    }

    public ObjectVector getTokenQueue() {
        return this.m_tokenQueue;
    }

    public Object getToken(int n) {
        return this.m_tokenQueue.elementAt(n);
    }

    public int getTokenQueueSize() {
        return this.m_tokenQueue.size();
    }

    public OpMapVector getOpMap() {
        return this.m_opMap;
    }

    void shrink() {
        int n = this.m_opMap.elementAt(1);
        this.m_opMap.setToSize(n + 4);
        this.m_opMap.setElementAt(0, n);
        this.m_opMap.setElementAt(0, n + 1);
        this.m_opMap.setElementAt(0, n + 2);
        n = this.m_tokenQueue.size();
        this.m_tokenQueue.setToSize(n + 4);
        this.m_tokenQueue.setElementAt(null, n);
        this.m_tokenQueue.setElementAt(null, n + 1);
        this.m_tokenQueue.setElementAt(null, n + 2);
    }

    public int getOp(int n) {
        return this.m_opMap.elementAt(n);
    }

    public void setOp(int n, int n2) {
        this.m_opMap.setElementAt(n2, n);
    }

    public int getNextOpPos(int n) {
        return n + this.m_opMap.elementAt(n + 1);
    }

    public int getNextStepPos(int n) {
        int n2 = this.getOp(n);
        if (n2 >= 37 && n2 <= 53) {
            return this.getNextOpPos(n);
        }
        if (n2 >= 22 && n2 <= 25) {
            int n3 = this.getNextOpPos(n);
            while (29 == this.getOp(n3)) {
                n3 = this.getNextOpPos(n3);
            }
            n2 = this.getOp(n3);
            if (n2 < 37 || n2 > 53) {
                return -1;
            }
            return n3;
        }
        throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_UNKNOWN_STEP", new Object[]{new Integer(n2).toString()}));
    }

    public static int getNextOpPos(int[] nArray, int n) {
        return n + nArray[n + 1];
    }

    public int getFirstPredicateOpPos(int n) throws TransformerException {
        int n2 = this.m_opMap.elementAt(n);
        if (n2 >= 37 && n2 <= 53) {
            return n + this.m_opMap.elementAt(n + 2);
        }
        if (n2 >= 22 && n2 <= 25) {
            return n + this.m_opMap.elementAt(n + 1);
        }
        if (-2 == n2) {
            return -2;
        }
        this.error("ER_UNKNOWN_OPCODE", new Object[]{String.valueOf(n2)});
        return -1;
    }

    public void error(String string, Object[] objectArray) throws TransformerException {
        String string2 = XPATHMessages.createXPATHMessage(string, objectArray);
        throw new TransformerException(string2);
    }

    public static int getFirstChildPos(int n) {
        return n + 2;
    }

    public int getArgLength(int n) {
        return this.m_opMap.elementAt(n + 1);
    }

    public int getArgLengthOfStep(int n) {
        return this.m_opMap.elementAt(n + 1 + 1) - 3;
    }

    public static int getFirstChildPosOfStep(int n) {
        return n + 3;
    }

    public int getStepTestType(int n) {
        return this.m_opMap.elementAt(n + 3);
    }

    public String getStepNS(int n) {
        int n2 = this.getArgLengthOfStep(n);
        if (n2 == 3) {
            int n3 = this.m_opMap.elementAt(n + 4);
            if (n3 >= 0) {
                return (String)this.m_tokenQueue.elementAt(n3);
            }
            if (-3 == n3) {
                return "*";
            }
            return null;
        }
        return null;
    }

    public String getStepLocalName(int n) {
        int n2;
        int n3 = this.getArgLengthOfStep(n);
        switch (n3) {
            case 0: {
                n2 = -2;
                break;
            }
            case 1: {
                n2 = -3;
                break;
            }
            case 2: {
                n2 = this.m_opMap.elementAt(n + 4);
                break;
            }
            case 3: {
                n2 = this.m_opMap.elementAt(n + 5);
                break;
            }
            default: {
                n2 = -2;
            }
        }
        if (n2 >= 0) {
            return this.m_tokenQueue.elementAt(n2).toString();
        }
        if (-3 == n2) {
            return "*";
        }
        return null;
    }
}

