/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;

public class WalkingIterator
extends LocPathIterator
implements ExpressionOwner {
    protected AxesWalker m_lastUsedWalker;
    protected AxesWalker m_firstWalker;

    WalkingIterator(Compiler compiler, int n, int n2, boolean bl) throws TransformerException {
        super(compiler, n, n2, bl);
        int n3 = OpMap.getFirstChildPos(n);
        if (bl) {
            this.m_lastUsedWalker = this.m_firstWalker = WalkerFactory.loadWalkers(this, compiler, n3, 0);
        }
    }

    public WalkingIterator(PrefixResolver prefixResolver) {
        super(prefixResolver);
    }

    public int getAnalysisBits() {
        int n = 0;
        if (null != this.m_firstWalker) {
            AxesWalker axesWalker = this.m_firstWalker;
            while (null != axesWalker) {
                int n2 = axesWalker.getAnalysisBits();
                n |= n2;
                axesWalker = axesWalker.getNextWalker();
            }
        }
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        WalkingIterator walkingIterator = (WalkingIterator)super.clone();
        if (null != this.m_firstWalker) {
            walkingIterator.m_firstWalker = this.m_firstWalker.cloneDeep(walkingIterator, null);
        }
        return walkingIterator;
    }

    public void reset() {
        super.reset();
        if (null != this.m_firstWalker) {
            this.m_lastUsedWalker = this.m_firstWalker;
            this.m_firstWalker.setRoot(this.m_context);
        }
    }

    public void setRoot(int n, Object object) {
        super.setRoot(n, object);
        if (null != this.m_firstWalker) {
            this.m_firstWalker.setRoot(n);
            this.m_lastUsedWalker = this.m_firstWalker;
        }
    }

    public int nextNode() {
        if (this.m_foundLast) {
            return -1;
        }
        if (-1 == this.m_stackFrame) {
            return this.returnNextNode(this.m_firstWalker.nextNode());
        }
        VariableStack variableStack = this.m_execContext.getVarStack();
        int n = variableStack.getStackFrame();
        variableStack.setStackFrame(this.m_stackFrame);
        int n2 = this.returnNextNode(this.m_firstWalker.nextNode());
        variableStack.setStackFrame(n);
        return n2;
    }

    public final AxesWalker getFirstWalker() {
        return this.m_firstWalker;
    }

    public final void setFirstWalker(AxesWalker axesWalker) {
        this.m_firstWalker = axesWalker;
    }

    public final void setLastUsedWalker(AxesWalker axesWalker) {
        this.m_lastUsedWalker = axesWalker;
    }

    public final AxesWalker getLastUsedWalker() {
        return this.m_lastUsedWalker;
    }

    public void detach() {
        if (this.m_allowDetach) {
            AxesWalker axesWalker = this.m_firstWalker;
            while (null != axesWalker) {
                axesWalker.detach();
                axesWalker = axesWalker.getNextWalker();
            }
            this.m_lastUsedWalker = null;
            super.detach();
        }
    }

    public void fixupVariables(Vector vector, int n) {
        this.m_predicateIndex = -1;
        AxesWalker axesWalker = this.m_firstWalker;
        while (null != axesWalker) {
            axesWalker.fixupVariables(vector, n);
            axesWalker = axesWalker.getNextWalker();
        }
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        if (xPathVisitor.visitLocationPath(expressionOwner, this) && null != this.m_firstWalker) {
            this.m_firstWalker.callVisitors(this, xPathVisitor);
        }
    }

    public Expression getExpression() {
        return this.m_firstWalker;
    }

    public void setExpression(Expression expression) {
        expression.exprSetParent(this);
        this.m_firstWalker = (AxesWalker)expression;
    }

    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        AxesWalker axesWalker = this.m_firstWalker;
        AxesWalker axesWalker2 = ((WalkingIterator)expression).m_firstWalker;
        while (null != axesWalker && null != axesWalker2) {
            if (!axesWalker.deepEquals(axesWalker2)) {
                return false;
            }
            axesWalker = axesWalker.getNextWalker();
            axesWalker2 = axesWalker2.getNextWalker();
        }
        return null == axesWalker && null == axesWalker2;
    }
}

