/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.FilterExprWalker;
import org.apache.xpath.axes.HasPositionalPredChecker;
import org.apache.xpath.axes.IteratorPool;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.PathComponent;
import org.apache.xpath.axes.UnionChildIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;

public class UnionPathIterator
extends LocPathIterator
implements Cloneable,
DTMIterator,
Serializable,
PathComponent {
    protected LocPathIterator[] m_exprs;
    protected DTMIterator[] m_iterators;

    public UnionPathIterator() {
        this.m_iterators = null;
        this.m_exprs = null;
    }

    public void setRoot(int n, Object object) {
        super.setRoot(n, object);
        try {
            if (null != this.m_exprs) {
                int n2 = this.m_exprs.length;
                DTMIterator[] dTMIteratorArray = new DTMIterator[n2];
                int n3 = 0;
                while (n3 < n2) {
                    DTMIterator dTMIterator;
                    dTMIteratorArray[n3] = dTMIterator = this.m_exprs[n3].asIterator(this.m_execContext, n);
                    dTMIterator.nextNode();
                    ++n3;
                }
                this.m_iterators = dTMIteratorArray;
            }
        }
        catch (Exception exception) {
            throw new WrappedRuntimeException(exception);
        }
    }

    public void addIterator(DTMIterator dTMIterator) {
        if (null == this.m_iterators) {
            this.m_iterators = new DTMIterator[1];
            this.m_iterators[0] = dTMIterator;
        } else {
            DTMIterator[] dTMIteratorArray = this.m_iterators;
            int n = this.m_iterators.length;
            this.m_iterators = new DTMIterator[n + 1];
            System.arraycopy(dTMIteratorArray, 0, this.m_iterators, 0, n);
            this.m_iterators[n] = dTMIterator;
        }
        dTMIterator.nextNode();
        if (dTMIterator instanceof Expression) {
            ((Expression)((Object)dTMIterator)).exprSetParent(this);
        }
    }

    public void detach() {
        if (null != this.m_iterators) {
            int n = this.m_iterators.length;
            int n2 = 0;
            while (n2 < n) {
                this.m_iterators[n2].detach();
                ++n2;
            }
            this.m_iterators = null;
        }
    }

    public UnionPathIterator(Compiler compiler, int n) throws TransformerException {
        n = OpMap.getFirstChildPos(n);
        this.loadLocationPaths(compiler, n, 0);
    }

    public static LocPathIterator createUnionIterator(Compiler compiler, int n) throws TransformerException {
        LocPathIterator locPathIterator;
        UnionPathIterator unionPathIterator = new UnionPathIterator(compiler, n);
        int n2 = unionPathIterator.m_exprs.length;
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2) {
            locPathIterator = unionPathIterator.m_exprs[n3];
            if (locPathIterator.getAxis() != 3) {
                bl = false;
                break;
            }
            if (HasPositionalPredChecker.check(locPathIterator)) {
                bl = false;
                break;
            }
            ++n3;
        }
        if (bl) {
            locPathIterator = new UnionChildIterator();
            int n4 = 0;
            while (n4 < n2) {
                LocPathIterator locPathIterator2 = unionPathIterator.m_exprs[n4];
                ((UnionChildIterator)locPathIterator).addNodeTest(locPathIterator2);
                ++n4;
            }
            return locPathIterator;
        }
        return unionPathIterator;
    }

    public int getAnalysisBits() {
        int n = 0;
        if (this.m_exprs != null) {
            int n2 = this.m_exprs.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.m_exprs[n3].getAnalysisBits();
                n |= n4;
                ++n3;
            }
        }
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, TransformerException {
        try {
            objectInputStream.defaultReadObject();
            this.m_clones = new IteratorPool(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TransformerException(classNotFoundException);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        UnionPathIterator unionPathIterator = (UnionPathIterator)super.clone();
        return unionPathIterator;
    }

    protected LocPathIterator createDTMIterator(Compiler compiler, int n) throws TransformerException {
        LocPathIterator locPathIterator = (LocPathIterator)WalkerFactory.newDTMIterator(compiler, n, compiler.getLocationPathDepth() <= 0);
        return locPathIterator;
    }

    protected void loadLocationPaths(Compiler compiler, int n, int n2) throws TransformerException {
        int n3 = compiler.getOp(n);
        if (n3 == 28) {
            this.loadLocationPaths(compiler, compiler.getNextOpPos(n), n2 + 1);
            this.m_exprs[n2] = this.createDTMIterator(compiler, n);
            this.m_exprs[n2].exprSetParent(this);
        } else {
            switch (n3) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.loadLocationPaths(compiler, compiler.getNextOpPos(n), n2 + 1);
                    WalkingIterator walkingIterator = new WalkingIterator(compiler.getNamespaceContext());
                    walkingIterator.exprSetParent(this);
                    if (compiler.getLocationPathDepth() <= 0) {
                        walkingIterator.setIsTopLevel(true);
                    }
                    walkingIterator.m_firstWalker = new FilterExprWalker(walkingIterator);
                    walkingIterator.m_firstWalker.init(compiler, n, n3);
                    this.m_exprs[n2] = walkingIterator;
                    break;
                }
                default: {
                    this.m_exprs = new LocPathIterator[n2];
                }
            }
        }
    }

    public int nextNode() {
        if (this.m_foundLast) {
            return -1;
        }
        int n = -1;
        if (null != this.m_iterators) {
            int n2 = this.m_iterators.length;
            int n3 = -1;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = this.m_iterators[n4].getCurrentNode();
                if (-1 != n5) {
                    if (-1 == n) {
                        n3 = n4;
                        n = n5;
                    } else if (n5 == n) {
                        this.m_iterators[n4].nextNode();
                    } else {
                        DTM dTM = this.getDTM(n5);
                        if (dTM.isNodeAfter(n5, n)) {
                            n3 = n4;
                            n = n5;
                        }
                    }
                }
                ++n4;
            }
            if (-1 != n) {
                this.m_iterators[n3].nextNode();
                this.incrementCurrentPos();
            } else {
                this.m_foundLast = true;
            }
        }
        this.m_lastFetched = n;
        return n;
    }

    public void fixupVariables(Vector vector, int n) {
        int n2 = 0;
        while (n2 < this.m_exprs.length) {
            this.m_exprs[n2].fixupVariables(vector, n);
            ++n2;
        }
    }

    public int getAxis() {
        return -1;
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        if (xPathVisitor.visitUnionPath(expressionOwner, this) && null != this.m_exprs) {
            int n = this.m_exprs.length;
            int n2 = 0;
            while (n2 < n) {
                this.m_exprs[n2].callVisitors(new iterOwner(n2), xPathVisitor);
                ++n2;
            }
        }
    }

    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        UnionPathIterator unionPathIterator = (UnionPathIterator)expression;
        if (null != this.m_exprs) {
            int n = this.m_exprs.length;
            if (null == unionPathIterator.m_exprs || unionPathIterator.m_exprs.length != n) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (!this.m_exprs[n2].deepEquals(unionPathIterator.m_exprs[n2])) {
                    return false;
                }
                ++n2;
            }
        } else if (null != unionPathIterator.m_exprs) {
            return false;
        }
        return true;
    }

    class iterOwner
    implements ExpressionOwner {
        int m_index;

        iterOwner(int n) {
            this.m_index = n;
        }

        public Expression getExpression() {
            return UnionPathIterator.this.m_exprs[this.m_index];
        }

        public void setExpression(Expression expression) {
            if (!(expression instanceof LocPathIterator)) {
                WalkingIterator walkingIterator = new WalkingIterator(UnionPathIterator.this.getPrefixResolver());
                FilterExprWalker filterExprWalker = new FilterExprWalker(walkingIterator);
                walkingIterator.setFirstWalker(filterExprWalker);
                filterExprWalker.setInnerExpression(expression);
                walkingIterator.exprSetParent(UnionPathIterator.this);
                filterExprWalker.exprSetParent(walkingIterator);
                expression.exprSetParent(filterExprWalker);
                expression = walkingIterator;
            } else {
                expression.exprSetParent(UnionPathIterator.this);
            }
            UnionPathIterator.this.m_exprs[this.m_index] = (LocPathIterator)expression;
        }
    }
}

