/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;

public abstract class PredicatedNodeTest
extends NodeTest
implements SubContextList {
    protected int m_predCount = -1;
    protected transient boolean m_foundLast = false;
    protected LocPathIterator m_lpi;
    transient int m_predicateIndex = -1;
    private Expression[] m_predicates;
    protected transient int[] m_proximityPositions;
    static final boolean DEBUG_PREDICATECOUNTING = false;

    PredicatedNodeTest(LocPathIterator locPathIterator) {
        this.m_lpi = locPathIterator;
    }

    PredicatedNodeTest() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, TransformerException {
        try {
            objectInputStream.defaultReadObject();
            this.m_predicateIndex = -1;
            this.resetProximityPositions();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TransformerException(classNotFoundException);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PredicatedNodeTest predicatedNodeTest = (PredicatedNodeTest)super.clone();
        if (null != this.m_proximityPositions && this.m_proximityPositions == predicatedNodeTest.m_proximityPositions) {
            predicatedNodeTest.m_proximityPositions = new int[this.m_proximityPositions.length];
            System.arraycopy(this.m_proximityPositions, 0, predicatedNodeTest.m_proximityPositions, 0, this.m_proximityPositions.length);
        }
        if (predicatedNodeTest.m_lpi == this) {
            predicatedNodeTest.m_lpi = (LocPathIterator)predicatedNodeTest;
        }
        return predicatedNodeTest;
    }

    public int getPredicateCount() {
        if (-1 == this.m_predCount) {
            return null == this.m_predicates ? 0 : this.m_predicates.length;
        }
        return this.m_predCount;
    }

    public void setPredicateCount(int n) {
        if (n > 0) {
            Expression[] expressionArray = new Expression[n];
            int n2 = 0;
            while (n2 < n) {
                expressionArray[n2] = this.m_predicates[n2];
                ++n2;
            }
            this.m_predicates = expressionArray;
        } else {
            this.m_predicates = null;
        }
    }

    protected void initPredicateInfo(Compiler compiler, int n) throws TransformerException {
        int n2 = compiler.getFirstPredicateOpPos(n);
        if (n2 > 0) {
            this.m_predicates = compiler.getCompiledPredicates(n2);
            if (null != this.m_predicates) {
                int n3 = 0;
                while (n3 < this.m_predicates.length) {
                    this.m_predicates[n3].exprSetParent(this);
                    ++n3;
                }
            }
        }
    }

    public Expression getPredicate(int n) {
        return this.m_predicates[n];
    }

    public int getProximityPosition() {
        return this.getProximityPosition(this.m_predicateIndex);
    }

    public int getProximityPosition(XPathContext xPathContext) {
        return this.getProximityPosition();
    }

    public abstract int getLastPos(XPathContext var1);

    protected int getProximityPosition(int n) {
        return n >= 0 ? this.m_proximityPositions[n] : 0;
    }

    public void resetProximityPositions() {
        int n = this.getPredicateCount();
        if (n > 0) {
            if (null == this.m_proximityPositions) {
                this.m_proximityPositions = new int[n];
            }
            int n2 = 0;
            while (n2 < n) {
                try {
                    this.initProximityPosition(n2);
                }
                catch (Exception exception) {
                    throw new WrappedRuntimeException(exception);
                }
                ++n2;
            }
        }
    }

    public void initProximityPosition(int n) throws TransformerException {
        this.m_proximityPositions[n] = 0;
    }

    protected void countProximityPosition(int n) {
        int[] nArray = this.m_proximityPositions;
        if (null != nArray && n < nArray.length) {
            int n2 = n;
            nArray[n2] = nArray[n2] + 1;
        }
    }

    public boolean isReverseAxes() {
        return false;
    }

    public int getPredicateIndex() {
        return this.m_predicateIndex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean executePredicates(int n, XPathContext xPathContext) throws TransformerException {
        block10: {
            int n2;
            int n3 = this.getPredicateCount();
            if (n3 == 0) {
                return true;
            }
            PrefixResolver prefixResolver = xPathContext.getNamespaceContext();
            try {
                this.m_predicateIndex = 0;
                xPathContext.pushSubContextList(this);
                xPathContext.pushNamespaceContext(this.m_lpi.getPrefixResolver());
                xPathContext.pushCurrentNode(n);
                int n4 = 0;
                while (true) {
                    if (n4 >= n3) {
                        break block10;
                    }
                    XObject xObject = this.m_predicates[n4].execute(xPathContext);
                    if (2 == xObject.getType()) {
                        int n5;
                        n2 = this.getProximityPosition(this.m_predicateIndex);
                        if (n2 != (n5 = (int)xObject.num())) {
                            boolean bl = false;
                            Object var11_10 = null;
                            xPathContext.popCurrentNode();
                            xPathContext.popNamespaceContext();
                            xPathContext.popSubContextList();
                            this.m_predicateIndex = -1;
                            return bl;
                        }
                        if (this.m_predicates[n4].isStableNumber() && n4 == n3 - 1) {
                            this.m_foundLast = true;
                        }
                    } else if (!xObject.bool()) {
                        n2 = 0;
                        break;
                    }
                    this.countProximityPosition(++this.m_predicateIndex);
                    ++n4;
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                xPathContext.popCurrentNode();
                xPathContext.popNamespaceContext();
                xPathContext.popSubContextList();
                this.m_predicateIndex = -1;
                throw throwable;
            }
            Object var11_11 = null;
            xPathContext.popCurrentNode();
            xPathContext.popNamespaceContext();
            xPathContext.popSubContextList();
            this.m_predicateIndex = -1;
            return n2 != 0;
        }
        Object var11_12 = null;
        xPathContext.popCurrentNode();
        xPathContext.popNamespaceContext();
        xPathContext.popSubContextList();
        this.m_predicateIndex = -1;
        return true;
    }

    public void fixupVariables(Vector vector, int n) {
        super.fixupVariables(vector, n);
        int n2 = this.getPredicateCount();
        int n3 = 0;
        while (n3 < n2) {
            this.m_predicates[n3].fixupVariables(vector, n);
            ++n3;
        }
    }

    protected String nodeToString(int n) {
        if (-1 != n) {
            DTM dTM = this.m_lpi.getXPathContext().getDTM(n);
            return dTM.getNodeName(n) + "{" + (n + 1) + "}";
        }
        return "null";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short acceptNode(int n) {
        XPathContext xPathContext;
        block7: {
            short s;
            xPathContext = this.m_lpi.getXPathContext();
            try {
                try {
                    xPathContext.pushCurrentNode(n);
                    XObject xObject = this.execute(xPathContext, n);
                    if (xObject == NodeTest.SCORE_NONE) break block7;
                    if (this.getPredicateCount() > 0) {
                        this.countProximityPosition(0);
                        if (!this.executePredicates(n, xPathContext)) {
                            short s2 = 3;
                            Object var6_7 = null;
                            xPathContext.popCurrentNode();
                            return s2;
                        }
                    }
                    s = 1;
                }
                catch (TransformerException transformerException) {
                    throw new RuntimeException(transformerException.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                xPathContext.popCurrentNode();
                throw throwable;
            }
            Object var6_8 = null;
            xPathContext.popCurrentNode();
            return s;
        }
        Object var6_9 = null;
        xPathContext.popCurrentNode();
        return 3;
    }

    public LocPathIterator getLocPathIterator() {
        return this.m_lpi;
    }

    public void setLocPathIterator(LocPathIterator locPathIterator) {
        this.m_lpi = locPathIterator;
        if (this != locPathIterator) {
            locPathIterator.exprSetParent(this);
        }
    }

    public boolean canTraverseOutsideSubtree() {
        int n = this.getPredicateCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getPredicate(n2).canTraverseOutsideSubtree()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void callPredicateVisitors(XPathVisitor xPathVisitor) {
        if (null != this.m_predicates) {
            int n = this.m_predicates.length;
            int n2 = 0;
            while (n2 < n) {
                PredOwner predOwner = new PredOwner(n2);
                if (xPathVisitor.visitPredicate(predOwner, this.m_predicates[n2])) {
                    this.m_predicates[n2].callVisitors(predOwner, xPathVisitor);
                }
                ++n2;
            }
        }
    }

    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        PredicatedNodeTest predicatedNodeTest = (PredicatedNodeTest)expression;
        if (null != this.m_predicates) {
            int n = this.m_predicates.length;
            if (null == predicatedNodeTest.m_predicates || predicatedNodeTest.m_predicates.length != n) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (!this.m_predicates[n2].deepEquals(predicatedNodeTest.m_predicates[n2])) {
                    return false;
                }
                ++n2;
            }
        } else if (null != predicatedNodeTest.m_predicates) {
            return false;
        }
        return true;
    }

    class PredOwner
    implements ExpressionOwner {
        int m_index;

        PredOwner(int n) {
            this.m_index = n;
        }

        public Expression getExpression() {
            return PredicatedNodeTest.this.m_predicates[this.m_index];
        }

        public void setExpression(Expression expression) {
            expression.exprSetParent(PredicatedNodeTest.this);
            ((PredicatedNodeTest)PredicatedNodeTest.this).m_predicates[this.m_index] = expression;
        }
    }
}

