/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.IteratorPool;
import org.apache.xpath.axes.PathComponent;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.res.XPATHMessages;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class LocPathIterator
extends PredicatedNodeTest
implements Cloneable,
DTMIterator,
Serializable,
PathComponent {
    protected boolean m_allowDetach = true;
    protected transient IteratorPool m_clones = new IteratorPool(this);
    protected transient DTM m_cdtm;
    transient int m_stackFrame = -1;
    private boolean m_isTopLevel = false;
    public transient int m_lastFetched = -1;
    protected transient int m_context = -1;
    protected transient int m_currentContextNode = -1;
    protected transient int m_pos = 0;
    protected transient int m_length = -1;
    private PrefixResolver m_prefixResolver;
    protected transient XPathContext m_execContext;

    protected LocPathIterator() {
    }

    protected LocPathIterator(PrefixResolver prefixResolver) {
        this.setLocPathIterator(this);
        this.m_prefixResolver = prefixResolver;
    }

    protected LocPathIterator(Compiler compiler, int n, int n2) throws TransformerException {
        this(compiler, n, n2, true);
    }

    protected LocPathIterator(Compiler compiler, int n, int n2, boolean bl) throws TransformerException {
        this.setLocPathIterator(this);
    }

    public int getAnalysisBits() {
        int n = this.getAxis();
        int n2 = WalkerFactory.getAnalysisBitFromAxes(n);
        return n2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, TransformerException {
        try {
            objectInputStream.defaultReadObject();
            this.m_clones = new IteratorPool(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TransformerException(classNotFoundException);
        }
    }

    public void setEnvironment(Object object) {
    }

    public DTM getDTM(int n) {
        return this.m_execContext.getDTM(n);
    }

    public DTMManager getDTMManager() {
        return this.m_execContext.getDTMManager();
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        XNodeSet xNodeSet = new XNodeSet((LocPathIterator)this.m_clones.getInstance());
        xNodeSet.setRoot(xPathContext.getCurrentNode(), xPathContext);
        return xNodeSet;
    }

    public void executeCharsToContentHandler(XPathContext xPathContext, ContentHandler contentHandler) throws TransformerException, SAXException {
        LocPathIterator locPathIterator = (LocPathIterator)this.m_clones.getInstance();
        int n = xPathContext.getCurrentNode();
        locPathIterator.setRoot(n, xPathContext);
        int n2 = locPathIterator.nextNode();
        DTM dTM = locPathIterator.getDTM(n2);
        locPathIterator.detach();
        if (n2 != -1) {
            dTM.dispatchCharactersEvents(n2, contentHandler, false);
        }
    }

    public DTMIterator asIterator(XPathContext xPathContext, int n) throws TransformerException {
        XNodeSet xNodeSet = new XNodeSet((LocPathIterator)this.m_clones.getInstance());
        xNodeSet.setRoot(n, xPathContext);
        return xNodeSet;
    }

    public boolean isNodesetExpr() {
        return true;
    }

    public int asNode(XPathContext xPathContext) throws TransformerException {
        DTMIterator dTMIterator = this.m_clones.getInstance();
        int n = xPathContext.getCurrentNode();
        dTMIterator.setRoot(n, xPathContext);
        int n2 = dTMIterator.nextNode();
        dTMIterator.detach();
        return n2;
    }

    public boolean bool(XPathContext xPathContext) throws TransformerException {
        return this.asNode(xPathContext) != -1;
    }

    public void setIsTopLevel(boolean bl) {
        this.m_isTopLevel = bl;
    }

    public boolean getIsTopLevel() {
        return this.m_isTopLevel;
    }

    public void setRoot(int n, Object object) {
        XPathContext xPathContext;
        this.m_context = n;
        this.m_execContext = xPathContext = (XPathContext)object;
        this.m_cdtm = xPathContext.getDTM(n);
        this.m_currentContextNode = n;
        if (null == this.m_prefixResolver) {
            this.m_prefixResolver = xPathContext.getNamespaceContext();
        }
        this.m_lastFetched = -1;
        this.m_foundLast = false;
        this.m_pos = 0;
        this.m_length = -1;
        if (this.m_isTopLevel) {
            this.m_stackFrame = xPathContext.getVarStack().getStackFrame();
        }
    }

    protected void setNextPosition(int n) {
        this.assertion(false, "setNextPosition not supported in this iterator!");
    }

    public final int getCurrentPos() {
        return this.m_pos;
    }

    public void setShouldCacheNodes(boolean bl) {
        this.assertion(false, "setShouldCacheNodes not supported by this iterater!");
    }

    public boolean isMutable() {
        return false;
    }

    public void setCurrentPos(int n) {
        this.assertion(false, "setCurrentPos not supported by this iterator!");
    }

    public void incrementCurrentPos() {
        ++this.m_pos;
    }

    public int size() {
        this.assertion(false, "size() not supported by this iterator!");
        return 0;
    }

    public int item(int n) {
        this.assertion(false, "item(int index) not supported by this iterator!");
        return 0;
    }

    public void setItem(int n, int n2) {
        this.assertion(false, "setItem not supported by this iterator!");
    }

    public int getLength() {
        int n;
        LocPathIterator locPathIterator;
        boolean bl = this == this.m_execContext.getSubContextList();
        int n2 = this.getPredicateCount();
        if (-1 != this.m_length && bl && this.m_predicateIndex < 1) {
            return this.m_length;
        }
        if (this.m_foundLast) {
            return this.m_pos;
        }
        int n3 = this.m_predicateIndex >= 0 ? this.getProximityPosition() : this.m_pos;
        try {
            locPathIterator = (LocPathIterator)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return -1;
        }
        if (n2 > 0 && bl) {
            locPathIterator.m_predCount = this.m_predicateIndex;
        }
        while (-1 != (n = locPathIterator.nextNode())) {
            ++n3;
        }
        if (bl && this.m_predicateIndex < 1) {
            this.m_length = n3;
        }
        return n3;
    }

    public boolean isFresh() {
        return this.m_pos == 0;
    }

    public int previousNode() {
        throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_CANNOT_ITERATE", null));
    }

    public int getWhatToShow() {
        return -17;
    }

    public DTMFilter getFilter() {
        return null;
    }

    public int getRoot() {
        return this.m_context;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public void allowDetachToRelease(boolean bl) {
        this.m_allowDetach = bl;
    }

    public void detach() {
        if (this.m_allowDetach) {
            this.m_execContext = null;
            this.m_cdtm = null;
            this.m_length = -1;
            this.m_pos = 0;
            this.m_lastFetched = -1;
            this.m_context = -1;
            this.m_currentContextNode = -1;
            this.m_clones.freeInstance(this);
        }
    }

    public void reset() {
        this.assertion(false, "This iterator can not reset!");
    }

    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        LocPathIterator locPathIterator = (LocPathIterator)this.m_clones.getInstanceOrThrow();
        locPathIterator.m_execContext = this.m_execContext;
        locPathIterator.m_cdtm = this.m_cdtm;
        locPathIterator.m_context = this.m_context;
        locPathIterator.m_currentContextNode = this.m_currentContextNode;
        locPathIterator.m_stackFrame = this.m_stackFrame;
        return locPathIterator;
    }

    public abstract int nextNode();

    protected int returnNextNode(int n) {
        if (-1 != n) {
            ++this.m_pos;
        }
        this.m_lastFetched = n;
        if (-1 == n) {
            this.m_foundLast = true;
        }
        return n;
    }

    public int getCurrentNode() {
        return this.m_lastFetched;
    }

    /*
     * Unable to fully structure code
     */
    public void runTo(int var1_1) {
        block3: {
            if (this.m_foundLast || var1_1 >= 0 && var1_1 <= this.getCurrentPos()) {
                return;
            }
            if (-1 != var1_1) ** GOTO lbl-1000
            while (-1 != (var2_2 = this.nextNode())) {
            }
            break block3;
            while (this.getCurrentPos() < var1_1) lbl-1000:
            // 2 sources

            {
                if (-1 != (var2_3 = this.nextNode())) continue;
            }
        }
    }

    public final boolean getFoundLast() {
        return this.m_foundLast;
    }

    public final XPathContext getXPathContext() {
        return this.m_execContext;
    }

    public final int getContext() {
        return this.m_context;
    }

    public final int getCurrentContextNode() {
        return this.m_currentContextNode;
    }

    public final void setCurrentContextNode(int n) {
        this.m_currentContextNode = n;
    }

    public final PrefixResolver getPrefixResolver() {
        if (null == this.m_prefixResolver) {
            this.m_prefixResolver = (PrefixResolver)((Object)this.getExpressionOwner());
        }
        return this.m_prefixResolver;
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        if (xPathVisitor.visitLocationPath(expressionOwner, this)) {
            xPathVisitor.visitStep(expressionOwner, this);
            this.callPredicateVisitors(xPathVisitor);
        }
    }

    public boolean isDocOrdered() {
        return true;
    }

    public int getAxis() {
        return -1;
    }

    public int getLastPos(XPathContext xPathContext) {
        return this.getLength();
    }
}

