/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.functions.Function;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.res.XPATHMessages;
import org.w3c.dom.Node;

public class XPath
implements Serializable,
ExpressionOwner {
    private Expression m_mainExp;
    String m_patternString;
    public static final int SELECT = 0;
    public static final int MATCH = 1;
    private static final boolean DEBUG_MATCHES = false;
    public static final double MATCH_SCORE_NONE = Double.NEGATIVE_INFINITY;
    public static final double MATCH_SCORE_QNAME = 0.0;
    public static final double MATCH_SCORE_NSWILD = -0.25;
    public static final double MATCH_SCORE_NODETEST = -0.5;
    public static final double MATCH_SCORE_OTHER = 0.5;

    public Expression getExpression() {
        return this.m_mainExp;
    }

    public void fixupVariables(Vector vector, int n) {
        this.m_mainExp.fixupVariables(vector, n);
    }

    public void setExpression(Expression expression) {
        if (null != this.m_mainExp) {
            expression.exprSetParent(this.m_mainExp.exprGetParent());
        }
        this.m_mainExp = expression;
    }

    public SourceLocator getLocator() {
        return this.m_mainExp;
    }

    public String getPatternString() {
        return this.m_patternString;
    }

    public XPath(String string, SourceLocator sourceLocator, PrefixResolver prefixResolver, int n, ErrorListener errorListener) throws TransformerException {
        if (null == errorListener) {
            errorListener = new DefaultErrorHandler();
        }
        this.m_patternString = string;
        XPathParser xPathParser = new XPathParser(errorListener, sourceLocator);
        Compiler compiler = new Compiler(errorListener, sourceLocator);
        if (0 == n) {
            xPathParser.initXPath(compiler, string, prefixResolver);
        } else if (1 == n) {
            xPathParser.initMatchPattern(compiler, string, prefixResolver);
        } else {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_CANNOT_DEAL_XPATH_TYPE", new Object[]{Integer.toString(n)}));
        }
        Expression expression = compiler.compile(0);
        this.setExpression(expression);
        if (null != sourceLocator && sourceLocator instanceof ExpressionNode) {
            expression.exprSetParent((ExpressionNode)sourceLocator);
        }
    }

    public XPath(String string, SourceLocator sourceLocator, PrefixResolver prefixResolver, int n) throws TransformerException {
        this(string, sourceLocator, prefixResolver, n, null);
    }

    public XPath(Expression expression) {
        this.setExpression(expression);
    }

    public XObject execute(XPathContext xPathContext, Node node, PrefixResolver prefixResolver) throws TransformerException {
        return this.execute(xPathContext, xPathContext.getDTMHandleFromNode(node), prefixResolver);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XObject execute(XPathContext xPathContext, int n, PrefixResolver prefixResolver) throws TransformerException {
        xPathContext.pushNamespaceContext(prefixResolver);
        xPathContext.pushCurrentNodeAndExpression(n, n);
        XObject xObject = null;
        try {
            String string;
            Exception exception;
            block8: {
                try {
                    xObject = this.m_mainExp.execute(xPathContext);
                }
                catch (TransformerException transformerException) {
                    transformerException.setLocator(this.getLocator());
                    ErrorListener errorListener = xPathContext.getErrorListener();
                    if (null == errorListener) throw transformerException;
                    errorListener.error(transformerException);
                    Object var11_6 = null;
                    xPathContext.popNamespaceContext();
                    xPathContext.popCurrentNodeAndExpression();
                    return xObject;
                }
                catch (Exception exception2) {
                    break block8;
                }
                Object var11_5 = null;
                xPathContext.popNamespaceContext();
                xPathContext.popCurrentNodeAndExpression();
                return xObject;
            }
            while (true) {
                if (!(exception instanceof WrappedRuntimeException)) {
                    string = exception.getMessage();
                    if (string == null || string.length() == 0) {
                        string = XPATHMessages.createXPATHMessage("ER_XPATH_ERROR", null);
                    }
                    break;
                }
                exception = ((WrappedRuntimeException)exception).getException();
            }
            TransformerException transformerException = new TransformerException(string, this.getLocator(), exception);
            ErrorListener errorListener = xPathContext.getErrorListener();
            if (null == errorListener) throw transformerException;
            errorListener.fatalError(transformerException);
            Object var11_7 = null;
            xPathContext.popNamespaceContext();
            xPathContext.popCurrentNodeAndExpression();
            return xObject;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            xPathContext.popNamespaceContext();
            xPathContext.popCurrentNodeAndExpression();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean bool(XPathContext var1_1, int var2_2, PrefixResolver var3_3) throws TransformerException {
        block9: {
            block10: {
                var1_1.pushNamespaceContext(var3_3);
                var1_1.pushCurrentNodeAndExpression(var2_2, var2_2);
                try {
                    try {
                        var4_4 = this.m_mainExp.bool(var1_1);
                        var10_6 = null;
                        var1_1.popNamespaceContext();
                        var1_1.popCurrentNodeAndExpression();
                        return var4_4;
                    }
                    catch (TransformerException var4_5) {
                        var4_5.setLocator(this.getLocator());
                        var5_10 = var1_1.getErrorListener();
                        if (null == var5_10) {
                            throw var4_5;
                        }
                        var5_10.error(var4_5);
                        var10_7 = null;
                        var1_1.popNamespaceContext();
                        var1_1.popCurrentNodeAndExpression();
                        break block9;
                    }
                    catch (Exception var5_11) {
                        ** while (var5_12 instanceof WrappedRuntimeException)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var5_12 = ((WrappedRuntimeException)var5_12).getException();
                        continue;
                    }
lbl25:
                    // 1 sources

                    var6_13 = var5_12.getMessage();
                    if (var6_13 == null || var6_13.length() == 0) {
                        var6_13 = XPATHMessages.createXPATHMessage("ER_XPATH_ERROR", null);
                    }
                    var7_14 = new TransformerException(var6_13, this.getLocator(), var5_12);
                    var8_15 = var1_1.getErrorListener();
                    if (null != var8_15) {
                        var8_15.fatalError(var7_14);
                        break block10;
                    }
                    throw var7_14;
                }
                catch (Throwable var9_16) {
                    var10_9 = null;
                    var1_1.popNamespaceContext();
                    var1_1.popCurrentNodeAndExpression();
                    throw var9_16;
                }
            }
            var10_8 = null;
            var1_1.popNamespaceContext();
            var1_1.popCurrentNodeAndExpression();
            {
            }
        }
        return false;
    }

    public double getMatchScore(XPathContext xPathContext, int n) throws TransformerException {
        xPathContext.pushCurrentNode(n);
        xPathContext.pushCurrentExpressionNode(n);
        try {
            XObject xObject = this.m_mainExp.execute(xPathContext);
            double d = xObject.num();
            Object var7_5 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            return d;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public void installFunction(String string, int n, Function function) {
        FunctionTable.installFunction(function, n);
    }

    public void warn(XPathContext xPathContext, int n, String string, Object[] objectArray) throws TransformerException {
        String string2 = XPATHMessages.createXPATHWarning(string, objectArray);
        ErrorListener errorListener = xPathContext.getErrorListener();
        if (null != errorListener) {
            errorListener.warning(new TransformerException(string2, (SAXSourceLocator)xPathContext.getSAXLocator()));
        }
    }

    public void assertion(boolean bl, String string) {
        if (!bl) {
            String string2 = XPATHMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    public void error(XPathContext xPathContext, int n, String string, Object[] objectArray) throws TransformerException {
        String string2 = XPATHMessages.createXPATHMessage(string, objectArray);
        ErrorListener errorListener = xPathContext.getErrorListener();
        if (null != errorListener) {
            errorListener.fatalError(new TransformerException(string2, (SAXSourceLocator)xPathContext.getSAXLocator()));
        } else {
            SourceLocator sourceLocator = xPathContext.getSAXLocator();
            System.out.println(string2 + "; file " + sourceLocator.getSystemId() + "; line " + sourceLocator.getLineNumber() + "; column " + sourceLocator.getColumnNumber());
        }
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        this.m_mainExp.callVisitors(this, xPathVisitor);
    }
}

