/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

public class SuballocatedByteVector {
    protected int m_blocksize;
    protected int m_numblocks = 32;
    protected byte[][] m_map;
    protected int m_firstFree = 0;
    protected byte[] m_map0;

    public SuballocatedByteVector() {
        this(2048);
    }

    public SuballocatedByteVector(int n) {
        this.m_blocksize = n;
        this.m_map0 = new byte[n];
        this.m_map = new byte[this.m_numblocks][];
        this.m_map[0] = this.m_map0;
    }

    public SuballocatedByteVector(int n, int n2) {
        this(n);
    }

    public int size() {
        return this.m_firstFree;
    }

    private void setSize(int n) {
        if (this.m_firstFree < n) {
            this.m_firstFree = n;
        }
    }

    public void addElement(byte by) {
        if (this.m_firstFree < this.m_blocksize) {
            this.m_map0[this.m_firstFree++] = by;
        } else {
            byte[] byArray;
            int n = this.m_firstFree / this.m_blocksize;
            int n2 = this.m_firstFree % this.m_blocksize;
            ++this.m_firstFree;
            if (n >= this.m_map.length) {
                int n3 = n + this.m_numblocks;
                byte[][] byArrayArray = new byte[n3][];
                System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
                this.m_map = byArrayArray;
            }
            if (null == (byArray = this.m_map[n])) {
                this.m_map[n] = new byte[this.m_blocksize];
                byArray = this.m_map[n];
            }
            byArray[n2] = by;
        }
    }

    private void addElements(byte by, int n) {
        if (this.m_firstFree + n < this.m_blocksize) {
            int n2 = 0;
            while (n2 < n) {
                this.m_map0[this.m_firstFree++] = by;
                ++n2;
            }
        } else {
            int n3 = this.m_firstFree / this.m_blocksize;
            int n4 = this.m_firstFree % this.m_blocksize;
            this.m_firstFree += n;
            while (n > 0) {
                byte[] byArray;
                if (n3 >= this.m_map.length) {
                    int n5 = n3 + this.m_numblocks;
                    byte[][] byArrayArray = new byte[n5][];
                    System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
                    this.m_map = byArrayArray;
                }
                if (null == (byArray = this.m_map[n3])) {
                    this.m_map[n3] = new byte[this.m_blocksize];
                    byArray = this.m_map[n3];
                }
                int n6 = this.m_blocksize - n4 < n ? this.m_blocksize - n4 : n;
                n -= n6;
                while (n6-- > 0) {
                    byArray[n4++] = by;
                }
                ++n3;
                n4 = 0;
            }
        }
    }

    private void addElements(int n) {
        int n2 = this.m_firstFree + n;
        if (n2 > this.m_blocksize) {
            int n3 = this.m_firstFree % this.m_blocksize;
            int n4 = (this.m_firstFree + n) % this.m_blocksize;
            int n5 = n3 + 1;
            while (n5 <= n4) {
                this.m_map[n5] = new byte[this.m_blocksize];
                ++n5;
            }
        }
        this.m_firstFree = n2;
    }

    private void insertElementAt(byte by, int n) {
        if (n == this.m_firstFree) {
            this.addElement(by);
        } else if (n > this.m_firstFree) {
            byte[] byArray;
            int n2 = n / this.m_blocksize;
            if (n2 >= this.m_map.length) {
                int n3 = n2 + this.m_numblocks;
                byte[][] byArrayArray = new byte[n3][];
                System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
                this.m_map = byArrayArray;
            }
            if (null == (byArray = this.m_map[n2])) {
                this.m_map[n2] = new byte[this.m_blocksize];
                byArray = this.m_map[n2];
            }
            int n4 = n % this.m_blocksize;
            byArray[n4] = by;
            this.m_firstFree = n4 + 1;
        } else {
            int n5 = n / this.m_blocksize;
            int n6 = this.m_firstFree + 1 / this.m_blocksize;
            ++this.m_firstFree;
            int n7 = n % this.m_blocksize;
            while (n5 <= n6) {
                byte by2;
                int n8 = this.m_blocksize - n7 - 1;
                byte[] byArray = this.m_map[n5];
                if (null == byArray) {
                    by2 = 0;
                    this.m_map[n5] = new byte[this.m_blocksize];
                    byArray = this.m_map[n5];
                } else {
                    by2 = byArray[this.m_blocksize - 1];
                    System.arraycopy(byArray, n7, byArray, n7 + 1, n8);
                }
                byArray[n7] = by;
                by = by2;
                n7 = 0;
                ++n5;
            }
        }
    }

    public void removeAllElements() {
        this.m_firstFree = 0;
    }

    private boolean removeElement(byte by) {
        int n = this.indexOf(by, 0);
        if (n < 0) {
            return false;
        }
        this.removeElementAt(n);
        return true;
    }

    private void removeElementAt(int n) {
        if (n < this.m_firstFree) {
            int n2 = n / this.m_blocksize;
            int n3 = this.m_firstFree / this.m_blocksize;
            int n4 = n % this.m_blocksize;
            while (n2 <= n3) {
                int n5 = this.m_blocksize - n4 - 1;
                byte[] byArray = this.m_map[n2];
                if (null == byArray) {
                    this.m_map[n2] = new byte[this.m_blocksize];
                    byArray = this.m_map[n2];
                } else {
                    System.arraycopy(byArray, n4 + 1, byArray, n4, n5);
                }
                if (n2 < n3) {
                    byte[] byArray2 = this.m_map[n2 + 1];
                    if (byArray2 != null) {
                        byArray[this.m_blocksize - 1] = byArray2 != null ? byArray2[0] : (byte)0;
                    }
                } else {
                    byArray[this.m_blocksize - 1] = 0;
                }
                n4 = 0;
                ++n2;
            }
        }
        --this.m_firstFree;
    }

    public void setElementAt(byte by, int n) {
        byte[] byArray;
        if (n < this.m_blocksize) {
            this.m_map0[n] = by;
            return;
        }
        int n2 = n / this.m_blocksize;
        int n3 = n % this.m_blocksize;
        if (n2 >= this.m_map.length) {
            int n4 = n2 + this.m_numblocks;
            byte[][] byArrayArray = new byte[n4][];
            System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
            this.m_map = byArrayArray;
        }
        if (null == (byArray = this.m_map[n2])) {
            this.m_map[n2] = new byte[this.m_blocksize];
            byArray = this.m_map[n2];
        }
        byArray[n3] = by;
        if (n >= this.m_firstFree) {
            this.m_firstFree = n + 1;
        }
    }

    public byte elementAt(int n) {
        if (n < this.m_blocksize) {
            return this.m_map0[n];
        }
        return this.m_map[n / this.m_blocksize][n % this.m_blocksize];
    }

    private boolean contains(byte by) {
        return this.indexOf(by, 0) >= 0;
    }

    public int indexOf(byte by, int n) {
        int n2;
        byte[] byArray;
        if (n >= this.m_firstFree) {
            return -1;
        }
        int n3 = n / this.m_blocksize;
        int n4 = n % this.m_blocksize;
        int n5 = this.m_firstFree / this.m_blocksize;
        while (n3 < n5) {
            byArray = this.m_map[n3];
            if (byArray != null) {
                n2 = n4;
                while (n2 < this.m_blocksize) {
                    if (byArray[n2] == by) {
                        return n2 + n3 * this.m_blocksize;
                    }
                    ++n2;
                }
            }
            n4 = 0;
            ++n3;
        }
        n2 = this.m_firstFree % this.m_blocksize;
        byArray = this.m_map[n5];
        int n6 = n4;
        while (n6 < n2) {
            if (byArray[n6] == by) {
                return n6 + n5 * this.m_blocksize;
            }
            ++n6;
        }
        return -1;
    }

    public int indexOf(byte by) {
        return this.indexOf(by, 0);
    }

    private int lastIndexOf(byte by) {
        int n = this.m_firstFree % this.m_blocksize;
        int n2 = this.m_firstFree / this.m_blocksize;
        while (n2 >= 0) {
            byte[] byArray = this.m_map[n2];
            if (byArray != null) {
                int n3 = n;
                while (n3 >= 0) {
                    if (byArray[n3] == by) {
                        return n3 + n2 * this.m_blocksize;
                    }
                    --n3;
                }
            }
            n = 0;
            --n2;
        }
        return -1;
    }
}

