/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.util.EmptyStackException;
import org.apache.xml.utils.IntVector;

public class IntStack
extends IntVector {
    public IntStack() {
    }

    public IntStack(int n) {
        super(n);
    }

    public IntStack(IntStack intStack) {
        super(intStack);
    }

    public int push(int n) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        this.m_map[this.m_firstFree] = n;
        ++this.m_firstFree;
        return n;
    }

    public final int pop() {
        return this.m_map[--this.m_firstFree];
    }

    public final void quickPop(int n) {
        this.m_firstFree -= n;
    }

    public final int peek() {
        try {
            return this.m_map[this.m_firstFree - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EmptyStackException();
        }
    }

    public int peek(int n) {
        try {
            return this.m_map[this.m_firstFree - (1 + n)];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EmptyStackException();
        }
    }

    public void setTop(int n) {
        try {
            this.m_map[this.m_firstFree - 1] = n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EmptyStackException();
        }
    }

    public boolean empty() {
        return this.m_firstFree == 0;
    }

    public int search(int n) {
        int n2 = this.lastIndexOf(n);
        if (n2 >= 0) {
            return this.size() - n2;
        }
        return -1;
    }

    public Object clone() throws CloneNotSupportedException {
        return (IntStack)super.clone();
    }
}

