/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public final class WriterToUTF8Buffered
extends Writer {
    private static final int buf_length = 16384;
    private final OutputStream m_os;
    private final byte[] buf;
    private int count;

    public WriterToUTF8Buffered(OutputStream outputStream) throws UnsupportedEncodingException {
        this.m_os = outputStream;
        this.buf = new byte[16387];
        this.count = 0;
    }

    public void write(int n) throws IOException {
        if (this.count >= 16384) {
            this.flushBuffer();
        }
        if (n < 128) {
            this.buf[this.count++] = (byte)n;
        } else if (n < 2048) {
            this.buf[this.count++] = (byte)(192 + (n >> 6));
            this.buf[this.count++] = (byte)(128 + (n & 0x3F));
        } else {
            this.buf[this.count++] = (byte)(224 + (n >> 12));
            this.buf[this.count++] = (byte)(128 + (n >> 6 & 0x3F));
            this.buf[this.count++] = (byte)(128 + (n & 0x3F));
        }
    }

    private final void writeDirect(char[] cArray, int n, int n2) throws IOException {
        OutputStream outputStream = this.m_os;
        int n3 = n2 + n;
        int n4 = n;
        while (n4 < n3) {
            char c = cArray[n4];
            if (c < '\u0080') {
                outputStream.write(c);
            } else if (c < '\u0800') {
                outputStream.write(192 + (c >> 6));
                outputStream.write(128 + (c & 0x3F));
            } else {
                outputStream.write(224 + (c >> 12));
                outputStream.write(128 + (c >> 6 & 0x3F));
                outputStream.write(128 + (c & 0x3F));
            }
            ++n4;
        }
    }

    private final void writeDirect(String string) throws IOException {
        int n = string.length();
        OutputStream outputStream = this.m_os;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < '\u0080') {
                outputStream.write(c);
            } else if (c < '\u0800') {
                outputStream.write(192 + (c >> 6));
                outputStream.write(128 + (c & 0x3F));
            } else {
                outputStream.write(224 + (c >> 12));
                outputStream.write(128 + (c >> 6 & 0x3F));
                outputStream.write(128 + (c & 0x3F));
            }
            ++n2;
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = (n2 << 1) + n2;
        if (n3 >= 16384) {
            this.flushBuffer();
            this.writeDirect(cArray, n, n2);
            return;
        }
        if (n3 > 16384 - this.count) {
            this.flushBuffer();
        }
        OutputStream outputStream = this.m_os;
        int n4 = n2 + n;
        int n5 = n;
        while (n5 < n4) {
            char c = cArray[n5];
            if (c < '\u0080') {
                this.buf[this.count++] = (byte)c;
            } else if (c < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c >> 6));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c >> 12));
                this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            }
            ++n5;
        }
    }

    public void write(String string) throws IOException {
        int n = string.length();
        int n2 = (n << 1) + n;
        if (n2 >= 16384) {
            this.flushBuffer();
            this.writeDirect(string);
            return;
        }
        if (n2 > 16384 - this.count) {
            this.flushBuffer();
        }
        OutputStream outputStream = this.m_os;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c < '\u0080') {
                this.buf[this.count++] = (byte)c;
            } else if (c < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c >> 6));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c >> 12));
                this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            }
            ++n3;
        }
    }

    public void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.m_os.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.m_os.flush();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.m_os.close();
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }
}

