/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.serializer.CharInfo;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.ToStream;
import org.xml.sax.SAXException;

public class ToXMLStream
extends ToStream {
    private boolean m_cdataTagOpen = false;
    protected static CharInfo m_xmlcharInfo = CharInfo.getCharInfo(CharInfo.XML_ENTITIES_RESOURCE);

    public ToXMLStream() {
        this.m_charInfo = m_xmlcharInfo;
        this.initCDATA();
        this.m_prefixMap = new NamespaceMappings();
    }

    public void CopyFrom(ToXMLStream toXMLStream) {
        this.m_writer = toXMLStream.m_writer;
        String string = toXMLStream.getEncoding();
        this.setEncoding(string);
        this.setOmitXMLDeclaration(toXMLStream.getOmitXMLDeclaration());
        this.m_startTagOpen = toXMLStream.m_startTagOpen;
        this.m_ispreserve = toXMLStream.m_ispreserve;
        this.m_preserves = toXMLStream.m_preserves;
        this.m_isprevtext = toXMLStream.m_isprevtext;
        this.m_doIndent = toXMLStream.m_doIndent;
        this.m_currentElemDepth = toXMLStream.m_currentElemDepth;
        this.setIndentAmount(toXMLStream.getIndentAmount());
        this.m_startNewLine = toXMLStream.m_startNewLine;
        this.m_needToOutputDocTypeDecl = toXMLStream.m_needToOutputDocTypeDecl;
        this.setDoctypeSystem(toXMLStream.getDoctypeSystem());
        this.setDoctypePublic(toXMLStream.getDoctypePublic());
        this.setStandalone(toXMLStream.getStandalone());
        this.setMediaType(toXMLStream.getMediaType());
        this.m_maxCharacter = toXMLStream.m_maxCharacter;
        this.m_spaceBeforeClose = toXMLStream.m_spaceBeforeClose;
        this.m_cdataStartCalled = toXMLStream.m_cdataStartCalled;
    }

    public void startDocumentInternal() throws SAXException {
        if (this.m_needToCallStartDocument) {
            super.startDocumentInternal();
            this.m_needToCallStartDocument = false;
            if (this.m_inEntityRef) {
                return;
            }
            this.m_needToOutputDocTypeDecl = true;
            this.m_startNewLine = false;
            if (!this.getOmitXMLDeclaration()) {
                String string = Encodings.getMimeEncoding(this.getEncoding());
                String string2 = this.getVersion();
                if (string2 == null) {
                    string2 = "1.0";
                }
                String string3 = this.m_standaloneWasSpecified ? " standalone=\"" + this.getStandalone() + "\"" : "";
                try {
                    this.m_writer.write("<?xml version=\"");
                    this.m_writer.write(string2);
                    this.m_writer.write("\" encoding=\"");
                    this.m_writer.write(string);
                    this.m_writer.write(34);
                    this.m_writer.write(string3);
                    this.m_writer.write("?>");
                    this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }
    }

    public void endDocument() throws SAXException {
        this.flushPending();
        if (this.m_doIndent && !this.m_isprevtext) {
            try {
                this.outputLineSep();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void startPreserving() throws SAXException {
        this.m_preserves.push(true);
        this.m_ispreserve = true;
    }

    public void endPreserving() throws SAXException {
        this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.flushPending();
        if (string.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (string.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            try {
                int n;
                if (this.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_startTagOpen = false;
                }
                if (this.shouldIndent()) {
                    this.indent();
                }
                this.m_writer.write(60);
                this.m_writer.write(63);
                this.m_writer.write(string);
                if (string2.length() > 0 && !Character.isSpaceChar(string2.charAt(0))) {
                    this.m_writer.write(32);
                }
                if ((n = string2.indexOf("?>")) >= 0) {
                    if (n > 0) {
                        this.m_writer.write(string2.substring(0, n));
                    }
                    this.m_writer.write("? >");
                    if (n + 2 < string2.length()) {
                        this.m_writer.write(string2.substring(n + 2));
                    }
                } else {
                    this.m_writer.write(string2);
                }
                this.m_writer.write(63);
                this.m_writer.write(62);
                if (this.m_currentElemDepth <= 0) {
                    this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                }
                this.m_startNewLine = true;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    public void entityReference(String string) throws SAXException {
        if (this.m_startTagOpen) {
            this.closeStartTag();
            this.m_startTagOpen = false;
        }
        try {
            if (this.shouldIndent()) {
                this.indent();
            }
            this.m_writer.write("&");
            this.m_writer.write(string);
            this.m_writer.write(";");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (this.m_tracer != null) {
            super.fireEntityReference(string);
        }
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this.m_startTagOpen) {
            String string6;
            if (!string3.startsWith("xmlns") && (string6 = this.ensureAttributesNamespaceIsDeclared(string, string2, string3)) != null && string3 != null && !string3.startsWith(string6)) {
                string3 = string6 + ":" + string2;
            }
            this.addAttributeAlways(string, string2, string3, string4, string5);
        } else {
            String string7 = XMLMessages.createXMLMessage("ER_ILLEGAL_ATTRIBUTE_POSITION", new Object[]{string2});
            try {
                Transformer transformer = super.getTransformer();
                ErrorListener errorListener = transformer.getErrorListener();
                if (null != errorListener && this.m_sourceLocator != null) {
                    errorListener.warning(new TransformerException(string7, this.m_sourceLocator));
                } else {
                    System.out.println(string7);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String escapeString(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            switch (cArray[n3]) {
                case '&': {
                    stringBuffer.append(cArray, n2, n3 - n2).append("&amp;");
                    n2 = n3 + 1;
                    break;
                }
                case '\"': {
                    stringBuffer.append(cArray, n2, n3 - n2).append("&quot;");
                    n2 = n3 + 1;
                    break;
                }
                case '<': {
                    stringBuffer.append(cArray, n2, n3 - n2).append("&lt;");
                    n2 = n3 + 1;
                    break;
                }
                case '>': {
                    stringBuffer.append(cArray, n2, n3 - n2).append("&gt;");
                    n2 = n3 + 1;
                    break;
                }
                case '\n': {
                    stringBuffer.append(cArray, n2, n3 - n2).append("&#xA;");
                    n2 = n3 + 1;
                }
            }
            ++n3;
        }
        if (n2 < n) {
            stringBuffer.append(cArray, n2, n - n2);
        }
        return stringBuffer.toString();
    }

    public void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
        String string3;
        if (this.m_elementURI == null && (string3 = SerializerBase.getPrefixPart(this.m_elementName)) == null && "".equals(string)) {
            this.m_elementURI = string2;
        }
        this.startPrefixMapping(string, string2, false);
    }

    protected boolean pushNamespace(String string, String string2) {
        try {
            if (this.m_prefixMap.pushNamespace(string, string2, this.m_currentElemDepth)) {
                this.startPrefixMapping(string, string2);
                return true;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return false;
    }

    public boolean reset() {
        boolean bl = false;
        if (super.reset()) {
            this.resetToXMLStream();
            bl = true;
        }
        return bl;
    }

    private void resetToXMLStream() {
        this.m_cdataTagOpen = false;
    }
}

