/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import org.apache.xml.serializer.ToStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ToTextStream
extends ToStream {
    protected void startDocumentInternal() throws SAXException {
        super.startDocumentInternal();
        this.m_needToCallStartDocument = false;
    }

    public void endDocument() throws SAXException {
        this.flushPending();
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.m_currentElemDepth;
        if (this.m_tracer != null) {
            super.fireStartElem(string3);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.m_currentElemDepth;
        if (this.m_tracer != null) {
            super.fireEndElem(string3);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.flushPending();
        try {
            this.writeNormalizedChars(cArray, n, n2, false);
            if (this.m_tracer != null) {
                super.fireCharEvent(cArray, n, n2);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void charactersRaw(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writeNormalizedChars(cArray, n, n2, false);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    void writeNormalizedChars(char[] cArray, int n, int n2, boolean bl) throws IOException, SAXException {
        int n3 = n + n2;
        int n4 = this.m_maxCharacter;
        if (bl) {
            int n5 = n;
            while (n5 < n3) {
                char c = cArray[n5];
                if ('\n' == c) {
                    this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                } else if (c > n4) {
                    if (n5 != 0) {
                        this.closeCDATA();
                    }
                    if (ToStream.isUTF16Surrogate(c)) {
                        n5 = this.writeUTF16Surrogate(c, cArray, n5, n3);
                    } else {
                        this.m_writer.write(c);
                    }
                    if (n5 != 0 && n5 < n3 - 1) {
                        this.m_writer.write("<![CDATA[");
                        this.m_cdataTagOpen = true;
                    }
                } else if (n5 < n3 - 2 && ']' == c && ']' == cArray[n5 + 1] && '>' == cArray[n5 + 2]) {
                    this.m_writer.write("]]]]><![CDATA[>");
                    n5 += 2;
                } else if (c <= n4) {
                    this.m_writer.write(c);
                } else if (ToStream.isUTF16Surrogate(c)) {
                    n5 = this.writeUTF16Surrogate(c, cArray, n5, n3);
                } else {
                    this.m_writer.write(c);
                }
                ++n5;
            }
        } else {
            int n6 = n;
            while (n6 < n3) {
                char c = cArray[n6];
                if ('\n' == c) {
                    this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                } else if (c <= n4) {
                    this.m_writer.write(c);
                } else if (ToStream.isUTF16Surrogate(c)) {
                    n6 = this.writeUTF16Surrogate(c, cArray, n6, n3);
                } else {
                    this.m_writer.write(c);
                }
                ++n6;
            }
        }
    }

    public void cdata(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writeNormalizedChars(cArray, n, n2, false);
            if (this.m_tracer != null) {
                super.fireCDATAEvent(cArray, n, n2);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writeNormalizedChars(cArray, n, n2, false);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushPending();
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    public void comment(String string) throws SAXException {
        this.comment(string.toCharArray(), 0, string.length());
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.flushPending();
        if (this.m_tracer != null) {
            super.fireCommentEvent(cArray, n, n2);
        }
    }

    public void entityReference(String string) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEntityReference(string);
        }
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) {
    }

    public void endCDATA() throws SAXException {
    }

    public void endElement(String string) throws SAXException {
        --this.m_currentElemDepth;
        if (this.m_tracer != null) {
            super.fireEndElem(string);
        }
    }

    public void startElement(String string, String string2, String string3) throws SAXException {
        ++this.m_currentElemDepth;
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
        }
        if (this.m_tracer != null) {
            super.fireStartElem(string3);
        }
    }

    public void characters(String string) throws SAXException {
        this.characters(string.toCharArray(), 0, string.length());
    }

    public void addAttribute(String string, String string2) {
    }

    public boolean startPrefixMapping(String string, String string2, boolean bl) throws SAXException {
        return false;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
    }

    public void flushPending() {
        try {
            if (this.m_needToCallStartDocument) {
                this.startDocumentInternal();
                this.m_needToCallStartDocument = false;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }
}

