/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.Transformer;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.serializer.CharInfo;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.OutputPropertyUtils;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.SerializerTraceWriter;
import org.apache.xml.serializer.WriterToASCI;
import org.apache.xml.serializer.WriterToUTF8;
import org.apache.xml.serializer.WriterToUTF8Buffered;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.DOM2Helper;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.TreeWalker;
import org.apache.xml.utils.WrappedRuntimeException;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class ToStream
extends SerializerBase {
    private static final String COMMENT_BEGIN = "<!--";
    private static final String COMMENT_END = "-->";
    protected BoolStack m_disableOutputEscapingStates = new BoolStack();
    boolean m_triedToGetConverter = false;
    Method m_canConvertMeth;
    Object m_charToByteConverter = null;
    protected BoolStack m_preserves = new BoolStack();
    protected boolean m_ispreserve = false;
    protected boolean m_isprevtext = false;
    protected int m_maxCharacter = Encodings.getLastPrintable();
    protected final char[] m_lineSep = System.getProperty("line.separator").toCharArray();
    protected final int m_lineSepLen = this.m_lineSep.length;
    protected CharInfo m_charInfo;
    boolean m_shouldFlush = true;
    protected boolean m_spaceBeforeClose = false;
    boolean m_startNewLine;
    protected boolean m_inDoctype = false;
    boolean m_isUTF8 = false;
    protected Properties m_format;
    protected boolean m_cdataStartCalled = false;
    private boolean m_escaping = true;

    protected void closeCDATA() throws SAXException {
        try {
            this.m_writer.write("]]>");
            this.m_cdataTagOpen = false;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void serialize(Node node) throws IOException {
        try {
            TreeWalker treeWalker = new TreeWalker(this, new DOM2Helper());
            treeWalker.traverse(node);
        }
        catch (SAXException sAXException) {
            throw new WrappedRuntimeException(sAXException);
        }
    }

    static final boolean isUTF16Surrogate(char c) {
        return (c & 0xFC00) == 55296;
    }

    protected final void flushWriter() throws SAXException {
        if (null != this.m_writer) {
            try {
                if (this.m_writer instanceof WriterToUTF8Buffered) {
                    if (this.m_shouldFlush) {
                        ((WriterToUTF8Buffered)this.m_writer).flush();
                    } else {
                        ((WriterToUTF8Buffered)this.m_writer).flushBuffer();
                    }
                }
                if (this.m_writer instanceof WriterToUTF8) {
                    if (this.m_shouldFlush) {
                        this.m_writer.flush();
                    }
                } else if (this.m_writer instanceof WriterToASCI) {
                    if (this.m_shouldFlush) {
                        this.m_writer.flush();
                    }
                } else {
                    this.m_writer.flush();
                }
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
    }

    public OutputStream getOutputStream() {
        if (this.m_writer instanceof WriterToUTF8Buffered) {
            return ((WriterToUTF8Buffered)this.m_writer).getOutputStream();
        }
        if (this.m_writer instanceof WriterToUTF8) {
            return ((WriterToUTF8)this.m_writer).getOutputStream();
        }
        if (this.m_writer instanceof WriterToASCI) {
            return ((WriterToASCI)this.m_writer).getOutputStream();
        }
        return null;
    }

    public void elementDecl(String string, String string2) throws SAXException {
        if (this.m_inExternalDTD) {
            return;
        }
        try {
            if (this.m_inDoctype) {
                this.m_writer.write(" [");
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            this.m_writer.write("<!ELEMENT ");
            this.m_writer.write(string);
            this.m_writer.write(32);
            this.m_writer.write(string2);
            this.m_writer.write(62);
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (this.m_inExternalDTD) {
            return;
        }
        try {
            if (this.m_inDoctype) {
                this.m_writer.write(" [");
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            this.outputEntityDecl(string, string2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    void outputEntityDecl(String string, String string2) throws IOException {
        this.m_writer.write("<!ENTITY ");
        this.m_writer.write(string);
        this.m_writer.write(" \"");
        this.m_writer.write(string2);
        this.m_writer.write("\">");
        this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
    }

    protected final void outputLineSep() throws IOException {
        this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
    }

    public void setOutputFormat(Properties properties) {
        boolean bl = this.m_shouldFlush;
        this.init(this.m_writer, properties, false, false);
        this.m_shouldFlush = bl;
    }

    private synchronized void init(Writer writer, Properties properties, boolean bl, boolean bl2) {
        String string;
        this.m_shouldFlush = bl2;
        this.m_writer = this.m_tracer != null && !(writer instanceof SerializerTraceWriter) ? new SerializerTraceWriter(writer, this.m_tracer) : writer;
        this.m_format = properties;
        this.setCdataSectionElements("cdata-section-elements", properties);
        this.setIndentAmount(OutputPropertyUtils.getIntProperty("{http://xml.apache.org/xalan}indent-amount", properties));
        this.setIndent(OutputPropertyUtils.getBooleanProperty("indent", properties));
        boolean bl3 = OutputPropertyUtils.getBooleanProperty("omit-xml-declaration", properties);
        this.setOmitXMLDeclaration(bl3);
        this.setDoctypeSystem(properties.getProperty("doctype-system"));
        String string2 = properties.getProperty("doctype-public");
        this.setDoctypePublic(string2);
        if (((Hashtable)properties).get("standalone") != null) {
            string = properties.getProperty("standalone");
            if (bl) {
                this.setStandaloneInternal(string);
            } else {
                this.setStandalone(string);
            }
        }
        this.setMediaType(properties.getProperty("media-type"));
        if (null != string2 && string2.startsWith("-//W3C//DTD XHTML")) {
            this.m_spaceBeforeClose = true;
        }
        if (null == (string = this.getEncoding())) {
            string = Encodings.getMimeEncoding(properties.getProperty("encoding"));
            this.setEncoding(string);
        }
        this.m_isUTF8 = string.equals("UTF-8");
        this.m_maxCharacter = Encodings.getLastPrintable(string);
        String string3 = (String)((Hashtable)properties).get("{http://xml.apache.org/xalan}entities");
        if (null != string3) {
            this.m_charInfo = CharInfo.getCharInfo(string3);
        }
    }

    private synchronized void init(Writer writer, Properties properties) {
        this.init(writer, properties, false, false);
    }

    protected synchronized void init(OutputStream outputStream, Properties properties, boolean bl) throws UnsupportedEncodingException {
        String string = this.getEncoding();
        if (string == null) {
            string = Encodings.getMimeEncoding(properties.getProperty("encoding"));
            this.setEncoding(string);
        }
        if (string.equalsIgnoreCase("UTF-8")) {
            this.m_isUTF8 = true;
            if (outputStream instanceof BufferedOutputStream || outputStream.getClass().getName().endsWith("BufferedServletOutputStream")) {
                this.init(new WriterToUTF8(outputStream), properties, bl, true);
            } else {
                this.init(new WriterToUTF8Buffered(outputStream), properties, bl, true);
            }
        } else if (string.equals("WINDOWS-1250") || string.equals("US-ASCII") || string.equals("ASCII")) {
            this.init(new WriterToASCI(outputStream), properties, bl, true);
        } else {
            Writer writer;
            try {
                writer = Encodings.getWriter(outputStream, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("Warning: encoding \"" + string + "\" not supported" + ", using " + "UTF-8");
                string = "UTF-8";
                this.setEncoding(string);
                writer = Encodings.getWriter(outputStream, string);
            }
            this.m_maxCharacter = Encodings.getLastPrintable(string);
            this.init(writer, properties, bl, true);
        }
    }

    public Properties getOutputFormat() {
        return this.m_format;
    }

    public void setWriter(Writer writer) {
        this.m_writer = this.m_tracer != null && !(writer instanceof SerializerTraceWriter) ? new SerializerTraceWriter(writer, this.m_tracer) : writer;
    }

    public void setOutputStream(OutputStream outputStream) {
        try {
            Properties properties = null == this.m_format ? OutputPropertiesFactory.getDefaultMethodProperties("xml") : this.m_format;
            this.init(outputStream, properties, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public boolean setEscaping(boolean bl) {
        boolean bl2 = this.m_escaping;
        this.m_escaping = bl;
        return bl2;
    }

    protected void indent() throws IOException {
        if (this.m_startNewLine) {
            this.outputLineSep();
        }
        if (this.m_indentAmount > 0) {
            this.printSpace(this.m_currentElemDepth * this.m_indentAmount);
        }
    }

    private void printSpace(int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            this.m_writer.write(32);
            ++n2;
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this.m_inExternalDTD) {
            return;
        }
        try {
            if (this.m_inDoctype) {
                this.m_writer.write(" [");
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            this.m_writer.write("<!ATTLIST ");
            this.m_writer.write(string);
            this.m_writer.write(" ");
            this.m_writer.write(string2);
            this.m_writer.write(" ");
            this.m_writer.write(string3);
            if (string4 != null) {
                this.m_writer.write(" ");
                this.m_writer.write(string4);
            }
            this.m_writer.write(">");
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    protected boolean escapingNotNeeded(char c) {
        Constable constable;
        Object[] objectArray;
        if (c < '\u007f') {
            return c >= ' ' || '\n' == c || '\r' == c || '\t' == c;
        }
        if (null == this.m_charToByteConverter && !this.m_triedToGetConverter) {
            this.m_triedToGetConverter = true;
            try {
                this.m_charToByteConverter = Encodings.getCharToByteConverter(this.getEncoding());
                if (null != this.m_charToByteConverter) {
                    objectArray = new Class[]{Character.TYPE};
                    constable = this.m_charToByteConverter.getClass();
                    this.m_canConvertMeth = ((Class)constable).getMethod("canConvert", (Class<?>[])objectArray);
                }
            }
            catch (Exception exception) {
                System.err.println("Warning: " + exception.getMessage());
            }
        }
        if (null != this.m_charToByteConverter) {
            try {
                objectArray = new Object[]{new Character(c)};
                constable = (Boolean)this.m_canConvertMeth.invoke(this.m_charToByteConverter, objectArray);
                return ((Boolean)constable).booleanValue() ? !Character.isISOControl(c) : false;
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("Warning: InvocationTargetException in canConvert!");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("Warning: IllegalAccessException in canConvert!");
            }
        }
        return c <= this.m_maxCharacter;
    }

    protected int writeUTF16Surrogate(char c, char[] cArray, int n, int n2) throws IOException {
        int n3 = this.getURF16SurrogateValue(c, cArray, n, n2);
        this.m_writer.write(38);
        this.m_writer.write(35);
        this.m_writer.write(Integer.toString(n3));
        this.m_writer.write(59);
        return ++n;
    }

    int getURF16SurrogateValue(char c, char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (n + 1 >= n2) {
            throw new IOException(XMLMessages.createXMLMessage("ER_INVALID_UTF16_SURROGATE", new Object[]{Integer.toHexString(c)}));
        }
        if (56320 > (n3 = cArray[++n]) || n3 >= 57344) {
            throw new IOException(XMLMessages.createXMLMessage("ER_INVALID_UTF16_SURROGATE", new Object[]{Integer.toHexString(c) + " " + Integer.toHexString(n3)}));
        }
        n3 = (c - 55296 << 10) + n3 - 56320 + 65536;
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int accumDefaultEntity(Writer writer, char c, int n, char[] cArray, int n2, boolean bl) throws IOException {
        if (!bl && '\n' == c) {
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            return n + 1;
        } else {
            if (!this.m_charInfo.isSpecial(c)) return n;
            String string = this.m_charInfo.getEntityNameForChar(c);
            if (null == string) return n;
            writer.write(38);
            writer.write(string);
            writer.write(59);
        }
        return n + 1;
    }

    void writeNormalizedChars(char[] cArray, int n, int n2, boolean bl) throws IOException, SAXException {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            String string;
            char c = cArray[n4];
            if ('\n' == c) {
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            } else if (bl && !this.escapingNotNeeded(c)) {
                if (this.m_cdataTagOpen) {
                    this.closeCDATA();
                }
                if (ToStream.isUTF16Surrogate(c)) {
                    n4 = this.writeUTF16Surrogate(c, cArray, n4, n3);
                } else {
                    this.m_writer.write("&#");
                    string = Integer.toString(c);
                    this.m_writer.write(string);
                    this.m_writer.write(59);
                }
            } else if (bl && n4 < n3 - 2 && ']' == c && ']' == cArray[n4 + 1] && '>' == cArray[n4 + 2]) {
                this.m_writer.write("]]]]><![CDATA[>");
                n4 += 2;
            } else if (this.escapingNotNeeded(c)) {
                if (bl && !this.m_cdataTagOpen) {
                    this.m_writer.write("<![CDATA[");
                    this.m_cdataTagOpen = true;
                }
                this.m_writer.write(c);
            } else if (ToStream.isUTF16Surrogate(c)) {
                if (this.m_cdataTagOpen) {
                    this.closeCDATA();
                }
                n4 = this.writeUTF16Surrogate(c, cArray, n4, n3);
            } else {
                if (this.m_cdataTagOpen) {
                    this.closeCDATA();
                }
                this.m_writer.write("&#");
                string = Integer.toString(c);
                this.m_writer.write(string);
                this.m_writer.write(59);
            }
            ++n4;
        }
    }

    public void endNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.pop();
    }

    public void startNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.push(true);
    }

    protected void cdata(char[] cArray, int n, int n2) throws SAXException {
        try {
            boolean bl;
            int n3 = n;
            if (this.m_startTagOpen) {
                this.closeStartTag();
                this.m_startTagOpen = false;
            }
            this.m_ispreserve = true;
            if (this.shouldIndent()) {
                this.indent();
            }
            boolean bl2 = bl = n2 >= 1 && this.escapingNotNeeded(cArray[n]);
            if (bl && !this.m_cdataTagOpen) {
                this.m_writer.write("<![CDATA[");
                this.m_cdataTagOpen = true;
            }
            if (this.isEscapingDisabled()) {
                this.charactersRaw(cArray, n, n2);
            } else {
                this.writeNormalizedChars(cArray, n, n2, true);
            }
            if (bl && cArray[n + n2 - 1] == ']') {
                this.closeCDATA();
            }
            if (this.m_tracer != null) {
                super.fireCDATAEvent(cArray, n3, n2);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(XMLMessages.createXMLMessage("ER_OIERROR", null), iOException);
        }
    }

    private boolean isEscapingDisabled() {
        return this.m_disableOutputEscapingStates.peekOrFalse();
    }

    protected void charactersRaw(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        try {
            if (this.m_startTagOpen) {
                this.closeStartTag();
                this.m_startTagOpen = false;
            }
            this.m_ispreserve = true;
            this.m_writer.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (0 == n2) {
            if (this.m_tracer != null) {
                super.fireCharEvent(cArray, n, n2);
            }
            return;
        }
        if (this.m_startTagOpen) {
            this.closeStartTag();
            this.m_startTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
        }
        if (this.m_cdataStartCalled || this.m_cdataSectionStates.peekOrFalse()) {
            this.cdata(cArray, n, n2);
            return;
        }
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (this.m_disableOutputEscapingStates.peekOrFalse() || !this.m_escaping) {
            this.charactersRaw(cArray, n, n2);
            if (this.m_tracer != null) {
                super.fireCharEvent(cArray, n, n2);
            }
            return;
        }
        if (this.m_startTagOpen) {
            this.closeStartTag();
            this.m_startTagOpen = false;
        }
        int n3 = n;
        int n4 = 0;
        int n5 = n + n2;
        boolean bl = true;
        int n6 = this.m_maxCharacter;
        BitSet bitSet = this.m_charInfo.m_specialsMap;
        try {
            int n7 = n;
            while (n7 < n5) {
                char c = cArray[n7];
                if (bl && (c > ' ' || c != ' ' && c != '\t' && c != '\r' && c != '\n')) {
                    this.m_ispreserve = true;
                    bl = false;
                }
                if (c < '\u007f' && (' ' <= c || '\n' == c || '\r' == c || '\t' == c) && !bitSet.get(c) || '\"' == c) {
                    ++n4;
                } else if (this.escapingNotNeeded(c) && !bitSet.get(c) || '\"' == c) {
                    ++n4;
                } else {
                    if (n4 > 0) {
                        this.m_writer.write(cArray, n3, n4);
                        n4 = 0;
                    }
                    if ('\n' == c) {
                        this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        n3 = n7 + 1;
                    } else {
                        n3 = this.accumDefaultEscape(this.m_writer, c, n7, cArray, n5, false);
                        n7 = n3 - 1;
                    }
                }
                ++n7;
            }
            if (n4 > 0) {
                this.m_writer.write(cArray, n3, n4);
            }
            this.m_isprevtext = true;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (this.m_tracer != null) {
            super.fireCharEvent(cArray, n, n2);
        }
    }

    public void characters(String string) throws SAXException {
        this.characters(string.toCharArray(), 0, string.length());
    }

    protected int accumDefaultEscape(Writer writer, char c, int n, char[] cArray, int n2, boolean bl) throws IOException {
        int n3 = this.accumDefaultEntity(writer, c, n, cArray, n2, bl);
        if (n == n3) {
            ++n3;
            if ('\ud800' <= c && c < '\udc00') {
                int n4;
                if (n + 1 >= n2) {
                    throw new IOException(XMLMessages.createXMLMessage("ER_INVALID_UTF16_SURROGATE", new Object[]{Integer.toHexString(c)}));
                }
                if (56320 > (n4 = cArray[++n]) || n4 >= 57344) {
                    throw new IOException(XMLMessages.createXMLMessage("ER_INVALID_UTF16_SURROGATE", new Object[]{Integer.toHexString(c) + " " + Integer.toHexString(n4)}));
                }
                n4 = (c - 55296 << 10) + n4 - 56320 + 65536;
                writer.write("&#");
                writer.write(Integer.toString(n4));
                writer.write(";");
            } else if (!this.escapingNotNeeded(c) || this.m_charInfo.isSpecial(c)) {
                writer.write("&#");
                writer.write(Integer.toString(c));
                writer.write(";");
            } else {
                writer.write(c);
            }
        }
        return n3;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        } else if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        try {
            if (this.m_needToOutputDocTypeDecl && null != this.getDoctypeSystem()) {
                this.outputDocTypeDecl(string3, true);
            }
            this.m_needToOutputDocTypeDecl = false;
            if (this.m_startTagOpen) {
                this.closeStartTag();
                this.m_startTagOpen = false;
            }
            if (string != null) {
                this.ensurePrefixIsDeclared(string, string3);
            }
            this.m_elementLocalName = string2;
            this.m_elementURI = string;
            this.m_elementName = string3;
            this.m_ispreserve = false;
            if (this.shouldIndent() && this.m_startNewLine) {
                this.indent();
            }
            this.m_startNewLine = true;
            this.m_writer.write(60);
            this.m_writer.write(string3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (attributes != null) {
            this.addAttributes(attributes);
        }
        this.m_startTagOpen = true;
        ++this.m_currentElemDepth;
        this.m_isprevtext = false;
    }

    public void startElement(String string, String string2, String string3) throws SAXException {
        this.startElement(string, string2, string3, null);
    }

    public void startElement(String string) throws SAXException {
        this.startElement(null, null, string, null);
    }

    void outputDocTypeDecl(String string, boolean bl) throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        try {
            boolean bl2;
            String string2;
            this.m_writer.write("<!DOCTYPE ");
            this.m_writer.write(string);
            String string3 = this.getDoctypePublic();
            if (null != string3) {
                this.m_writer.write(" PUBLIC \"");
                this.m_writer.write(string3);
                this.m_writer.write(34);
            }
            if (null != (string2 = this.getDoctypeSystem())) {
                if (null == string3) {
                    this.m_writer.write(" SYSTEM \"");
                } else {
                    this.m_writer.write(" \"");
                }
                this.m_writer.write(string2);
                if (bl) {
                    this.m_writer.write("\">");
                    this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    bl = false;
                } else {
                    this.m_writer.write(34);
                }
            }
            if ((bl2 = false) && bl) {
                this.m_writer.write(">");
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void processAttributes(int n) throws IOException, SAXException {
        String string = this.getEncoding();
        int n2 = 0;
        while (n2 < n) {
            String string2 = this.m_attributes.getQName(n2);
            String string3 = this.m_attributes.getValue(n2);
            this.m_writer.write(32);
            this.m_writer.write(string2);
            this.m_writer.write("=\"");
            this.writeAttrString(this.m_writer, string3, string);
            this.m_writer.write(34);
            ++n2;
        }
        this.m_attributes.clear();
    }

    public void writeAttrString(Writer writer, String string, String string2) throws IOException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (this.escapingNotNeeded(c) && !this.m_charInfo.isSpecial(c)) {
                writer.write(c);
            } else {
                if (CharInfo.S_CARRIAGERETURN == c && n2 + 1 < n && '\n' == cArray[n2 + 1]) {
                    ++n2;
                    c = '\n';
                }
                this.accumDefaultEscape(writer, c, n2, cArray, n, true);
            }
            ++n2;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.m_prefixMap.popNamespaces(this.m_currentElemDepth);
        --this.m_currentElemDepth;
        try {
            if (this.m_startTagOpen) {
                int n;
                if (this.m_tracer != null) {
                    super.fireStartElem(this.m_elementName);
                }
                if ((n = this.m_attributes.getLength()) > 0) {
                    this.processAttributes(n);
                }
                if (this.m_spaceBeforeClose) {
                    this.m_writer.write(" />");
                } else {
                    this.m_writer.write("/>");
                }
            } else {
                if (this.m_cdataTagOpen) {
                    this.closeCDATA();
                }
                if (this.shouldIndent()) {
                    this.indent();
                }
                this.m_writer.write(60);
                this.m_writer.write(47);
                this.m_writer.write(string3);
                this.m_writer.write(62);
                if (this.m_cdataSectionElements != null) {
                    this.m_cdataSectionStates.pop();
                }
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (!this.m_startTagOpen && this.m_doIndent) {
            this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
        }
        this.m_isprevtext = false;
        this.m_startTagOpen = false;
        this.m_elementURI = null;
        this.m_elementLocalName = null;
        if (this.m_tracer != null) {
            super.fireEndElem(string3);
        }
    }

    public void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.startPrefixMapping(string, string2, true);
    }

    public boolean startPrefixMapping(String string, String string2, boolean bl) throws SAXException {
        int n;
        if (bl) {
            this.flushPending();
            n = this.m_currentElemDepth + 1;
        } else {
            n = this.m_currentElemDepth;
        }
        boolean bl2 = this.m_prefixMap.pushNamespace(string, string2, n);
        if (bl2) {
            if ("".equals(string)) {
                String string3 = "xmlns";
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", string, string3, "CDATA", string2);
            } else if (!"".equals(string2)) {
                String string4 = "xmlns:" + string;
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", string, string4, "CDATA", string2);
            }
        }
        return bl2;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        int n3 = n;
        if (this.m_inEntityRef) {
            return;
        }
        if (this.m_startTagOpen) {
            this.closeStartTag();
            this.m_startTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
        try {
            if (this.shouldIndent()) {
                this.indent();
            }
            int n4 = n + n2;
            boolean bl = false;
            if (this.m_cdataTagOpen) {
                this.closeCDATA();
            }
            this.m_writer.write(COMMENT_BEGIN);
            int n5 = n;
            while (n5 < n4) {
                if (bl && cArray[n5] == '-') {
                    this.m_writer.write(cArray, n, n5 - n);
                    this.m_writer.write(" -");
                    n = n5 + 1;
                }
                bl = cArray[n5] == '-';
                ++n5;
            }
            if (n2 > 0) {
                int n6 = n4 - n;
                if (n6 > 0) {
                    this.m_writer.write(cArray, n, n6);
                }
                if (cArray[n4 - 1] == '-') {
                    this.m_writer.write(32);
                }
            }
            this.m_writer.write(COMMENT_END);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.m_startNewLine = true;
        if (this.m_tracer != null) {
            super.fireCommentEvent(cArray, n3, n2);
        }
    }

    public void endCDATA() throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        this.m_cdataStartCalled = false;
    }

    public void endDTD() throws SAXException {
        try {
            if (this.m_needToOutputDocTypeDecl) {
                this.outputDocTypeDecl(this.m_elementName, false);
                this.m_needToOutputDocTypeDecl = false;
            }
            if (!this.m_inDoctype) {
                this.m_writer.write("]>");
            } else {
                this.m_writer.write(62);
            }
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (0 == n2) {
            return;
        }
        this.characters(cArray, n, n2);
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.m_cdataStartCalled = true;
    }

    public void startEntity(String string) throws SAXException {
        if (string.equals("[dtd]")) {
            this.m_inExternalDTD = true;
        }
        this.m_inEntityRef = true;
    }

    protected void closeStartTag() throws SAXException {
        if (this.m_startTagOpen) {
            try {
                int n;
                if (this.m_tracer != null) {
                    super.fireStartElem(this.m_elementName);
                }
                if ((n = this.m_attributes.getLength()) > 0) {
                    this.processAttributes(n);
                }
                this.m_writer.write(62);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
            if (this.m_cdataSectionElements != null) {
                this.pushCdataSectionState();
            }
            if (this.m_doIndent) {
                this.m_isprevtext = false;
                this.m_preserves.push(this.m_ispreserve);
            }
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.setDoctypeSystem(string3);
        this.setDoctypePublic(string2);
        this.m_elementName = string;
        this.m_inDoctype = true;
    }

    public int getIndentAmount() {
        return this.m_indentAmount;
    }

    public void setIndentAmount(int n) {
        this.m_indentAmount = n;
    }

    protected boolean shouldIndent() {
        return this.m_doIndent && !this.m_ispreserve && !this.m_isprevtext;
    }

    private void setCdataSectionElements(String string, Properties properties) {
        block6: {
            String string2 = properties.getProperty(string);
            if (null == string2) break block6;
            Vector vector = new Vector();
            int n = string2.length();
            boolean bl = false;
            FastStringBuffer fastStringBuffer = new FastStringBuffer();
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    char c;
                    block8: {
                        block7: {
                            c = string2.charAt(n2);
                            if (!Character.isWhitespace(c)) break block7;
                            if (bl) break block8;
                            if (fastStringBuffer.length() > 0) {
                                this.addCdataSectionElement(fastStringBuffer.toString(), vector);
                                fastStringBuffer.reset();
                            }
                            break block9;
                        }
                        if ('{' == c) {
                            bl = true;
                        } else if ('}' == c) {
                            bl = false;
                        }
                    }
                    fastStringBuffer.append(c);
                }
                ++n2;
            }
            if (fastStringBuffer.length() > 0) {
                this.addCdataSectionElement(fastStringBuffer.toString(), vector);
                fastStringBuffer.reset();
            }
            this.setCdataSectionElements(vector);
        }
    }

    private void addCdataSectionElement(String string, Vector vector) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", false);
        String string3 = stringTokenizer.nextToken();
        String string4 = string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
        if (null == string2) {
            vector.addElement(null);
            vector.addElement(string3);
        } else {
            vector.addElement(string3);
            vector.addElement(string2);
        }
    }

    public void setCdataSectionElements(Vector vector) {
        this.m_cdataSectionElements = vector;
    }

    protected String ensureAttributesNamespaceIsDeclared(String string, String string2, String string3) throws SAXException {
        if (string != null && string.length() > 0) {
            String string4;
            int n = 0;
            n = string3.indexOf(":");
            String string5 = string4 = n < 0 ? "" : string3.substring(0, n);
            if (n > 0) {
                String string6 = this.m_prefixMap.lookupNamespace(string4);
                if (string6 != null && string6.equals(string)) {
                    return null;
                }
                this.startPrefixMapping(string4, string, false);
                this.addAttribute("http://www.w3.org/2000/xmlns/", string4, "xmlns:" + string4, "CDATA", string);
                return string4;
            }
            String string7 = this.m_prefixMap.lookupPrefix(string);
            if (string7 == null) {
                string7 = this.m_prefixMap.generateNextPrefix();
                this.startPrefixMapping(string7, string, false);
                this.addAttribute("http://www.w3.org/2000/xmlns/", string7, "xmlns:" + string7, "CDATA", string);
            }
            return string7;
        }
        return null;
    }

    private void ensurePrefixIsDeclared(String string, String string2) throws SAXException {
        if (string != null && string.length() > 0) {
            String string3;
            String string4;
            int n = string2.indexOf(":");
            String string5 = string4 = n < 0 ? "" : string2.substring(0, n);
            if (!(null == string4 || null != (string3 = this.m_prefixMap.lookupNamespace(string4)) && string3.equals(string))) {
                this.startPrefixMapping(string4, string);
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", string4, "xmlns" + (string4.length() == 0 ? "" : ":") + string4, "CDATA", string);
            }
        }
    }

    public void flushPending() {
        try {
            if (this.m_needToCallStartDocument) {
                this.startDocumentInternal();
                this.m_needToCallStartDocument = false;
            }
            if (this.m_startTagOpen) {
                this.closeStartTag();
                this.m_startTagOpen = false;
            }
            if (this.m_cdataTagOpen) {
                this.closeCDATA();
                this.m_cdataTagOpen = false;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
    }

    public void addAttributeAlways(String string, String string2, String string3, String string4, String string5) {
        int n = this.m_attributes.getIndex(string3);
        if (n >= 0) {
            String string6 = null;
            if (this.m_tracer != null && string5.equals(string6 = this.m_attributes.getValue(n))) {
                string6 = null;
            }
            this.m_attributes.setValue(n, string5);
            if (string6 != null) {
                this.firePseudoAttributes();
            }
        } else {
            this.m_attributes.addAttribute(string, string2, string3, string4, string5);
            if (this.m_tracer != null) {
                this.firePseudoAttributes();
            }
        }
    }

    protected void firePseudoAttributes() {
        int n;
        if (this.m_tracer != null && (n = this.m_attributes.getLength()) > 0) {
            String string = this.getEncoding();
            StringBuffer stringBuffer = new StringBuffer();
            WritertoStringBuffer writertoStringBuffer = new WritertoStringBuffer(stringBuffer);
            try {
                int n2 = 0;
                while (n2 < n) {
                    String string2 = this.m_attributes.getQName(n2);
                    String string3 = this.m_attributes.getValue(n2);
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                    stringBuffer.append("=\"");
                    this.writeAttrString(writertoStringBuffer, string3, string);
                    stringBuffer.append('\"');
                    ++n2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            char[] cArray = stringBuffer.toString().toCharArray();
            this.m_tracer.fireGenerateEvent(11, cArray, 0, cArray.length);
        }
    }

    public void setTransformer(Transformer transformer) {
        super.setTransformer(transformer);
        if (this.m_tracer != null && !(this.m_writer instanceof SerializerTraceWriter)) {
            this.m_writer = new SerializerTraceWriter(this.m_writer, this.m_tracer);
        }
    }

    public boolean reset() {
        boolean bl = false;
        if (super.reset()) {
            this.resetToStream();
            bl = true;
        }
        return bl;
    }

    private void resetToStream() {
        this.m_canConvertMeth = null;
        this.m_cdataStartCalled = false;
        this.m_charInfo = null;
        this.m_charToByteConverter = null;
        this.m_disableOutputEscapingStates.clear();
        this.m_escaping = false;
        this.m_inDoctype = false;
        this.m_ispreserve = false;
        this.m_ispreserve = false;
        this.m_isprevtext = false;
        this.m_isUTF8 = false;
        this.m_maxCharacter = Encodings.getLastPrintable();
        this.m_preserves.clear();
        this.m_shouldFlush = true;
        this.m_spaceBeforeClose = false;
        this.m_startNewLine = false;
        this.m_triedToGetConverter = false;
    }

    private class WritertoStringBuffer
    extends Writer {
        private final StringBuffer m_stringbuf;

        WritertoStringBuffer(StringBuffer stringBuffer) {
            this.m_stringbuf = stringBuffer;
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            this.m_stringbuf.append(cArray, n, n2);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        public void write(int n) {
            this.m_stringbuf.append((char)n);
        }

        public void write(String string) {
            this.m_stringbuf.append(string);
        }
    }
}

