/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.serializer.CharInfo;
import org.apache.xml.serializer.ElemDesc;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.OutputPropertyUtils;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.ToStream;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.Trie;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ToHTMLStream
extends ToStream {
    protected final BoolStack m_isRawStack = new BoolStack();
    protected boolean m_inDTD = false;
    private boolean m_inBlockElem = false;
    protected static final CharInfo m_htmlcharInfo = CharInfo.getCharInfo(CharInfo.HTML_ENTITIES_RESOURCE);
    static final Trie m_elementFlags = new Trie();
    private static final ElemDesc m_dummy;
    private boolean m_specialEscapeURLs = true;
    private boolean m_omitMetaTag = false;
    private ElemDesc m_elementDesc = null;

    public void setSpecialEscapeURLs(boolean bl) {
        this.m_specialEscapeURLs = bl;
    }

    public void setOmitMetaTag(boolean bl) {
        this.m_omitMetaTag = bl;
    }

    public void setOutputFormat(Properties properties) {
        this.m_specialEscapeURLs = OutputPropertyUtils.getBooleanProperty("{http://xml.apache.org/xalan}use-url-escaping", properties);
        this.m_omitMetaTag = OutputPropertyUtils.getBooleanProperty("{http://xml.apache.org/xalan}omit-meta-tag", properties);
        super.setOutputFormat(properties);
    }

    private final boolean getSpecialEscapeURLs() {
        return this.m_specialEscapeURLs;
    }

    private final boolean getOmitMetaTag() {
        return this.m_omitMetaTag;
    }

    private final ElemDesc getElemDesc(String string) {
        Object object;
        if (null != string && null != (object = m_elementFlags.get(string))) {
            return (ElemDesc)object;
        }
        return m_dummy;
    }

    public ToHTMLStream() {
        this.m_charInfo = m_htmlcharInfo;
        this.m_prefixMap = new NamespaceMappings();
    }

    protected void startDocumentInternal() throws SAXException {
        super.startDocumentInternal();
        this.m_needToCallStartDocument = false;
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        this.setOmitXMLDeclaration(true);
        if (this.m_needToOutputDocTypeDecl) {
            String string = this.getDoctypeSystem();
            String string2 = this.getDoctypePublic();
            if (null != string || null != string2) {
                try {
                    this.m_writer.write("<!DOCTYPE HTML");
                    if (null != string2) {
                        this.m_writer.write(" PUBLIC \"");
                        this.m_writer.write(string2);
                        this.m_writer.write("\"");
                    }
                    if (null != string) {
                        if (null == string2) {
                            this.m_writer.write(" SYSTEM \"");
                        } else {
                            this.m_writer.write(" \"");
                        }
                        this.m_writer.write(string);
                        this.m_writer.write("\"");
                    }
                    this.m_writer.write(">");
                    this.outputLineSep();
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }
        this.m_needToOutputDocTypeDecl = false;
    }

    public final void endDocument() throws SAXException {
        this.flushPending();
        if (this.m_doIndent && !this.m_isprevtext) {
            try {
                this.outputLineSep();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
            this.m_cdataTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
        if (null != string && string.length() > 0) {
            super.startElement(string, string2, string3, attributes);
            return;
        }
        try {
            boolean bl = this.m_doIndent;
            if (this.m_startTagOpen) {
                this.closeStartTag();
                this.m_startTagOpen = false;
            }
            ElemDesc elemDesc = this.getElemDesc(string3);
            boolean bl2 = elemDesc.is(8);
            boolean bl3 = elemDesc.is(0x400000);
            if (this.m_ispreserve) {
                this.m_ispreserve = false;
            } else if (this.m_doIndent && null != this.m_elementName && (!this.m_inBlockElem || bl2)) {
                this.m_startNewLine = true;
                this.indent();
            }
            this.m_inBlockElem = !bl2;
            this.m_elementLocalName = string2;
            this.m_elementURI = string;
            this.m_elementName = string3;
            this.m_elementDesc = elemDesc;
            this.m_isRawStack.push(elemDesc.is(256));
            this.m_writer.write(60);
            this.m_writer.write(string3);
            if (attributes != null) {
                this.addAttributes(attributes);
            }
            this.m_startTagOpen = true;
            ++this.m_currentElemDepth;
            this.m_isprevtext = false;
            this.m_doIndent = bl;
            if (bl3) {
                if (this.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_startTagOpen = false;
                }
                if (!this.m_omitMetaTag) {
                    if (this.m_doIndent) {
                        this.indent();
                    }
                    this.m_writer.write("<META http-equiv=\"Content-Type\" content=\"text/html; charset=");
                    String string4 = this.getEncoding();
                    String string5 = Encodings.getMimeEncoding(string4);
                    this.m_writer.write(string5);
                    this.m_writer.write(34);
                    this.m_writer.write(62);
                }
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        ElemDesc elemDesc;
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (null != string && string.length() > 0) {
            super.endElement(string, string2, string3);
            return;
        }
        --this.m_currentElemDepth;
        this.m_isRawStack.pop();
        this.m_elementDesc = elemDesc = this.getElemDesc(string3);
        boolean bl = elemDesc.is(8);
        boolean bl2 = false;
        if (this.m_ispreserve) {
            this.m_ispreserve = false;
        } else if (this.m_doIndent && (!this.m_inBlockElem || bl)) {
            this.m_startNewLine = true;
            bl2 = true;
        }
        this.m_inBlockElem = !bl;
        try {
            if (!this.m_startTagOpen) {
                if (bl2) {
                    this.indent();
                }
                this.m_writer.write("</");
                this.m_writer.write(string3);
                this.m_writer.write(62);
                this.m_elementName = string3;
                if (this.m_cdataSectionElements != null) {
                    this.m_cdataSectionStates.pop();
                }
                if (this.m_doIndent && !this.m_preserves.isEmpty()) {
                    this.m_preserves.pop();
                }
            } else {
                int n;
                if (this.m_tracer != null) {
                    super.fireStartElem(this.m_elementName);
                }
                if ((n = this.m_attributes.getLength()) > 0) {
                    this.processAttributes(n);
                }
                if (!elemDesc.is(2)) {
                    this.m_writer.write(62);
                    this.m_writer.write(60);
                    this.m_writer.write(47);
                    this.m_writer.write(string3);
                    this.m_writer.write(62);
                } else {
                    this.m_writer.write(62);
                }
            }
            if (elemDesc.is(0x200000)) {
                this.m_ispreserve = true;
            }
            this.m_startTagOpen = false;
            this.m_isprevtext = false;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.m_elementURI = null;
        this.m_elementLocalName = null;
        if (this.m_tracer != null) {
            super.fireEndElem(string3);
        }
    }

    protected void processAttribute(String string, String string2, ElemDesc elemDesc) throws IOException {
        this.m_writer.write(32);
        if ((string2.length() == 0 || string2.equalsIgnoreCase(string)) && elemDesc != null && elemDesc.isAttrFlagSet(string, 4)) {
            this.m_writer.write(string);
        } else {
            this.m_writer.write(string);
            this.m_writer.write(61);
            this.m_writer.write(34);
            if (elemDesc != null && elemDesc.isAttrFlagSet(string, 2)) {
                this.writeAttrURI(string2, this.m_specialEscapeURLs);
            } else {
                this.writeAttrString(string2, this.getEncoding());
            }
            this.m_writer.write(34);
        }
    }

    private boolean isASCIIDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private String makeHHString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private boolean isHHSign(String string) {
        boolean bl = true;
        try {
            char c = (char)Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void writeAttrURI(String string, boolean bl) throws IOException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < ' ' || c > '~') {
                if (bl) {
                    int n3;
                    int n4;
                    int n5;
                    if (c <= '\u007f') {
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(c));
                    } else if (c <= '\u07ff') {
                        n5 = c >> 6 | 0xC0;
                        n4 = c & 0x3F | 0x80;
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(n5));
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(n4));
                    } else if (ToStream.isUTF16Surrogate(c)) {
                        n5 = c & 0x3FF;
                        n4 = (n5 & 0x3C0) >> 6;
                        n3 = n4 + 1;
                        int n6 = (n5 & 0x3C) >> 2;
                        int n7 = (n5 & 3) << 4 & 0x30;
                        c = cArray[++n2];
                        int n8 = c & 0x3FF;
                        int n9 = n8 & 0x3F;
                        int n10 = 0xF0 | n3 >> 2;
                        int n11 = 0x80 | (n3 & 3) << 4 & 0x30 | n6;
                        int n12 = 0x80 | (n7 |= (n8 & 0x3C0) >> 6);
                        int n13 = 0x80 | n9;
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(n10));
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(n11));
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(n12));
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(n13));
                    } else {
                        n5 = c >> 12 | 0xE0;
                        n4 = (c & 0xFC0) >> 6 | 0x80;
                        n3 = c & 0x3F | 0x80;
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(n5));
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(n4));
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(n3));
                    }
                } else if (this.escapingNotNeeded(c)) {
                    this.m_writer.write(c);
                } else {
                    this.m_writer.write("&#");
                    this.m_writer.write(Integer.toString(c));
                    this.m_writer.write(59);
                }
            } else if ('%' == c) {
                this.m_writer.write(c);
            } else if (c == '\"') {
                if (bl) {
                    this.m_writer.write("%22");
                } else {
                    this.m_writer.write("&quot;");
                }
            } else {
                this.m_writer.write(c);
            }
            ++n2;
        }
    }

    public void writeAttrString(String string, String string2) throws IOException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (this.escapingNotNeeded(c) && !this.m_charInfo.isSpecial(c)) {
                this.m_writer.write(c);
            } else if ('<' == c || '>' == c) {
                this.m_writer.write(c);
            } else if ('&' == c && n2 + 1 < n && '{' == cArray[n2 + 1]) {
                this.m_writer.write(c);
            } else {
                int n3 = this.accumDefaultEntity(this.m_writer, c, n2, cArray, n, false);
                if (n2 != n3) {
                    n2 = n3 - 1;
                } else {
                    String string3;
                    if (ToStream.isUTF16Surrogate(c)) {
                        n2 = this.writeUTF16Surrogate(c, cArray, n2, n);
                    }
                    if (null != (string3 = this.m_charInfo.getEntityNameForChar(c))) {
                        this.m_writer.write(38);
                        this.m_writer.write(string3);
                        this.m_writer.write(59);
                    } else if (this.escapingNotNeeded(c)) {
                        this.m_writer.write(c);
                    } else {
                        this.m_writer.write("&#");
                        this.m_writer.write(Integer.toString(c));
                        this.m_writer.write(59);
                    }
                }
            }
            ++n2;
        }
    }

    public final void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_isRawStack.peekOrFalse()) {
            try {
                if (this.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_startTagOpen = false;
                }
                this.m_ispreserve = true;
                this.writeNormalizedChars(cArray, n, n2, false);
                if (this.m_tracer != null) {
                    super.fireCharEvent(cArray, n, n2);
                }
                return;
            }
            catch (IOException iOException) {
                throw new SAXException(XMLMessages.createXMLMessage("ER_OIERROR", null), iOException);
            }
        }
        super.characters(cArray, n, n2);
    }

    public final void cdata(char[] cArray, int n, int n2) throws SAXException {
        if (null != this.m_elementName && (this.m_elementName.equalsIgnoreCase("SCRIPT") || this.m_elementName.equalsIgnoreCase("STYLE"))) {
            try {
                if (this.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_startTagOpen = false;
                }
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent();
                }
                this.writeNormalizedChars(cArray, n, n2, true);
            }
            catch (IOException iOException) {
                throw new SAXException(XMLMessages.createXMLMessage("ER_OIERROR", null), iOException);
            }
        } else {
            super.cdata(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushPending();
        if (string.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (string.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            try {
                if (this.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_startTagOpen = false;
                } else if (this.m_needToCallStartDocument) {
                    this.startDocumentInternal();
                }
                if (this.shouldIndent()) {
                    this.indent();
                }
                this.m_writer.write("<?" + string);
                if (string2.length() > 0 && !Character.isSpaceChar(string2.charAt(0))) {
                    this.m_writer.write(" ");
                }
                this.m_writer.write(string2 + ">");
                if (this.m_currentElemDepth <= 0) {
                    this.outputLineSep();
                }
                this.m_startNewLine = true;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    public final void entityReference(String string) throws SAXException {
        try {
            this.m_writer.write("&");
            this.m_writer.write(string);
            this.m_writer.write(";");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public final void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    public void processAttributes(int n) throws IOException, SAXException {
        int n2 = 0;
        while (n2 < n) {
            this.processAttribute(this.m_attributes.getQName(n2), this.m_attributes.getValue(n2), this.m_elementDesc);
            ++n2;
        }
        this.m_attributes.clear();
    }

    protected void closeStartTag() throws SAXException {
        try {
            int n;
            if (this.m_tracer != null) {
                super.fireStartElem(this.m_elementName);
            }
            if ((n = this.m_attributes.getLength()) > 0) {
                this.processAttributes(n);
            }
            this.m_writer.write(62);
            if (this.m_cdataSectionElements != null) {
                this.pushCdataSectionState();
            }
            if (this.m_doIndent) {
                this.m_isprevtext = false;
                this.m_preserves.push(this.m_ispreserve);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected synchronized void init(OutputStream outputStream, Properties properties) throws UnsupportedEncodingException {
        if (null == properties) {
            properties = OutputPropertiesFactory.getDefaultMethodProperties("html");
        }
        super.init(outputStream, properties, false);
    }

    public void setOutputStream(OutputStream outputStream) {
        try {
            Properties properties = null == this.m_format ? OutputPropertiesFactory.getDefaultMethodProperties("html") : this.m_format;
            this.init(outputStream, properties, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
        String string3;
        if (this.m_elementURI == null && (string3 = SerializerBase.getPrefixPart(this.m_elementName)) == null && "".equals(string)) {
            this.m_elementURI = string2;
        }
        this.startPrefixMapping(string, string2, false);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.m_inDTD = true;
        super.startDTD(string, string2, string3);
    }

    public void endDTD() throws SAXException {
        this.m_inDTD = false;
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
    }

    public void elementDecl(String string, String string2) throws SAXException {
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_inDTD) {
            return;
        }
        super.comment(cArray, n, n2);
    }

    public boolean reset() {
        boolean bl = super.reset();
        if (!bl) {
            return false;
        }
        this.initToHTMLStream();
        return true;
    }

    private void initToHTMLStream() {
        this.m_elementDesc = null;
        this.m_inBlockElem = false;
        this.m_inDTD = false;
        this.m_isRawStack.clear();
        this.m_omitMetaTag = false;
        this.m_specialEscapeURLs = true;
    }

    static {
        m_elementFlags.put("BASEFONT", new ElemDesc(2));
        m_elementFlags.put("FRAME", new ElemDesc(10));
        m_elementFlags.put("FRAMESET", new ElemDesc(8));
        m_elementFlags.put("NOFRAMES", new ElemDesc(8));
        m_elementFlags.put("ISINDEX", new ElemDesc(10));
        m_elementFlags.put("APPLET", new ElemDesc(0x200000));
        m_elementFlags.put("CENTER", new ElemDesc(8));
        m_elementFlags.put("DIR", new ElemDesc(8));
        m_elementFlags.put("MENU", new ElemDesc(8));
        m_elementFlags.put("TT", new ElemDesc(4096));
        m_elementFlags.put("I", new ElemDesc(4096));
        m_elementFlags.put("B", new ElemDesc(4096));
        m_elementFlags.put("BIG", new ElemDesc(4096));
        m_elementFlags.put("SMALL", new ElemDesc(4096));
        m_elementFlags.put("EM", new ElemDesc(8192));
        m_elementFlags.put("STRONG", new ElemDesc(8192));
        m_elementFlags.put("DFN", new ElemDesc(8192));
        m_elementFlags.put("CODE", new ElemDesc(8192));
        m_elementFlags.put("SAMP", new ElemDesc(8192));
        m_elementFlags.put("KBD", new ElemDesc(8192));
        m_elementFlags.put("VAR", new ElemDesc(8192));
        m_elementFlags.put("CITE", new ElemDesc(8192));
        m_elementFlags.put("ABBR", new ElemDesc(8192));
        m_elementFlags.put("ACRONYM", new ElemDesc(8192));
        m_elementFlags.put("SUP", new ElemDesc(98304));
        m_elementFlags.put("SUB", new ElemDesc(98304));
        m_elementFlags.put("SPAN", new ElemDesc(98304));
        m_elementFlags.put("BDO", new ElemDesc(98304));
        m_elementFlags.put("BR", new ElemDesc(98314));
        m_elementFlags.put("BODY", new ElemDesc(8));
        m_elementFlags.put("ADDRESS", new ElemDesc(56));
        m_elementFlags.put("DIV", new ElemDesc(56));
        m_elementFlags.put("A", new ElemDesc(32768));
        m_elementFlags.put("MAP", new ElemDesc(98312));
        m_elementFlags.put("AREA", new ElemDesc(10));
        m_elementFlags.put("LINK", new ElemDesc(131082));
        m_elementFlags.put("IMG", new ElemDesc(2195458));
        m_elementFlags.put("OBJECT", new ElemDesc(2326528));
        m_elementFlags.put("PARAM", new ElemDesc(2));
        m_elementFlags.put("HR", new ElemDesc(58));
        m_elementFlags.put("P", new ElemDesc(56));
        m_elementFlags.put("H1", new ElemDesc(262152));
        m_elementFlags.put("H2", new ElemDesc(262152));
        m_elementFlags.put("H3", new ElemDesc(262152));
        m_elementFlags.put("H4", new ElemDesc(262152));
        m_elementFlags.put("H5", new ElemDesc(262152));
        m_elementFlags.put("H6", new ElemDesc(262152));
        m_elementFlags.put("PRE", new ElemDesc(0x100008));
        m_elementFlags.put("Q", new ElemDesc(98304));
        m_elementFlags.put("BLOCKQUOTE", new ElemDesc(56));
        m_elementFlags.put("INS", new ElemDesc(0));
        m_elementFlags.put("DEL", new ElemDesc(0));
        m_elementFlags.put("DL", new ElemDesc(56));
        m_elementFlags.put("DT", new ElemDesc(8));
        m_elementFlags.put("DD", new ElemDesc(8));
        m_elementFlags.put("OL", new ElemDesc(524296));
        m_elementFlags.put("UL", new ElemDesc(524296));
        m_elementFlags.put("LI", new ElemDesc(8));
        m_elementFlags.put("FORM", new ElemDesc(8));
        m_elementFlags.put("LABEL", new ElemDesc(16384));
        m_elementFlags.put("INPUT", new ElemDesc(18434));
        m_elementFlags.put("SELECT", new ElemDesc(18432));
        m_elementFlags.put("OPTGROUP", new ElemDesc(0));
        m_elementFlags.put("OPTION", new ElemDesc(0));
        m_elementFlags.put("TEXTAREA", new ElemDesc(18432));
        m_elementFlags.put("FIELDSET", new ElemDesc(24));
        m_elementFlags.put("LEGEND", new ElemDesc(0));
        m_elementFlags.put("BUTTON", new ElemDesc(18432));
        m_elementFlags.put("TABLE", new ElemDesc(56));
        m_elementFlags.put("CAPTION", new ElemDesc(8));
        m_elementFlags.put("THEAD", new ElemDesc(8));
        m_elementFlags.put("TFOOT", new ElemDesc(8));
        m_elementFlags.put("TBODY", new ElemDesc(8));
        m_elementFlags.put("COLGROUP", new ElemDesc(8));
        m_elementFlags.put("COL", new ElemDesc(10));
        m_elementFlags.put("TR", new ElemDesc(8));
        m_elementFlags.put("TH", new ElemDesc(0));
        m_elementFlags.put("TD", new ElemDesc(0));
        m_elementFlags.put("HEAD", new ElemDesc(0x400008));
        m_elementFlags.put("TITLE", new ElemDesc(8));
        m_elementFlags.put("BASE", new ElemDesc(10));
        m_elementFlags.put("META", new ElemDesc(131082));
        m_elementFlags.put("STYLE", new ElemDesc(131336));
        m_elementFlags.put("SCRIPT", new ElemDesc(229632));
        m_elementFlags.put("NOSCRIPT", new ElemDesc(56));
        m_elementFlags.put("HTML", new ElemDesc(8));
        m_elementFlags.put("FONT", new ElemDesc(4096));
        m_elementFlags.put("S", new ElemDesc(4096));
        m_elementFlags.put("STRIKE", new ElemDesc(4096));
        m_elementFlags.put("U", new ElemDesc(4096));
        m_elementFlags.put("NOBR", new ElemDesc(4096));
        m_elementFlags.put("IFRAME", new ElemDesc(56));
        m_elementFlags.put("LAYER", new ElemDesc(56));
        m_elementFlags.put("ILAYER", new ElemDesc(56));
        ElemDesc elemDesc = (ElemDesc)m_elementFlags.get("AREA");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NOHREF", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("BASE");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("BLOCKQUOTE");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("Q");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INS");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("DEL");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("A");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NAME", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("LINK");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INPUT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("CHECKED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SELECT");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("MULTIPLE", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTGROUP");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTION");
        elemDesc.setAttr("SELECTED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("TEXTAREA");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("BUTTON");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SCRIPT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("FOR", 2);
        elemDesc.setAttr("DEFER", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("IMG");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OBJECT");
        elemDesc.setAttr("CLASSID", 2);
        elemDesc.setAttr("CODEBASE", 2);
        elemDesc.setAttr("DATA", 2);
        elemDesc.setAttr("ARCHIVE", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("DECLARE", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("FORM");
        elemDesc.setAttr("ACTION", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("HEAD");
        elemDesc.setAttr("PROFILE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("FRAME");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("IFRAME");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("LAYER");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("ILAYER");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("DIV");
        elemDesc.setAttr("SRC", 2);
        m_dummy = new ElemDesc(8);
    }
}

