/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.Writer;
import org.apache.xml.serializer.SerializerTrace;

public class SerializerTraceWriter
extends Writer {
    private final Writer m_writer;
    private final SerializerTrace m_tracer;
    private int buf_length;
    private byte[] buf;
    private int count;

    private void setBufferSize(int n) {
        this.buf = new byte[n + 3];
        this.buf_length = n;
        this.count = 0;
    }

    public SerializerTraceWriter(Writer writer, SerializerTrace serializerTrace) {
        this.m_writer = writer;
        this.m_tracer = serializerTrace;
        this.setBufferSize(1024);
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            char[] cArray = new char[this.count];
            int n = 0;
            while (n < this.count) {
                cArray[n] = (char)this.buf[n];
                ++n;
            }
            if (this.m_tracer != null) {
                this.m_tracer.fireGenerateEvent(12, cArray, 0, cArray.length);
            }
            this.count = 0;
        }
    }

    public void flush() throws IOException {
        if (this.m_writer != null) {
            this.m_writer.flush();
        }
        this.flushBuffer();
    }

    public void close() throws IOException {
        if (this.m_writer != null) {
            this.m_writer.close();
        }
        this.flushBuffer();
    }

    public void write(int n) throws IOException {
        if (this.m_writer != null) {
            this.m_writer.write(n);
        }
        if (this.count >= this.buf_length) {
            this.flushBuffer();
        }
        if (n < 128) {
            this.buf[this.count++] = (byte)n;
        } else if (n < 2048) {
            this.buf[this.count++] = (byte)(192 + (n >> 6));
            this.buf[this.count++] = (byte)(128 + (n & 0x3F));
        } else {
            this.buf[this.count++] = (byte)(224 + (n >> 12));
            this.buf[this.count++] = (byte)(128 + (n >> 6 & 0x3F));
            this.buf[this.count++] = (byte)(128 + (n & 0x3F));
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (this.m_writer != null) {
            this.m_writer.write(cArray, n, n2);
        }
        if ((n3 = (n2 << 1) + n2) >= this.buf_length) {
            this.flushBuffer();
            this.setBufferSize(2 * n3);
        }
        if (n3 > this.buf_length - this.count) {
            this.flushBuffer();
        }
        int n4 = n2 + n;
        int n5 = n;
        while (n5 < n4) {
            char c = cArray[n5];
            if (c < '\u0080') {
                this.buf[this.count++] = (byte)c;
            } else if (c < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c >> 6));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c >> 12));
                this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            }
            ++n5;
        }
    }

    public void write(String string) throws IOException {
        int n;
        int n2;
        if (this.m_writer != null) {
            this.m_writer.write(string);
        }
        if ((n2 = ((n = string.length()) << 1) + n) >= this.buf_length) {
            this.flushBuffer();
            this.setBufferSize(2 * n2);
        }
        if (n2 > this.buf_length - this.count) {
            this.flushBuffer();
        }
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c < '\u0080') {
                this.buf[this.count++] = (byte)c;
            } else if (c < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c >> 6));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c >> 12));
                this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            }
            ++n3;
        }
    }
}

