/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class NamespaceMappings {
    private int count = 0;
    private Stack m_prefixStack = new Stack();
    private Hashtable m_namespaces = new Hashtable();
    private Stack m_nodeStack = new Stack();
    private static final String EMPTYSTRING = "";
    private static final String XML_PREFIX = "xml";

    public NamespaceMappings() {
        this.initNamespaces();
    }

    private void initNamespaces() {
        Stack<String> stack = new Stack<String>();
        this.m_namespaces.put(EMPTYSTRING, stack);
        stack.push(EMPTYSTRING);
        this.m_prefixStack.push(EMPTYSTRING);
        stack = new Stack();
        this.m_namespaces.put(XML_PREFIX, stack);
        stack.push("http://www.w3.org/XML/1998/namespace");
        this.m_prefixStack.push(XML_PREFIX);
        this.m_nodeStack.push(new Integer(-1));
    }

    public String lookupNamespace(String string) {
        Stack stack = (Stack)this.m_namespaces.get(string);
        return stack != null && !stack.isEmpty() ? (String)stack.peek() : null;
    }

    public String lookupPrefix(String string) {
        String string2 = null;
        Enumeration enumeration = this.m_namespaces.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = this.lookupNamespace(string3);
            if (string4 == null || !string4.equals(string)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    public boolean popNamespace(String string) {
        if (string.startsWith(XML_PREFIX)) {
            return false;
        }
        Stack stack = (Stack)this.m_namespaces.get(string);
        if (stack != null) {
            stack.pop();
            return true;
        }
        return false;
    }

    public boolean pushNamespace(String string, String string2, int n) {
        if (string.startsWith(XML_PREFIX)) {
            return false;
        }
        Stack<String> stack = (Stack<String>)this.m_namespaces.get(string);
        if (stack == null) {
            stack = new Stack<String>();
            this.m_namespaces.put(string, stack);
        }
        if (!stack.empty() && string2.equals(stack.peek())) {
            return false;
        }
        stack.push(string2);
        this.m_prefixStack.push(string);
        this.m_nodeStack.push(new Integer(n));
        return true;
    }

    public void popNamespaces(int n) {
        while (!this.m_nodeStack.isEmpty()) {
            Integer n2 = (Integer)this.m_nodeStack.peek();
            if (n2 < n) {
                return;
            }
            this.m_nodeStack.pop();
            this.popNamespace((String)this.m_prefixStack.pop());
        }
        return;
    }

    public String generateNextPrefix() {
        return "ns" + this.count++;
    }

    public Object clone() throws CloneNotSupportedException {
        NamespaceMappings namespaceMappings = new NamespaceMappings();
        namespaceMappings.m_prefixStack = (Stack)this.m_prefixStack.clone();
        namespaceMappings.m_nodeStack = (Stack)this.m_nodeStack.clone();
        namespaceMappings.m_namespaces = (Hashtable)this.m_namespaces.clone();
        namespaceMappings.count = this.count;
        return namespaceMappings;
    }

    public final void reset() {
        this.count = 0;
        this.m_namespaces.clear();
        this.m_nodeStack.clear();
        this.m_prefixStack.clear();
        this.initNamespaces();
    }
}

