/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.xml.serializer.EncodingInfo;
import org.apache.xml.serializer.Utils;
import org.apache.xml.utils.WrappedRuntimeException;

public class Encodings {
    static final int m_defaultLastPrintable = 127;
    static final String ENCODINGS_FILE = "org/apache/xml/serializer/Encodings.properties";
    static final String ENCODINGS_PROP = "org.apache.xalan.serialize.encodings";
    private static final Class[] NO_CLASSES = new Class[0];
    private static final Object[] NO_OBJS = new Object[0];
    public static final String DEFAULT_MIME_ENCODING = "UTF-8";
    private static final Hashtable _encodingTableKeyJava = new Hashtable();
    private static final Hashtable _encodingTableKeyMime = new Hashtable();
    private static final EncodingInfo[] _encodings = Encodings.loadEncodingInfo();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Thread;

    public static Writer getWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        int n = 0;
        while (n < _encodings.length) {
            if (Encodings._encodings[n].name.equalsIgnoreCase(string)) {
                try {
                    return new OutputStreamWriter(outputStream, Encodings._encodings[n].javaName);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            ++n;
        }
        try {
            return new OutputStreamWriter(outputStream, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedEncodingException(string);
        }
    }

    public static Object getCharToByteConverter(String string) {
        Object[] objectArray;
        Class clazz = null;
        Method method = null;
        try {
            clazz = Utils.ClassForName("sun.io.CharToByteConverter");
            objectArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Encodings.class$("java.lang.String")) : class$java$lang$String};
            method = clazz.getMethod("getConverter", (Class<?>[])objectArray);
        }
        catch (Exception exception) {
            System.err.println("Warning: Could not get charToByteConverterClass!");
            return null;
        }
        objectArray = new Object[1];
        int n = 0;
        while (n < _encodings.length) {
            if (Encodings._encodings[n].name.equalsIgnoreCase(string)) {
                try {
                    objectArray[0] = Encodings._encodings[n].javaName;
                    Object object = method.invoke(null, objectArray);
                    if (null != object) {
                        return object;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
        return null;
    }

    public static int getLastPrintable(String string) {
        String string2 = string.toUpperCase();
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(string2);
        if (encodingInfo == null) {
            encodingInfo = (EncodingInfo)_encodingTableKeyMime.get(string2);
        }
        if (encodingInfo != null) {
            return encodingInfo.lastPrintable;
        }
        return 127;
    }

    public static int getLastPrintable() {
        return 127;
    }

    public static String getMimeEncoding(String string) {
        block5: {
            if (null == string) {
                try {
                    string = System.getProperty("file.encoding", "UTF8");
                    if (null != string) {
                        String string2 = string.equalsIgnoreCase("Cp1252") || string.equalsIgnoreCase("ISO8859_1") || string.equalsIgnoreCase("8859_1") || string.equalsIgnoreCase("UTF8") ? DEFAULT_MIME_ENCODING : Encodings.convertJava2MimeEncoding(string);
                        string = null != string2 ? string2 : DEFAULT_MIME_ENCODING;
                        break block5;
                    }
                    string = DEFAULT_MIME_ENCODING;
                }
                catch (SecurityException securityException) {
                    string = DEFAULT_MIME_ENCODING;
                }
            } else {
                string = Encodings.convertJava2MimeEncoding(string);
            }
        }
        return string;
    }

    public static String convertJava2MimeEncoding(String string) {
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(string.toUpperCase());
        if (null != encodingInfo) {
            return encodingInfo.name;
        }
        return string;
    }

    public static String convertMime2JavaEncoding(String string) {
        int n = 0;
        while (n < _encodings.length) {
            if (Encodings._encodings[n].name.equalsIgnoreCase(string)) {
                return Encodings._encodings[n].javaName;
            }
            ++n;
        }
        return string;
    }

    private static EncodingInfo[] loadEncodingInfo() {
        URL uRL = null;
        try {
            int n;
            EncodingInfo[] encodingInfoArray;
            Object object;
            Object object2;
            String string = null;
            try {
                string = System.getProperty(ENCODINGS_PROP, "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string != null && string.length() > 0) {
                uRL = new URL(string);
            }
            if (uRL == null) {
                object2 = null;
                try {
                    object = (class$java$lang$Thread == null ? (class$java$lang$Thread = Encodings.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", NO_CLASSES);
                    if (object != null) {
                        object2 = (ClassLoader)((Method)object).invoke((Object)Thread.currentThread(), NO_OBJS);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object2 != null) {
                    uRL = ((ClassLoader)object2).getResource(ENCODINGS_FILE);
                }
            }
            if (uRL == null) {
                uRL = ClassLoader.getSystemResource(ENCODINGS_FILE);
            }
            object2 = new Properties();
            if (uRL != null) {
                object = uRL.openStream();
                ((Properties)object2).load((InputStream)object);
                ((InputStream)object).close();
            }
            int n2 = ((Hashtable)object2).size();
            int n3 = 0;
            Enumeration enumeration = ((Hashtable)object2).keys();
            int n4 = 0;
            while (n4 < n2) {
                encodingInfoArray = (String)enumeration.nextElement();
                String string2 = ((Properties)object2).getProperty((String)encodingInfoArray);
                ++n3;
                n = string2.indexOf(32);
                int n5 = 0;
                while (n5 < n) {
                    if (string2.charAt(n5) == ',') {
                        ++n3;
                    }
                    ++n5;
                }
                ++n4;
            }
            encodingInfoArray = new EncodingInfo[n3];
            int n6 = 0;
            enumeration = ((Hashtable)object2).keys();
            n = 0;
            while (n < n2) {
                int n7;
                String string3;
                String string4 = (String)enumeration.nextElement();
                String string5 = ((Properties)object2).getProperty(string4);
                int n8 = string5.indexOf(32);
                if (n8 < 0) {
                    string3 = string5;
                    n7 = 255;
                } else {
                    n7 = Integer.decode(string5.substring(n8).trim());
                    StringTokenizer stringTokenizer = new StringTokenizer(string5.substring(0, n8), ",");
                    boolean bl = true;
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        encodingInfoArray[n6] = new EncodingInfo(string3, string4, n7);
                        _encodingTableKeyMime.put(string3.toUpperCase(), encodingInfoArray[n6]);
                        if (bl) {
                            _encodingTableKeyJava.put(string4.toUpperCase(), encodingInfoArray[n6]);
                        }
                        ++n6;
                        bl = false;
                    }
                }
                ++n;
            }
            return encodingInfoArray;
        }
        catch (MalformedURLException malformedURLException) {
            throw new WrappedRuntimeException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException(iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

