/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.CharKey;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.WrappedRuntimeException;

public class CharInfo {
    BitSet m_specialsMap = new BitSet(65535);
    private Hashtable m_charToEntityRef = new Hashtable();
    public static String HTML_ENTITIES_RESOURCE = "org.apache.xml.serializer.HTMLEntities";
    public static String XML_ENTITIES_RESOURCE = "org.apache.xml.serializer.XMLEntities";
    public static final char S_LINEFEED = '\n';
    public static char S_CARRIAGERETURN = (char)13;
    private CharKey m_charKey = new CharKey();
    static /* synthetic */ Class class$org$apache$xml$serializer$CharInfo;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CharInfo(String string) {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        PropertyResourceBundle propertyResourceBundle = this.loadEntitiesResource(string);
        if (null != propertyResourceBundle) {
            Enumeration<String> enumeration = propertyResourceBundle.getKeys();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    this.m_specialsMap.set(10);
                    this.m_specialsMap.set(S_CARRIAGERETURN);
                    return;
                }
                String string2 = enumeration.nextElement();
                String string3 = propertyResourceBundle.getString(string2);
                int n = Integer.parseInt(string3);
                this.defineEntity(string2, (char)n);
            }
        }
        try {
            try {
                Object object;
                try {
                    object = (class$org$apache$xml$serializer$CharInfo == null ? (class$org$apache$xml$serializer$CharInfo = CharInfo.class$("org.apache.xml.serializer.CharInfo")) : class$org$apache$xml$serializer$CharInfo).getClassLoader();
                    inputStream = object == null ? ClassLoader.getSystemResourceAsStream(string) : ((ClassLoader)object).getResourceAsStream(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (inputStream == null) {
                    inputStream = (class$org$apache$xml$serializer$CharInfo == null ? (class$org$apache$xml$serializer$CharInfo = CharInfo.class$("org.apache.xml.serializer.CharInfo")) : class$org$apache$xml$serializer$CharInfo).getResourceAsStream(string);
                }
                if (inputStream == null) {
                    object = new URL(string);
                    inputStream = ((URL)object).openStream();
                }
                if (inputStream == null) {
                    throw new RuntimeException(XMLMessages.createXMLMessage("ER_RESOURCE_COULD_NOT_FIND", new Object[]{string, string}));
                }
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                }
                String string4 = bufferedReader.readLine();
                while (true) {
                    if (string4 == null) {
                        inputStream.close();
                        this.m_specialsMap.set(10);
                        this.m_specialsMap.set(S_CARRIAGERETURN);
                        break;
                    }
                    if (string4.length() == 0 || string4.charAt(0) == '#') {
                        string4 = bufferedReader.readLine();
                        continue;
                    }
                    int n = string4.indexOf(32);
                    if (n > 1) {
                        String string5 = string4.substring(0, n);
                        if (++n < string4.length()) {
                            String string6 = string4.substring(n);
                            if ((n = string6.indexOf(32)) > 0) {
                                string6 = string6.substring(0, n);
                            }
                            int n2 = Integer.parseInt(string6);
                            this.defineEntity(string5, (char)n2);
                        }
                    }
                    string4 = bufferedReader.readLine();
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(XMLMessages.createXMLMessage("ER_RESOURCE_COULD_NOT_LOAD", new Object[]{string, exception.toString(), string, exception.toString()}));
            }
            Object var12_18 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        inputStream.close();
        return;
    }

    protected void defineEntity(String string, char c) {
        CharKey charKey = new CharKey(c);
        this.m_charToEntityRef.put(charKey, string);
        this.m_specialsMap.set(c);
    }

    public synchronized String getEntityNameForChar(char c) {
        this.m_charKey.setChar(c);
        return (String)this.m_charToEntityRef.get(this.m_charKey);
    }

    public boolean isSpecial(char c) {
        return this.m_specialsMap.get(c);
    }

    public static CharInfo getCharInfo(String string) {
        CharInfo charInfo = null;
        Hashtable hashtable = HashtableHolder.m_getCharInfo_cache;
        charInfo = (CharInfo)hashtable.get(string);
        if (charInfo == null) {
            try {
                charInfo = new CharInfo(string);
                hashtable.put(string, charInfo);
            }
            catch (Exception exception) {
                charInfo = null;
            }
        }
        if (null == charInfo) {
            String string2;
            if (string.indexOf(58) < 0) {
                string2 = SystemIDResolver.getAbsoluteURIFromRelative(string);
            } else {
                try {
                    string2 = SystemIDResolver.getAbsoluteURI(string, null);
                }
                catch (TransformerException transformerException) {
                    throw new WrappedRuntimeException(transformerException);
                }
            }
            charInfo = new CharInfo(string2);
            hashtable.put(string, charInfo);
        }
        return charInfo;
    }

    private PropertyResourceBundle loadEntitiesResource(String string) throws MissingResourceException {
        try {
            Locale locale = Locale.getDefault();
            ClassLoader classLoader = this.getClass().getClassLoader();
            return (PropertyResourceBundle)ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class HashtableHolder {
        private static Hashtable m_getCharInfo_cache = new Hashtable();

        private HashtableHolder() {
        }
    }
}

