/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBase;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.dtm.ref.IncrementalSAXSource;
import org.apache.xml.dtm.ref.IncrementalSAXSource_Filter;
import org.apache.xml.dtm.ref.IncrementalSAXSource_Xerces;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTM;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTMdefaultNamespaceDeclarationNode;
import org.apache.xml.dtm.ref.sax2dtm.SAX2DTM;
import org.apache.xml.dtm.ref.sax2dtm.SAX2RTFDTM;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SuballocatedIntVector;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DTMManagerDefault
extends DTMManager {
    private static final boolean DUMPTREE = false;
    private static final boolean DEBUG = false;
    protected DTM[] m_dtms = new DTM[256];
    int[] m_dtm_offsets = new int[256];
    private ExpandedNameTable m_expandedNameTable = new ExpandedNameTable();

    public synchronized void addDTM(DTM dTM, int n) {
        this.addDTM(dTM, n, 0);
    }

    public synchronized void addDTM(DTM dTM, int n, int n2) {
        if (n >= 65536) {
            throw new DTMException(XMLMessages.createXMLMessage("ER_NO_DTMIDS_AVAIL", null));
        }
        int n3 = this.m_dtms.length;
        if (n3 <= n) {
            int n4 = Math.min(n + 256, 65536);
            DTM[] dTMArray = new DTM[n4];
            System.arraycopy(this.m_dtms, 0, dTMArray, 0, n3);
            this.m_dtms = dTMArray;
            int[] nArray = new int[n4];
            System.arraycopy(this.m_dtm_offsets, 0, nArray, 0, n3);
            this.m_dtm_offsets = nArray;
        }
        this.m_dtms[n] = dTM;
        this.m_dtm_offsets[n] = n2;
        dTM.documentRegistration();
    }

    public synchronized int getFirstFreeDTMID() {
        int n = this.m_dtms.length;
        int n2 = 1;
        while (n2 < n) {
            if (null == this.m_dtms[n2]) {
                return n2;
            }
            ++n2;
        }
        return n;
    }

    public synchronized DTM getDTM(Source source, boolean bl, DTMWSFilter dTMWSFilter, boolean bl2, boolean bl3) {
        boolean bl4;
        XMLStringFactory xMLStringFactory = this.m_xsf;
        int n = this.getFirstFreeDTMID();
        int n2 = n << 16;
        if (null != source && source instanceof DOMSource) {
            DOM2DTM dOM2DTM = new DOM2DTM((DTMManager)this, (DOMSource)source, n2, dTMWSFilter, xMLStringFactory, bl3);
            this.addDTM(dOM2DTM, n, 0);
            return dOM2DTM;
        }
        boolean bl5 = null != source ? source instanceof SAXSource : true;
        boolean bl6 = bl4 = null != source ? source instanceof StreamSource : false;
        if (bl5 || bl4) {
            boolean bl7;
            Object object;
            XMLReader xMLReader;
            InputSource inputSource;
            if (null == source) {
                inputSource = null;
                xMLReader = null;
            } else {
                xMLReader = this.getXMLReader(source);
                inputSource = SAXSource.sourceToInputSource(source);
                object = inputSource.getSystemId();
                if (null != object) {
                    try {
                        object = SystemIDResolver.getAbsoluteURI((String)object);
                    }
                    catch (Exception exception) {
                        System.err.println("Can not absolutize URL: " + (String)object);
                    }
                    inputSource.setSystemId((String)object);
                }
            }
            object = source == null && bl && !bl2 && !bl3 ? new SAX2RTFDTM(this, source, n2, dTMWSFilter, xMLStringFactory, bl3) : new SAX2DTM(this, source, n2, dTMWSFilter, xMLStringFactory, bl3);
            this.addDTM((DTM)object, n, 0);
            boolean bl8 = bl7 = null != xMLReader && xMLReader.getClass().getName().equals("org.apache.xerces.parsers.SAXParser");
            if (bl7) {
                bl2 = true;
            }
            if (DTMManager.m_incremental && bl2) {
                IncrementalSAXSource incrementalSAXSource = null;
                if (bl7) {
                    try {
                        incrementalSAXSource = IncrementalSAXSource_Xerces.createIncrementalSAXSource();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        incrementalSAXSource = null;
                    }
                }
                if (incrementalSAXSource == null) {
                    if (null == xMLReader) {
                        incrementalSAXSource = new IncrementalSAXSource_Filter();
                    } else {
                        IncrementalSAXSource_Filter incrementalSAXSource_Filter = new IncrementalSAXSource_Filter();
                        incrementalSAXSource_Filter.setXMLReader(xMLReader);
                        incrementalSAXSource = incrementalSAXSource_Filter;
                    }
                }
                ((SAX2DTM)object).setIncrementalSAXSource(incrementalSAXSource);
                if (null == inputSource) {
                    return object;
                }
                if (null == xMLReader.getErrorHandler()) {
                    xMLReader.setErrorHandler((ErrorHandler)object);
                }
                xMLReader.setDTDHandler((DTDHandler)object);
                try {
                    incrementalSAXSource.startParse(inputSource);
                }
                catch (RuntimeException runtimeException) {
                    ((SAX2DTM)object).clearCoRoutine();
                    throw runtimeException;
                }
                catch (Exception exception) {
                    ((SAX2DTM)object).clearCoRoutine();
                    throw new WrappedRuntimeException(exception);
                }
            }
            if (null == xMLReader) {
                return object;
            }
            xMLReader.setContentHandler((ContentHandler)object);
            xMLReader.setDTDHandler((DTDHandler)object);
            if (null == xMLReader.getErrorHandler()) {
                xMLReader.setErrorHandler((ErrorHandler)object);
            }
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", object);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
            try {
                xMLReader.parse(inputSource);
            }
            catch (RuntimeException runtimeException) {
                ((SAX2DTM)object).clearCoRoutine();
                throw runtimeException;
            }
            catch (Exception exception) {
                ((SAX2DTM)object).clearCoRoutine();
                throw new WrappedRuntimeException(exception);
            }
            return object;
        }
        throw new DTMException(XMLMessages.createXMLMessage("ER_NOT_SUPPORTED", new Object[]{source}));
    }

    public synchronized int getDTMHandleFromNode(Node node) {
        int n;
        Object object;
        if (null == node) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_NODE_NON_NULL", null));
        }
        if (node instanceof DTMNodeProxy) {
            return ((DTMNodeProxy)node).getDTMNodeNumber();
        }
        int n2 = this.m_dtms.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            object = this.m_dtms[n3];
            if (null != object && object instanceof DOM2DTM && (n4 = ((DOM2DTM)object).getHandleOfNode(node)) != -1) {
                return n4;
            }
            ++n3;
        }
        object = node;
        Node node2 = object.getNodeType() == 2 ? ((Attr)object).getOwnerElement() : object.getParentNode();
        while (node2 != null) {
            object = node2;
            node2 = node2.getParentNode();
        }
        DOM2DTM dOM2DTM = (DOM2DTM)this.getDTM(new DOMSource((Node)object), false, null, true, true);
        if (node instanceof DOM2DTMdefaultNamespaceDeclarationNode) {
            n = dOM2DTM.getHandleOfNode(((Attr)node).getOwnerElement());
            n = dOM2DTM.getAttributeNode(n, node.getNamespaceURI(), node.getLocalName());
        } else {
            n = dOM2DTM.getHandleOfNode(node);
        }
        if (-1 == n) {
            throw new RuntimeException(XMLMessages.createXMLMessage("ER_COULD_NOT_RESOLVE_NODE", null));
        }
        return n;
    }

    public synchronized XMLReader getXMLReader(Source source) {
        try {
            XMLReader xMLReader;
            XMLReader xMLReader2 = xMLReader = source instanceof SAXSource ? ((SAXSource)source).getXMLReader() : null;
            if (null == xMLReader) {
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    xMLReader = sAXParser.getXMLReader();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    throw new SAXException(factoryConfigurationError.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
                if (null == xMLReader) {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
            }
            try {
                xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            return xMLReader;
        }
        catch (SAXException sAXException) {
            throw new DTMException(sAXException.getMessage(), sAXException);
        }
    }

    public synchronized DTM getDTM(int n) {
        try {
            return this.m_dtms[n >>> 16];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n == -1) {
                return null;
            }
            throw arrayIndexOutOfBoundsException;
        }
    }

    public synchronized int getDTMIdentity(DTM dTM) {
        if (dTM instanceof DTMDefaultBase) {
            DTMDefaultBase dTMDefaultBase = (DTMDefaultBase)dTM;
            if (dTMDefaultBase.getManager() == this) {
                return dTMDefaultBase.getDTMIDs().elementAt(0);
            }
            return -1;
        }
        int n = this.m_dtms.length;
        int n2 = 0;
        while (n2 < n) {
            DTM dTM2 = this.m_dtms[n2];
            if (dTM2 == dTM && this.m_dtm_offsets[n2] == 0) {
                return n2 << 16;
            }
            ++n2;
        }
        return -1;
    }

    public synchronized boolean release(DTM dTM, boolean bl) {
        if (dTM instanceof SAX2DTM) {
            ((SAX2DTM)dTM).clearCoRoutine();
        }
        if (dTM instanceof DTMDefaultBase) {
            SuballocatedIntVector suballocatedIntVector = ((DTMDefaultBase)dTM).getDTMIDs();
            int n = suballocatedIntVector.size() - 1;
            while (n >= 0) {
                this.m_dtms[suballocatedIntVector.elementAt((int)n) >>> 16] = null;
                --n;
            }
        } else {
            int n = this.getDTMIdentity(dTM);
            if (n >= 0) {
                this.m_dtms[n >>> 16] = null;
            }
        }
        dTM.documentRelease();
        return true;
    }

    public synchronized DTM createDocumentFragment() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            DocumentFragment documentFragment = document.createDocumentFragment();
            return this.getDTM(new DOMSource(documentFragment), true, null, false, false);
        }
        catch (Exception exception) {
            throw new DTMException(exception);
        }
    }

    public synchronized DTMIterator createDTMIterator(int n, DTMFilter dTMFilter, boolean bl) {
        return null;
    }

    public synchronized DTMIterator createDTMIterator(String string, PrefixResolver prefixResolver) {
        return null;
    }

    public synchronized DTMIterator createDTMIterator(int n) {
        return null;
    }

    public synchronized DTMIterator createDTMIterator(Object object, int n) {
        return null;
    }

    public ExpandedNameTable getExpandedNameTable(DTM dTM) {
        return this.m_expandedNameTable;
    }
}

