/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMManagerDefault;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.SuballocatedIntVector;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class DTMDefaultBase
implements DTM {
    static boolean JJK_DEBUG = false;
    public static final int ROOTNODE = 0;
    protected int m_size = 0;
    protected SuballocatedIntVector m_exptype;
    protected SuballocatedIntVector m_firstch;
    protected SuballocatedIntVector m_nextsib;
    protected SuballocatedIntVector m_prevsib;
    protected SuballocatedIntVector m_parent;
    protected Vector m_namespaceDeclSets = null;
    protected SuballocatedIntVector m_namespaceDeclSetElements = null;
    protected int[][][] m_elemIndexes;
    public static final int DEFAULT_BLOCKSIZE = 512;
    public static final int DEFAULT_NUMBLOCKS = 32;
    public static final int DEFAULT_NUMBLOCKS_SMALL = 4;
    protected static final int NOTPROCESSED = -2;
    public DTMManager m_mgr;
    protected DTMManagerDefault m_mgrDefault = null;
    protected SuballocatedIntVector m_dtmIdent;
    protected String m_documentBaseURI;
    protected DTMWSFilter m_wsfilter;
    protected boolean m_shouldStripWS = false;
    protected BoolStack m_shouldStripWhitespaceStack;
    protected XMLStringFactory m_xstrf;
    protected ExpandedNameTable m_expandedNameTable;
    protected boolean m_indexing;
    protected DTMAxisTraverser[] m_traversers;
    private Vector m_namespaceLists = null;

    public DTMDefaultBase(DTMManager dTMManager, Source source, int n, DTMWSFilter dTMWSFilter, XMLStringFactory xMLStringFactory, boolean bl) {
        this(dTMManager, source, n, dTMWSFilter, xMLStringFactory, bl, 512, true);
    }

    public DTMDefaultBase(DTMManager dTMManager, Source source, int n, DTMWSFilter dTMWSFilter, XMLStringFactory xMLStringFactory, boolean bl, int n2, boolean bl2) {
        int n3;
        if (n2 <= 64) {
            n3 = 4;
            this.m_dtmIdent = new SuballocatedIntVector(4, 1);
        } else {
            n3 = 32;
            this.m_dtmIdent = new SuballocatedIntVector(32);
        }
        this.m_exptype = new SuballocatedIntVector(n2, n3);
        this.m_firstch = new SuballocatedIntVector(n2, n3);
        this.m_nextsib = new SuballocatedIntVector(n2, n3);
        this.m_parent = new SuballocatedIntVector(n2, n3);
        if (bl2) {
            this.m_prevsib = new SuballocatedIntVector(n2, n3);
        }
        this.m_mgr = dTMManager;
        if (dTMManager instanceof DTMManagerDefault) {
            this.m_mgrDefault = (DTMManagerDefault)dTMManager;
        }
        this.m_documentBaseURI = null != source ? source.getSystemId() : null;
        this.m_dtmIdent.setElementAt(n, 0);
        this.m_wsfilter = dTMWSFilter;
        this.m_xstrf = xMLStringFactory;
        this.m_indexing = bl;
        this.m_expandedNameTable = bl ? new ExpandedNameTable() : this.m_mgrDefault.getExpandedNameTable(this);
        if (null != dTMWSFilter) {
            this.m_shouldStripWhitespaceStack = new BoolStack();
            this.pushShouldStripWhitespace(false);
        }
    }

    protected void ensureSizeOfIndex(int n, int n2) {
        Object object;
        Object object2;
        if (null == this.m_elemIndexes) {
            this.m_elemIndexes = new int[n + 20][][];
        } else if (this.m_elemIndexes.length <= n) {
            object2 = this.m_elemIndexes;
            this.m_elemIndexes = new int[n + 20][][];
            System.arraycopy(object2, 0, this.m_elemIndexes, 0, ((int[][][])object2).length);
        }
        object2 = this.m_elemIndexes[n];
        if (null == object2) {
            object2 = new int[n2 + 100][];
            this.m_elemIndexes[n] = (int[][])object2;
        } else if (((int[][][])object2).length <= n2) {
            object = object2;
            object2 = new int[n2 + 100][];
            System.arraycopy(object, 0, object2, 0, ((int[][][])object).length);
            this.m_elemIndexes[n] = (int[][])object2;
        }
        object = object2[n2];
        if (null == object) {
            object = new int[128];
            object2[n2] = (int[][])object;
            object[0] = (int[][])true;
        } else if (((int[][][])object).length <= object[0] + true) {
            Object object3 = object;
            object = new int[object[0] + 1024];
            System.arraycopy(object3, 0, object, 0, ((int[][][])object3).length);
            object2[n2] = (int[][])object;
        }
    }

    protected void indexNode(int n, int n2) {
        ExpandedNameTable expandedNameTable = this.m_expandedNameTable;
        short s = expandedNameTable.getType(n);
        if (1 == s) {
            int n3 = expandedNameTable.getNamespaceID(n);
            int n4 = expandedNameTable.getLocalNameID(n);
            this.ensureSizeOfIndex(n3, n4);
            int[] nArray = this.m_elemIndexes[n3][n4];
            nArray[nArray[0]] = n2;
            nArray[0] = nArray[0] + 1;
        }
    }

    protected int findGTE(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = n;
        int n6 = n4 = n + (n2 - 1);
        while (n5 <= n4) {
            int n7 = (n5 + n4) / 2;
            int n8 = nArray[n7];
            if (n8 > n3) {
                n4 = n7 - 1;
                continue;
            }
            if (n8 < n3) {
                n5 = n7 + 1;
                continue;
            }
            return n7;
        }
        return n5 <= n6 && nArray[n5] > n3 ? n5 : -1;
    }

    int findElementFromIndex(int n, int n2, int n3) {
        int n4;
        int[] nArray;
        int[][] nArray2;
        int[][][] nArray3 = this.m_elemIndexes;
        if (null != nArray3 && n < nArray3.length && null != (nArray2 = nArray3[n]) && n2 < nArray2.length && null != (nArray = nArray2[n2]) && (n4 = this.findGTE(nArray, 1, nArray[0], n3)) > -1) {
            return nArray[n4];
        }
        return -2;
    }

    protected abstract int getNextNodeIdentity(int var1);

    protected abstract boolean nextNode();

    protected abstract int getNumberOfNodes();

    protected short _type(int n) {
        int n2 = this._exptype(n);
        if (-1 != n2) {
            return this.m_expandedNameTable.getType(n2);
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    protected int _exptype(int var1_1) {
        if (var1_1 != -1) ** GOTO lbl5
        return -1;
lbl-1000:
        // 1 sources

        {
            if (this.nextNode() || var1_1 < this.m_size) continue;
            return -1;
lbl5:
            // 2 sources

            ** while (var1_1 >= this.m_size)
        }
lbl6:
        // 1 sources

        return this.m_exptype.elementAt(var1_1);
    }

    protected int _level(int n) {
        int n2;
        while (n >= this.m_size) {
            n2 = this.nextNode();
            if (n2 != 0 || n < this.m_size) continue;
            return -1;
        }
        n2 = 0;
        while (-1 != (n = this._parent(n))) {
            ++n2;
        }
        return n2;
    }

    protected int _firstch(int n) {
        int n2 = n >= this.m_size ? -2 : this.m_firstch.elementAt(n);
        while (n2 == -2) {
            boolean bl = this.nextNode();
            if (n >= this.m_size && !bl) {
                return -1;
            }
            n2 = this.m_firstch.elementAt(n);
            if (n2 != -2 || bl) continue;
            return -1;
        }
        return n2;
    }

    protected int _nextsib(int n) {
        int n2 = n >= this.m_size ? -2 : this.m_nextsib.elementAt(n);
        while (n2 == -2) {
            boolean bl = this.nextNode();
            if (n >= this.m_size && !bl) {
                return -1;
            }
            n2 = this.m_nextsib.elementAt(n);
            if (n2 != -2 || bl) continue;
            return -1;
        }
        return n2;
    }

    protected int _prevsib(int n) {
        if (n < this.m_size) {
            return this.m_prevsib.elementAt(n);
        }
        do {
            boolean bl = this.nextNode();
            if (n < this.m_size || bl) continue;
            return -1;
        } while (n >= this.m_size);
        return this.m_prevsib.elementAt(n);
    }

    protected int _parent(int n) {
        if (n < this.m_size) {
            return this.m_parent.elementAt(n);
        }
        do {
            boolean bl = this.nextNode();
            if (n < this.m_size || bl) continue;
            return -1;
        } while (n >= this.m_size);
        return this.m_parent.elementAt(n);
    }

    public void dumpDTM(OutputStream outputStream) {
        try {
            Object object;
            if (outputStream == null) {
                object = new File("DTMDump" + this.hashCode() + ".txt");
                System.err.println("Dumping... " + ((File)object).getAbsolutePath());
                outputStream = new FileOutputStream((File)object);
            }
            object = new PrintStream(outputStream);
            while (this.nextNode()) {
            }
            int n = this.m_size;
            ((PrintStream)object).println("Total nodes: " + n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                String string;
                int n4 = this.makeNodeHandle(n2);
                ((PrintStream)object).println("=========== index=" + n2 + " handle=" + n4 + " ===========");
                ((PrintStream)object).println("NodeName: " + this.getNodeName(n4));
                ((PrintStream)object).println("NodeNameX: " + this.getNodeNameX(n4));
                ((PrintStream)object).println("LocalName: " + this.getLocalName(n4));
                ((PrintStream)object).println("NamespaceURI: " + this.getNamespaceURI(n4));
                ((PrintStream)object).println("Prefix: " + this.getPrefix(n4));
                int n5 = this._exptype(n2);
                ((PrintStream)object).println("Expanded Type ID: " + Integer.toHexString(n5));
                short s = this._type(n2);
                switch (s) {
                    case 2: {
                        string = "ATTRIBUTE_NODE";
                        break;
                    }
                    case 4: {
                        string = "CDATA_SECTION_NODE";
                        break;
                    }
                    case 8: {
                        string = "COMMENT_NODE";
                        break;
                    }
                    case 11: {
                        string = "DOCUMENT_FRAGMENT_NODE";
                        break;
                    }
                    case 9: {
                        string = "DOCUMENT_NODE";
                        break;
                    }
                    case 10: {
                        string = "DOCUMENT_NODE";
                        break;
                    }
                    case 1: {
                        string = "ELEMENT_NODE";
                        break;
                    }
                    case 6: {
                        string = "ENTITY_NODE";
                        break;
                    }
                    case 5: {
                        string = "ENTITY_REFERENCE_NODE";
                        break;
                    }
                    case 13: {
                        string = "NAMESPACE_NODE";
                        break;
                    }
                    case 12: {
                        string = "NOTATION_NODE";
                        break;
                    }
                    case -1: {
                        string = "NULL";
                        break;
                    }
                    case 7: {
                        string = "PROCESSING_INSTRUCTION_NODE";
                        break;
                    }
                    case 3: {
                        string = "TEXT_NODE";
                        break;
                    }
                    default: {
                        string = "Unknown!";
                    }
                }
                ((PrintStream)object).println("Type: " + string);
                int n6 = this._firstch(n2);
                if (-1 == n6) {
                    ((PrintStream)object).println("First child: DTM.NULL");
                } else if (-2 == n6) {
                    ((PrintStream)object).println("First child: NOTPROCESSED");
                } else {
                    ((PrintStream)object).println("First child: " + n6);
                }
                if (this.m_prevsib != null) {
                    n3 = this._prevsib(n2);
                    if (-1 == n3) {
                        ((PrintStream)object).println("Prev sibling: DTM.NULL");
                    } else if (-2 == n3) {
                        ((PrintStream)object).println("Prev sibling: NOTPROCESSED");
                    } else {
                        ((PrintStream)object).println("Prev sibling: " + n3);
                    }
                }
                if (-1 == (n3 = this._nextsib(n2))) {
                    ((PrintStream)object).println("Next sibling: DTM.NULL");
                } else if (-2 == n3) {
                    ((PrintStream)object).println("Next sibling: NOTPROCESSED");
                } else {
                    ((PrintStream)object).println("Next sibling: " + n3);
                }
                int n7 = this._parent(n2);
                if (-1 == n7) {
                    ((PrintStream)object).println("Parent: DTM.NULL");
                } else if (-2 == n7) {
                    ((PrintStream)object).println("Parent: NOTPROCESSED");
                } else {
                    ((PrintStream)object).println("Parent: " + n7);
                }
                int n8 = this._level(n2);
                ((PrintStream)object).println("Level: " + n8);
                ((PrintStream)object).println("Node Value: " + this.getNodeValue(n4));
                ((PrintStream)object).println("String Value: " + this.getStringValue(n4));
                ++n2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public String dumpNode(int n) {
        String string;
        if (n == -1) {
            return "[null]";
        }
        switch (this.getNodeType(n)) {
            case 2: {
                string = "ATTR";
                break;
            }
            case 4: {
                string = "CDATA";
                break;
            }
            case 8: {
                string = "COMMENT";
                break;
            }
            case 11: {
                string = "DOC_FRAG";
                break;
            }
            case 9: {
                string = "DOC";
                break;
            }
            case 10: {
                string = "DOC_TYPE";
                break;
            }
            case 1: {
                string = "ELEMENT";
                break;
            }
            case 6: {
                string = "ENTITY";
                break;
            }
            case 5: {
                string = "ENT_REF";
                break;
            }
            case 13: {
                string = "NAMESPACE";
                break;
            }
            case 12: {
                string = "NOTATION";
                break;
            }
            case -1: {
                string = "null";
                break;
            }
            case 7: {
                string = "PI";
                break;
            }
            case 3: {
                string = "TEXT";
                break;
            }
            default: {
                string = "Unknown!";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[" + n + ": " + string + "(0x" + Integer.toHexString(this.getExpandedTypeID(n)) + ") " + this.getNodeNameX(n) + " {" + this.getNamespaceURI(n) + "}" + "=\"" + this.getNodeValue(n) + "\"]");
        return stringBuffer.toString();
    }

    public void setFeature(String string, boolean bl) {
    }

    public boolean hasChildNodes(int n) {
        int n2 = this.makeNodeIdentity(n);
        int n3 = this._firstch(n2);
        return n3 != -1;
    }

    public final int makeNodeHandle(int n) {
        if (-1 == n) {
            return -1;
        }
        if (JJK_DEBUG && n > 65535) {
            System.err.println("GONK! (only useful in limited situations)");
        }
        return this.m_dtmIdent.elementAt(n >>> 16) + (n & 0xFFFF);
    }

    public final int makeNodeIdentity(int n) {
        if (-1 == n) {
            return -1;
        }
        if (this.m_mgrDefault != null) {
            int n2 = n >>> 16;
            if (this.m_mgrDefault.m_dtms[n2] != this) {
                return -1;
            }
            return this.m_mgrDefault.m_dtm_offsets[n2] | n & 0xFFFF;
        }
        int n3 = this.m_dtmIdent.indexOf(n & 0xFFFF0000);
        return n3 == -1 ? -1 : (n3 << 16) + (n & 0xFFFF);
    }

    public int getFirstChild(int n) {
        int n2 = this.makeNodeIdentity(n);
        int n3 = this._firstch(n2);
        return this.makeNodeHandle(n3);
    }

    public int getTypedFirstChild(int n, int n2) {
        if (n2 < 14) {
            int n3 = this._firstch(this.makeNodeIdentity(n));
            while (n3 != -1) {
                int n4 = this._exptype(n3);
                if (n4 == n2 || n4 >= 14 && this.m_expandedNameTable.getType(n4) == n2) {
                    return this.makeNodeHandle(n3);
                }
                n3 = this._nextsib(n3);
            }
        } else {
            int n5 = this._firstch(this.makeNodeIdentity(n));
            while (n5 != -1) {
                if (this._exptype(n5) == n2) {
                    return this.makeNodeHandle(n5);
                }
                n5 = this._nextsib(n5);
            }
        }
        return -1;
    }

    public int getLastChild(int n) {
        int n2 = this.makeNodeIdentity(n);
        int n3 = this._firstch(n2);
        int n4 = -1;
        while (n3 != -1) {
            n4 = n3;
            n3 = this._nextsib(n3);
        }
        return this.makeNodeHandle(n4);
    }

    public abstract int getAttributeNode(int var1, String var2, String var3);

    public int getFirstAttribute(int n) {
        int n2 = this.makeNodeIdentity(n);
        return this.makeNodeHandle(this.getFirstAttributeIdentity(n2));
    }

    protected int getFirstAttributeIdentity(int n) {
        short s = this._type(n);
        if (1 == s) {
            while (-1 != (n = this.getNextNodeIdentity(n))) {
                s = this._type(n);
                if (s == 2) {
                    return n;
                }
                if (13 != s) break;
            }
        }
        return -1;
    }

    protected int getTypedAttribute(int n, int n2) {
        short s = this.getNodeType(n);
        if (1 == s) {
            int n3 = this.makeNodeIdentity(n);
            while (-1 != (n3 = this.getNextNodeIdentity(n3))) {
                s = this._type(n3);
                if (s == 2) {
                    if (this._exptype(n3) != n2) continue;
                    return this.makeNodeHandle(n3);
                }
                if (13 != s) break;
            }
        }
        return -1;
    }

    public int getNextSibling(int n) {
        if (n == -1) {
            return -1;
        }
        return this.makeNodeHandle(this._nextsib(this.makeNodeIdentity(n)));
    }

    public int getTypedNextSibling(int n, int n2) {
        int n3;
        if (n == -1) {
            return -1;
        }
        int n4 = this.makeNodeIdentity(n);
        while ((n4 = this._nextsib(n4)) != -1 && (n3 = this._exptype(n4)) != n2 && this.m_expandedNameTable.getType(n3) != n2) {
        }
        return n4 == -1 ? -1 : this.makeNodeHandle(n4);
    }

    public int getPreviousSibling(int n) {
        if (n == -1) {
            return -1;
        }
        if (this.m_prevsib != null) {
            return this.makeNodeHandle(this._prevsib(this.makeNodeIdentity(n)));
        }
        int n2 = this.makeNodeIdentity(n);
        int n3 = this._parent(n2);
        int n4 = this._firstch(n3);
        int n5 = -1;
        while (n4 != n2) {
            n5 = n4;
            n4 = this._nextsib(n4);
        }
        return this.makeNodeHandle(n5);
    }

    public int getNextAttribute(int n) {
        int n2 = this.makeNodeIdentity(n);
        if (this._type(n2) == 2) {
            return this.makeNodeHandle(this.getNextAttributeIdentity(n2));
        }
        return -1;
    }

    protected int getNextAttributeIdentity(int n) {
        while (-1 != (n = this.getNextNodeIdentity(n))) {
            short s = this._type(n);
            if (s == 2) {
                return n;
            }
            if (s != 13) break;
        }
        return -1;
    }

    protected void declareNamespaceInContext(int n, int n2) {
        int n3;
        int n4;
        SuballocatedIntVector suballocatedIntVector = null;
        if (this.m_namespaceDeclSets == null) {
            this.m_namespaceDeclSetElements = new SuballocatedIntVector(32);
            this.m_namespaceDeclSetElements.addElement(n);
            this.m_namespaceDeclSets = new Vector();
            suballocatedIntVector = new SuballocatedIntVector(32);
            this.m_namespaceDeclSets.addElement(suballocatedIntVector);
        } else {
            n4 = this.m_namespaceDeclSetElements.size() - 1;
            if (n4 >= 0 && n == this.m_namespaceDeclSetElements.elementAt(n4)) {
                suballocatedIntVector = (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(n4);
            }
        }
        if (suballocatedIntVector == null) {
            this.m_namespaceDeclSetElements.addElement(n);
            SuballocatedIntVector suballocatedIntVector2 = this.findNamespaceContext(this._parent(n));
            if (suballocatedIntVector2 != null) {
                n3 = suballocatedIntVector2.size();
                suballocatedIntVector = new SuballocatedIntVector(Math.max(Math.min(n3 + 16, 2048), 32));
                int n5 = 0;
                while (n5 < n3) {
                    suballocatedIntVector.addElement(suballocatedIntVector2.elementAt(n5));
                    ++n5;
                }
            } else {
                suballocatedIntVector = new SuballocatedIntVector(32);
            }
            this.m_namespaceDeclSets.addElement(suballocatedIntVector);
        }
        n4 = this._exptype(n2);
        n3 = suballocatedIntVector.size() - 1;
        while (n3 >= 0) {
            if (n4 == this.getExpandedTypeID(suballocatedIntVector.elementAt(n3))) {
                suballocatedIntVector.setElementAt(this.makeNodeHandle(n2), n3);
                return;
            }
            --n3;
        }
        suballocatedIntVector.addElement(this.makeNodeHandle(n2));
    }

    /*
     * Unable to fully structure code
     */
    protected SuballocatedIntVector findNamespaceContext(int var1_1) {
        block6: {
            if (null == this.m_namespaceDeclSetElements) break block6;
            var2_2 = this.findInSortedSuballocatedIntVector(this.m_namespaceDeclSetElements, var1_1);
            if (var2_2 >= 0) {
                return (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(var2_2);
            }
            if (var2_2 == -1) {
                return null;
            }
            var2_2 = -1 - var2_2;
            var3_3 = this.m_namespaceDeclSetElements.elementAt(--var2_2);
            var4_4 = this._parent(var1_1);
            if (var2_2 != 0 || var3_3 >= var4_4) ** GOTO lbl24
            var5_5 = this.getDocumentRoot(this.makeNodeHandle(var1_1));
            var6_6 = this.makeNodeIdentity(var5_5);
            var7_8 = this.getNodeType(var5_5) == 9 ? ((var8_7 = this._firstch(var6_6)) != -1 ? var8_7 : var6_6) : var6_6;
            if (var3_3 != var7_8) ** GOTO lbl24
            return (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(var2_2);
lbl-1000:
            // 1 sources

            {
                if (var3_3 == var4_4) {
                    return (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(var2_2);
                }
                if (var3_3 < var4_4) {
                    while (var3_3 < (var4_4 = this._parent(var4_4))) {
                    }
                    continue;
                }
                if (var2_2 <= 0) break;
                var3_3 = this.m_namespaceDeclSetElements.elementAt(--var2_2);
lbl24:
                // 4 sources

                ** while (var2_2 >= 0 && var4_4 > 0)
            }
        }
        return null;
    }

    protected int findInSortedSuballocatedIntVector(SuballocatedIntVector suballocatedIntVector, int n) {
        int n2 = 0;
        if (suballocatedIntVector != null) {
            int n3 = 0;
            int n4 = suballocatedIntVector.size() - 1;
            while (n3 <= n4) {
                n2 = (n3 + n4) / 2;
                int n5 = n - suballocatedIntVector.elementAt(n2);
                if (n5 == 0) {
                    return n2;
                }
                if (n5 < 0) {
                    n4 = n2 - 1;
                    continue;
                }
                n3 = n2 + 1;
            }
            if (n3 > n2) {
                n2 = n3;
            }
        }
        return -1 - n2;
    }

    public int getFirstNamespaceNode(int n, boolean bl) {
        if (bl) {
            int n2 = this.makeNodeIdentity(n);
            if (this._type(n2) == 1) {
                SuballocatedIntVector suballocatedIntVector = this.findNamespaceContext(n2);
                if (suballocatedIntVector == null || suballocatedIntVector.size() < 1) {
                    return -1;
                }
                return suballocatedIntVector.elementAt(0);
            }
            return -1;
        }
        int n3 = this.makeNodeIdentity(n);
        if (this._type(n3) == 1) {
            while (-1 != (n3 = this.getNextNodeIdentity(n3))) {
                short s = this._type(n3);
                if (s == 13) {
                    return this.makeNodeHandle(n3);
                }
                if (2 != s) break;
            }
            return -1;
        }
        return -1;
    }

    public int getNextNamespaceNode(int n, int n2, boolean bl) {
        if (bl) {
            SuballocatedIntVector suballocatedIntVector = this.findNamespaceContext(this.makeNodeIdentity(n));
            if (suballocatedIntVector == null) {
                return -1;
            }
            int n3 = 1 + suballocatedIntVector.indexOf(n2);
            if (n3 <= 0 || n3 == suballocatedIntVector.size()) {
                return -1;
            }
            return suballocatedIntVector.elementAt(n3);
        }
        int n4 = this.makeNodeIdentity(n2);
        while (-1 != (n4 = this.getNextNodeIdentity(n4))) {
            short s = this._type(n4);
            if (s == 13) {
                return this.makeNodeHandle(n4);
            }
            if (s != 2) break;
        }
        return -1;
    }

    public int getParent(int n) {
        int n2 = this.makeNodeIdentity(n);
        if (n2 > 0) {
            return this.makeNodeHandle(this._parent(n2));
        }
        return -1;
    }

    public int getDocument() {
        return this.m_dtmIdent.elementAt(0);
    }

    public int getOwnerDocument(int n) {
        if (9 == this.getNodeType(n)) {
            return -1;
        }
        return this.getDocumentRoot(n);
    }

    public int getDocumentRoot(int n) {
        return this.getDocument();
    }

    public abstract XMLString getStringValue(int var1);

    public int getStringValueChunkCount(int n) {
        this.error(XMLMessages.createXMLMessage("ER_METHOD_NOT_SUPPORTED", null));
        return 0;
    }

    public char[] getStringValueChunk(int n, int n2, int[] nArray) {
        this.error(XMLMessages.createXMLMessage("ER_METHOD_NOT_SUPPORTED", null));
        return null;
    }

    public int getExpandedTypeID(int n) {
        int n2 = this.makeNodeIdentity(n);
        if (n2 == -1) {
            return -1;
        }
        return this._exptype(n2);
    }

    public int getExpandedTypeID(String string, String string2, int n) {
        ExpandedNameTable expandedNameTable = this.m_expandedNameTable;
        return expandedNameTable.getExpandedTypeID(string, string2, n);
    }

    public String getLocalNameFromExpandedNameID(int n) {
        return this.m_expandedNameTable.getLocalName(n);
    }

    public String getNamespaceFromExpandedNameID(int n) {
        return this.m_expandedNameTable.getNamespace(n);
    }

    public int getNamespaceType(int n) {
        int n2 = this.makeNodeIdentity(n);
        int n3 = this._exptype(n2);
        return this.m_expandedNameTable.getNamespaceID(n3);
    }

    public abstract String getNodeName(int var1);

    public String getNodeNameX(int n) {
        this.error(XMLMessages.createXMLMessage("ER_METHOD_NOT_SUPPORTED", null));
        return null;
    }

    public abstract String getLocalName(int var1);

    public abstract String getPrefix(int var1);

    public abstract String getNamespaceURI(int var1);

    public abstract String getNodeValue(int var1);

    public short getNodeType(int n) {
        if (n == -1) {
            return -1;
        }
        return this.m_expandedNameTable.getType(this._exptype(this.makeNodeIdentity(n)));
    }

    public short getLevel(int n) {
        int n2 = this.makeNodeIdentity(n);
        return (short)(this._level(n2) + 1);
    }

    public int getNodeIdent(int n) {
        return this.makeNodeIdentity(n);
    }

    public int getNodeHandle(int n) {
        return this.makeNodeHandle(n);
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public String getDocumentBaseURI() {
        return this.m_documentBaseURI;
    }

    public void setDocumentBaseURI(String string) {
        this.m_documentBaseURI = string;
    }

    public String getDocumentSystemIdentifier(int n) {
        return this.m_documentBaseURI;
    }

    public String getDocumentEncoding(int n) {
        return "UTF-8";
    }

    public String getDocumentStandalone(int n) {
        return null;
    }

    public String getDocumentVersion(int n) {
        return null;
    }

    public boolean getDocumentAllDeclarationsProcessed() {
        return true;
    }

    public abstract String getDocumentTypeDeclarationSystemIdentifier();

    public abstract String getDocumentTypeDeclarationPublicIdentifier();

    public abstract int getElementById(String var1);

    public abstract String getUnparsedEntityURI(String var1);

    public boolean supportsPreStripping() {
        return true;
    }

    public boolean isNodeAfter(int n, int n2) {
        int n3 = this.makeNodeIdentity(n);
        int n4 = this.makeNodeIdentity(n2);
        return n3 != -1 & n4 != -1 & n3 <= n4;
    }

    public boolean isCharacterElementContentWhitespace(int n) {
        return false;
    }

    public boolean isDocumentAllDeclarationsProcessed(int n) {
        return true;
    }

    public abstract boolean isAttributeSpecified(int var1);

    public abstract void dispatchCharactersEvents(int var1, ContentHandler var2, boolean var3) throws SAXException;

    public abstract void dispatchToEvents(int var1, ContentHandler var2) throws SAXException;

    public Node getNode(int n) {
        return new DTMNodeProxy(this, n);
    }

    public void appendChild(int n, boolean bl, boolean bl2) {
        this.error(XMLMessages.createXMLMessage("ER_METHOD_NOT_SUPPORTED", null));
    }

    public void appendTextChild(String string) {
        this.error(XMLMessages.createXMLMessage("ER_METHOD_NOT_SUPPORTED", null));
    }

    protected void error(String string) {
        throw new DTMException(string);
    }

    protected boolean getShouldStripWhitespace() {
        return this.m_shouldStripWS;
    }

    protected void pushShouldStripWhitespace(boolean bl) {
        this.m_shouldStripWS = bl;
        if (null != this.m_shouldStripWhitespaceStack) {
            this.m_shouldStripWhitespaceStack.push(bl);
        }
    }

    protected void popShouldStripWhitespace() {
        if (null != this.m_shouldStripWhitespaceStack) {
            this.m_shouldStripWS = this.m_shouldStripWhitespaceStack.popAndTop();
        }
    }

    protected void setShouldStripWhitespace(boolean bl) {
        this.m_shouldStripWS = bl;
        if (null != this.m_shouldStripWhitespaceStack) {
            this.m_shouldStripWhitespaceStack.setTop(bl);
        }
    }

    public void documentRegistration() {
    }

    public void documentRelease() {
    }

    public DTMManager getManager() {
        return this.m_mgr;
    }

    public SuballocatedIntVector getDTMIDs() {
        if (this.m_mgr == null) {
            return null;
        }
        return this.m_dtmIdent;
    }

    public abstract SourceLocator getSourceLocatorFor(int var1);

    public abstract DeclHandler getDeclHandler();

    public abstract ErrorHandler getErrorHandler();

    public abstract DTDHandler getDTDHandler();

    public abstract EntityResolver getEntityResolver();

    public abstract LexicalHandler getLexicalHandler();

    public abstract ContentHandler getContentHandler();

    public abstract boolean needsTwoThreads();

    public abstract DTMAxisIterator getTypedAxisIterator(int var1, int var2);

    public abstract DTMAxisIterator getAxisIterator(int var1);

    public abstract DTMAxisTraverser getAxisTraverser(int var1);

    public abstract void setProperty(String var1, Object var2);
}

