/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.dom.DOMBuilder;
import org.apache.xalan.xsltc.dom.SAXImpl;
import org.apache.xalan.xsltc.dom.XSLTCDTMManager;
import org.apache.xml.dtm.DTM;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XSLTCSource
implements Source {
    private String _systemId = null;
    private DOM _dom = null;
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";

    public XSLTCSource(int n) {
        XSLTCDTMManager xSLTCDTMManager = XSLTCDTMManager.newInstance();
        int n2 = xSLTCDTMManager.getFirstFreeDTMID();
        int n3 = n2 << 16;
        this._dom = new SAXImpl(xSLTCDTMManager, (Source)this, n3, null, null, false, n, true);
        xSLTCDTMManager.addDTM((DTM)((Object)this._dom), n2);
    }

    public XSLTCSource() {
        XSLTCDTMManager xSLTCDTMManager = XSLTCDTMManager.newInstance();
        int n = xSLTCDTMManager.getFirstFreeDTMID();
        int n2 = n << 16;
        this._dom = new SAXImpl(xSLTCDTMManager, this, n2, null, null, false, true);
        xSLTCDTMManager.addDTM((DTM)((Object)this._dom), n);
    }

    public void setSystemId(String string) {
        this._systemId = new File(string).exists() ? "file:" + string : string;
        ((SAXImpl)this._dom).setDocumentURI(this._systemId);
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void build(XMLReader xMLReader, String string) throws SAXException {
        try {
            if (string == null && this._systemId == null) {
                ErrorMsg errorMsg = new ErrorMsg("XSLTC_SOURCE_ERR");
                throw new SAXException(errorMsg.toString());
            }
            if (string == null) {
                string = this._systemId;
            }
            this.setSystemId(string);
            InputSource inputSource = new InputSource(string);
            DOMBuilder dOMBuilder = ((SAXImpl)this._dom).getBuilder();
            xMLReader.setContentHandler(dOMBuilder);
            xMLReader.setDTDHandler(dOMBuilder);
            try {
                xMLReader.setProperty(LEXICAL_HANDLER_PROPERTY, dOMBuilder);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            xMLReader.parse(inputSource);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void build(String string) throws SAXException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            this.build(xMLReader, string);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
    }

    public void build(XMLReader xMLReader) throws SAXException {
        this.build(xMLReader, this._systemId);
    }

    public void build() throws SAXException {
        this.build(this._systemId);
    }

    protected DOM getDOM() {
        return this._dom;
    }
}

