/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import org.apache.xalan.xsltc.Translet;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.trax.TransformerFactoryImpl;
import org.apache.xalan.xsltc.trax.TransformerImpl;

public final class TemplatesImpl
implements Templates,
Serializable {
    private static String ABSTRACT_TRANSLET = "org.apache.xalan.xsltc.runtime.AbstractTranslet";
    private String _name = null;
    private byte[][] _bytecodes = null;
    private Class[] _class = null;
    private int _transletIndex = -1;
    private Properties _outputProperties;
    private int _indentNumber;
    private URIResolver _uriResolver = null;
    private transient TransformerFactoryImpl _tfactory = null;

    protected TemplatesImpl(byte[][] byArray, String string, Properties properties, int n, TransformerFactoryImpl transformerFactoryImpl) {
        this._bytecodes = byArray;
        this._name = string;
        this._outputProperties = properties;
        this._indentNumber = n;
        this._tfactory = transformerFactoryImpl;
    }

    protected TemplatesImpl(Class[] classArray, String string, Properties properties, int n, TransformerFactoryImpl transformerFactoryImpl) {
        this._class = classArray;
        this._name = string;
        this._transletIndex = 0;
        this._outputProperties = properties;
        this._indentNumber = n;
        this._tfactory = transformerFactoryImpl;
    }

    public TemplatesImpl() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._tfactory = new TransformerFactoryImpl();
    }

    public synchronized void setURIResolver(URIResolver uRIResolver) {
        this._uriResolver = uRIResolver;
    }

    protected synchronized void setTransletBytecodes(byte[][] byArray) {
        this._bytecodes = byArray;
    }

    public synchronized byte[][] getTransletBytecodes() {
        return this._bytecodes;
    }

    public synchronized Class[] getTransletClasses() {
        try {
            if (this._class == null) {
                this.defineTransletClasses();
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        return this._class;
    }

    public synchronized int getTransletIndex() {
        try {
            if (this._class == null) {
                this.defineTransletClasses();
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        return this._transletIndex;
    }

    protected synchronized void setTransletName(String string) {
        this._name = string;
    }

    protected synchronized String getTransletName() {
        return this._name;
    }

    private void defineTransletClasses() throws TransformerConfigurationException {
        if (this._bytecodes == null) {
            ErrorMsg errorMsg = new ErrorMsg("NO_TRANSLET_CLASS_ERR");
            throw new TransformerConfigurationException(errorMsg.toString());
        }
        TransletClassLoader transletClassLoader = (TransletClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new TransletClassLoader(Thread.currentThread().getContextClassLoader());
            }
        });
        try {
            Class clazz;
            int n = this._bytecodes.length;
            this._class = new Class[n];
            int n2 = 0;
            while (n2 < n) {
                this._class[n2] = transletClassLoader.defineClass(this._bytecodes[n2]);
                clazz = this._class[n2].getSuperclass();
                if (clazz.getName().equals(ABSTRACT_TRANSLET)) {
                    this._transletIndex = n2;
                }
                ++n2;
            }
            if (this._transletIndex < 0) {
                clazz = new ErrorMsg("NO_MAIN_TRANSLET_ERR", this._name);
                throw new TransformerConfigurationException(((ErrorMsg)((Object)clazz)).toString());
            }
        }
        catch (ClassFormatError classFormatError) {
            ErrorMsg errorMsg = new ErrorMsg("TRANSLET_CLASS_ERR", this._name);
            throw new TransformerConfigurationException(errorMsg.toString());
        }
        catch (LinkageError linkageError) {
            ErrorMsg errorMsg = new ErrorMsg("TRANSLET_OBJECT_ERR", this._name);
            throw new TransformerConfigurationException(errorMsg.toString());
        }
    }

    private Translet getTransletInstance() throws TransformerConfigurationException {
        try {
            if (this._name == null) {
                return null;
            }
            if (this._class == null) {
                this.defineTransletClasses();
            }
            Translet translet = (Translet)this._class[this._transletIndex].newInstance();
            int n = this._class.length;
            int n2 = 0;
            while (n2 < n) {
                if (n2 != this._transletIndex) {
                    translet.addAuxiliaryClass(this._class[n2]);
                }
                ++n2;
            }
            return translet;
        }
        catch (InstantiationException instantiationException) {
            ErrorMsg errorMsg = new ErrorMsg("TRANSLET_OBJECT_ERR", this._name);
            throw new TransformerConfigurationException(errorMsg.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorMsg errorMsg = new ErrorMsg("TRANSLET_OBJECT_ERR", this._name);
            throw new TransformerConfigurationException(errorMsg.toString());
        }
    }

    public synchronized Transformer newTransformer() throws TransformerConfigurationException {
        TransformerImpl transformerImpl = new TransformerImpl(this.getTransletInstance(), this._outputProperties, this._indentNumber, this._tfactory);
        if (this._uriResolver != null) {
            transformerImpl.setURIResolver(this._uriResolver);
        }
        return transformerImpl;
    }

    public synchronized Properties getOutputProperties() {
        try {
            return this.newTransformer().getOutputProperties();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            return null;
        }
    }

    private class TransletClassLoader
    extends ClassLoader {
        protected TransletClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        public Class defineClass(byte[] byArray) {
            return super.defineClass(null, byArray, 0, byArray.length);
        }
    }
}

