/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.ref.DTMAxisIteratorBase;

public final class UnionIterator
extends DTMAxisIteratorBase {
    private final DOM _dom;
    private static final int InitSize = 8;
    private int _heapSize = 0;
    private int _size = 8;
    private LookAheadIterator[] _heap = new LookAheadIterator[8];
    private int _free = 0;
    private int _returnedLast;

    public UnionIterator(DOM dOM) {
        this._dom = dOM;
    }

    public DTMAxisIterator cloneIterator() {
        this._isRestartable = false;
        LookAheadIterator[] lookAheadIteratorArray = new LookAheadIterator[this._heap.length];
        try {
            UnionIterator unionIterator = (UnionIterator)super.clone();
            int n = 0;
            while (n < this._free) {
                lookAheadIteratorArray[n] = this._heap[n].cloneIterator();
                ++n;
            }
            unionIterator.setRestartable(false);
            unionIterator._heap = lookAheadIteratorArray;
            return unionIterator.reset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            BasisLibrary.runTimeError("ITERATOR_CLONE_ERR", cloneNotSupportedException.toString());
            return null;
        }
    }

    public UnionIterator addIterator(DTMAxisIterator dTMAxisIterator) {
        if (this._free == this._size) {
            LookAheadIterator[] lookAheadIteratorArray = new LookAheadIterator[this._size *= 2];
            System.arraycopy(this._heap, 0, lookAheadIteratorArray, 0, this._free);
            this._heap = lookAheadIteratorArray;
        }
        ++this._heapSize;
        this._heap[this._free++] = new LookAheadIterator(dTMAxisIterator);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int next() {
        while (this._heapSize > 0) {
            int n = this._heap[0].node;
            if (n == -1) {
                if (this._heapSize <= 1) return -1;
                LookAheadIterator lookAheadIterator = this._heap[0];
                this._heap[0] = this._heap[--this._heapSize];
                this._heap[this._heapSize] = lookAheadIterator;
            } else if (n == this._returnedLast) {
                this._heap[0].step();
            } else {
                this._heap[0].step();
                this.heapify(0);
                this._returnedLast = n;
                return this.returnNode(this._returnedLast);
            }
            this.heapify(0);
        }
        return -1;
    }

    public DTMAxisIterator setStartNode(int n) {
        if (this._isRestartable) {
            this._startNode = n;
            int n2 = 0;
            while (n2 < this._free) {
                this._heap[n2].iterator.setStartNode(n);
                this._heap[n2].step();
                ++n2;
            }
            this._heapSize = this._free;
            int n3 = this._heapSize / 2;
            while (n3 >= 0) {
                this.heapify(n3);
                --n3;
            }
            this._returnedLast = -1;
            return this.resetPosition();
        }
        return this;
    }

    private void heapify(int n) {
        while (true) {
            int n2;
            int n3;
            int n4;
            int n5 = n4 = (n3 = (n2 = n + 1 << 1) - 1) < this._heapSize && this._dom.lessThan(this._heap[n3].node, this._heap[n].node) ? n3 : n;
            if (n2 < this._heapSize && this._dom.lessThan(this._heap[n2].node, this._heap[n4].node)) {
                n4 = n2;
            }
            if (n4 == n) break;
            LookAheadIterator lookAheadIterator = this._heap[n4];
            this._heap[n4] = this._heap[n];
            this._heap[n] = lookAheadIterator;
            n = n4;
        }
    }

    public void setMark() {
        int n = 0;
        while (n < this._free) {
            this._heap[n].setMark();
            ++n;
        }
    }

    public void gotoMark() {
        int n = 0;
        while (n < this._free) {
            this._heap[n].gotoMark();
            ++n;
        }
    }

    public DTMAxisIterator reset() {
        int n = 0;
        while (n < this._free) {
            this._heap[n].iterator.reset();
            this._heap[n].step();
            ++n;
        }
        this._heapSize = this._free;
        int n2 = this._heapSize / 2;
        while (n2 >= 0) {
            this.heapify(n2);
            --n2;
        }
        this._returnedLast = -1;
        return this.resetPosition();
    }

    private static final class LookAheadIterator {
        public int node;
        public int markedNode;
        public DTMAxisIterator iterator;

        public LookAheadIterator(DTMAxisIterator dTMAxisIterator) {
            this.iterator = dTMAxisIterator;
        }

        public int step() {
            this.node = this.iterator.next();
            return this.node;
        }

        public LookAheadIterator cloneIterator() {
            LookAheadIterator lookAheadIterator = new LookAheadIterator(this.iterator.cloneIterator());
            lookAheadIterator.node = this.node;
            lookAheadIterator.markedNode = this.node;
            return lookAheadIterator;
        }

        public void setMark() {
            this.markedNode = this.node;
            this.iterator.setMark();
        }

        public void gotoMark() {
            this.node = this.markedNode;
            this.iterator.gotoMark();
        }
    }
}

