/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Locale;
import org.apache.xalan.xsltc.CollatorFactory;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.dom.CollatorFactoryBase;
import org.apache.xalan.xsltc.dom.NodeSortRecordFactory;
import org.apache.xalan.xsltc.runtime.AbstractTranslet;

public abstract class NodeSortRecord {
    public static int COMPARE_STRING = 0;
    public static int COMPARE_NUMERIC = 1;
    public static int COMPARE_ASCENDING = 0;
    public static int COMPARE_DESCENDING = 1;
    protected static final Locale DEFAULT_LOCALE = Locale.getDefault();
    protected Locale _locale = Locale.getDefault();
    protected static final Collator DEFAULT_COLLATOR = Collator.getInstance();
    protected Collator _collator = DEFAULT_COLLATOR;
    protected CollatorFactory _collatorFactory;
    protected int _levels = 1;
    protected int[] _compareType;
    protected int[] _sortOrder;
    private AbstractTranslet _translet = null;
    private DOM _dom = null;
    private int _node;
    private int _last = 0;
    private int _scanned = 0;
    private Object[] _values;

    public NodeSortRecord(int n) {
        this._node = n;
        if (this._locale != DEFAULT_LOCALE) {
            this._collator = Collator.getInstance(this._locale);
        }
    }

    public NodeSortRecord() {
        this(0);
    }

    public final void initialize(int n, int n2, DOM dOM, AbstractTranslet abstractTranslet, int[] nArray, int[] nArray2, NodeSortRecordFactory nodeSortRecordFactory) throws TransletException {
        this._dom = dOM;
        this._node = n;
        this._last = n2;
        this._translet = abstractTranslet;
        this._scanned = 0;
        this._levels = nArray.length;
        this._sortOrder = nArray;
        this._compareType = nArray2;
        this._values = new Object[this._levels];
        String string = System.getProperty("org.apache.xalan.xsltc.COLLATOR_FACTORY");
        if (string != null) {
            try {
                Class clazz = nodeSortRecordFactory.loadTranslet(string);
                this._collatorFactory = (CollatorFactory)((Object)clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new TransletException(classNotFoundException);
            }
        } else {
            this._collatorFactory = new CollatorFactoryBase();
        }
        this._collator = this._collatorFactory.getCollator(this._locale);
    }

    public final int getNode() {
        return this._node;
    }

    public final int compareDocOrder(NodeSortRecord nodeSortRecord) {
        return this._node - nodeSortRecord._node;
    }

    private final CollationKey stringValue(int n) {
        if (this._scanned <= n) {
            String string = this.extractValueFromDOM(this._dom, this._node, n, this._translet, this._last);
            CollationKey collationKey = this._collator.getCollationKey(string);
            this._values[this._scanned++] = collationKey;
            return collationKey;
        }
        return (CollationKey)this._values[n];
    }

    private final Double numericValue(int n) {
        if (this._scanned <= n) {
            Double d;
            String string = this.extractValueFromDOM(this._dom, this._node, n, this._translet, this._last);
            try {
                d = new Double(string);
            }
            catch (NumberFormatException numberFormatException) {
                d = new Double(Double.NEGATIVE_INFINITY);
            }
            this._values[this._scanned++] = d;
            return d;
        }
        return (Double)this._values[n];
    }

    public int compareTo(NodeSortRecord nodeSortRecord) {
        int n = 0;
        while (n < this._levels) {
            int n2;
            Comparable<Double> comparable;
            Comparable<Double> comparable2;
            if (this._compareType[n] == COMPARE_NUMERIC) {
                comparable2 = this.numericValue(n);
                comparable = nodeSortRecord.numericValue(n);
                n2 = ((Double)comparable2).compareTo((Double)comparable);
            } else {
                comparable2 = this.stringValue(n);
                comparable = nodeSortRecord.stringValue(n);
                n2 = ((CollationKey)comparable2).compareTo((CollationKey)comparable);
            }
            if (n2 != 0) {
                return this._sortOrder[n] == COMPARE_DESCENDING ? 0 - n2 : n2;
            }
            ++n;
        }
        return this._node - nodeSortRecord._node;
    }

    public Collator getCollator() {
        return this._collator;
    }

    public abstract String extractValueFromDOM(DOM var1, int var2, int var3, AbstractTranslet var4, int var5);
}

