/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.DOMCache;
import org.apache.xalan.xsltc.Translet;
import org.apache.xalan.xsltc.dom.SAXImpl;
import org.apache.xalan.xsltc.dom.XSLTCDTMManager;
import org.apache.xalan.xsltc.runtime.AbstractTranslet;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class DocumentCache
implements DOMCache {
    private int _size;
    private Hashtable _references;
    private String[] _URIs;
    private int _count;
    private int _current;
    private SAXParser _parser;
    private XMLReader _reader;
    private XSLTCDTMManager _dtmManager;
    private static final int REFRESH_INTERVAL = 1000;

    public DocumentCache(int n) throws SAXException {
        this(n, null);
        this._dtmManager = XSLTCDTMManager.newInstance();
    }

    public DocumentCache(int n, XSLTCDTMManager xSLTCDTMManager) throws SAXException {
        this._dtmManager = xSLTCDTMManager;
        this._count = 0;
        this._current = 0;
        this._size = n;
        this._references = new Hashtable(this._size + 2);
        this._URIs = new String[this._size];
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            try {
                sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            catch (Exception exception) {
                sAXParserFactory.setNamespaceAware(true);
            }
            this._parser = sAXParserFactory.newSAXParser();
            this._reader = this._parser.getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            BasisLibrary.runTimeError("NAMESPACES_SUPPORT_ERR");
            System.exit(-1);
        }
    }

    private final long getLastModified(String string) {
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            long l = uRLConnection.getLastModified();
            if (l == 0L && "file".equals(uRL.getProtocol())) {
                File file = new File(URLDecoder.decode(uRL.getFile()));
                l = file.lastModified();
            }
            return l;
        }
        catch (Exception exception) {
            return System.currentTimeMillis();
        }
    }

    private CachedDocument lookupDocument(String string) {
        return (CachedDocument)this._references.get(string);
    }

    private synchronized void insertDocument(String string, CachedDocument cachedDocument) {
        if (this._count < this._size) {
            this._URIs[this._count++] = string;
            this._current = 0;
        } else {
            this._references.remove(this._URIs[this._current]);
            this._URIs[this._current] = string;
            if (++this._current >= this._size) {
                this._current = 0;
            }
        }
        this._references.put(string, cachedDocument);
    }

    private synchronized void replaceDocument(String string, CachedDocument cachedDocument) {
        CachedDocument cachedDocument2 = (CachedDocument)this._references.get(string);
        if (cachedDocument == null) {
            this.insertDocument(string, cachedDocument);
        } else {
            this._references.put(string, cachedDocument);
        }
    }

    public final DOM retrieveDocument(String string, int n, Translet translet) {
        CachedDocument cachedDocument = this.lookupDocument(string);
        if (cachedDocument == null) {
            cachedDocument = new CachedDocument(string);
            if (cachedDocument == null) {
                return null;
            }
            cachedDocument.setLastModified(this.getLastModified(string));
            this.insertDocument(string, cachedDocument);
        } else {
            long l = System.currentTimeMillis();
            long l2 = cachedDocument.getLastChecked();
            cachedDocument.setLastChecked(l);
            if (l > l2 + 1000L) {
                cachedDocument.setLastChecked(l);
                long l3 = this.getLastModified(string);
                if (l3 > cachedDocument.getLastModified()) {
                    cachedDocument = new CachedDocument(string);
                    if (cachedDocument == null) {
                        return null;
                    }
                    cachedDocument.setLastModified(this.getLastModified(string));
                    this.replaceDocument(string, cachedDocument);
                }
            }
        }
        DOM dOM = cachedDocument.getDocument();
        if (dOM == null) {
            return null;
        }
        cachedDocument.incAccessCount();
        AbstractTranslet abstractTranslet = (AbstractTranslet)translet;
        abstractTranslet.prepassDocument(dOM);
        return cachedDocument.getDocument();
    }

    public void getStatistics(PrintWriter printWriter) {
        printWriter.println("<h2>DOM cache statistics</h2><center><table border=\"2\"><tr><td><b>Document URI</b></td><td><center><b>Build time</b></center></td><td><center><b>Access count</b></center></td><td><center><b>Last accessed</b></center></td><td><center><b>Last modified</b></center></td></tr>");
        int n = 0;
        while (n < this._count) {
            CachedDocument cachedDocument = (CachedDocument)this._references.get(this._URIs[n]);
            printWriter.print("<tr><td><a href=\"" + this._URIs[n] + "\">" + "<font size=-1>" + this._URIs[n] + "</font></a></td>");
            printWriter.print("<td><center>" + cachedDocument.getLatency() + "ms</center></td>");
            printWriter.print("<td><center>" + cachedDocument.getAccessCount() + "</center></td>");
            printWriter.print("<td><center>" + new Date(cachedDocument.getLastReferenced()) + "</center></td>");
            printWriter.print("<td><center>" + new Date(cachedDocument.getLastModified()) + "</center></td>");
            printWriter.println("</tr>");
            ++n;
        }
        printWriter.println("</table></center>");
    }

    public final class CachedDocument {
        private long _firstReferenced;
        private long _lastReferenced;
        private long _accessCount;
        private long _lastModified;
        private long _lastChecked;
        private long _buildTime;
        private SAXImpl _dom = null;

        public CachedDocument(String string) {
            long l;
            this._firstReferenced = l = System.currentTimeMillis();
            this._lastReferenced = l;
            this._accessCount = 0L;
            this.loadDocument(string);
            this._buildTime = System.currentTimeMillis() - l;
        }

        public void loadDocument(String string) {
            try {
                long l = System.currentTimeMillis();
                this._dom = (SAXImpl)DocumentCache.this._dtmManager.getDTM(new SAXSource(DocumentCache.this._reader, new InputSource(string)), false, null, true, false);
                this._dom.setDocumentURI(string);
                long l2 = System.currentTimeMillis() - l;
                this._buildTime = this._buildTime > 0L ? this._buildTime + l2 >>> 1 : l2;
            }
            catch (Exception exception) {
                this._dom = null;
            }
        }

        public DOM getDocument() {
            return this._dom;
        }

        public long getFirstReferenced() {
            return this._firstReferenced;
        }

        public long getLastReferenced() {
            return this._lastReferenced;
        }

        public long getAccessCount() {
            return this._accessCount;
        }

        public void incAccessCount() {
            ++this._accessCount;
        }

        public long getLastModified() {
            return this._lastModified;
        }

        public void setLastModified(long l) {
            this._lastModified = l;
        }

        public long getLatency() {
            return this._buildTime;
        }

        public long getLastChecked() {
            return this._lastChecked;
        }

        public void setLastChecked(long l) {
            this._lastChecked = l;
        }

        public long getEstimatedSize() {
            if (this._dom != null) {
                return this._dom.getSize() << 5;
            }
            return 0L;
        }
    }
}

