/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler.util;

import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.Type;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;

final class SlotAllocator {
    private int _firstAvailableSlot;
    private int _size = 8;
    private int _free = 0;
    private int[] _slotsTaken = new int[this._size];

    SlotAllocator() {
    }

    public void initialize(LocalVariableGen[] localVariableGenArray) {
        int n = localVariableGenArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = localVariableGenArray[n3].getType().getSize();
            int n5 = localVariableGenArray[n3].getIndex();
            n2 = Math.max(n2, n5 + n4);
            ++n3;
        }
        this._firstAvailableSlot = n2;
    }

    public int allocateSlot(Type type) {
        int n = type.getSize();
        int n2 = this._free;
        int n3 = this._firstAvailableSlot;
        int n4 = 0;
        if (this._free + n > this._size) {
            int[] nArray = new int[this._size *= 2];
            int n5 = 0;
            while (n5 < n2) {
                nArray[n5] = this._slotsTaken[n5];
                ++n5;
            }
            this._slotsTaken = nArray;
        }
        while (n4 < n2) {
            if (n3 + n <= this._slotsTaken[n4]) {
                int n6 = n2 - 1;
                while (n6 >= n4) {
                    this._slotsTaken[n6 + n] = this._slotsTaken[n6];
                    --n6;
                }
                break;
            }
            n3 = this._slotsTaken[n4++] + 1;
        }
        int n7 = 0;
        while (n7 < n) {
            this._slotsTaken[n4 + n7] = n3 + n7;
            ++n7;
        }
        this._free += n;
        return n3;
    }

    public void releaseSlot(LocalVariableGen localVariableGen) {
        int n = localVariableGen.getType().getSize();
        int n2 = localVariableGen.getIndex();
        int n3 = this._free;
        int n4 = 0;
        while (n4 < n3) {
            if (this._slotsTaken[n4] == n2) {
                int n5 = n4 + n;
                while (n5 < n3) {
                    this._slotsTaken[n4++] = this._slotsTaken[n5++];
                }
                this._free -= n;
                return;
            }
            ++n4;
        }
        String string = "Variable slot allocation error(size=" + n + ", slot=" + n2 + ", limit=" + n3 + ")";
        ErrorMsg errorMsg = new ErrorMsg("INTERNAL_ERR", string);
        throw new Error(errorMsg.toString());
    }
}

