/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler.util;

import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.FlowList;
import org.apache.xalan.xsltc.compiler.util.BooleanType;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.NodeSetType;
import org.apache.xalan.xsltc.compiler.util.ObjectType;
import org.apache.xalan.xsltc.compiler.util.RealType;
import org.apache.xalan.xsltc.compiler.util.ReferenceType;
import org.apache.xalan.xsltc.compiler.util.StringType;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.Util;

public final class ResultTreeType
extends Type {
    private final String _methodName;

    protected ResultTreeType() {
        this._methodName = null;
    }

    public ResultTreeType(String string) {
        this._methodName = string;
    }

    public String toString() {
        return "result-tree";
    }

    public boolean identicalTo(Type type) {
        return type instanceof ResultTreeType;
    }

    public String toSignature() {
        return "Lorg/apache/xalan/xsltc/DOM;";
    }

    public org.apache.bcel.generic.Type toJCType() {
        return Util.getJCRefType(this.toSignature());
    }

    public String getMethodName() {
        return this._methodName;
    }

    public boolean implementedAsMethod() {
        return this._methodName != null;
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, Type type) {
        if (type == Type.String) {
            this.translateTo(classGenerator, methodGenerator, (StringType)type);
        } else if (type == Type.Boolean) {
            this.translateTo(classGenerator, methodGenerator, (BooleanType)type);
        } else if (type == Type.Real) {
            this.translateTo(classGenerator, methodGenerator, (RealType)type);
        } else if (type == Type.NodeSet) {
            this.translateTo(classGenerator, methodGenerator, (NodeSetType)type);
        } else if (type == Type.Reference) {
            this.translateTo(classGenerator, methodGenerator, (ReferenceType)type);
        } else if (type == Type.Object) {
            this.translateTo(classGenerator, methodGenerator, (ObjectType)type);
        } else {
            ErrorMsg errorMsg = new ErrorMsg("DATA_CONVERSION_ERR", (Object)this.toString(), (Object)type.toString());
            classGenerator.getParser().reportError(2, errorMsg);
        }
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, BooleanType booleanType) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        instructionList.append(InstructionConstants.POP);
        instructionList.append(InstructionConstants.ICONST_1);
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, StringType stringType) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        if (this._methodName == null) {
            int n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getStringValue", "()Ljava/lang/String;");
            instructionList.append(new INVOKEINTERFACE(n, 1));
        } else {
            String string = classGenerator.getClassName();
            int n = methodGenerator.getLocalIndex("current");
            instructionList.append(classGenerator.loadTranslet());
            if (classGenerator.isExternal()) {
                instructionList.append(new CHECKCAST(constantPoolGen.addClass(string)));
            }
            instructionList.append(InstructionConstants.DUP);
            instructionList.append(new GETFIELD(constantPoolGen.addFieldref(string, "_dom", "Lorg/apache/xalan/xsltc/DOM;")));
            int n2 = constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.StringValueHandler", "<init>", "()V");
            instructionList.append(new NEW(constantPoolGen.addClass("org.apache.xalan.xsltc.runtime.StringValueHandler")));
            instructionList.append(InstructionConstants.DUP);
            instructionList.append(InstructionConstants.DUP);
            instructionList.append(new INVOKESPECIAL(n2));
            LocalVariableGen localVariableGen = methodGenerator.addLocalVariable("rt_to_string_handler", Util.getJCRefType("Lorg/apache/xalan/xsltc/runtime/StringValueHandler;"), null, null);
            instructionList.append(new ASTORE(localVariableGen.getIndex()));
            n2 = constantPoolGen.addMethodref(string, this._methodName, "(Lorg/apache/xalan/xsltc/DOM;Lorg/apache/xml/serializer/SerializationHandler;)V");
            instructionList.append(new INVOKEVIRTUAL(n2));
            instructionList.append(new ALOAD(localVariableGen.getIndex()));
            n2 = constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.StringValueHandler", "getValue", "()Ljava/lang/String;");
            instructionList.append(new INVOKEVIRTUAL(n2));
        }
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, RealType realType) {
        this.translateTo(classGenerator, methodGenerator, Type.String);
        Type.String.translateTo(classGenerator, methodGenerator, Type.Real);
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, ReferenceType referenceType) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        if (this._methodName == null) {
            instructionList.append(InstructionConstants.NOP);
        } else {
            String string = classGenerator.getClassName();
            int n = methodGenerator.getLocalIndex("current");
            instructionList.append(classGenerator.loadTranslet());
            if (classGenerator.isExternal()) {
                instructionList.append(new CHECKCAST(constantPoolGen.addClass(string)));
            }
            instructionList.append(methodGenerator.loadDOM());
            instructionList.append(methodGenerator.loadDOM());
            int n2 = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getResultTreeFrag", "(IZ)Lorg/apache/xalan/xsltc/DOM;");
            instructionList.append(new PUSH(constantPoolGen, 32));
            instructionList.append(new PUSH(constantPoolGen, false));
            instructionList.append(new INVOKEINTERFACE(n2, 3));
            instructionList.append(InstructionConstants.DUP);
            LocalVariableGen localVariableGen = methodGenerator.addLocalVariable("rt_to_reference_dom", Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), null, null);
            instructionList.append(new CHECKCAST(constantPoolGen.addClass("Lorg/apache/xalan/xsltc/DOM;")));
            instructionList.append(new ASTORE(localVariableGen.getIndex()));
            n2 = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getOutputDomBuilder", "()Lorg/apache/xml/serializer/SerializationHandler;");
            instructionList.append(new INVOKEINTERFACE(n2, 1));
            instructionList.append(InstructionConstants.DUP);
            instructionList.append(InstructionConstants.DUP);
            LocalVariableGen localVariableGen2 = methodGenerator.addLocalVariable("rt_to_reference_handler", Util.getJCRefType("Lorg/apache/xml/serializer/SerializationHandler;"), null, null);
            instructionList.append(new ASTORE(localVariableGen2.getIndex()));
            n2 = constantPoolGen.addInterfaceMethodref("org.apache.xml.serializer.SerializationHandler", "startDocument", "()V");
            instructionList.append(new INVOKEINTERFACE(n2, 1));
            n2 = constantPoolGen.addMethodref(string, this._methodName, "(Lorg/apache/xalan/xsltc/DOM;Lorg/apache/xml/serializer/SerializationHandler;)V");
            instructionList.append(new INVOKEVIRTUAL(n2));
            instructionList.append(new ALOAD(localVariableGen2.getIndex()));
            n2 = constantPoolGen.addInterfaceMethodref("org.apache.xml.serializer.SerializationHandler", "endDocument", "()V");
            instructionList.append(new INVOKEINTERFACE(n2, 1));
            instructionList.append(new ALOAD(localVariableGen.getIndex()));
        }
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, NodeSetType nodeSetType) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        instructionList.append(InstructionConstants.DUP);
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new GETFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "namesArray", "[Ljava/lang/String;")));
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new GETFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "namespaceArray", "[Ljava/lang/String;")));
        int n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "setupMapping", "([Ljava/lang/String;[Ljava/lang/String;)V");
        instructionList.append(new INVOKEINTERFACE(n, 3));
        instructionList.append(InstructionConstants.DUP);
        int n2 = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getIterator", "()Lorg/apache/xml/dtm/DTMAxisIterator;");
        instructionList.append(new INVOKEINTERFACE(n2, 1));
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, ObjectType objectType) {
        methodGenerator.getInstructionList().append(InstructionConstants.NOP);
    }

    public FlowList translateToDesynthesized(ClassGenerator classGenerator, MethodGenerator methodGenerator, BooleanType booleanType) {
        InstructionList instructionList = methodGenerator.getInstructionList();
        this.translateTo(classGenerator, methodGenerator, Type.Boolean);
        return new FlowList(instructionList.append(new IFEQ(null)));
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, Class clazz) {
        String string = clazz.getName();
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        if (string.equals("org.w3c.dom.Node")) {
            this.translateTo(classGenerator, methodGenerator, Type.NodeSet);
            int n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "makeNode", "(Lorg/apache/xml/dtm/DTMAxisIterator;)Lorg/w3c/dom/Node;");
            instructionList.append(new INVOKEINTERFACE(n, 2));
        } else if (string.equals("org.w3c.dom.NodeList")) {
            this.translateTo(classGenerator, methodGenerator, Type.NodeSet);
            int n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "makeNodeList", "(Lorg/apache/xml/dtm/DTMAxisIterator;)Lorg/w3c/dom/NodeList;");
            instructionList.append(new INVOKEINTERFACE(n, 2));
        } else if (string.equals("java.lang.Object")) {
            instructionList.append(InstructionConstants.NOP);
        } else if (string.equals("java.lang.String")) {
            this.translateTo(classGenerator, methodGenerator, Type.String);
        } else if (clazz == Double.TYPE) {
            this.translateTo(classGenerator, methodGenerator, Type.Real);
        } else {
            ErrorMsg errorMsg = new ErrorMsg("DATA_CONVERSION_ERR", (Object)this.toString(), (Object)string);
            classGenerator.getParser().reportError(2, errorMsg);
        }
    }

    public void translateBox(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        this.translateTo(classGenerator, methodGenerator, Type.Reference);
    }

    public void translateUnBox(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        methodGenerator.getInstructionList().append(InstructionConstants.NOP);
    }

    public String getClassName() {
        return "org.apache.xalan.xsltc.DOM";
    }

    public Instruction LOAD(int n) {
        return new ALOAD(n);
    }

    public Instruction STORE(int n) {
        return new ASTORE(n);
    }
}

