/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler.util;

import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.FlowList;
import org.apache.xalan.xsltc.compiler.util.BooleanType;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.NodeSetType;
import org.apache.xalan.xsltc.compiler.util.NodeType;
import org.apache.xalan.xsltc.compiler.util.ObjectType;
import org.apache.xalan.xsltc.compiler.util.RealType;
import org.apache.xalan.xsltc.compiler.util.ResultTreeType;
import org.apache.xalan.xsltc.compiler.util.StringType;
import org.apache.xalan.xsltc.compiler.util.Type;

public final class ReferenceType
extends Type {
    protected ReferenceType() {
    }

    public String toString() {
        return "reference";
    }

    public boolean identicalTo(Type type) {
        return this == type;
    }

    public String toSignature() {
        return "Ljava/lang/Object;";
    }

    public org.apache.bcel.generic.Type toJCType() {
        return org.apache.bcel.generic.Type.OBJECT;
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, Type type) {
        if (type == Type.String) {
            this.translateTo(classGenerator, methodGenerator, (StringType)type);
        } else if (type == Type.Real) {
            this.translateTo(classGenerator, methodGenerator, (RealType)type);
        } else if (type == Type.Boolean) {
            this.translateTo(classGenerator, methodGenerator, (BooleanType)type);
        } else if (type == Type.NodeSet) {
            this.translateTo(classGenerator, methodGenerator, (NodeSetType)type);
        } else if (type == Type.Node) {
            this.translateTo(classGenerator, methodGenerator, (NodeType)type);
        } else if (type == Type.ResultTree) {
            this.translateTo(classGenerator, methodGenerator, (ResultTreeType)type);
        } else if (type == Type.Object) {
            this.translateTo(classGenerator, methodGenerator, (ObjectType)type);
        } else {
            ErrorMsg errorMsg = new ErrorMsg("INTERNAL_ERR", type.toString());
            classGenerator.getParser().reportError(2, errorMsg);
        }
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, StringType stringType) {
        int n = methodGenerator.getLocalIndex("current");
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        if (n < 0) {
            instructionList.append(new PUSH(constantPoolGen, 0));
        } else {
            instructionList.append(new ILOAD(n));
        }
        instructionList.append(methodGenerator.loadDOM());
        int n2 = constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", "stringF", "(Ljava/lang/Object;ILorg/apache/xalan/xsltc/DOM;)Ljava/lang/String;");
        instructionList.append(new INVOKESTATIC(n2));
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, RealType realType) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        instructionList.append(methodGenerator.loadDOM());
        int n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", "numberF", "(Ljava/lang/Object;Lorg/apache/xalan/xsltc/DOM;)D");
        instructionList.append(new INVOKESTATIC(n));
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, BooleanType booleanType) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        int n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", "booleanF", "(Ljava/lang/Object;)Z");
        instructionList.append(new INVOKESTATIC(n));
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, NodeSetType nodeSetType) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        int n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", "referenceToNodeSet", "(Ljava/lang/Object;)Lorg/apache/xml/dtm/DTMAxisIterator;");
        instructionList.append(new INVOKESTATIC(n));
        n = constantPoolGen.addInterfaceMethodref("org.apache.xml.dtm.DTMAxisIterator", "reset", "()Lorg/apache/xml/dtm/DTMAxisIterator;");
        instructionList.append(new INVOKEINTERFACE(n, 1));
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, NodeType nodeType) {
        this.translateTo(classGenerator, methodGenerator, Type.NodeSet);
        Type.NodeSet.translateTo(classGenerator, methodGenerator, nodeType);
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, ResultTreeType resultTreeType) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        int n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", "referenceToResultTree", "(Ljava/lang/Object;)Lorg/apache/xalan/xsltc/DOM;");
        instructionList.append(new INVOKESTATIC(n));
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, ObjectType objectType) {
        methodGenerator.getInstructionList().append(InstructionConstants.NOP);
    }

    public void translateTo(ClassGenerator classGenerator, MethodGenerator methodGenerator, Class clazz) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        if (clazz.getName().equals("java.lang.Object")) {
            instructionList.append(InstructionConstants.NOP);
        } else if (clazz == Double.TYPE) {
            this.translateTo(classGenerator, methodGenerator, Type.Real);
        } else if (clazz.getName().equals("java.lang.String")) {
            this.translateTo(classGenerator, methodGenerator, Type.String);
        } else if (clazz.getName().equals("org.w3c.dom.Node")) {
            int n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", "referenceToNode", "(Ljava/lang/Object;Lorg/apache/xalan/xsltc/DOM;)Lorg/w3c/dom/Node;");
            instructionList.append(methodGenerator.loadDOM());
            instructionList.append(new INVOKESTATIC(n));
        } else if (clazz.getName().equals("org.w3c.dom.NodeList")) {
            int n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", "referenceToNodeList", "(Ljava/lang/Object;Lorg/apache/xalan/xsltc/DOM;)Lorg/w3c/dom/NodeList;");
            instructionList.append(methodGenerator.loadDOM());
            instructionList.append(new INVOKESTATIC(n));
        } else if (clazz.getName().equals("org.apache.xalan.xsltc.DOM")) {
            this.translateTo(classGenerator, methodGenerator, Type.ResultTree);
        } else {
            ErrorMsg errorMsg = new ErrorMsg("DATA_CONVERSION_ERR", (Object)this.toString(), (Object)clazz.getName());
            classGenerator.getParser().reportError(2, errorMsg);
        }
    }

    public void translateFrom(ClassGenerator classGenerator, MethodGenerator methodGenerator, Class clazz) {
        if (clazz.getName().equals("java.lang.Object")) {
            methodGenerator.getInstructionList().append(InstructionConstants.NOP);
        } else {
            ErrorMsg errorMsg = new ErrorMsg("DATA_CONVERSION_ERR", (Object)this.toString(), (Object)clazz.getName());
            classGenerator.getParser().reportError(2, errorMsg);
        }
    }

    public FlowList translateToDesynthesized(ClassGenerator classGenerator, MethodGenerator methodGenerator, BooleanType booleanType) {
        InstructionList instructionList = methodGenerator.getInstructionList();
        this.translateTo(classGenerator, methodGenerator, booleanType);
        return new FlowList(instructionList.append(new IFEQ(null)));
    }

    public void translateBox(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
    }

    public void translateUnBox(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
    }

    public Instruction LOAD(int n) {
        return new ALOAD(n);
    }

    public Instruction STORE(int n) {
        return new ASTORE(n);
    }
}

