/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler.util;

import java.util.Vector;
import org.apache.xalan.xsltc.compiler.util.Type;

public final class MethodType
extends Type {
    private final Type _resultType;
    private final Vector _argsType;

    public MethodType(Type type) {
        this._argsType = null;
        this._resultType = type;
    }

    public MethodType(Type type, Type type2) {
        if (type2 != Type.Void) {
            this._argsType = new Vector();
            this._argsType.addElement(type2);
        } else {
            this._argsType = null;
        }
        this._resultType = type;
    }

    public MethodType(Type type, Type type2, Type type3) {
        this._argsType = new Vector(2);
        this._argsType.addElement(type2);
        this._argsType.addElement(type3);
        this._resultType = type;
    }

    public MethodType(Type type, Type type2, Type type3, Type type4) {
        this._argsType = new Vector(3);
        this._argsType.addElement(type2);
        this._argsType.addElement(type3);
        this._argsType.addElement(type4);
        this._resultType = type;
    }

    public MethodType(Type type, Vector vector) {
        this._resultType = type;
        this._argsType = vector.size() > 0 ? vector : null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("method{");
        if (this._argsType != null) {
            int n = this._argsType.size();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(this._argsType.elementAt(n2));
                if (n2 != n - 1) {
                    stringBuffer.append(',');
                }
                ++n2;
            }
        } else {
            stringBuffer.append("void");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public String toSignature() {
        return this.toSignature("");
    }

    public String toSignature(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        if (this._argsType != null) {
            int n = this._argsType.size();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(((Type)this._argsType.elementAt(n2)).toSignature());
                ++n2;
            }
        }
        return stringBuffer.append(string).append(')').append(this._resultType.toSignature()).toString();
    }

    public org.apache.bcel.generic.Type toJCType() {
        return null;
    }

    public boolean identicalTo(Type type) {
        boolean bl = false;
        if (type instanceof MethodType) {
            MethodType methodType = (MethodType)type;
            if (this._resultType.identicalTo(methodType._resultType)) {
                int n = this.argsCount();
                bl = n == methodType.argsCount();
                int n2 = 0;
                while (n2 < n && bl) {
                    Type type2 = (Type)this._argsType.elementAt(n2);
                    Type type3 = (Type)methodType._argsType.elementAt(n2);
                    bl = type2.identicalTo(type3);
                    ++n2;
                }
            }
        }
        return bl;
    }

    public int distanceTo(Type type) {
        int n = Integer.MAX_VALUE;
        if (type instanceof MethodType) {
            MethodType methodType = (MethodType)type;
            if (this._argsType != null) {
                int n2 = this._argsType.size();
                if (n2 == methodType._argsType.size()) {
                    n = 0;
                    int n3 = 0;
                    while (n3 < n2) {
                        Type type2;
                        Type type3 = (Type)this._argsType.elementAt(n3);
                        int n4 = type3.distanceTo(type2 = (Type)methodType._argsType.elementAt(n3));
                        if (n4 == Integer.MAX_VALUE) {
                            n = n4;
                            break;
                        }
                        n += type3.distanceTo(type2);
                        ++n3;
                    }
                }
            } else if (methodType._argsType == null) {
                n = 0;
            }
        }
        return n;
    }

    public Type resultType() {
        return this._resultType;
    }

    public Vector argsType() {
        return this._argsType;
    }

    public int argsCount() {
        return this._argsType == null ? 0 : this._argsType.size();
    }
}

