/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.AttributeValueTemplate;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.UseAttributeSets;
import org.apache.xalan.xsltc.compiler.XslAttribute;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class XslElement
extends Instruction {
    private String _prefix;
    private boolean _ignore = false;
    private boolean _isLiteralName = true;
    private AttributeValueTemplate _name;
    private AttributeValueTemplate _namespace;

    XslElement() {
    }

    public void display(int n) {
        this.indent(n);
        Util.println("Element " + this._name);
        this.displayContents(n + 4);
    }

    public boolean declaresDefaultNS() {
        return false;
    }

    private boolean isLiteral(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) == '{' && string.charAt(n2 + 1) != '{') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isLegalName(String string) {
        if (string.indexOf(32) > -1) {
            return false;
        }
        int n = string.indexOf(58);
        if (n == 0 || n == string.length() - 1) {
            return false;
        }
        char c = string.charAt(0);
        return Character.isLetter(c) || c == '_';
    }

    public void parseContents(Parser parser2) {
        Object object;
        SymbolTable symbolTable = parser2.getSymbolTable();
        String string = this.getAttribute("name");
        if (string == "") {
            ErrorMsg errorMsg = new ErrorMsg("ILLEGAL_ELEM_NAME_ERR", (Object)string, this);
            parser2.reportError(4, errorMsg);
            this.parseChildren(parser2);
            this._ignore = true;
            return;
        }
        String string2 = this.getAttribute("namespace");
        this._isLiteralName = this.isLiteral(string);
        if (this._isLiteralName) {
            if (!this.isLegalName(string)) {
                ErrorMsg errorMsg = new ErrorMsg("ILLEGAL_ELEM_NAME_ERR", (Object)string, this);
                parser2.reportError(4, errorMsg);
                this.parseChildren(parser2);
                this._ignore = true;
                return;
            }
            object = parser2.getQNameSafe(string);
            String string3 = ((QName)object).getPrefix();
            String string4 = ((QName)object).getLocalPart();
            if (string3 == null) {
                string3 = "";
            }
            if (!this.hasAttribute("namespace")) {
                string2 = this.lookupNamespace(string3);
                if (string2 == null) {
                    ErrorMsg errorMsg = new ErrorMsg("NAMESPACE_UNDEF_ERR", (Object)string3, this);
                    parser2.reportError(4, errorMsg);
                    this.parseChildren(parser2);
                    this._ignore = true;
                    return;
                }
                this._prefix = string3;
                this._namespace = new AttributeValueTemplate(string2, parser2, this);
            } else {
                if (string3 == "") {
                    if (this.isLiteral(string2) && (string3 = this.lookupPrefix(string2)) == null) {
                        string3 = symbolTable.generateNamespacePrefix();
                    }
                    StringBuffer stringBuffer = new StringBuffer(string3);
                    if (string3 != "") {
                        stringBuffer.append(':');
                    }
                    string = stringBuffer.append(string4).toString();
                }
                this._prefix = string3;
                this._namespace = new AttributeValueTemplate(string2, parser2, this);
            }
        } else {
            this._namespace = string2 == "" ? null : new AttributeValueTemplate(string2, parser2, this);
        }
        this._name = new AttributeValueTemplate(string, parser2, this);
        object = this.getAttribute("use-attribute-sets");
        if (((String)object).length() > 0) {
            this.setFirstElement(new UseAttributeSets((String)object, parser2));
        }
        this.parseChildren(parser2);
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        if (!this._ignore) {
            this._name.typeCheck(symbolTable);
            if (this._namespace != null) {
                this._namespace.typeCheck(symbolTable);
            }
        }
        this.typeCheckContents(symbolTable);
        return Type.Void;
    }

    public void translateLiteral(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        if (!this._ignore) {
            instructionList.append(methodGenerator.loadHandler());
            this._name.translate(classGenerator, methodGenerator);
            instructionList.append(InstructionConstants.DUP2);
            instructionList.append(methodGenerator.startElement());
            if (this._namespace != null) {
                instructionList.append(methodGenerator.loadHandler());
                instructionList.append(new PUSH(constantPoolGen, this._prefix));
                this._namespace.translate(classGenerator, methodGenerator);
                instructionList.append(methodGenerator.namespace());
            }
        }
        this.translateContents(classGenerator, methodGenerator);
        if (!this._ignore) {
            instructionList.append(methodGenerator.endElement());
        }
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        Object var3_3 = null;
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        if (this._isLiteralName) {
            this.translateLiteral(classGenerator, methodGenerator);
            return;
        }
        if (!this._ignore) {
            instructionList.append(methodGenerator.loadHandler());
            this._name.translate(classGenerator, methodGenerator);
            if (this._namespace != null) {
                this._namespace.translate(classGenerator, methodGenerator);
            } else {
                instructionList.append(InstructionConstants.ACONST_NULL);
            }
            instructionList.append(methodGenerator.loadHandler());
            instructionList.append(methodGenerator.loadDOM());
            instructionList.append(methodGenerator.loadCurrentNode());
            instructionList.append(new INVOKESTATIC(constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", "startXslElement", "(Ljava/lang/String;Ljava/lang/String;Lorg/apache/xml/serializer/SerializationHandler;Lorg/apache/xalan/xsltc/DOM;I)Ljava/lang/String;")));
        }
        this.translateContents(classGenerator, methodGenerator);
        if (!this._ignore) {
            instructionList.append(methodGenerator.endElement());
        }
    }

    public void translateContents(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        int n = this.elementCount();
        int n2 = 0;
        while (n2 < n) {
            SyntaxTreeNode syntaxTreeNode = (SyntaxTreeNode)this.getContents().elementAt(n2);
            if (!this._ignore || !(syntaxTreeNode instanceof XslAttribute)) {
                syntaxTreeNode.translate(classGenerator, methodGenerator);
            }
            ++n2;
        }
    }
}

