/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.AttributeValue;
import org.apache.xalan.xsltc.compiler.AttributeValueTemplate;
import org.apache.xalan.xsltc.compiler.Choose;
import org.apache.xalan.xsltc.compiler.CopyOf;
import org.apache.xalan.xsltc.compiler.If;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.LiteralAttribute;
import org.apache.xalan.xsltc.compiler.LiteralElement;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.Text;
import org.apache.xalan.xsltc.compiler.UseAttributeSets;
import org.apache.xalan.xsltc.compiler.VariableBase;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class XslAttribute
extends Instruction {
    private String _prefix;
    private AttributeValue _name;
    private AttributeValueTemplate _namespace = null;
    private boolean _ignore = false;

    XslAttribute() {
    }

    public AttributeValue getName() {
        return this._name;
    }

    public void display(int n) {
        this.indent(n);
        Util.println("Attribute " + this._name);
        this.displayContents(n + 4);
    }

    public void parseContents(Parser parser2) {
        boolean bl = false;
        SymbolTable symbolTable = parser2.getSymbolTable();
        String string = this.getAttribute("name");
        String string2 = this.getAttribute("namespace");
        QName qName = parser2.getQName(string, false);
        String string3 = qName.getPrefix();
        if (string3 != null && string3.equals("xmlns")) {
            this.reportError(this, parser2, "ILLEGAL_ATTR_NAME_ERR", string);
            return;
        }
        SyntaxTreeNode syntaxTreeNode = this.getParent();
        Vector vector = syntaxTreeNode.getContents();
        int n = 0;
        while (n < syntaxTreeNode.elementCount()) {
            SyntaxTreeNode syntaxTreeNode2 = (SyntaxTreeNode)vector.elementAt(n);
            if (syntaxTreeNode2 == this) break;
            if (!(syntaxTreeNode2 instanceof XslAttribute || syntaxTreeNode2 instanceof UseAttributeSets || syntaxTreeNode2 instanceof LiteralAttribute || syntaxTreeNode2 instanceof Text || syntaxTreeNode2 instanceof If || syntaxTreeNode2 instanceof Choose || syntaxTreeNode2 instanceof CopyOf || syntaxTreeNode2 instanceof VariableBase)) {
                this.reportWarning(this, parser2, "STRAY_ATTRIBUTE_ERR", string);
            }
            ++n;
        }
        if (string2 != null && string2 != "") {
            this._prefix = this.lookupPrefix(string2);
            this._namespace = new AttributeValueTemplate(string2, parser2, this);
        } else if (string3 != null && string3 != "") {
            this._prefix = string3;
            string2 = this.lookupNamespace(string3);
            if (string2 != null) {
                this._namespace = new AttributeValueTemplate(string2, parser2, this);
            }
        }
        if (this._namespace != null) {
            if (this._prefix == null || this._prefix == "") {
                if (string3 != null) {
                    this._prefix = string3;
                } else {
                    this._prefix = symbolTable.generateNamespacePrefix();
                    bl = true;
                }
            } else if (string3 != null && !string3.equals(this._prefix)) {
                this._prefix = string3;
            }
            string = this._prefix + ":" + qName.getLocalPart();
            if (syntaxTreeNode instanceof LiteralElement && !bl) {
                ((LiteralElement)syntaxTreeNode).registerNamespace(this._prefix, string2, symbolTable, false);
            }
        }
        if (string.equals("xmlns")) {
            this.reportError(this, parser2, "ILLEGAL_ATTR_NAME_ERR", string);
            return;
        }
        if (syntaxTreeNode instanceof LiteralElement) {
            ((LiteralElement)syntaxTreeNode).addAttribute(this);
        }
        this._name = AttributeValue.create(this, string, parser2);
        this.parseChildren(parser2);
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        if (!this._ignore) {
            this._name.typeCheck(symbolTable);
            if (this._namespace != null) {
                this._namespace.typeCheck(symbolTable);
            }
            this.typeCheckContents(symbolTable);
        }
        return Type.Void;
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        if (this._ignore) {
            return;
        }
        this._ignore = true;
        if (this._namespace != null) {
            instructionList.append(methodGenerator.loadHandler());
            instructionList.append(new PUSH(constantPoolGen, this._prefix));
            this._namespace.translate(classGenerator, methodGenerator);
            instructionList.append(methodGenerator.namespace());
        }
        instructionList.append(methodGenerator.loadHandler());
        instructionList.append(InstructionConstants.DUP);
        this._name.translate(classGenerator, methodGenerator);
        if (this.elementCount() == 1 && this.elementAt(0) instanceof Text) {
            instructionList.append(new PUSH(constantPoolGen, ((Text)this.elementAt(0)).getText()));
        } else {
            instructionList.append(classGenerator.loadTranslet());
            instructionList.append(new GETFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "stringValueHandler", "Lorg/apache/xalan/xsltc/runtime/StringValueHandler;")));
            instructionList.append(InstructionConstants.DUP);
            instructionList.append(methodGenerator.storeHandler());
            this.translateContents(classGenerator, methodGenerator);
            instructionList.append(new INVOKEVIRTUAL(constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.StringValueHandler", "getValue", "()Ljava/lang/String;")));
        }
        instructionList.append(methodGenerator.attribute());
        instructionList.append(methodGenerator.storeHandler());
    }
}

