/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.InstructionList;
import org.apache.xalan.xsltc.compiler.AttributeSet;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;

final class UseAttributeSets
extends Instruction {
    private static final String ATTR_SET_NOT_FOUND = "";
    private final Vector _sets = new Vector(2);

    public UseAttributeSets(String string, Parser parser2) {
        this.setParser(parser2);
        this.addAttributeSets(string);
    }

    public void addAttributeSets(String string) {
        if (string != null && !string.equals(ATTR_SET_NOT_FOUND)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                QName qName = this.getParser().getQNameIgnoreDefaultNs(stringTokenizer.nextToken());
                this._sets.add(qName);
            }
        }
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        return Type.Void;
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        SymbolTable symbolTable = this.getParser().getSymbolTable();
        int n = 0;
        while (n < this._sets.size()) {
            Object object;
            QName qName = (QName)this._sets.elementAt(n);
            AttributeSet attributeSet = symbolTable.lookupAttributeSet(qName);
            if (attributeSet != null) {
                object = attributeSet.getMethodName();
                instructionList.append(classGenerator.loadTranslet());
                instructionList.append(methodGenerator.loadHandler());
                instructionList.append(methodGenerator.loadIterator());
                int n2 = constantPoolGen.addMethodref(classGenerator.getClassName(), (String)object, "(Lorg/apache/xml/serializer/SerializationHandler;Lorg/apache/xml/dtm/DTMAxisIterator;)V");
                instructionList.append(new INVOKESPECIAL(n2));
            } else {
                object = this.getParser();
                String string = qName.toString();
                this.reportError(this, (Parser)object, "ATTRIBSET_UNDEF_ERR", string);
            }
            ++n;
        }
    }
}

