/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.NEW;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.Step;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.dom.Axis;

final class UnionPathExpr
extends Expression {
    private final Expression _pathExpr;
    private final Expression _rest;
    private boolean _reverse = false;
    private Expression[] _components;

    public UnionPathExpr(Expression expression, Expression expression2) {
        this._pathExpr = expression;
        this._rest = expression2;
    }

    public void setParser(Parser parser2) {
        super.setParser(parser2);
        Vector vector = new Vector();
        this.flatten(vector);
        int n = vector.size();
        this._components = vector.toArray(new Expression[n]);
        int n2 = 0;
        while (n2 < n) {
            this._components[n2].setParser(parser2);
            this._components[n2].setParent(this);
            if (this._components[n2] instanceof Step) {
                Step step = (Step)this._components[n2];
                int n3 = step.getAxis();
                int n4 = step.getNodeType();
                if (n3 == 2 || n4 == 2) {
                    this._components[n2] = this._components[0];
                    this._components[0] = step;
                }
                if (Axis.isReverse[n3]) {
                    this._reverse = true;
                }
            }
            ++n2;
        }
        if (this.getParent() instanceof Expression) {
            this._reverse = false;
        }
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        int n = this._components.length;
        int n2 = 0;
        while (n2 < n) {
            if (this._components[n2].typeCheck(symbolTable) != Type.NodeSet) {
                this._components[n2] = new CastExpr(this._components[n2], Type.NodeSet);
            }
            ++n2;
        }
        this._type = Type.NodeSet;
        return this._type;
    }

    public String toString() {
        return "union(" + this._pathExpr + ", " + this._rest + ')';
    }

    private void flatten(Vector vector) {
        vector.addElement(this._pathExpr);
        if (this._rest != null) {
            if (this._rest instanceof UnionPathExpr) {
                ((UnionPathExpr)this._rest).flatten(vector);
            } else {
                vector.addElement(this._rest);
            }
        }
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        int n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.dom.UnionIterator", "<init>", "(Lorg/apache/xalan/xsltc/DOM;)V");
        int n2 = constantPoolGen.addMethodref("org.apache.xalan.xsltc.dom.UnionIterator", "addIterator", "(Lorg/apache/xml/dtm/DTMAxisIterator;)Lorg/apache/xalan/xsltc/dom/UnionIterator;");
        instructionList.append(new NEW(constantPoolGen.addClass("org.apache.xalan.xsltc.dom.UnionIterator")));
        instructionList.append(InstructionConstants.DUP);
        instructionList.append(methodGenerator.loadDOM());
        instructionList.append(new INVOKESPECIAL(n));
        int n3 = this._components.length;
        int n4 = 0;
        while (n4 < n3) {
            this._components[n4].translate(classGenerator, methodGenerator);
            instructionList.append(new INVOKEVIRTUAL(n2));
            ++n4;
        }
        if (this._reverse) {
            int n5 = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "orderNodes", "(Lorg/apache/xml/dtm/DTMAxisIterator;I)Lorg/apache/xml/dtm/DTMAxisIterator;");
            instructionList.append(methodGenerator.loadDOM());
            instructionList.append(InstructionConstants.SWAP);
            instructionList.append(methodGenerator.loadContextNode());
            instructionList.append(new INVOKEINTERFACE(n5, 3));
        }
    }
}

