/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.LiteralElement;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Util;

final class Text
extends Instruction {
    private String _text;
    private boolean _escaping = true;
    private boolean _ignore = false;
    private boolean _textElement = false;

    public Text() {
        this._textElement = true;
    }

    public Text(String string) {
        this._text = string;
    }

    protected String getText() {
        return this._text;
    }

    protected void setText(String string) {
        this._text = this._text == null ? string : this._text + string;
    }

    public void display(int n) {
        this.indent(n);
        Util.println("Text");
        this.indent(n + 4);
        Util.println(this._text);
    }

    public void parseContents(Parser parser2) {
        String string = this.getAttribute("disable-output-escaping");
        if (string != null && string.equals("yes")) {
            this._escaping = false;
        }
        this.parseChildren(parser2);
        if (this._text == null) {
            if (this._textElement) {
                this._text = "";
            } else {
                this._ignore = true;
            }
        } else if (this._textElement) {
            if (this._text.length() == 0) {
                this._ignore = true;
            }
        } else if (this.getParent() instanceof LiteralElement) {
            LiteralElement literalElement = (LiteralElement)this.getParent();
            String string2 = literalElement.getAttribute("xml:space");
            if (!(string2 != null && string2.equals("preserve") || this._text.trim().length() != 0)) {
                this._ignore = true;
            }
        } else if (this._text.trim().length() == 0) {
            this._ignore = true;
        }
    }

    public void ignore() {
        this._ignore = true;
    }

    public boolean isTextElement() {
        return this._textElement;
    }

    protected boolean contextDependent() {
        return false;
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        if (!this._ignore) {
            int n = constantPoolGen.addInterfaceMethodref("org/apache/xml/serializer/SerializationHandler", "setEscaping", "(Z)Z");
            if (!this._escaping) {
                instructionList.append(methodGenerator.loadHandler());
                instructionList.append(new PUSH(constantPoolGen, false));
                instructionList.append(new INVOKEINTERFACE(n, 2));
            }
            int n2 = constantPoolGen.addInterfaceMethodref("org/apache/xml/serializer/SerializationHandler", "characters", "(Ljava/lang/String;)V");
            instructionList.append(methodGenerator.loadHandler());
            instructionList.append(new PUSH(constantPoolGen, this._text));
            instructionList.append(new INVOKEINTERFACE(n2, 2));
            if (!this._escaping) {
                instructionList.append(methodGenerator.loadHandler());
                instructionList.append(InstructionConstants.SWAP);
                instructionList.append(new INVOKEINTERFACE(n, 2));
                instructionList.append(InstructionConstants.POP);
            }
        }
        this.translateContents(classGenerator, methodGenerator);
    }
}

