/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.util.InstructionFinder;
import org.apache.xalan.xsltc.compiler.AttributeSet;
import org.apache.xalan.xsltc.compiler.Constants;
import org.apache.xalan.xsltc.compiler.DecimalFormatting;
import org.apache.xalan.xsltc.compiler.Include;
import org.apache.xalan.xsltc.compiler.Key;
import org.apache.xalan.xsltc.compiler.Mode;
import org.apache.xalan.xsltc.compiler.NamespaceAlias;
import org.apache.xalan.xsltc.compiler.Output;
import org.apache.xalan.xsltc.compiler.Param;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SourceLoader;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.Template;
import org.apache.xalan.xsltc.compiler.TopLevelElement;
import org.apache.xalan.xsltc.compiler.Variable;
import org.apache.xalan.xsltc.compiler.VariableBase;
import org.apache.xalan.xsltc.compiler.Whitespace;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

public final class Stylesheet
extends SyntaxTreeNode {
    private String _version;
    private QName _name;
    private String _systemId;
    private Stylesheet _parentStylesheet;
    private Vector _globals = new Vector();
    private Boolean _hasLocalParams = null;
    private String _className;
    private final Vector _templates = new Vector();
    private int _nextModeSerial = 1;
    private final Hashtable _modes = new Hashtable();
    private final Hashtable _extensions = new Hashtable();
    public Stylesheet _importedFrom = null;
    public Stylesheet _includedFrom = null;
    private int _importPrecedence = 1;
    private Mode _defaultMode;
    private boolean _multiDocument = false;
    private boolean _callsNodeset = false;
    private Hashtable _keys = new Hashtable();
    private boolean _numberFormattingUsed = false;
    private boolean _simplified = false;
    private SourceLoader _loader = null;
    private boolean _templateInlining = true;
    private boolean _forwardReference = false;
    private boolean _hasIdCall = false;
    private Properties _outputProperties = null;

    public void setForwardReference() {
        this._forwardReference = true;
    }

    public boolean getTemplateInlining() {
        return this._templateInlining;
    }

    public void setTemplateInlining(boolean bl) {
        this._templateInlining = bl;
    }

    public boolean isSimplified() {
        return this._simplified;
    }

    public void setSimplified() {
        this._simplified = true;
    }

    public void setHasIdCall(boolean bl) {
        this._hasIdCall = bl;
    }

    public void setOutputProperty(String string, String string2) {
        if (this._outputProperties == null) {
            this._outputProperties = new Properties();
        }
        this._outputProperties.setProperty(string, string2);
    }

    public void setOutputProperties(Properties properties) {
        this._outputProperties = properties;
    }

    public Properties getOutputProperties() {
        return this._outputProperties;
    }

    public void setMultiDocument(boolean bl) {
        this._multiDocument = bl;
    }

    public boolean isMultiDocument() {
        return this._multiDocument;
    }

    public void setCallsNodeset(boolean bl) {
        if (bl) {
            this.setMultiDocument(bl);
        }
        this._callsNodeset = bl;
    }

    public boolean callsNodeset() {
        return this._callsNodeset;
    }

    public void numberFormattingUsed() {
        this._numberFormattingUsed = true;
    }

    public void setImportPrecedence(int n) {
        Constants constants;
        this._importPrecedence = n;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Stylesheet stylesheet;
            constants = (SyntaxTreeNode)enumeration.nextElement();
            if (!(constants instanceof Include) || (stylesheet = ((Include)constants).getIncludedStylesheet()) == null || stylesheet._includedFrom != this) continue;
            stylesheet.setImportPrecedence(n);
        }
        if (this._importedFrom != null) {
            if (this._importedFrom.getImportPrecedence() < n) {
                constants = this.getParser();
                int n2 = ((Parser)constants).getNextImportPrecedence();
                this._importedFrom.setImportPrecedence(n2);
            }
        } else if (this._includedFrom != null && this._includedFrom.getImportPrecedence() != n) {
            this._includedFrom.setImportPrecedence(n);
        }
    }

    public int getImportPrecedence() {
        return this._importPrecedence;
    }

    public boolean checkForLoop(String string) {
        if (this._systemId != null && this._systemId.equals(string)) {
            return true;
        }
        if (this._parentStylesheet != null) {
            return this._parentStylesheet.checkForLoop(string);
        }
        return false;
    }

    public void setParser(Parser parser2) {
        super.setParser(parser2);
        this._name = this.makeStylesheetName("__stylesheet_");
    }

    public void setParentStylesheet(Stylesheet stylesheet) {
        this._parentStylesheet = stylesheet;
    }

    public Stylesheet getParentStylesheet() {
        return this._parentStylesheet;
    }

    public void setImportingStylesheet(Stylesheet stylesheet) {
        this._importedFrom = stylesheet;
    }

    public void setIncludingStylesheet(Stylesheet stylesheet) {
        this._includedFrom = stylesheet;
    }

    public void setSystemId(String string) {
        this._systemId = string;
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void setSourceLoader(SourceLoader sourceLoader) {
        this._loader = sourceLoader;
    }

    public SourceLoader getSourceLoader() {
        return this._loader;
    }

    private QName makeStylesheetName(String string) {
        return this.getParser().getQName(string + this.getXSLTC().nextStylesheetSerial());
    }

    public boolean hasGlobals() {
        return this._globals.size() > 0;
    }

    public boolean hasLocalParams() {
        if (this._hasLocalParams == null) {
            int n = this._templates.size();
            int n2 = 0;
            while (n2 < n) {
                Template template = (Template)this._templates.elementAt(n2);
                if (template.hasParams()) {
                    this._hasLocalParams = new Boolean(true);
                    return true;
                }
                ++n2;
            }
            this._hasLocalParams = new Boolean(false);
            return false;
        }
        return this._hasLocalParams;
    }

    protected void addPrefixMapping(String string, String string2) {
        if (string.equals("") && string2.equals("http://www.w3.org/1999/xhtml")) {
            return;
        }
        super.addPrefixMapping(string, string2);
    }

    private void extensionURI(String string, SymbolTable symbolTable) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = this.lookupNamespace(string2);
                if (string3 == null) continue;
                this._extensions.put(string3, string2);
            }
        }
    }

    public boolean isExtension(String string) {
        return this._extensions.get(string) != null;
    }

    public void excludeExtensionPrefixes(Parser parser2) {
        SymbolTable symbolTable = parser2.getSymbolTable();
        String string = this.getAttribute("exclude-result-prefixes");
        String string2 = this.getAttribute("extension-element-prefixes");
        symbolTable.excludeURI("http://www.w3.org/1999/XSL/Transform");
        symbolTable.excludeNamespaces(string);
        symbolTable.excludeNamespaces(string2);
        this.extensionURI(string2, symbolTable);
    }

    public void parseContents(Parser parser2) {
        Object object;
        SymbolTable symbolTable = parser2.getSymbolTable();
        this.addPrefixMapping("xml", "http://www.w3.org/XML/1998/namespace");
        Stylesheet stylesheet = symbolTable.addStylesheet(this._name, this);
        if (stylesheet != null) {
            object = new ErrorMsg("MULTIPLE_STYLESHEET_ERR", this);
            parser2.reportError(3, (ErrorMsg)object);
        }
        if (this._simplified) {
            symbolTable.excludeURI("http://www.w3.org/1999/XSL/Transform");
            object = new Template();
            ((Template)object).parseSimplified(this, parser2);
        } else {
            this.parseOwnChildren(parser2);
        }
    }

    public final void parseOwnChildren(Parser parser2) {
        Vector vector = this.getContents();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            SyntaxTreeNode syntaxTreeNode = (SyntaxTreeNode)vector.elementAt(n2);
            if (syntaxTreeNode instanceof VariableBase || syntaxTreeNode instanceof NamespaceAlias) {
                parser2.getSymbolTable().setCurrentNode(syntaxTreeNode);
                syntaxTreeNode.parseContents(parser2);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            SyntaxTreeNode syntaxTreeNode = (SyntaxTreeNode)vector.elementAt(n3);
            if (!(syntaxTreeNode instanceof VariableBase) && !(syntaxTreeNode instanceof NamespaceAlias)) {
                parser2.getSymbolTable().setCurrentNode(syntaxTreeNode);
                syntaxTreeNode.parseContents(parser2);
            }
            if (!this._templateInlining && syntaxTreeNode instanceof Template) {
                Template template = (Template)syntaxTreeNode;
                String string = "template$dot$" + template.getPosition();
                template.setName(parser2.getQName(string));
            }
            ++n3;
        }
    }

    public void processModes() {
        if (this._defaultMode == null) {
            this._defaultMode = new Mode(null, this, "");
        }
        this._defaultMode.processPatterns(this._keys);
        Enumeration enumeration = this._modes.elements();
        while (enumeration.hasMoreElements()) {
            Mode mode = (Mode)enumeration.nextElement();
            mode.processPatterns(this._keys);
        }
    }

    private void compileModes(ClassGenerator classGenerator) {
        this._defaultMode.compileApplyTemplates(classGenerator);
        Enumeration enumeration = this._modes.elements();
        while (enumeration.hasMoreElements()) {
            Mode mode = (Mode)enumeration.nextElement();
            mode.compileApplyTemplates(classGenerator);
        }
    }

    public Mode getMode(QName qName) {
        if (qName == null) {
            if (this._defaultMode == null) {
                this._defaultMode = new Mode(null, this, "");
            }
            return this._defaultMode;
        }
        Mode mode = (Mode)this._modes.get(qName);
        if (mode == null) {
            String string = Integer.toString(this._nextModeSerial++);
            mode = new Mode(qName, this, string);
            this._modes.put(qName, mode);
        }
        return mode;
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        int n = this._globals.size();
        int n2 = 0;
        while (n2 < n) {
            VariableBase variableBase = (VariableBase)this._globals.elementAt(n2);
            variableBase.typeCheck(symbolTable);
            ++n2;
        }
        return this.typeCheckContents(symbolTable);
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        this.translate();
    }

    private void addDOMField(ClassGenerator classGenerator) {
        FieldGen fieldGen = new FieldGen(1, Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), "_dom", classGenerator.getConstantPool());
        classGenerator.addField(fieldGen.getField());
    }

    public void translate() {
        TopLevelElement topLevelElement = null;
        this._className = this.getXSLTC().getClassName();
        ClassGenerator classGenerator = new ClassGenerator(this._className, "org.apache.xalan.xsltc.runtime.AbstractTranslet", "", 33, null, this);
        this.addDOMField(classGenerator);
        this.compileTransform(classGenerator);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            TopLevelElement topLevelElement2;
            Object e = enumeration.nextElement();
            if (e instanceof Template) {
                topLevelElement2 = (Template)e;
                this._templates.addElement(topLevelElement2);
                this.getMode(((Template)topLevelElement2).getModeName()).addTemplate((Template)topLevelElement2);
                continue;
            }
            if (e instanceof AttributeSet) {
                ((AttributeSet)e).translate(classGenerator, null);
                continue;
            }
            if (!(e instanceof Output) || !((Output)(topLevelElement2 = (Output)e)).enabled()) continue;
            topLevelElement = topLevelElement2;
        }
        this.processModes();
        this.compileModes(classGenerator);
        this.compileConstructor(classGenerator, (Output)topLevelElement);
        if (!this.getParser().errorsFound()) {
            this.getXSLTC().dumpClass(classGenerator.getJavaClass());
        }
    }

    private void compileConstructor(ClassGenerator classGenerator, Output output) {
        Object object;
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = new InstructionList();
        MethodGenerator methodGenerator = new MethodGenerator(1, org.apache.bcel.generic.Type.VOID, null, null, "<init>", this._className, instructionList, constantPoolGen);
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new INVOKESPECIAL(constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "<init>", "()V")));
        Vector vector = this.getXSLTC().getNamesIndex();
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new PUSH(constantPoolGen, vector.size()));
        instructionList.append(new ANEWARRAY(constantPoolGen.addClass("java.lang.String")));
        int n = 0;
        while (n < vector.size()) {
            object = (String)vector.elementAt(n);
            instructionList.append(InstructionConstants.DUP);
            instructionList.append(new PUSH(constantPoolGen, n));
            instructionList.append(new PUSH(constantPoolGen, (String)object));
            instructionList.append(InstructionConstants.AASTORE);
            ++n;
        }
        instructionList.append(new PUTFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "namesArray", "[Ljava/lang/String;")));
        object = this.getXSLTC().getNamespaceIndex();
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new PUSH(constantPoolGen, ((Vector)object).size()));
        instructionList.append(new ANEWARRAY(constantPoolGen.addClass("java.lang.String")));
        int n2 = 0;
        while (n2 < ((Vector)object).size()) {
            String string = (String)((Vector)object).elementAt(n2);
            instructionList.append(InstructionConstants.DUP);
            instructionList.append(new PUSH(constantPoolGen, n2));
            instructionList.append(new PUSH(constantPoolGen, string));
            instructionList.append(InstructionConstants.AASTORE);
            ++n2;
        }
        instructionList.append(new PUTFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "namespaceArray", "[Ljava/lang/String;")));
        if (this._hasIdCall) {
            instructionList.append(classGenerator.loadTranslet());
            instructionList.append(new PUSH(constantPoolGen, Boolean.TRUE));
            instructionList.append(new PUTFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "_hasIdCall", "Z")));
        }
        if (output != null) {
            output.translate(classGenerator, methodGenerator);
        }
        if (this._numberFormattingUsed) {
            DecimalFormatting.translateDefaultDFS(classGenerator, methodGenerator);
        }
        instructionList.append(InstructionConstants.RETURN);
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        classGenerator.addMethod(methodGenerator.getMethod());
    }

    private String compileTopLevel(ClassGenerator classGenerator, Enumeration enumeration) {
        Object object;
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        org.apache.bcel.generic.Type[] typeArray = new org.apache.bcel.generic.Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), Util.getJCRefType("Lorg/apache/xml/dtm/DTMAxisIterator;"), Util.getJCRefType("Lorg/apache/xml/serializer/SerializationHandler;")};
        String[] stringArray = new String[]{"document", "iterator", "handler"};
        InstructionList instructionList = new InstructionList();
        MethodGenerator methodGenerator = new MethodGenerator(1, org.apache.bcel.generic.Type.VOID, typeArray, stringArray, "topLevel", this._className, instructionList, classGenerator.getConstantPool());
        methodGenerator.addException("org.apache.xalan.xsltc.TransletException");
        LocalVariableGen localVariableGen = methodGenerator.addLocalVariable("current", org.apache.bcel.generic.Type.INT, instructionList.getEnd(), null);
        int n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "setFilter", "(Lorg/apache/xalan/xsltc/StripFilter;)V");
        instructionList.append(new PUSH(constantPoolGen, 0));
        instructionList.append(new ISTORE(localVariableGen.getIndex()));
        this._globals = this.resolveReferences(this._globals);
        int n2 = this._globals.size();
        int n3 = 0;
        while (n3 < n2) {
            object = (VariableBase)this._globals.elementAt(n3);
            ((TopLevelElement)object).translate(classGenerator, methodGenerator);
            ++n3;
        }
        object = new Vector();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof DecimalFormatting) {
                ((DecimalFormatting)e).translate(classGenerator, methodGenerator);
                continue;
            }
            if (!(e instanceof Whitespace)) continue;
            ((Vector)object).addAll(((Whitespace)e).getRules());
        }
        if (((Vector)object).size() > 0) {
            Whitespace.translateRules((Vector)object, classGenerator);
        }
        if (classGenerator.containsMethod("stripSpace", "(Lorg/apache/xalan/xsltc/DOM;II)Z") != null) {
            instructionList.append(methodGenerator.loadDOM());
            instructionList.append(classGenerator.loadTranslet());
            instructionList.append(new INVOKEINTERFACE(n, 2));
        }
        instructionList.append(InstructionConstants.RETURN);
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        methodGenerator.removeNOPs();
        classGenerator.addMethod(methodGenerator.getMethod());
        return "(Lorg/apache/xalan/xsltc/DOM;Lorg/apache/xml/dtm/DTMAxisIterator;Lorg/apache/xml/serializer/SerializationHandler;)V";
    }

    private Vector resolveReferences(Vector vector) {
        Object object;
        int n;
        Object object2;
        int n2 = 0;
        while (n2 < vector.size()) {
            object2 = (VariableBase)vector.elementAt(n2);
            Vector vector2 = ((VariableBase)object2).getDependencies();
            n = vector2 != null ? vector2.size() : 0;
            int n3 = 0;
            while (n3 < n) {
                object = (VariableBase)vector2.elementAt(n3);
                if (!vector.contains(object)) {
                    vector.addElement(object);
                }
                ++n3;
            }
            ++n2;
        }
        object2 = new Vector();
        while (vector.size() > 0) {
            boolean bl = false;
            n = 0;
            while (n < vector.size()) {
                VariableBase variableBase = (VariableBase)vector.elementAt(n);
                object = variableBase.getDependencies();
                if (object == null || ((Vector)object2).containsAll((Collection<?>)object)) {
                    ((Vector)object2).addElement(variableBase);
                    vector.remove(n);
                    bl = true;
                    continue;
                }
                ++n;
            }
            if (bl) continue;
            ErrorMsg errorMsg = new ErrorMsg("CIRCULAR_VARIABLE_ERR", (Object)vector.toString(), this);
            this.getParser().reportError(3, errorMsg);
            return object2;
        }
        return object2;
    }

    private String compileBuildKeys(ClassGenerator classGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        org.apache.bcel.generic.Type[] typeArray = new org.apache.bcel.generic.Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), Util.getJCRefType("Lorg/apache/xml/dtm/DTMAxisIterator;"), Util.getJCRefType("Lorg/apache/xml/serializer/SerializationHandler;"), org.apache.bcel.generic.Type.INT};
        String[] stringArray = new String[]{"document", "iterator", "handler", "current"};
        InstructionList instructionList = new InstructionList();
        MethodGenerator methodGenerator = new MethodGenerator(1, org.apache.bcel.generic.Type.VOID, typeArray, stringArray, "buildKeys", this._className, instructionList, classGenerator.getConstantPool());
        methodGenerator.addException("org.apache.xalan.xsltc.TransletException");
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Key)) continue;
            Key key = (Key)e;
            key.translate(classGenerator, methodGenerator);
            this._keys.put(key.getName(), key);
        }
        instructionList.append(InstructionConstants.RETURN);
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        methodGenerator.removeNOPs();
        classGenerator.addMethod(methodGenerator.getMethod());
        return "(Lorg/apache/xalan/xsltc/DOM;Lorg/apache/xml/dtm/DTMAxisIterator;Lorg/apache/xml/serializer/SerializationHandler;I)V";
    }

    private void compileTransform(ClassGenerator classGenerator) {
        int n;
        String string;
        int n2;
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        org.apache.bcel.generic.Type[] typeArray = new org.apache.bcel.generic.Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), Util.getJCRefType("Lorg/apache/xml/dtm/DTMAxisIterator;"), Util.getJCRefType("Lorg/apache/xml/serializer/SerializationHandler;")};
        String[] stringArray = new String[]{"document", "iterator", "handler"};
        InstructionList instructionList = new InstructionList();
        MethodGenerator methodGenerator = new MethodGenerator(1, org.apache.bcel.generic.Type.VOID, typeArray, stringArray, "transform", this._className, instructionList, classGenerator.getConstantPool());
        methodGenerator.addException("org.apache.xalan.xsltc.TransletException");
        LocalVariableGen localVariableGen = methodGenerator.addLocalVariable("current", org.apache.bcel.generic.Type.INT, instructionList.getEnd(), null);
        String string2 = classGenerator.getApplyTemplatesSig();
        int n3 = constantPoolGen.addMethodref(this.getClassName(), "applyTemplates", string2);
        int n4 = constantPoolGen.addFieldref(this.getClassName(), "_dom", "Lorg/apache/xalan/xsltc/DOM;");
        instructionList.append(classGenerator.loadTranslet());
        if (this.isMultiDocument()) {
            instructionList.append(new NEW(constantPoolGen.addClass("org.apache.xalan.xsltc.dom.MultiDOM")));
            instructionList.append(InstructionConstants.DUP);
        }
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(methodGenerator.loadDOM());
        instructionList.append(new INVOKEVIRTUAL(constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "makeDOMAdapter", "(Lorg/apache/xalan/xsltc/DOM;)Lorg/apache/xalan/xsltc/dom/DOMAdapter;")));
        if (this.isMultiDocument()) {
            n2 = constantPoolGen.addMethodref("org.apache.xalan.xsltc.dom.MultiDOM", "<init>", "(Lorg/apache/xalan/xsltc/DOM;)V");
            instructionList.append(new INVOKESPECIAL(n2));
        }
        instructionList.append(new PUTFIELD(n4));
        instructionList.append(new PUSH(constantPoolGen, 0));
        instructionList.append(new ISTORE(localVariableGen.getIndex()));
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(methodGenerator.loadHandler());
        n2 = constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "transferOutputSettings", "(Lorg/apache/xml/serializer/SerializationHandler;)V");
        instructionList.append(new INVOKEVIRTUAL(n2));
        Enumeration enumeration = this.elements();
        if (this._globals.size() > 0 || enumeration.hasMoreElements()) {
            string = this.compileTopLevel(classGenerator, enumeration);
            n = constantPoolGen.addMethodref(this.getClassName(), "topLevel", string);
            instructionList.append(classGenerator.loadTranslet());
            instructionList.append(classGenerator.loadTranslet());
            instructionList.append(new GETFIELD(n4));
            instructionList.append(methodGenerator.loadIterator());
            instructionList.append(methodGenerator.loadHandler());
            instructionList.append(new INVOKEVIRTUAL(n));
        }
        string = this.compileBuildKeys(classGenerator);
        n = constantPoolGen.addMethodref(this.getClassName(), "buildKeys", string);
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new GETFIELD(n4));
        instructionList.append(methodGenerator.loadIterator());
        instructionList.append(methodGenerator.loadHandler());
        instructionList.append(new PUSH(constantPoolGen, 0));
        instructionList.append(new INVOKEVIRTUAL(n));
        instructionList.append(methodGenerator.loadHandler());
        instructionList.append(methodGenerator.startDocument());
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new GETFIELD(n4));
        instructionList.append(methodGenerator.loadIterator());
        instructionList.append(methodGenerator.loadHandler());
        instructionList.append(new INVOKEVIRTUAL(n3));
        instructionList.append(methodGenerator.loadHandler());
        instructionList.append(methodGenerator.endDocument());
        instructionList.append(InstructionConstants.RETURN);
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        methodGenerator.removeNOPs();
        classGenerator.addMethod(methodGenerator.getMethod());
    }

    private void peepHoleOptimization(MethodGenerator methodGenerator) {
        InstructionList instructionList = methodGenerator.getInstructionList();
        InstructionFinder instructionFinder = new InstructionFinder(instructionList);
        Iterator iterator = instructionFinder.search("`ALOAD'`POP'`Instruction'");
        while (iterator.hasNext()) {
            InstructionHandle[] instructionHandleArray = (InstructionHandle[])iterator.next();
            try {
                instructionList.delete(instructionHandleArray[0], instructionHandleArray[1]);
            }
            catch (TargetLostException targetLostException) {
                // empty catch block
            }
        }
    }

    public int addParam(Param param) {
        this._globals.addElement(param);
        return this._globals.size() - 1;
    }

    public int addVariable(Variable variable) {
        this._globals.addElement(variable);
        return this._globals.size() - 1;
    }

    public void display(int n) {
        this.indent(n);
        Util.println("Stylesheet");
        this.displayContents(n + 4);
    }

    public String getNamespace(String string) {
        return this.lookupNamespace(string);
    }

    public String getClassName() {
        return this._className;
    }

    public Vector getTemplates() {
        return this._templates;
    }
}

