/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Vector;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.GOTO_W;
import org.apache.bcel.generic.IFLT;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.Predicate;
import org.apache.xalan.xsltc.compiler.RelativePathPattern;
import org.apache.xalan.xsltc.compiler.Step;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;
import org.apache.xml.dtm.Axis;

class StepPattern
extends RelativePathPattern {
    private static final int NO_CONTEXT = 0;
    private static final int SIMPLE_CONTEXT = 1;
    private static final int GENERAL_CONTEXT = 2;
    protected final int _axis;
    protected final int _nodeType;
    protected Vector _predicates;
    private Step _step = null;
    private boolean _isEpsilon = false;
    private int _contextCase;
    private double _priority = Double.MAX_VALUE;

    public StepPattern(int n, int n2, Vector vector) {
        this._axis = n;
        this._nodeType = n2;
        this._predicates = vector;
    }

    public void setParser(Parser parser2) {
        super.setParser(parser2);
        if (this._predicates != null) {
            int n = this._predicates.size();
            int n2 = 0;
            while (n2 < n) {
                Predicate predicate = (Predicate)this._predicates.elementAt(n2);
                predicate.setParser(parser2);
                predicate.setParent(this);
                ++n2;
            }
        }
    }

    public int getNodeType() {
        return this._nodeType;
    }

    public void setPriority(double d) {
        this._priority = d;
    }

    public StepPattern getKernelPattern() {
        return this;
    }

    public boolean isWildcard() {
        return this._isEpsilon && !this.hasPredicates();
    }

    public StepPattern setPredicates(Vector vector) {
        this._predicates = vector;
        return this;
    }

    protected boolean hasPredicates() {
        return this._predicates != null && this._predicates.size() > 0;
    }

    public double getDefaultPriority() {
        if (this._priority != Double.MAX_VALUE) {
            return this._priority;
        }
        if (this.hasPredicates()) {
            return 0.5;
        }
        switch (this._nodeType) {
            case -1: {
                return -0.5;
            }
            case 0: {
                return 0.0;
            }
        }
        return this._nodeType >= 14 ? 0.0 : -0.5;
    }

    public int getAxis() {
        return this._axis;
    }

    public void reduceKernelPattern() {
        this._isEpsilon = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("stepPattern(\"");
        stringBuffer.append(Axis.names[this._axis]).append("\", ").append(this._isEpsilon ? "epsilon{" + Integer.toString(this._nodeType) + "}" : Integer.toString(this._nodeType));
        if (this._predicates != null) {
            stringBuffer.append(", ").append(this._predicates.toString());
        }
        return stringBuffer.append(')').toString();
    }

    private int analyzeCases() {
        boolean bl = true;
        int n = this._predicates.size();
        int n2 = 0;
        while (n2 < n && bl) {
            Predicate predicate = (Predicate)this._predicates.elementAt(n2);
            if (predicate.getExpr().hasPositionCall() || predicate.isNthPositionFilter()) {
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            return 0;
        }
        if (n == 1) {
            return 1;
        }
        return 2;
    }

    private String getNextFieldName() {
        return "__step_pattern_iter_" + this.getXSLTC().nextStepPatternSerial();
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        if (this.hasPredicates()) {
            Expression expression;
            int n = this._predicates.size();
            int n2 = 0;
            while (n2 < n) {
                expression = (Predicate)this._predicates.elementAt(n2);
                expression.typeCheck(symbolTable);
                ++n2;
            }
            this._contextCase = this.analyzeCases();
            expression = null;
            if (this._contextCase == 1) {
                Predicate predicate = (Predicate)this._predicates.elementAt(0);
                if (predicate.isNthPositionFilter()) {
                    this._contextCase = 2;
                    expression = new Step(this._axis, this._nodeType, this._predicates);
                } else {
                    expression = new Step(this._axis, this._nodeType, null);
                }
            } else if (this._contextCase == 2) {
                int n3 = this._predicates.size();
                int n4 = 0;
                while (n4 < n3) {
                    ((Predicate)this._predicates.elementAt(n4)).dontOptimize();
                    ++n4;
                }
                expression = new Step(this._axis, this._nodeType, this._predicates);
            }
            if (expression != null) {
                ((Step)expression).setParser(this.getParser());
                ((Step)expression).typeCheck(symbolTable);
                this._step = expression;
            }
        }
        return this._axis == 3 ? Type.Element : Type.Attribute;
    }

    private void translateKernel(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        if (this._nodeType == 1) {
            int n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "isElement", "(I)Z");
            instructionList.append(methodGenerator.loadDOM());
            instructionList.append(InstructionConstants.SWAP);
            instructionList.append(new INVOKEINTERFACE(n, 2));
            BranchHandle branchHandle = instructionList.append(new IFNE(null));
            this._falseList.add(instructionList.append(new GOTO_W(null)));
            branchHandle.setTarget(instructionList.append(InstructionConstants.NOP));
        } else if (this._nodeType == 2) {
            int n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "isAttribute", "(I)Z");
            instructionList.append(methodGenerator.loadDOM());
            instructionList.append(InstructionConstants.SWAP);
            instructionList.append(new INVOKEINTERFACE(n, 2));
            BranchHandle branchHandle = instructionList.append(new IFNE(null));
            this._falseList.add(instructionList.append(new GOTO_W(null)));
            branchHandle.setTarget(instructionList.append(InstructionConstants.NOP));
        } else {
            int n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getExpandedTypeID", "(I)I");
            instructionList.append(methodGenerator.loadDOM());
            instructionList.append(InstructionConstants.SWAP);
            instructionList.append(new INVOKEINTERFACE(n, 2));
            instructionList.append(new PUSH(constantPoolGen, this._nodeType));
            BranchHandle branchHandle = instructionList.append(new IF_ICMPEQ(null));
            this._falseList.add(instructionList.append(new GOTO_W(null)));
            branchHandle.setTarget(instructionList.append(InstructionConstants.NOP));
        }
    }

    private void translateNoContext(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        Object object;
        Object object2;
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        instructionList.append(methodGenerator.loadCurrentNode());
        instructionList.append(InstructionConstants.SWAP);
        instructionList.append(methodGenerator.storeCurrentNode());
        if (!this._isEpsilon) {
            instructionList.append(methodGenerator.loadCurrentNode());
            this.translateKernel(classGenerator, methodGenerator);
        }
        int n = this._predicates.size();
        int n2 = 0;
        while (n2 < n) {
            object2 = (Predicate)this._predicates.elementAt(n2);
            object = ((Predicate)object2).getExpr();
            ((Expression)object).translateDesynthesized(classGenerator, methodGenerator);
            this._trueList.append(((Expression)object)._trueList);
            this._falseList.append(((Expression)object)._falseList);
            ++n2;
        }
        object2 = instructionList.append(methodGenerator.storeCurrentNode());
        this.backPatchTrueList((InstructionHandle)object2);
        object = instructionList.append(new GOTO(null));
        object2 = instructionList.append(methodGenerator.storeCurrentNode());
        this.backPatchFalseList((InstructionHandle)object2);
        this._falseList.add(instructionList.append(new GOTO(null)));
        ((BranchHandle)object).setTarget(instructionList.append(InstructionConstants.NOP));
    }

    private void translateSimpleContext(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        LocalVariableGen localVariableGen = methodGenerator.addLocalVariable("step_pattern_tmp1", Util.getJCRefType("I"), instructionList.getEnd(), null);
        instructionList.append(new ISTORE(localVariableGen.getIndex()));
        if (!this._isEpsilon) {
            instructionList.append(new ILOAD(localVariableGen.getIndex()));
            this.translateKernel(classGenerator, methodGenerator);
        }
        instructionList.append(methodGenerator.loadCurrentNode());
        instructionList.append(methodGenerator.loadIterator());
        int n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.dom.MatchingIterator", "<init>", "(ILorg/apache/xml/dtm/DTMAxisIterator;)V");
        instructionList.append(new NEW(constantPoolGen.addClass("org.apache.xalan.xsltc.dom.MatchingIterator")));
        instructionList.append(InstructionConstants.DUP);
        instructionList.append(new ILOAD(localVariableGen.getIndex()));
        this._step.translate(classGenerator, methodGenerator);
        instructionList.append(new INVOKESPECIAL(n));
        instructionList.append(methodGenerator.loadDOM());
        instructionList.append(new ILOAD(localVariableGen.getIndex()));
        n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getParent", "(I)I");
        instructionList.append(new INVOKEINTERFACE(n, 2));
        instructionList.append(methodGenerator.setStartNode());
        instructionList.append(methodGenerator.storeIterator());
        instructionList.append(new ILOAD(localVariableGen.getIndex()));
        instructionList.append(methodGenerator.storeCurrentNode());
        Predicate predicate = (Predicate)this._predicates.elementAt(0);
        Expression expression = predicate.getExpr();
        expression.translateDesynthesized(classGenerator, methodGenerator);
        InstructionHandle instructionHandle = instructionList.append(methodGenerator.storeIterator());
        instructionList.append(methodGenerator.storeCurrentNode());
        expression.backPatchTrueList(instructionHandle);
        BranchHandle branchHandle = instructionList.append(new GOTO(null));
        instructionHandle = instructionList.append(methodGenerator.storeIterator());
        instructionList.append(methodGenerator.storeCurrentNode());
        expression.backPatchFalseList(instructionHandle);
        this._falseList.add(instructionList.append(new GOTO(null)));
        branchHandle.setTarget(instructionList.append(InstructionConstants.NOP));
    }

    private void translateGeneralContext(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        int n = 0;
        BranchHandle branchHandle = null;
        String string = this.getNextFieldName();
        LocalVariableGen localVariableGen = methodGenerator.addLocalVariable("step_pattern_tmp1", Util.getJCRefType("I"), instructionList.getEnd(), null);
        instructionList.append(new ISTORE(localVariableGen.getIndex()));
        LocalVariableGen localVariableGen2 = methodGenerator.addLocalVariable("step_pattern_tmp2", Util.getJCRefType("Lorg/apache/xml/dtm/DTMAxisIterator;"), instructionList.getEnd(), null);
        if (!classGenerator.isExternal()) {
            Field field = new Field(2, constantPoolGen.addUtf8(string), constantPoolGen.addUtf8("Lorg/apache/xml/dtm/DTMAxisIterator;"), null, constantPoolGen.getConstantPool());
            classGenerator.addField(field);
            n = constantPoolGen.addFieldref(classGenerator.getClassName(), string, "Lorg/apache/xml/dtm/DTMAxisIterator;");
            instructionList.append(classGenerator.loadTranslet());
            instructionList.append(new GETFIELD(n));
            instructionList.append(InstructionConstants.DUP);
            instructionList.append(new ASTORE(localVariableGen2.getIndex()));
            branchHandle = instructionList.append(new IFNONNULL(null));
            instructionList.append(classGenerator.loadTranslet());
        }
        this._step.translate(classGenerator, methodGenerator);
        instructionList.append(new ASTORE(localVariableGen2.getIndex()));
        if (!classGenerator.isExternal()) {
            instructionList.append(new ALOAD(localVariableGen2.getIndex()));
            instructionList.append(new PUTFIELD(n));
            branchHandle.setTarget(instructionList.append(InstructionConstants.NOP));
        }
        instructionList.append(methodGenerator.loadDOM());
        instructionList.append(new ILOAD(localVariableGen.getIndex()));
        int n2 = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getParent", "(I)I");
        instructionList.append(new INVOKEINTERFACE(n2, 2));
        instructionList.append(new ALOAD(localVariableGen2.getIndex()));
        instructionList.append(InstructionConstants.SWAP);
        instructionList.append(methodGenerator.setStartNode());
        LocalVariableGen localVariableGen3 = methodGenerator.addLocalVariable("step_pattern_tmp3", Util.getJCRefType("I"), instructionList.getEnd(), null);
        BranchHandle branchHandle2 = instructionList.append(new GOTO(null));
        InstructionHandle instructionHandle = instructionList.append(new ALOAD(localVariableGen2.getIndex()));
        InstructionHandle instructionHandle2 = instructionList.append(methodGenerator.nextNode());
        instructionList.append(InstructionConstants.DUP);
        instructionList.append(new ISTORE(localVariableGen3.getIndex()));
        this._falseList.add(instructionList.append(new IFLT(null)));
        instructionList.append(new ILOAD(localVariableGen3.getIndex()));
        instructionList.append(new ILOAD(localVariableGen.getIndex()));
        instructionList.append(new IF_ICMPLT(instructionHandle));
        instructionList.append(new ILOAD(localVariableGen3.getIndex()));
        instructionList.append(new ILOAD(localVariableGen.getIndex()));
        this._falseList.add(instructionList.append(new IF_ICMPNE(null)));
        branchHandle2.setTarget(instructionHandle2);
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        if (this.hasPredicates()) {
            switch (this._contextCase) {
                case 0: {
                    this.translateNoContext(classGenerator, methodGenerator);
                    break;
                }
                case 1: {
                    this.translateSimpleContext(classGenerator, methodGenerator);
                    break;
                }
                default: {
                    this.translateGeneralContext(classGenerator, methodGenerator);
                    break;
                }
            }
        } else if (this.isWildcard()) {
            instructionList.append(InstructionConstants.POP);
        } else {
            this.translateKernel(classGenerator, methodGenerator);
        }
    }
}

