/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Vector;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.FilterParentPath;
import org.apache.xalan.xsltc.compiler.ParentLocationPath;
import org.apache.xalan.xsltc.compiler.ParentPattern;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.Predicate;
import org.apache.xalan.xsltc.compiler.RelativeLocationPath;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.UnionPathExpr;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xml.dtm.Axis;

final class Step
extends RelativeLocationPath {
    private int _axis;
    private Vector _predicates;
    private boolean _hadPredicates = false;
    private int _nodeType;

    public Step(int n, int n2, Vector vector) {
        this._axis = n;
        this._nodeType = n2;
        this._predicates = vector;
    }

    public void setParser(Parser parser2) {
        super.setParser(parser2);
        if (this._predicates != null) {
            int n = this._predicates.size();
            int n2 = 0;
            while (n2 < n) {
                Predicate predicate = (Predicate)this._predicates.elementAt(n2);
                predicate.setParser(parser2);
                predicate.setParent(this);
                ++n2;
            }
        }
    }

    public int getAxis() {
        return this._axis;
    }

    public void setAxis(int n) {
        this._axis = n;
    }

    public int getNodeType() {
        return this._nodeType;
    }

    public Vector getPredicates() {
        return this._predicates;
    }

    public void addPredicates(Vector vector) {
        if (this._predicates == null) {
            this._predicates = vector;
        } else {
            this._predicates.addAll(vector);
        }
    }

    private boolean hasParentPattern() {
        SyntaxTreeNode syntaxTreeNode = this.getParent();
        return syntaxTreeNode instanceof ParentPattern || syntaxTreeNode instanceof ParentLocationPath || syntaxTreeNode instanceof UnionPathExpr || syntaxTreeNode instanceof FilterParentPath;
    }

    private boolean hasPredicates() {
        return this._predicates != null && this._predicates.size() > 0;
    }

    private boolean isPredicate() {
        SyntaxTreeNode syntaxTreeNode = this;
        while (syntaxTreeNode != null) {
            if (!((syntaxTreeNode = syntaxTreeNode.getParent()) instanceof Predicate)) continue;
            return true;
        }
        return false;
    }

    public boolean isAbbreviatedDot() {
        return this._nodeType == -1 && this._axis == 13;
    }

    public boolean isAbbreviatedDDot() {
        return this._nodeType == -1 && this._axis == 10;
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        this._hadPredicates = this.hasPredicates();
        this._type = this.isAbbreviatedDot() ? (this.hasParentPattern() || this.hasPredicates() ? Type.NodeSet : Type.Node) : Type.NodeSet;
        if (this._predicates != null) {
            int n = this._predicates.size();
            int n2 = 0;
            while (n2 < n) {
                Expression expression = (Expression)this._predicates.elementAt(n2);
                expression.typeCheck(symbolTable);
                ++n2;
            }
        }
        return this._type;
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        if (this.hasPredicates()) {
            this.translatePredicates(classGenerator, methodGenerator);
        } else {
            if (this._axis == 2 && this._nodeType != 2 && this._nodeType != -1 && !this.hasParentPattern()) {
                int n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getTypedAxisIterator", "(II)Lorg/apache/xml/dtm/DTMAxisIterator;");
                instructionList.append(methodGenerator.loadDOM());
                instructionList.append(new PUSH(constantPoolGen, 2));
                instructionList.append(new PUSH(constantPoolGen, this._nodeType));
                instructionList.append(new INVOKEINTERFACE(n, 3));
                return;
            }
            if (this.isAbbreviatedDot()) {
                if (this._type == Type.Node) {
                    instructionList.append(methodGenerator.loadContextNode());
                } else {
                    int n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.dom.SingletonIterator", "<init>", "(I)V");
                    instructionList.append(new NEW(constantPoolGen.addClass("org.apache.xalan.xsltc.dom.SingletonIterator")));
                    instructionList.append(InstructionConstants.DUP);
                    instructionList.append(methodGenerator.loadContextNode());
                    instructionList.append(new INVOKESPECIAL(n));
                }
                return;
            }
            SyntaxTreeNode syntaxTreeNode = this.getParent();
            if (syntaxTreeNode instanceof ParentLocationPath && syntaxTreeNode.getParent() instanceof ParentLocationPath && this._nodeType == 1 && !this._hadPredicates) {
                this._nodeType = -1;
            }
            switch (this._nodeType) {
                case 2: {
                    this._axis = 2;
                }
                case -1: {
                    int n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getAxisIterator", "(I)Lorg/apache/xml/dtm/DTMAxisIterator;");
                    instructionList.append(methodGenerator.loadDOM());
                    instructionList.append(new PUSH(constantPoolGen, this._axis));
                    instructionList.append(new INVOKEINTERFACE(n, 2));
                    break;
                }
                default: {
                    XSLTC xSLTC = this.getParser().getXSLTC();
                    Vector vector = xSLTC.getNamesIndex();
                    String string = null;
                    int n = 0;
                    if (this._nodeType >= 14) {
                        string = (String)vector.elementAt(this._nodeType - 14);
                        n = string.lastIndexOf(42);
                    }
                    if (n > 1) {
                        String string2 = this._axis == 2 ? string.substring(0, n - 2) : string.substring(0, n - 1);
                        int n2 = xSLTC.registerNamespace(string2);
                        int n3 = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getNamespaceAxisIterator", "(II)Lorg/apache/xml/dtm/DTMAxisIterator;");
                        instructionList.append(methodGenerator.loadDOM());
                        instructionList.append(new PUSH(constantPoolGen, this._axis));
                        instructionList.append(new PUSH(constantPoolGen, n2));
                        instructionList.append(new INVOKEINTERFACE(n3, 3));
                        break;
                    }
                }
                case 1: {
                    int n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getTypedAxisIterator", "(II)Lorg/apache/xml/dtm/DTMAxisIterator;");
                    instructionList.append(methodGenerator.loadDOM());
                    instructionList.append(new PUSH(constantPoolGen, this._axis));
                    instructionList.append(new PUSH(constantPoolGen, this._nodeType));
                    instructionList.append(new INVOKEINTERFACE(n, 3));
                }
            }
        }
    }

    public void translatePredicates(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        int n = 0;
        if (this._predicates.size() == 0) {
            this.translate(classGenerator, methodGenerator);
        } else {
            Predicate predicate = (Predicate)this._predicates.lastElement();
            this._predicates.remove(predicate);
            if (predicate.isNodeValueTest()) {
                Step step = predicate.getStep();
                instructionList.append(methodGenerator.loadDOM());
                if (step.isAbbreviatedDot()) {
                    this.translate(classGenerator, methodGenerator);
                    instructionList.append(new ICONST(0));
                } else {
                    ParentLocationPath parentLocationPath = new ParentLocationPath(this, step);
                    try {
                        parentLocationPath.typeCheck(this.getParser().getSymbolTable());
                    }
                    catch (TypeCheckError typeCheckError) {
                        // empty catch block
                    }
                    parentLocationPath.translate(classGenerator, methodGenerator);
                    instructionList.append(new ICONST(1));
                }
                predicate.translate(classGenerator, methodGenerator);
                n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getNodeValueIterator", "(Lorg/apache/xml/dtm/DTMAxisIterator;ILjava/lang/String;Z)Lorg/apache/xml/dtm/DTMAxisIterator;");
                instructionList.append(new INVOKEINTERFACE(n, 5));
            } else if (predicate.isNthDescendant()) {
                instructionList.append(methodGenerator.loadDOM());
                instructionList.append(new ICONST(1));
                predicate.translate(classGenerator, methodGenerator);
                instructionList.append(new ICONST(0));
                n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getNthDescendant", "(IIZ)Lorg/apache/xml/dtm/DTMAxisIterator;");
                instructionList.append(new INVOKEINTERFACE(n, 4));
            } else if (predicate.isNthPositionFilter()) {
                n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.dom.NthIterator", "<init>", "(Lorg/apache/xml/dtm/DTMAxisIterator;I)V");
                instructionList.append(new NEW(constantPoolGen.addClass("org.apache.xalan.xsltc.dom.NthIterator")));
                instructionList.append(InstructionConstants.DUP);
                this.translatePredicates(classGenerator, methodGenerator);
                predicate.translate(classGenerator, methodGenerator);
                instructionList.append(new INVOKESPECIAL(n));
            } else {
                n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.dom.CurrentNodeListIterator", "<init>", "(Lorg/apache/xml/dtm/DTMAxisIterator;Lorg/apache/xalan/xsltc/dom/CurrentNodeListFilter;ILorg/apache/xalan/xsltc/runtime/AbstractTranslet;)V");
                instructionList.append(new NEW(constantPoolGen.addClass("org.apache.xalan.xsltc.dom.CurrentNodeListIterator")));
                instructionList.append(InstructionConstants.DUP);
                this.translatePredicates(classGenerator, methodGenerator);
                predicate.translateFilter(classGenerator, methodGenerator);
                instructionList.append(methodGenerator.loadCurrentNode());
                instructionList.append(classGenerator.loadTranslet());
                if (classGenerator.isExternal()) {
                    String string = classGenerator.getClassName();
                    instructionList.append(new CHECKCAST(constantPoolGen.addClass(string)));
                }
                instructionList.append(new INVOKESPECIAL(n));
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("step(\"");
        stringBuffer.append(Axis.names[this._axis]).append("\", ").append(this._nodeType);
        if (this._predicates != null) {
            int n = this._predicates.size();
            int n2 = 0;
            while (n2 < n) {
                Predicate predicate = (Predicate)this._predicates.elementAt(n2);
                stringBuffer.append(", ").append(predicate.toString());
                ++n2;
            }
        }
        return stringBuffer.append(')').toString();
    }
}

