/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.xalan.xsltc.compiler.ApplyTemplates;
import org.apache.xalan.xsltc.compiler.AttributeValue;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.Closure;
import org.apache.xalan.xsltc.compiler.Constants;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.ForEach;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.VariableBase;
import org.apache.xalan.xsltc.compiler.VariableRef;
import org.apache.xalan.xsltc.compiler.VariableRefBase;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.CompareGenerator;
import org.apache.xalan.xsltc.compiler.util.IntType;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.NodeSortRecordFactGenerator;
import org.apache.xalan.xsltc.compiler.util.NodeSortRecordGenerator;
import org.apache.xalan.xsltc.compiler.util.StringType;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class Sort
extends Instruction
implements Closure {
    private Expression _select;
    private AttributeValue _order;
    private AttributeValue _caseOrder;
    private AttributeValue _dataType;
    private String _data = null;
    public String _lang;
    public String _country;
    private String _className = null;
    private ArrayList _closureVars = null;
    private boolean _needsSortRecordFactory = false;

    Sort() {
    }

    public boolean inInnerClass() {
        return this._className != null;
    }

    public Closure getParentClosure() {
        return null;
    }

    public String getInnerClassName() {
        return this._className;
    }

    public void addVariable(VariableRefBase variableRefBase) {
        if (this._closureVars == null) {
            this._closureVars = new ArrayList();
        }
        if (!this._closureVars.contains(variableRefBase)) {
            this._closureVars.add(variableRefBase);
            this._needsSortRecordFactory = true;
        }
    }

    private void setInnerClassName(String string) {
        this._className = string;
    }

    public void parseContents(Parser parser2) {
        Object object;
        SyntaxTreeNode syntaxTreeNode = this.getParent();
        if (!(syntaxTreeNode instanceof ApplyTemplates) && !(syntaxTreeNode instanceof ForEach)) {
            this.reportError(this, parser2, "STRAY_SORT_ERR", null);
            return;
        }
        this._select = parser2.parseExpression(this, "select", "string(.)");
        String string = this.getAttribute("order");
        if (string.length() == 0) {
            string = "ascending";
        }
        this._order = AttributeValue.create(this, string, parser2);
        string = this.getAttribute("case-order");
        if (string.length() == 0) {
            string = "upper-first";
        }
        this._caseOrder = AttributeValue.create(this, string, parser2);
        string = this.getAttribute("data-type");
        if (string.length() == 0) {
            try {
                object = this._select.typeCheck(parser2.getSymbolTable());
                string = object instanceof IntType ? "number" : "text";
            }
            catch (TypeCheckError typeCheckError) {
                string = "text";
            }
        }
        this._dataType = AttributeValue.create(this, string, parser2);
        string = this.getAttribute("lang");
        if (string != null) {
            try {
                object = new StringTokenizer(string, "-", false);
                this._lang = ((StringTokenizer)object).nextToken();
                this._country = ((StringTokenizer)object).nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        Type type = this._select.typeCheck(symbolTable);
        if (!(type instanceof StringType)) {
            this._select = new CastExpr(this._select, Type.String);
        }
        this._order.typeCheck(symbolTable);
        this._caseOrder.typeCheck(symbolTable);
        this._dataType.typeCheck(symbolTable);
        return Type.Void;
    }

    public void translateSortType(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        this._dataType.translate(classGenerator, methodGenerator);
    }

    public void translateSortOrder(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        this._order.translate(classGenerator, methodGenerator);
    }

    public void translateSelect(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        this._select.translate(classGenerator, methodGenerator);
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
    }

    public static void translateSortIterator(ClassGenerator classGenerator, MethodGenerator methodGenerator, Expression expression, Vector vector) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        int n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.dom.SortingIterator", "<init>", "(Lorg/apache/xml/dtm/DTMAxisIterator;Lorg/apache/xalan/xsltc/dom/NodeSortRecordFactory;)V");
        instructionList.append(new NEW(constantPoolGen.addClass("org.apache.xalan.xsltc.dom.SortingIterator")));
        instructionList.append(InstructionConstants.DUP);
        if (expression == null) {
            int n2 = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getAxisIterator", "(I)Lorg/apache/xml/dtm/DTMAxisIterator;");
            instructionList.append(methodGenerator.loadDOM());
            instructionList.append(new PUSH(constantPoolGen, 3));
            instructionList.append(new INVOKEINTERFACE(n2, 2));
        } else {
            expression.translate(classGenerator, methodGenerator);
        }
        Sort.compileSortRecordFactory(vector, classGenerator, methodGenerator);
        instructionList.append(new INVOKESPECIAL(n));
    }

    public static void compileSortRecordFactory(Vector vector, ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        Object object;
        Object object2;
        String string = Sort.compileSortRecord(vector, classGenerator, methodGenerator);
        boolean bl = false;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            object2 = (Sort)vector.elementAt(n2);
            bl |= ((Sort)object2)._needsSortRecordFactory;
            ++n2;
        }
        object2 = "org/apache/xalan/xsltc/dom/NodeSortRecordFactory";
        if (bl) {
            object2 = Sort.compileSortRecordFactory(vector, classGenerator, methodGenerator, string);
        }
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        instructionList.append(new NEW(constantPoolGen.addClass((String)object2)));
        instructionList.append(InstructionConstants.DUP);
        instructionList.append(methodGenerator.loadDOM());
        instructionList.append(new PUSH(constantPoolGen, string));
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new PUSH(constantPoolGen, n));
        instructionList.append(new ANEWARRAY(constantPoolGen.addClass("java.lang.String")));
        int n3 = 0;
        while (n3 < n) {
            Sort sort = (Sort)vector.elementAt(n3);
            instructionList.append(InstructionConstants.DUP);
            instructionList.append(new PUSH(constantPoolGen, n3));
            sort.translateSortOrder(classGenerator, methodGenerator);
            instructionList.append(InstructionConstants.AASTORE);
            ++n3;
        }
        instructionList.append(new PUSH(constantPoolGen, n));
        instructionList.append(new ANEWARRAY(constantPoolGen.addClass("java.lang.String")));
        int n4 = 0;
        while (n4 < n) {
            object = (Sort)vector.elementAt(n4);
            instructionList.append(InstructionConstants.DUP);
            instructionList.append(new PUSH(constantPoolGen, n4));
            ((Sort)object).translateSortType(classGenerator, methodGenerator);
            instructionList.append(InstructionConstants.AASTORE);
            ++n4;
        }
        instructionList.append(new INVOKESPECIAL(constantPoolGen.addMethodref((String)object2, "<init>", "(Lorg/apache/xalan/xsltc/DOM;Ljava/lang/String;Lorg/apache/xalan/xsltc/Translet;[Ljava/lang/String;[Ljava/lang/String;)V")));
        object = new ArrayList();
        int n5 = 0;
        while (n5 < n) {
            Sort sort = (Sort)vector.get(n5);
            int n6 = sort._closureVars == null ? 0 : sort._closureVars.size();
            int n7 = 0;
            while (n7 < n6) {
                VariableRefBase variableRefBase = (VariableRefBase)sort._closureVars.get(n7);
                if (!((ArrayList)object).contains(variableRefBase)) {
                    VariableBase variableBase = variableRefBase.getVariable();
                    instructionList.append(InstructionConstants.DUP);
                    instructionList.append(variableBase.loadInstruction());
                    instructionList.append(new PUTFIELD(constantPoolGen.addFieldref((String)object2, variableBase.getVariable(), variableBase.getType().toSignature())));
                    ((ArrayList)object).add(variableRefBase);
                }
                ++n7;
            }
            ++n5;
        }
    }

    public static String compileSortRecordFactory(Vector vector, ClassGenerator classGenerator, MethodGenerator methodGenerator, String string) {
        Constants constants;
        Constants constants2;
        org.apache.bcel.generic.Type[] typeArray;
        XSLTC xSLTC = ((Sort)vector.firstElement()).getXSLTC();
        String string2 = xSLTC.getHelperClassName();
        NodeSortRecordFactGenerator nodeSortRecordFactGenerator = new NodeSortRecordFactGenerator(string2, "org/apache/xalan/xsltc/dom/NodeSortRecordFactory", string2 + ".java", 49, new String[0], classGenerator.getStylesheet());
        ConstantPoolGen constantPoolGen = nodeSortRecordFactGenerator.getConstantPool();
        int n = vector.size();
        ArrayList<VariableRef> arrayList = new ArrayList<VariableRef>();
        int n2 = 0;
        while (n2 < n) {
            typeArray = (Sort)vector.get(n2);
            int n3 = typeArray._closureVars == null ? 0 : typeArray._closureVars.size();
            int n4 = 0;
            while (n4 < n3) {
                constants2 = (VariableRef)typeArray._closureVars.get(n4);
                if (!arrayList.contains(constants2)) {
                    constants = ((VariableRefBase)constants2).getVariable();
                    nodeSortRecordFactGenerator.addField(new Field(1, constantPoolGen.addUtf8(((VariableBase)constants).getVariable()), constantPoolGen.addUtf8(((VariableBase)constants).getType().toSignature()), null, constantPoolGen.getConstantPool()));
                    arrayList.add((VariableRef)constants2);
                }
                ++n4;
            }
            ++n2;
        }
        typeArray = new org.apache.bcel.generic.Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), Util.getJCRefType("Ljava/lang/String;"), Util.getJCRefType("Lorg/apache/xalan/xsltc/Translet;"), Util.getJCRefType("[Ljava/lang/String;"), Util.getJCRefType("[Ljava/lang/String;")};
        String[] stringArray = new String[]{"document", "className", "translet", "order", "type"};
        InstructionList instructionList = new InstructionList();
        constants2 = new MethodGenerator(1, org.apache.bcel.generic.Type.VOID, typeArray, stringArray, "<init>", string2, instructionList, constantPoolGen);
        instructionList.append(InstructionConstants.ALOAD_0);
        instructionList.append(InstructionConstants.ALOAD_1);
        instructionList.append(InstructionConstants.ALOAD_2);
        instructionList.append(new ALOAD(3));
        instructionList.append(new ALOAD(4));
        instructionList.append(new ALOAD(5));
        instructionList.append(new INVOKESPECIAL(constantPoolGen.addMethodref("org/apache/xalan/xsltc/dom/NodeSortRecordFactory", "<init>", "(Lorg/apache/xalan/xsltc/DOM;Ljava/lang/String;Lorg/apache/xalan/xsltc/Translet;[Ljava/lang/String;[Ljava/lang/String;)V")));
        instructionList.append(InstructionConstants.RETURN);
        instructionList = new InstructionList();
        constants = new MethodGenerator(1, Util.getJCRefType("Lorg/apache/xalan/xsltc/dom/NodeSortRecord;"), new org.apache.bcel.generic.Type[]{org.apache.bcel.generic.Type.INT, org.apache.bcel.generic.Type.INT}, new String[]{"node", "last"}, "makeNodeSortRecord", string2, instructionList, constantPoolGen);
        instructionList.append(InstructionConstants.ALOAD_0);
        instructionList.append(InstructionConstants.ILOAD_1);
        instructionList.append(InstructionConstants.ILOAD_2);
        instructionList.append(new INVOKESPECIAL(constantPoolGen.addMethodref("org/apache/xalan/xsltc/dom/NodeSortRecordFactory", "makeNodeSortRecord", "(II)Lorg/apache/xalan/xsltc/dom/NodeSortRecord;")));
        instructionList.append(InstructionConstants.DUP);
        instructionList.append(new CHECKCAST(constantPoolGen.addClass(string)));
        int n5 = arrayList.size();
        int n6 = 0;
        while (n6 < n5) {
            VariableRef variableRef = (VariableRef)arrayList.get(n6);
            VariableBase variableBase = variableRef.getVariable();
            Type type = variableBase.getType();
            instructionList.append(InstructionConstants.DUP);
            instructionList.append(InstructionConstants.ALOAD_0);
            instructionList.append(new GETFIELD(constantPoolGen.addFieldref(string2, variableBase.getVariable(), type.toSignature())));
            instructionList.append(new PUTFIELD(constantPoolGen.addFieldref(string, variableBase.getVariable(), type.toSignature())));
            ++n6;
        }
        instructionList.append(InstructionConstants.POP);
        instructionList.append(InstructionConstants.ARETURN);
        ((MethodGenerator)constants2).setMaxLocals();
        ((MethodGen)((Object)constants2)).setMaxStack();
        nodeSortRecordFactGenerator.addMethod(((MethodGen)((Object)constants2)).getMethod());
        ((MethodGenerator)constants).setMaxLocals();
        ((MethodGen)((Object)constants)).setMaxStack();
        nodeSortRecordFactGenerator.addMethod(((MethodGen)((Object)constants)).getMethod());
        xSLTC.dumpClass(nodeSortRecordFactGenerator.getJavaClass());
        return string2;
    }

    private static String compileSortRecord(Vector vector, ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        Object object;
        XSLTC xSLTC = ((Sort)vector.firstElement()).getXSLTC();
        String string = xSLTC.getHelperClassName();
        NodeSortRecordGenerator nodeSortRecordGenerator = new NodeSortRecordGenerator(string, "org.apache.xalan.xsltc.dom.NodeSortRecord", "sort$0.java", 49, new String[0], classGenerator.getStylesheet());
        ConstantPoolGen constantPoolGen = nodeSortRecordGenerator.getConstantPool();
        int n = vector.size();
        ArrayList<VariableRef> arrayList = new ArrayList<VariableRef>();
        int n2 = 0;
        while (n2 < n) {
            object = (Sort)vector.get(n2);
            super.setInnerClassName(string);
            int n3 = ((Sort)object)._closureVars == null ? 0 : ((Sort)object)._closureVars.size();
            int n4 = 0;
            while (n4 < n3) {
                VariableRef variableRef = (VariableRef)((Sort)object)._closureVars.get(n4);
                if (!arrayList.contains(variableRef)) {
                    VariableBase variableBase = variableRef.getVariable();
                    nodeSortRecordGenerator.addField(new Field(1, constantPoolGen.addUtf8(variableBase.getVariable()), constantPoolGen.addUtf8(variableBase.getType().toSignature()), null, constantPoolGen.getConstantPool()));
                    arrayList.add(variableRef);
                }
                ++n4;
            }
            ++n2;
        }
        object = Sort.compileInit(vector, nodeSortRecordGenerator, constantPoolGen, string);
        Method method = Sort.compileExtract(vector, nodeSortRecordGenerator, constantPoolGen, string);
        nodeSortRecordGenerator.addMethod((Method)object);
        nodeSortRecordGenerator.addMethod(method);
        xSLTC.dumpClass(nodeSortRecordGenerator.getJavaClass());
        return string;
    }

    private static Method compileInit(Vector vector, NodeSortRecordGenerator nodeSortRecordGenerator, ConstantPoolGen constantPoolGen, String string) {
        InstructionList instructionList = new InstructionList();
        MethodGenerator methodGenerator = new MethodGenerator(1, org.apache.bcel.generic.Type.VOID, null, null, "<init>", string, instructionList, constantPoolGen);
        instructionList.append(InstructionConstants.ALOAD_0);
        instructionList.append(new INVOKESPECIAL(constantPoolGen.addMethodref("org.apache.xalan.xsltc.dom.NodeSortRecord", "<init>", "()V")));
        int n = constantPoolGen.addMethodref("java/util/Locale", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V");
        int n2 = constantPoolGen.addMethodref("java/text/Collator", "getInstance", "(Ljava/util/Locale;)Ljava/text/Collator;");
        int n3 = constantPoolGen.addMethodref("java/text/Collator", "setStrength", "(I)V");
        int n4 = vector.size();
        String string2 = null;
        String string3 = null;
        Sort sort = (Sort)vector.elementAt(0);
        int n5 = 0;
        while (n5 < n4) {
            if (string2 == null && sort._lang != null) {
                string2 = sort._lang;
            }
            if (string3 == null && sort._country != null) {
                string3 = sort._country;
            }
            ++n5;
        }
        int n6 = constantPoolGen.addFieldref(string, "_collator", "Ljava/text/Collator;");
        int n7 = constantPoolGen.addFieldref(string, "_locale", "Ljava/util/Locale;");
        if (string2 != null) {
            instructionList.append(new NEW(constantPoolGen.addClass("java/util/Locale")));
            instructionList.append(InstructionConstants.DUP);
            instructionList.append(InstructionConstants.DUP);
            instructionList.append(new PUSH(constantPoolGen, string2));
            instructionList.append(new PUSH(constantPoolGen, string3 != null ? string3 : ""));
            instructionList.append(new INVOKESPECIAL(n));
            instructionList.append(InstructionConstants.ALOAD_0);
            instructionList.append(InstructionConstants.SWAP);
            instructionList.append(new PUTFIELD(n7));
            instructionList.append(new INVOKESTATIC(n2));
            instructionList.append(InstructionConstants.ALOAD_0);
            instructionList.append(InstructionConstants.SWAP);
            instructionList.append(new PUTFIELD(n6));
        }
        instructionList.append(InstructionConstants.ALOAD_0);
        instructionList.append(new GETFIELD(n6));
        instructionList.append(new ICONST(2));
        instructionList.append(new INVOKEVIRTUAL(n3));
        instructionList.append(InstructionConstants.RETURN);
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        return methodGenerator.getMethod();
    }

    private static Method compileExtract(Vector vector, NodeSortRecordGenerator nodeSortRecordGenerator, ConstantPoolGen constantPoolGen, String string) {
        Object object;
        InstructionList instructionList = new InstructionList();
        CompareGenerator compareGenerator = new CompareGenerator(17, org.apache.bcel.generic.Type.STRING, new org.apache.bcel.generic.Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), org.apache.bcel.generic.Type.INT, org.apache.bcel.generic.Type.INT, Util.getJCRefType("Lorg/apache/xalan/xsltc/runtime/AbstractTranslet;"), org.apache.bcel.generic.Type.INT}, new String[]{"dom", "current", "level", "translet", "last"}, "extractValueFromDOM", string, instructionList, constantPoolGen);
        int n = vector.size();
        int[] nArray = new int[n];
        InstructionHandle[] instructionHandleArray = new InstructionHandle[n];
        InstructionHandle instructionHandle = null;
        if (n > 1) {
            instructionList.append(new ILOAD(compareGenerator.getLocalIndex("level")));
            instructionHandle = instructionList.append(new NOP());
        }
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            object = (Sort)vector.elementAt(n2);
            instructionHandleArray[n2] = instructionList.append(InstructionConstants.NOP);
            ((Sort)object).translateSelect(nodeSortRecordGenerator, compareGenerator);
            instructionList.append(InstructionConstants.ARETURN);
            ++n2;
        }
        if (n > 1) {
            object = instructionList.append(new PUSH(constantPoolGen, ""));
            instructionList.insert(instructionHandle, new TABLESWITCH(nArray, instructionHandleArray, (InstructionHandle)object));
            instructionList.append(InstructionConstants.ARETURN);
        }
        compareGenerator.stripAttributes(true);
        compareGenerator.setMaxLocals();
        compareGenerator.setMaxStack();
        compareGenerator.removeNOPs();
        return compareGenerator.getMethod();
    }
}

