/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.GOTO_W;
import org.apache.bcel.generic.IFLT;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.SWITCH;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.InstructionFinder;
import org.apache.xalan.xsltc.compiler.AlternativePattern;
import org.apache.xalan.xsltc.compiler.Constants;
import org.apache.xalan.xsltc.compiler.IdKeyPattern;
import org.apache.xalan.xsltc.compiler.LocationPathPattern;
import org.apache.xalan.xsltc.compiler.Pattern;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.StepPattern;
import org.apache.xalan.xsltc.compiler.Stylesheet;
import org.apache.xalan.xsltc.compiler.Template;
import org.apache.xalan.xsltc.compiler.TestSeq;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.NamedMethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Util;

final class Mode
implements Constants {
    private final QName _name;
    private final Stylesheet _stylesheet;
    private final String _methodName;
    private Vector _templates;
    private Vector _childNodeGroup = null;
    private TestSeq _childNodeTestSeq = null;
    private Vector _attribNodeGroup = null;
    private TestSeq _attribNodeTestSeq = null;
    private Vector _idxGroup = null;
    private TestSeq _idxTestSeq = null;
    private Vector[] _patternGroups;
    private TestSeq[] _testSeq;
    private Hashtable _preCompiled = new Hashtable();
    private Hashtable _neededTemplates = new Hashtable();
    private Hashtable _namedTemplates = new Hashtable();
    private Hashtable _templateIHs = new Hashtable();
    private Hashtable _templateILs = new Hashtable();
    private LocationPathPattern _rootPattern = null;
    private Hashtable _importLevels = null;
    private Hashtable _keys = null;
    private int _currentIndex;

    public Mode(QName qName, Stylesheet stylesheet, String string) {
        this._name = qName;
        this._stylesheet = stylesheet;
        this._methodName = "applyTemplates" + string;
        this._templates = new Vector();
        this._patternGroups = new Vector[32];
    }

    public String functionName() {
        return this._methodName;
    }

    public String functionName(int n, int n2) {
        if (this._importLevels == null) {
            this._importLevels = new Hashtable();
        }
        this._importLevels.put(new Integer(n2), new Integer(n));
        return this._methodName + '_' + n2;
    }

    public void addInstructionList(Pattern pattern, InstructionList instructionList) {
        this._preCompiled.put(pattern, instructionList);
    }

    public InstructionList getInstructionList(Pattern pattern) {
        return (InstructionList)this._preCompiled.get(pattern);
    }

    private String getClassName() {
        return this._stylesheet.getClassName();
    }

    public Stylesheet getStylesheet() {
        return this._stylesheet;
    }

    public void addTemplate(Template template) {
        this._templates.addElement(template);
    }

    private Vector quicksort(Vector vector, int n, int n2) {
        if (n < n2) {
            int n3 = this.partition(vector, n, n2);
            this.quicksort(vector, n, n3);
            this.quicksort(vector, n3 + 1, n2);
        }
        return vector;
    }

    private int partition(Vector vector, int n, int n2) {
        Template template = (Template)vector.elementAt(n);
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (template.compareTo((Template)vector.elementAt(--n4)) > 0) {
                continue;
            }
            while (template.compareTo((Template)vector.elementAt(++n3)) < 0) {
            }
            if (n3 >= n4) break;
            vector.set(n4, vector.set(n3, vector.elementAt(n4)));
        }
        return n4;
    }

    public void processPatterns(Hashtable hashtable) {
        this._keys = hashtable;
        this._templates = this.quicksort(this._templates, 0, this._templates.size() - 1);
        Enumeration enumeration = this._templates.elements();
        while (enumeration.hasMoreElements()) {
            Pattern pattern;
            Template template = (Template)enumeration.nextElement();
            if (template.isNamed() && !template.disabled()) {
                this._namedTemplates.put(template, this);
            }
            if ((pattern = template.getPattern()) == null) continue;
            this.flattenAlternative(pattern, template, hashtable);
        }
        this.prepareTestSequences();
    }

    private void flattenAlternative(Pattern pattern, Template template, Hashtable hashtable) {
        if (pattern instanceof IdKeyPattern) {
            IdKeyPattern idKeyPattern = (IdKeyPattern)pattern;
            idKeyPattern.setTemplate(template);
            if (this._idxGroup == null) {
                this._idxGroup = new Vector();
            }
            this._idxGroup.add(pattern);
        } else if (pattern instanceof AlternativePattern) {
            AlternativePattern alternativePattern = (AlternativePattern)pattern;
            this.flattenAlternative(alternativePattern.getLeft(), template, hashtable);
            this.flattenAlternative(alternativePattern.getRight(), template, hashtable);
        } else if (pattern instanceof LocationPathPattern) {
            LocationPathPattern locationPathPattern = (LocationPathPattern)pattern;
            locationPathPattern.setTemplate(template);
            this.addPatternToGroup(locationPathPattern);
        }
    }

    private void addPatternToGroup(LocationPathPattern locationPathPattern) {
        if (locationPathPattern instanceof IdKeyPattern) {
            this.addPattern(-1, locationPathPattern);
        } else {
            StepPattern stepPattern = locationPathPattern.getKernelPattern();
            if (stepPattern != null) {
                this.addPattern(stepPattern.getNodeType(), locationPathPattern);
            } else if (this._rootPattern == null || locationPathPattern.noSmallerThan(this._rootPattern)) {
                this._rootPattern = locationPathPattern;
            }
        }
    }

    private void addPattern(int n, LocationPathPattern locationPathPattern) {
        Object object;
        int n2 = this._patternGroups.length;
        if (n >= n2) {
            object = new Vector[n * 2];
            System.arraycopy(this._patternGroups, 0, object, 0, n2);
            this._patternGroups = object;
        }
        if (n == -1) {
            object = locationPathPattern.getAxis() == 2 ? (this._attribNodeGroup == null ? (this._attribNodeGroup = new Vector(2)) : this._attribNodeGroup) : (this._childNodeGroup == null ? (this._childNodeGroup = new Vector(2)) : this._childNodeGroup);
        } else {
            Object object2 = object = this._patternGroups[n] == null ? new Vector(2) : this._patternGroups[n];
        }
        if (((Vector)object).size() == 0) {
            ((Vector)object).addElement(locationPathPattern);
        } else {
            boolean bl = false;
            int n3 = 0;
            while (n3 < ((Vector)object).size()) {
                LocationPathPattern locationPathPattern2 = (LocationPathPattern)((Vector)object).elementAt(n3);
                if (locationPathPattern.noSmallerThan(locationPathPattern2)) {
                    bl = true;
                    ((Vector)object).insertElementAt(locationPathPattern, n3);
                    break;
                }
                ++n3;
            }
            if (!bl) {
                ((Vector)object).addElement(locationPathPattern);
            }
        }
    }

    private void completeTestSequences(int n, Vector vector) {
        if (vector != null) {
            if (this._patternGroups[n] == null) {
                this._patternGroups[n] = vector;
            } else {
                int n2 = vector.size();
                int n3 = 0;
                while (n3 < n2) {
                    this.addPattern(n, (LocationPathPattern)vector.elementAt(n3));
                    ++n3;
                }
            }
        }
    }

    private void prepareTestSequences() {
        Object object;
        int n;
        int n2;
        Vector vector = this._patternGroups[1];
        Vector vector2 = this._patternGroups[2];
        this.completeTestSequences(3, this._childNodeGroup);
        this.completeTestSequences(1, this._childNodeGroup);
        this.completeTestSequences(7, this._childNodeGroup);
        this.completeTestSequences(8, this._childNodeGroup);
        this.completeTestSequences(2, this._attribNodeGroup);
        Vector vector3 = this._stylesheet.getXSLTC().getNamesIndex();
        if (vector != null || vector2 != null || this._childNodeGroup != null || this._attribNodeGroup != null) {
            n2 = this._patternGroups.length;
            n = 14;
            while (n < n2) {
                if (this._patternGroups[n] != null) {
                    object = (String)vector3.elementAt(n - 14);
                    if (Mode.isAttributeName((String)object)) {
                        this.completeTestSequences(n, vector2);
                        this.completeTestSequences(n, this._attribNodeGroup);
                    } else {
                        this.completeTestSequences(n, vector);
                        this.completeTestSequences(n, this._childNodeGroup);
                    }
                }
                ++n;
            }
        }
        this._testSeq = new TestSeq[14 + vector3.size()];
        n2 = this._patternGroups.length;
        n = 0;
        while (n < n2) {
            object = this._patternGroups[n];
            if (object != null) {
                TestSeq testSeq = new TestSeq((Vector)object, n, this);
                testSeq.reduce();
                this._testSeq[n] = testSeq;
                testSeq.findTemplates(this._neededTemplates);
            }
            ++n;
        }
        if (this._childNodeGroup != null && this._childNodeGroup.size() > 0) {
            this._childNodeTestSeq = new TestSeq(this._childNodeGroup, -1, this);
            this._childNodeTestSeq.reduce();
            this._childNodeTestSeq.findTemplates(this._neededTemplates);
        }
        if (this._idxGroup != null && this._idxGroup.size() > 0) {
            this._idxTestSeq = new TestSeq(this._idxGroup, this);
            this._idxTestSeq.reduce();
            this._idxTestSeq.findTemplates(this._neededTemplates);
        }
        if (this._rootPattern != null) {
            this._neededTemplates.put(this._rootPattern.getTemplate(), this);
        }
    }

    private void compileNamedTemplate(Template template, ClassGenerator classGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = new InstructionList();
        String string = Util.escape(template.getName().toString());
        NamedMethodGenerator namedMethodGenerator = new NamedMethodGenerator(1, Type.VOID, new Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), Util.getJCRefType("Lorg/apache/xml/dtm/DTMAxisIterator;"), Util.getJCRefType("Lorg/apache/xml/serializer/SerializationHandler;"), Type.INT}, new String[]{"document", "iterator", "handler", "node"}, string, this.getClassName(), instructionList, constantPoolGen);
        instructionList.append(template.compile(classGenerator, namedMethodGenerator));
        instructionList.append(InstructionConstants.RETURN);
        namedMethodGenerator.stripAttributes(true);
        namedMethodGenerator.setMaxLocals();
        namedMethodGenerator.setMaxStack();
        namedMethodGenerator.removeNOPs();
        classGenerator.addMethod(namedMethodGenerator.getMethod());
    }

    private void compileTemplates(ClassGenerator classGenerator, MethodGenerator methodGenerator, InstructionHandle instructionHandle) {
        Template template;
        Enumeration enumeration = this._namedTemplates.keys();
        while (enumeration.hasMoreElements()) {
            template = (Template)enumeration.nextElement();
            this.compileNamedTemplate(template, classGenerator);
        }
        enumeration = this._neededTemplates.keys();
        while (enumeration.hasMoreElements()) {
            template = (Template)enumeration.nextElement();
            if (template.hasContents()) {
                InstructionList instructionList = template.compile(classGenerator, methodGenerator);
                instructionList.append(new GOTO_W(instructionHandle));
                this._templateILs.put(template, instructionList);
                this._templateIHs.put(template, instructionList.getStart());
                continue;
            }
            this._templateIHs.put(template, instructionHandle);
        }
    }

    private void appendTemplateCode(InstructionList instructionList) {
        Enumeration enumeration = this._neededTemplates.keys();
        while (enumeration.hasMoreElements()) {
            Object v = this._templateILs.get(enumeration.nextElement());
            if (v == null) continue;
            instructionList.append((InstructionList)v);
        }
    }

    private void appendTestSequences(InstructionList instructionList) {
        int n = this._testSeq.length;
        int n2 = 0;
        while (n2 < n) {
            InstructionList instructionList2;
            TestSeq testSeq = this._testSeq[n2];
            if (testSeq != null && (instructionList2 = testSeq.getInstructionList()) != null) {
                instructionList.append(instructionList2);
            }
            ++n2;
        }
    }

    public static void compileGetChildren(ClassGenerator classGenerator, MethodGenerator methodGenerator, int n) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        int n2 = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getChildren", "(I)Lorg/apache/xml/dtm/DTMAxisIterator;");
        instructionList.append(methodGenerator.loadDOM());
        instructionList.append(new ILOAD(n));
        instructionList.append(new INVOKEINTERFACE(n2, 2));
    }

    private InstructionList compileDefaultRecursion(ClassGenerator classGenerator, MethodGenerator methodGenerator, InstructionHandle instructionHandle) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = new InstructionList();
        String string = classGenerator.getApplyTemplatesSig();
        int n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getChildren", "(I)Lorg/apache/xml/dtm/DTMAxisIterator;");
        int n2 = constantPoolGen.addMethodref(this.getClassName(), this.functionName(), string);
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(methodGenerator.loadDOM());
        instructionList.append(methodGenerator.loadDOM());
        instructionList.append(new ILOAD(this._currentIndex));
        instructionList.append(new INVOKEINTERFACE(n, 2));
        instructionList.append(methodGenerator.loadHandler());
        instructionList.append(new INVOKEVIRTUAL(n2));
        instructionList.append(new GOTO_W(instructionHandle));
        return instructionList;
    }

    private InstructionList compileDefaultText(ClassGenerator classGenerator, MethodGenerator methodGenerator, InstructionHandle instructionHandle) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = new InstructionList();
        int n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "characters", "(ILorg/apache/xml/serializer/SerializationHandler;)V");
        instructionList.append(methodGenerator.loadDOM());
        instructionList.append(new ILOAD(this._currentIndex));
        instructionList.append(methodGenerator.loadHandler());
        instructionList.append(new INVOKEINTERFACE(n, 3));
        instructionList.append(new GOTO_W(instructionHandle));
        return instructionList;
    }

    private InstructionList compileNamespaces(ClassGenerator classGenerator, MethodGenerator methodGenerator, boolean[] blArray, boolean[] blArray2, boolean bl, InstructionHandle instructionHandle) {
        XSLTC xSLTC = classGenerator.getParser().getXSLTC();
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        Vector vector = xSLTC.getNamespaceIndex();
        Vector vector2 = xSLTC.getNamesIndex();
        int n = vector.size() + 1;
        int n2 = vector2.size();
        InstructionList instructionList = new InstructionList();
        int[] nArray = new int[n];
        InstructionHandle[] instructionHandleArray = new InstructionHandle[nArray.length];
        if (n > 0) {
            boolean bl2 = false;
            int n3 = 0;
            while (n3 < n) {
                instructionHandleArray[n3] = instructionHandle;
                nArray[n3] = n3;
                ++n3;
            }
            int n4 = 14;
            while (n4 < 14 + n2) {
                if (blArray[n4] && blArray2[n4] == bl) {
                    String string = (String)vector2.elementAt(n4 - 14);
                    String string2 = string.substring(0, string.lastIndexOf(58));
                    int n5 = xSLTC.registerNamespace(string2);
                    if (n4 < this._testSeq.length && this._testSeq[n4] != null) {
                        instructionHandleArray[n5] = this._testSeq[n4].compile(classGenerator, methodGenerator, instructionHandle);
                        bl2 = true;
                    }
                }
                ++n4;
            }
            if (!bl2) {
                return null;
            }
            int n6 = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getNamespaceType", "(I)I");
            instructionList.append(methodGenerator.loadDOM());
            instructionList.append(new ILOAD(this._currentIndex));
            instructionList.append(new INVOKEINTERFACE(n6, 2));
            instructionList.append(new SWITCH(nArray, instructionHandleArray, instructionHandle));
            return instructionList;
        }
        return null;
    }

    public void compileApplyTemplates(ClassGenerator classGenerator) {
        Object object;
        int n;
        Object object2;
        XSLTC xSLTC = classGenerator.getParser().getXSLTC();
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        Vector vector = xSLTC.getNamesIndex();
        Type[] typeArray = new Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), Util.getJCRefType("Lorg/apache/xml/dtm/DTMAxisIterator;"), Util.getJCRefType("Lorg/apache/xml/serializer/SerializationHandler;")};
        String[] stringArray = new String[]{"document", "iterator", "handler"};
        InstructionList instructionList = new InstructionList();
        MethodGenerator methodGenerator = new MethodGenerator(17, Type.VOID, typeArray, stringArray, this.functionName(), this.getClassName(), instructionList, classGenerator.getConstantPool());
        methodGenerator.addException("org.apache.xalan.xsltc.TransletException");
        LocalVariableGen localVariableGen = methodGenerator.addLocalVariable2("current", Type.INT, instructionList.getEnd());
        this._currentIndex = localVariableGen.getIndex();
        InstructionList instructionList2 = new InstructionList();
        instructionList2.append(InstructionConstants.NOP);
        InstructionList instructionList3 = new InstructionList();
        instructionList3.append(methodGenerator.loadIterator());
        instructionList3.append(methodGenerator.nextNode());
        instructionList3.append(InstructionConstants.DUP);
        instructionList3.append(new ISTORE(this._currentIndex));
        BranchHandle branchHandle = instructionList3.append(new IFLT(null));
        BranchHandle branchHandle2 = instructionList3.append(new GOTO_W(null));
        branchHandle.setTarget(instructionList3.append(InstructionConstants.RETURN));
        InstructionHandle instructionHandle = instructionList3.getStart();
        InstructionList instructionList4 = this.compileDefaultRecursion(classGenerator, methodGenerator, instructionHandle);
        InstructionHandle instructionHandle2 = instructionList4.getStart();
        InstructionList instructionList5 = this.compileDefaultText(classGenerator, methodGenerator, instructionHandle);
        InstructionHandle instructionHandle3 = instructionList5.getStart();
        int[] nArray = new int[14 + vector.size()];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = n2;
            ++n2;
        }
        boolean[] blArray = new boolean[nArray.length];
        boolean[] blArray2 = new boolean[nArray.length];
        int n3 = 0;
        while (n3 < vector.size()) {
            object2 = (String)vector.elementAt(n3);
            blArray[n3 + 14] = Mode.isAttributeName((String)object2);
            blArray2[n3 + 14] = Mode.isNamespaceName((String)object2);
            ++n3;
        }
        this.compileTemplates(classGenerator, methodGenerator, instructionHandle);
        object2 = this._testSeq[1];
        InstructionHandle instructionHandle4 = instructionHandle2;
        if (object2 != null) {
            instructionHandle4 = ((TestSeq)object2).compile(classGenerator, methodGenerator, instructionHandle2);
        }
        TestSeq testSeq = this._testSeq[2];
        InstructionHandle instructionHandle5 = instructionHandle3;
        if (testSeq != null) {
            instructionHandle5 = testSeq.compile(classGenerator, methodGenerator, instructionHandle5);
        }
        InstructionList instructionList6 = null;
        if (this._idxTestSeq != null) {
            branchHandle2.setTarget(this._idxTestSeq.compile(classGenerator, methodGenerator, instructionList2.getStart()));
            instructionList6 = this._idxTestSeq.getInstructionList();
        } else {
            branchHandle2.setTarget(instructionList2.getStart());
        }
        if (this._childNodeTestSeq != null) {
            double d = this._childNodeTestSeq.getPriority();
            int n4 = this._childNodeTestSeq.getPosition();
            double d2 = -1.7976931348623157E308;
            n = Integer.MIN_VALUE;
            if (object2 != null) {
                d2 = ((TestSeq)object2).getPriority();
                n = ((TestSeq)object2).getPosition();
            }
            if (d2 == Double.NaN || d2 < d || d2 == d && n < n4) {
                instructionHandle4 = this._childNodeTestSeq.compile(classGenerator, methodGenerator, instructionHandle);
            }
            object = this._testSeq[3];
            double d3 = -1.7976931348623157E308;
            int n5 = Integer.MIN_VALUE;
            if (object != null) {
                d3 = ((TestSeq)object).getPriority();
                n5 = ((TestSeq)object).getPosition();
            }
            if (d3 == Double.NaN || d3 < d || d3 == d && n5 < n4) {
                instructionHandle3 = this._childNodeTestSeq.compile(classGenerator, methodGenerator, instructionHandle);
                this._testSeq[3] = this._childNodeTestSeq;
            }
        }
        InstructionHandle instructionHandle6 = instructionHandle4;
        InstructionList instructionList7 = this.compileNamespaces(classGenerator, methodGenerator, blArray2, blArray, false, instructionHandle4);
        if (instructionList7 != null) {
            instructionHandle6 = instructionList7.getStart();
        }
        InstructionHandle instructionHandle7 = instructionHandle5;
        InstructionList instructionList8 = this.compileNamespaces(classGenerator, methodGenerator, blArray2, blArray, true, instructionHandle5);
        if (instructionList8 != null) {
            instructionHandle7 = instructionList8.getStart();
        }
        InstructionHandle[] instructionHandleArray = new InstructionHandle[nArray.length];
        n = 14;
        while (n < instructionHandleArray.length) {
            object = this._testSeq[n];
            instructionHandleArray[n] = blArray2[n] ? (blArray[n] ? instructionHandle7 : instructionHandle6) : (object != null ? (blArray[n] ? ((TestSeq)object).compile(classGenerator, methodGenerator, instructionHandle7) : ((TestSeq)object).compile(classGenerator, methodGenerator, instructionHandle6)) : instructionHandle);
            ++n;
        }
        instructionHandleArray[0] = this._rootPattern != null ? this.getTemplateInstructionHandle(this._rootPattern.getTemplate()) : instructionHandle2;
        instructionHandleArray[9] = this._rootPattern != null ? this.getTemplateInstructionHandle(this._rootPattern.getTemplate()) : instructionHandle2;
        instructionHandleArray[3] = this._testSeq[3] != null ? this._testSeq[3].compile(classGenerator, methodGenerator, instructionHandle3) : instructionHandle3;
        instructionHandleArray[13] = instructionHandle;
        instructionHandleArray[1] = instructionHandle6;
        instructionHandleArray[2] = instructionHandle7;
        object = instructionHandle;
        if (this._childNodeTestSeq != null) {
            object = instructionHandle4;
        }
        instructionHandleArray[7] = this._testSeq[7] != null ? this._testSeq[7].compile(classGenerator, methodGenerator, (InstructionHandle)object) : object;
        InstructionHandle instructionHandle8 = instructionHandle;
        if (this._childNodeTestSeq != null) {
            instructionHandle8 = instructionHandle4;
        }
        instructionHandleArray[8] = this._testSeq[8] != null ? this._testSeq[8].compile(classGenerator, methodGenerator, instructionHandle8) : instructionHandle8;
        instructionHandleArray[4] = instructionHandle;
        instructionHandleArray[11] = instructionHandle;
        instructionHandleArray[10] = instructionHandle;
        instructionHandleArray[6] = instructionHandle;
        instructionHandleArray[5] = instructionHandle;
        instructionHandleArray[12] = instructionHandle;
        int n6 = 14;
        while (n6 < instructionHandleArray.length) {
            TestSeq testSeq2 = this._testSeq[n6];
            instructionHandleArray[n6] = testSeq2 == null || blArray2[n6] ? (blArray[n6] ? instructionHandle7 : instructionHandle6) : (blArray[n6] ? testSeq2.compile(classGenerator, methodGenerator, instructionHandle7) : testSeq2.compile(classGenerator, methodGenerator, instructionHandle6));
            ++n6;
        }
        if (instructionList6 != null) {
            instructionList2.insert(instructionList6);
        }
        int n7 = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getExpandedTypeID", "(I)I");
        instructionList2.append(methodGenerator.loadDOM());
        instructionList2.append(new ILOAD(this._currentIndex));
        instructionList2.append(new INVOKEINTERFACE(n7, 2));
        InstructionHandle instructionHandle9 = instructionList2.append(new SWITCH(nArray, instructionHandleArray, instructionHandle));
        this.appendTestSequences(instructionList2);
        this.appendTemplateCode(instructionList2);
        if (instructionList7 != null) {
            instructionList2.append(instructionList7);
        }
        if (instructionList8 != null) {
            instructionList2.append(instructionList8);
        }
        instructionList2.append(instructionList4);
        instructionList2.append(instructionList5);
        instructionList.append(new GOTO_W(instructionHandle));
        instructionList.append(instructionList2);
        instructionList.append(instructionList3);
        this.peepHoleOptimization(methodGenerator);
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        methodGenerator.removeNOPs();
        classGenerator.addMethod(methodGenerator.getMethod());
        if (this._importLevels != null) {
            Enumeration enumeration = this._importLevels.keys();
            while (enumeration.hasMoreElements()) {
                Integer n8 = (Integer)enumeration.nextElement();
                Integer n9 = (Integer)this._importLevels.get(n8);
                this.compileApplyImports(classGenerator, n9, n8);
            }
        }
    }

    private void compileTemplateCalls(ClassGenerator classGenerator, MethodGenerator methodGenerator, InstructionHandle instructionHandle, int n, int n2) {
        Enumeration enumeration = this._neededTemplates.keys();
        while (enumeration.hasMoreElements()) {
            Template template = (Template)enumeration.nextElement();
            int n3 = template.getImportPrecedence();
            if (n3 < n || n3 >= n2) continue;
            if (template.hasContents()) {
                InstructionList instructionList = template.compile(classGenerator, methodGenerator);
                instructionList.append(new GOTO_W(instructionHandle));
                this._templateILs.put(template, instructionList);
                this._templateIHs.put(template, instructionList.getStart());
                continue;
            }
            this._templateIHs.put(template, instructionHandle);
        }
    }

    public void compileApplyImports(ClassGenerator classGenerator, int n, int n2) {
        Object object;
        int n3;
        Object object2;
        Type[] typeArray;
        XSLTC xSLTC = classGenerator.getParser().getXSLTC();
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        Vector vector = xSLTC.getNamesIndex();
        this._namedTemplates = new Hashtable();
        this._neededTemplates = new Hashtable();
        this._templateIHs = new Hashtable();
        this._templateILs = new Hashtable();
        this._patternGroups = new Vector[32];
        this._rootPattern = null;
        Vector vector2 = this._templates;
        this._templates = new Vector();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            typeArray = (Type[])enumeration.nextElement();
            int n4 = typeArray.getImportPrecedence();
            if (n4 < n || n4 >= n2) continue;
            this.addTemplate((Template)typeArray);
        }
        this.processPatterns(this._keys);
        typeArray = new Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), Util.getJCRefType("Lorg/apache/xml/dtm/DTMAxisIterator;"), Util.getJCRefType("Lorg/apache/xml/serializer/SerializationHandler;")};
        String[] stringArray = new String[]{"document", "iterator", "handler"};
        InstructionList instructionList = new InstructionList();
        MethodGenerator methodGenerator = new MethodGenerator(17, Type.VOID, typeArray, stringArray, this.functionName() + '_' + n2, this.getClassName(), instructionList, classGenerator.getConstantPool());
        methodGenerator.addException("org.apache.xalan.xsltc.TransletException");
        LocalVariableGen localVariableGen = methodGenerator.addLocalVariable2("current", Type.INT, instructionList.getEnd());
        this._currentIndex = localVariableGen.getIndex();
        InstructionList instructionList2 = new InstructionList();
        instructionList2.append(InstructionConstants.NOP);
        InstructionList instructionList3 = new InstructionList();
        instructionList3.append(methodGenerator.loadIterator());
        instructionList3.append(methodGenerator.nextNode());
        instructionList3.append(InstructionConstants.DUP);
        instructionList3.append(new ISTORE(this._currentIndex));
        BranchHandle branchHandle = instructionList3.append(new IFLT(null));
        BranchHandle branchHandle2 = instructionList3.append(new GOTO_W(null));
        branchHandle.setTarget(instructionList3.append(InstructionConstants.RETURN));
        InstructionHandle instructionHandle = instructionList3.getStart();
        InstructionList instructionList4 = this.compileDefaultRecursion(classGenerator, methodGenerator, instructionHandle);
        InstructionHandle instructionHandle2 = instructionList4.getStart();
        InstructionList instructionList5 = this.compileDefaultText(classGenerator, methodGenerator, instructionHandle);
        InstructionHandle instructionHandle3 = instructionList5.getStart();
        int[] nArray = new int[14 + vector.size()];
        int n5 = 0;
        while (n5 < nArray.length) {
            nArray[n5] = n5;
            ++n5;
        }
        boolean[] blArray = new boolean[nArray.length];
        boolean[] blArray2 = new boolean[nArray.length];
        int n6 = 0;
        while (n6 < vector.size()) {
            object2 = (String)vector.elementAt(n6);
            blArray[n6 + 14] = Mode.isAttributeName((String)object2);
            blArray2[n6 + 14] = Mode.isNamespaceName((String)object2);
            ++n6;
        }
        this.compileTemplateCalls(classGenerator, methodGenerator, instructionHandle, n, n2);
        object2 = this._testSeq[1];
        InstructionHandle instructionHandle4 = instructionHandle2;
        if (object2 != null) {
            instructionHandle4 = ((TestSeq)object2).compile(classGenerator, methodGenerator, instructionHandle);
        }
        TestSeq testSeq = this._testSeq[2];
        InstructionHandle instructionHandle5 = instructionHandle;
        if (testSeq != null) {
            instructionHandle5 = testSeq.compile(classGenerator, methodGenerator, instructionHandle5);
        }
        InstructionList instructionList6 = null;
        if (this._idxTestSeq != null) {
            branchHandle2.setTarget(this._idxTestSeq.compile(classGenerator, methodGenerator, instructionList2.getStart()));
            instructionList6 = this._idxTestSeq.getInstructionList();
        } else {
            branchHandle2.setTarget(instructionList2.getStart());
        }
        if (this._childNodeTestSeq != null) {
            double d = this._childNodeTestSeq.getPriority();
            int n7 = this._childNodeTestSeq.getPosition();
            double d2 = -1.7976931348623157E308;
            n3 = Integer.MIN_VALUE;
            if (object2 != null) {
                d2 = ((TestSeq)object2).getPriority();
                n3 = ((TestSeq)object2).getPosition();
            }
            if (d2 == Double.NaN || d2 < d || d2 == d && n3 < n7) {
                instructionHandle4 = this._childNodeTestSeq.compile(classGenerator, methodGenerator, instructionHandle);
            }
            object = this._testSeq[3];
            double d3 = -1.7976931348623157E308;
            int n8 = Integer.MIN_VALUE;
            if (object != null) {
                d3 = ((TestSeq)object).getPriority();
                n8 = ((TestSeq)object).getPosition();
            }
            if (d3 == Double.NaN || d3 < d || d3 == d && n8 < n7) {
                instructionHandle3 = this._childNodeTestSeq.compile(classGenerator, methodGenerator, instructionHandle);
                this._testSeq[3] = this._childNodeTestSeq;
            }
        }
        InstructionHandle instructionHandle6 = instructionHandle4;
        InstructionList instructionList7 = this.compileNamespaces(classGenerator, methodGenerator, blArray2, blArray, false, instructionHandle4);
        if (instructionList7 != null) {
            instructionHandle6 = instructionList7.getStart();
        }
        InstructionList instructionList8 = this.compileNamespaces(classGenerator, methodGenerator, blArray2, blArray, true, instructionHandle5);
        InstructionHandle instructionHandle7 = instructionHandle5;
        if (instructionList8 != null) {
            instructionHandle7 = instructionList8.getStart();
        }
        InstructionHandle[] instructionHandleArray = new InstructionHandle[nArray.length];
        n3 = 14;
        while (n3 < instructionHandleArray.length) {
            object = this._testSeq[n3];
            instructionHandleArray[n3] = blArray2[n3] ? (blArray[n3] ? instructionHandle7 : instructionHandle6) : (object != null ? (blArray[n3] ? ((TestSeq)object).compile(classGenerator, methodGenerator, instructionHandle7) : ((TestSeq)object).compile(classGenerator, methodGenerator, instructionHandle6)) : instructionHandle);
            ++n3;
        }
        instructionHandleArray[0] = this._rootPattern != null ? this.getTemplateInstructionHandle(this._rootPattern.getTemplate()) : instructionHandle2;
        instructionHandleArray[9] = this._rootPattern != null ? this.getTemplateInstructionHandle(this._rootPattern.getTemplate()) : instructionHandle2;
        instructionHandleArray[3] = this._testSeq[3] != null ? this._testSeq[3].compile(classGenerator, methodGenerator, instructionHandle3) : instructionHandle3;
        instructionHandleArray[13] = instructionHandle;
        instructionHandleArray[1] = instructionHandle6;
        instructionHandleArray[2] = instructionHandle7;
        object = instructionHandle;
        if (this._childNodeTestSeq != null) {
            object = instructionHandle4;
        }
        instructionHandleArray[7] = this._testSeq[7] != null ? this._testSeq[7].compile(classGenerator, methodGenerator, (InstructionHandle)object) : object;
        InstructionHandle instructionHandle8 = instructionHandle;
        if (this._childNodeTestSeq != null) {
            instructionHandle8 = instructionHandle4;
        }
        instructionHandleArray[8] = this._testSeq[8] != null ? this._testSeq[8].compile(classGenerator, methodGenerator, instructionHandle8) : instructionHandle8;
        instructionHandleArray[4] = instructionHandle;
        instructionHandleArray[11] = instructionHandle;
        instructionHandleArray[10] = instructionHandle;
        instructionHandleArray[6] = instructionHandle;
        instructionHandleArray[5] = instructionHandle;
        instructionHandleArray[12] = instructionHandle;
        int n9 = 14;
        while (n9 < instructionHandleArray.length) {
            TestSeq testSeq2 = this._testSeq[n9];
            instructionHandleArray[n9] = testSeq2 == null || blArray2[n9] ? (blArray[n9] ? instructionHandle7 : instructionHandle6) : (blArray[n9] ? testSeq2.compile(classGenerator, methodGenerator, instructionHandle7) : testSeq2.compile(classGenerator, methodGenerator, instructionHandle6));
            ++n9;
        }
        if (instructionList6 != null) {
            instructionList2.insert(instructionList6);
        }
        int n10 = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getExpandedTypeID", "(I)I");
        instructionList2.append(methodGenerator.loadDOM());
        instructionList2.append(new ILOAD(this._currentIndex));
        instructionList2.append(new INVOKEINTERFACE(n10, 2));
        InstructionHandle instructionHandle9 = instructionList2.append(new SWITCH(nArray, instructionHandleArray, instructionHandle));
        this.appendTestSequences(instructionList2);
        this.appendTemplateCode(instructionList2);
        if (instructionList7 != null) {
            instructionList2.append(instructionList7);
        }
        if (instructionList8 != null) {
            instructionList2.append(instructionList8);
        }
        instructionList2.append(instructionList4);
        instructionList2.append(instructionList5);
        instructionList.append(new GOTO_W(instructionHandle));
        instructionList.append(instructionList2);
        instructionList.append(instructionList3);
        this.peepHoleOptimization(methodGenerator);
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        methodGenerator.removeNOPs();
        classGenerator.addMethod(methodGenerator.getMethod());
        this._templates = vector2;
    }

    private void peepHoleOptimization(MethodGenerator methodGenerator) {
        Object object;
        Object object2;
        Object object3;
        InstructionList instructionList = methodGenerator.getInstructionList();
        InstructionFinder instructionFinder = new InstructionFinder(instructionList);
        String string = "`ALOAD'`POP'`Instruction'";
        Iterator iterator = instructionFinder.search(string);
        while (iterator.hasNext()) {
            object3 = (InstructionHandle[])iterator.next();
            try {
                if (object3[0].hasTargeters() || ((InstructionHandle)object3[1]).hasTargeters()) continue;
                instructionList.delete((InstructionHandle)object3[0], (InstructionHandle)object3[1]);
            }
            catch (TargetLostException targetLostException) {
                // empty catch block
            }
        }
        string = "`ILOAD'`ALOAD'`SWAP'`Instruction'";
        object3 = instructionFinder.search(string);
        while (object3.hasNext()) {
            object2 = (InstructionHandle[])object3.next();
            try {
                if (object2[0].hasTargeters() || ((InstructionHandle)object2[1]).hasTargeters() || ((InstructionHandle)object2[2]).hasTargeters()) continue;
                object = ((InstructionHandle)object2[0]).getInstruction();
                Instruction instruction = ((InstructionHandle)object2[1]).getInstruction();
                instructionList.insert((InstructionHandle)object2[0], instruction);
                instructionList.insert((InstructionHandle)object2[0], (Instruction)object);
                instructionList.delete((InstructionHandle)object2[0], (InstructionHandle)object2[2]);
            }
            catch (TargetLostException targetLostException) {
                // empty catch block
            }
        }
        string = "`ALOAD_1'`ALOAD_1'`Instruction'";
        object2 = instructionFinder.search(string);
        while (object2.hasNext()) {
            object = (InstructionHandle[])object2.next();
            try {
                if (object[0].hasTargeters() || object[1].hasTargeters()) continue;
                instructionList.insert(object[1], (Instruction)new DUP());
                instructionList.delete(object[1]);
            }
            catch (TargetLostException targetLostException) {
                // empty catch block
            }
        }
    }

    public InstructionHandle getTemplateInstructionHandle(Template template) {
        return (InstructionHandle)this._templateIHs.get(template);
    }

    private static boolean isAttributeName(String string) {
        int n = string.lastIndexOf(58) + 1;
        return string.charAt(n) == '@';
    }

    private static boolean isNamespaceName(String string) {
        int n = string.lastIndexOf(58);
        return n > -1 && string.charAt(string.length() - 1) == '*';
    }
}

