/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.LiteralAttribute;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.UseAttributeSets;
import org.apache.xalan.xsltc.compiler.Variable;
import org.apache.xalan.xsltc.compiler.XslElement;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class LiteralElement
extends Instruction {
    private String _name;
    private LiteralElement _literalElemParent;
    private Vector _attributeElements = null;
    private Hashtable _accessedPrefixes = null;
    private static final String XMLNS_STRING = "xmlns";

    LiteralElement() {
    }

    public QName getName() {
        return this._qname;
    }

    public void display(int n) {
        this.indent(n);
        Util.println("LiteralElement name = " + this._name);
        this.displayContents(n + 4);
    }

    private String accessedNamespace(String string) {
        if (this._accessedPrefixes == null) {
            return null;
        }
        return (String)this._accessedPrefixes.get(string);
    }

    public void registerNamespace(String string, String string2, SymbolTable symbolTable, boolean bl) {
        String string3;
        if (this._literalElemParent != null) {
            string3 = this._literalElemParent.accessedNamespace(string);
            if (string3 == null) {
                this._literalElemParent.registerNamespace(string, string2, symbolTable, bl);
                return;
            }
            if (string3.equals(string2)) {
                return;
            }
        }
        if (this._accessedPrefixes == null) {
            this._accessedPrefixes = new Hashtable();
        } else if (!bl && (string3 = (String)this._accessedPrefixes.get(string)) != null) {
            if (string3.equals(string2)) {
                return;
            }
            string = symbolTable.generateNamespacePrefix();
        }
        if (!string.equals("xml")) {
            this._accessedPrefixes.put(string, string2);
        }
    }

    private String translateQName(QName qName, SymbolTable symbolTable) {
        String string;
        String string2 = qName.getLocalPart();
        String string3 = qName.getPrefix();
        if (string3 == null) {
            string3 = "";
        } else if (string3.equals(XMLNS_STRING)) {
            return XMLNS_STRING;
        }
        String string4 = symbolTable.lookupPrefixAlias(string3);
        if (string4 != null) {
            symbolTable.excludeNamespaces(string3);
            string3 = string4;
        }
        if ((string = this.lookupNamespace(string3)) == null) {
            return string2;
        }
        this.registerNamespace(string3, string, symbolTable, false);
        if (string3 != "") {
            return string3 + ":" + string2;
        }
        return string2;
    }

    public void addAttribute(SyntaxTreeNode syntaxTreeNode) {
        if (this._attributeElements == null) {
            this._attributeElements = new Vector(2);
        }
        this._attributeElements.add(syntaxTreeNode);
    }

    public void setFirstAttribute(SyntaxTreeNode syntaxTreeNode) {
        if (this._attributeElements == null) {
            this._attributeElements = new Vector(2);
        }
        this._attributeElements.insertElementAt(syntaxTreeNode, 0);
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        if (this._attributeElements != null) {
            int n = this._attributeElements.size();
            int n2 = 0;
            while (n2 < n) {
                SyntaxTreeNode syntaxTreeNode = (SyntaxTreeNode)this._attributeElements.elementAt(n2);
                syntaxTreeNode.typeCheck(symbolTable);
                ++n2;
            }
        }
        this.typeCheckContents(symbolTable);
        return Type.Void;
    }

    public Enumeration getNamespaceScope(SyntaxTreeNode syntaxTreeNode) {
        Hashtable hashtable = new Hashtable();
        while (syntaxTreeNode != null) {
            Hashtable hashtable2 = syntaxTreeNode.getPrefixMapping();
            if (hashtable2 != null) {
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (hashtable.containsKey(string)) continue;
                    hashtable.put(string, hashtable2.get(string));
                }
            }
            syntaxTreeNode = syntaxTreeNode.getParent();
        }
        return hashtable.keys();
    }

    public void parseContents(Parser parser2) {
        String string;
        Object object;
        String string2;
        Object object2;
        SymbolTable symbolTable = parser2.getSymbolTable();
        symbolTable.setCurrentNode(this);
        SyntaxTreeNode syntaxTreeNode = this.getParent();
        while (syntaxTreeNode != null && !(syntaxTreeNode instanceof LiteralElement)) {
            syntaxTreeNode = syntaxTreeNode.getParent();
        }
        if (!(syntaxTreeNode instanceof LiteralElement)) {
            syntaxTreeNode = null;
        }
        this._name = this.translateQName(this._qname, symbolTable);
        int n = this._attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            object2 = parser2.getQName(this._attributes.getQName(n2));
            string2 = ((QName)object2).getNamespace();
            object = this._attributes.getValue(n2);
            if (object2 == parser2.getUseAttributeSets()) {
                this.setFirstAttribute(new UseAttributeSets((String)object, parser2));
            } else if (object2 == parser2.getExtensionElementPrefixes()) {
                symbolTable.excludeNamespaces((String)object);
            } else if (object2 == parser2.getExcludeResultPrefixes()) {
                symbolTable.excludeNamespaces((String)object);
            } else {
                string = ((QName)object2).getPrefix();
                if (!(string != null && string.equals(XMLNS_STRING) || string == null && ((QName)object2).getLocalPart().equals(XMLNS_STRING) || string2 != null && string2.equals("http://www.w3.org/1999/XSL/Transform"))) {
                    String string3 = this.translateQName((QName)object2, symbolTable);
                    LiteralAttribute literalAttribute = new LiteralAttribute(string3, (String)object, parser2);
                    this.addAttribute(literalAttribute);
                    literalAttribute.setParent(this);
                    literalAttribute.parseContents(parser2);
                }
            }
            ++n2;
        }
        object2 = this.getNamespaceScope(this);
        while (object2.hasMoreElements()) {
            string2 = (String)object2.nextElement();
            if (string2.equals("xml") || (object = this.lookupNamespace(string2)) == null || symbolTable.isExcludedNamespace((String)object)) continue;
            this.registerNamespace(string2, (String)object, symbolTable, true);
        }
        this.parseChildren(parser2);
        int n3 = 0;
        while (n3 < n) {
            object = parser2.getQName(this._attributes.getQName(n3));
            string = this._attributes.getValue(n3);
            if (object == parser2.getExtensionElementPrefixes()) {
                symbolTable.unExcludeNamespaces(string);
            } else if (object == parser2.getExcludeResultPrefixes()) {
                symbolTable.unExcludeNamespaces(string);
            }
            ++n3;
        }
    }

    protected boolean contextDependent() {
        return this.dependentContents();
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        Object object;
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        instructionList.append(methodGenerator.loadHandler());
        instructionList.append(new PUSH(constantPoolGen, this._name));
        instructionList.append(InstructionConstants.DUP2);
        instructionList.append(methodGenerator.startElement());
        int n = 0;
        while (n < this.elementCount()) {
            SyntaxTreeNode syntaxTreeNode = (SyntaxTreeNode)this.elementAt(n);
            if (syntaxTreeNode instanceof Variable) {
                syntaxTreeNode.translate(classGenerator, methodGenerator);
                this.removeElement(syntaxTreeNode);
            }
            ++n;
        }
        if (this._accessedPrefixes != null) {
            boolean bl = false;
            Enumeration enumeration = this._accessedPrefixes.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                String string = (String)this._accessedPrefixes.get(object);
                if (string == "" && object == "") continue;
                if (object == "") {
                    bl = true;
                }
                instructionList.append(methodGenerator.loadHandler());
                instructionList.append(new PUSH(constantPoolGen, (String)object));
                instructionList.append(new PUSH(constantPoolGen, string));
                instructionList.append(methodGenerator.namespace());
            }
            if (!bl && this._parent instanceof XslElement && ((XslElement)this._parent).declaresDefaultNS()) {
                instructionList.append(methodGenerator.loadHandler());
                instructionList.append(new PUSH(constantPoolGen, ""));
                instructionList.append(new PUSH(constantPoolGen, ""));
                instructionList.append(methodGenerator.namespace());
            }
        }
        if (this._attributeElements != null) {
            int n2 = this._attributeElements.size();
            int n3 = 0;
            while (n3 < n2) {
                object = (SyntaxTreeNode)this._attributeElements.elementAt(n3);
                ((SyntaxTreeNode)object).translate(classGenerator, methodGenerator);
                ++n3;
            }
        }
        this.translateContents(classGenerator, methodGenerator);
        instructionList.append(methodGenerator.endElement());
    }
}

